/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.encoding;

import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistryImpl;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class AgnosticTypeMappingRegistry
extends TypeMappingRegistryImpl
implements TypeMappingRegistry {
    private Hashtable consistencies = new Hashtable();

    public TypeMapping register(String string, TypeMapping typeMapping) {
        this.markAllInconsistent();
        return super.register(string, typeMapping);
    }

    public void registerDefault(TypeMapping typeMapping) {
        this.markAllInconsistent();
        super.registerDefault(typeMapping);
    }

    public TypeMapping unregisterTypeMapping(String string) {
        this.markAllInconsistent();
        return super.unregisterTypeMapping(string);
    }

    public boolean removeTypeMapping(TypeMapping typeMapping) {
        this.markAllInconsistent();
        return super.removeTypeMapping(typeMapping);
    }

    public void clear() {
        this.markAllInconsistent();
        super.clear();
    }

    private void markAllInconsistent() {
        Set set = this.consistencies.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            entry.setValue(new Boolean(false));
        }
    }

    public void copyContents(TypeMappingRegistry typeMappingRegistry) {
        Integer n = new Integer(typeMappingRegistry.hashCode());
        Object v = this.consistencies.get(n);
        if (v != null && v instanceof Boolean && ((Boolean)v).booleanValue()) {
            return;
        }
        typeMappingRegistry.clear();
        TypeMapping typeMapping = this.getDefaultTypeMapping();
        typeMappingRegistry.registerDefault(typeMapping);
        String[] stringArray = this.getRegisteredEncodingStyleURIs();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            TypeMapping typeMapping2 = this.getTypeMapping(string);
            if (typeMapping2 == null) continue;
            typeMappingRegistry.register(string, typeMapping2);
        }
        this.consistencies.put(new Integer(typeMappingRegistry.hashCode()), new Boolean(true));
    }
}

