/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.provider.ejb.stubless.impl.FaultWrapper;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;

public abstract class ModelInvocationHandler
implements InvocationHandler {
    protected InvocationContext invocationContext;
    protected static ArrayList propertyNames = new ArrayList();

    protected ModelInvocationHandler(InvocationContext invocationContext) {
        this.invocationContext = invocationContext;
    }

    public Object invoke(Object object, Method method2, Object[] objectArray) throws Throwable {
        Object object2;
        if (method2.getName().charAt(0) == '_') {
            object2 = this.invokeSpecialMethod(method2, objectArray);
        } else {
            try {
                object2 = this.invokeOperation(method2, objectArray);
            }
            catch (RemoteException remoteException) {
                Throwable throwable = remoteException;
                while (((Throwable)throwable).getCause() != null) {
                    if (!this.isDeclaredException(method2, throwable = ((Throwable)throwable).getCause())) continue;
                    throw throwable;
                }
                throw remoteException;
            }
        }
        return object2;
    }

    protected abstract Object invokeOperation(Method var1, Object[] var2) throws RemoteException;

    protected Object invokeSpecialMethod(Method method2, Object[] objectArray) throws RemoteException {
        Object object = null;
        String string = method2.getName();
        if ("_getPropertyNames".equals(string)) {
            object = this.doGetPropertyNames();
        } else if ("_getProperty".equals(string)) {
            object = this.doGetProperty(objectArray[0]);
        } else if ("_setProperty".equals(string)) {
            this.doSetProperty(objectArray[0], objectArray[1]);
        } else {
            this.doUnknownSpecialMethod(method2, objectArray);
        }
        return object;
    }

    protected Object doGetPropertyNames() {
        Iterator iterator = propertyNames.iterator();
        return iterator;
    }

    protected Object doGetProperty(Object object) {
        if (this.isIllegalPropertyNameForStub((String)object)) {
            throw new JAXRPCException(Messages.getMessage("badCallPropName", object.toString()));
        }
        return this.invocationContext.getProperty((String)object);
    }

    protected void doSetProperty(Object object, Object object2) {
        if (this.isIllegalPropertyNameForStub((String)object)) {
            throw new JAXRPCException(Messages.getMessage("badCallPropName", object.toString()));
        }
        this.invocationContext.setProperty((String)object, object2);
    }

    protected Object doUnknownSpecialMethod(Method method2, Object[] objectArray) throws RemoteException {
        throw new IllegalArgumentException(Messages.getMessage("invalidMethod", method2.getName()));
    }

    protected boolean isIllegalPropertyNameForStub(String string) {
        if (string == null) {
            return true;
        }
        if (string.equals("javax.xml.rpc.service.endpoint.address") || string.equals("javax.xml.rpc.security.auth.password") || string.equals("javax.xml.rpc.session.maintain") || string.equals("javax.xml.rpc.security.auth.username")) {
            return false;
        }
        return string.startsWith("javax.xml.rpc");
    }

    protected boolean isDeclaredException(Method method2, Throwable throwable) {
        if (throwable instanceof FaultWrapper) {
            return false;
        }
        Class<?>[] classArray = method2.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return false;
    }

    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    static {
        propertyNames.add("javax.xml.rpc.session.maintain");
    }
}

