/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.base.DefaultService;
import com.ibm.ws.webservices.multiprotocol.extensions.ExtensionDescription;
import com.ibm.ws.webservices.multiprotocol.provider.BindingGenerator;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.ws.webservices.multiprotocol.provider.StubGenerator;
import com.ibm.ws.webservices.multiprotocol.provider.Transport;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;

public abstract class ModelServiceProvider
implements ServiceProvider {
    protected String[] supportedBindings;

    protected ModelServiceProvider() throws ServiceException {
        if (this.isEnabled()) {
            this.enableServiceProvider();
        } else {
            this.disableServiceProvider();
        }
    }

    public boolean isBindingNamespaceSupported(String string) {
        boolean bl = false;
        for (int i = 0; !bl && i < this.supportedBindings.length; ++i) {
            if (this.supportedBindings[i] == null || this.supportedBindings[i].length() == 0) {
                bl = string == null || string.length() == 0;
                continue;
            }
            if (!this.supportedBindings[i].equals(string)) continue;
            bl = true;
        }
        return bl;
    }

    protected abstract String[] getRequiredClasses();

    public abstract ExtensionDescription[] getExtensionDescriptions();

    protected abstract String[] getSupportedBindingNamespaces();

    public BindingGenerator[] getBindingGenerators() {
        return null;
    }

    public StubGenerator getStubGenerator(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        return null;
    }

    protected Service makeService(ServiceContext serviceContext) throws ServiceException {
        Transport transport2 = this.makeTransport(serviceContext);
        DefaultService defaultService = new DefaultService(serviceContext, transport2);
        return defaultService;
    }

    protected abstract Transport makeTransport(ServiceContext var1) throws ServiceException;

    public Service createService(ServiceContext serviceContext) throws ServiceException {
        Service service = this.makeService(serviceContext);
        return service;
    }

    public boolean isEnabled() {
        String[] stringArray = this.getRequiredClasses();
        return ModelServiceProvider.areRequiredClassesAvailable(stringArray);
    }

    protected void enableServiceProvider() throws ServiceException {
        this.supportedBindings = this.getSupportedBindingNamespaces();
    }

    protected void disableServiceProvider() {
        this.supportedBindings = new String[0];
    }

    protected static boolean areRequiredClassesAvailable(String[] stringArray) {
        boolean bl = true;
        if (stringArray != null) {
            for (int i = 0; bl && i < stringArray.length; ++i) {
                final String string = stringArray[i];
                Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return ClassUtils.forName(string);
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    }
                });
                if (clazz != null) continue;
                bl = false;
            }
        }
        return bl;
    }
}

