/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.naming;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.WebServicesException;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ClientModuleMetaData;
import com.ibm.ws.webservices.metadata.ClientServiceMetaData;
import com.ibm.ws.webservices.multiprotocol.AgnosticServiceFactory;
import com.ibm.ws.webservices.multiprotocol.GeneratedService;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;

public class ObjectFactoryImpl
extends AgnosticServiceFactory
implements ObjectFactory {
    protected static TraceComponent _tc = Tr.register(ObjectFactoryImpl.class, "WebServices", "com.ibm.ws.webservices.multiprotocol.resources.mpMessages");
    private static String SET_WSDDPORT_METHOD_PREFIX = "set";
    private static String SET_WSDDPORT_METHOD_SUFFIX = "WSDDPortName";
    private static String UNSPECIFIED_PORT_NAME = null;

    private static String getClassLocator(String string) {
        return string + "Locator";
    }

    public Object getObjectInstance(Object object, Name name2, Context context, Hashtable hashtable) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getObjectInstance", new Object[]{object, name2, context, hashtable});
        }
        javax.xml.rpc.Service service = null;
        Reference reference = (Reference)object;
        if (reference != null) {
            String string = reference.getClassName();
            if (string.equals(ClientServiceMetaData.class.getName())) {
                ClientEntityMetaData clientEntityMetaData = WebServicesServiceHome.getWebServicesService().getClientEntityMetaData();
                if (clientEntityMetaData == null) {
                    String string2 = "ClientEntityMetaData is not available";
                    Tr.error(_tc, "internal.error", string2);
                    throw new WebServicesException(string2);
                }
                ClientServiceMetaData clientServiceMetaData = clientEntityMetaData.getClientServiceMetaData(reference);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "clientEntityMetaData.getClientServiceMetaData(ref) == " + clientServiceMetaData);
                }
                String string3 = clientServiceMetaData.getName();
                String string4 = clientServiceMetaData.getWsdlFileName();
                Map map = clientServiceMetaData.getDefaultPortMapping();
                Map map2 = clientServiceMetaData.getSeiToPortTypeMapping();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Refname on java:comp lookup is " + string3);
                    Tr.debug(_tc, "RefWsdlFile on java:comp lookup is " + string4);
                }
                if (clientServiceMetaData.getServiceInterface().equals(javax.xml.rpc.Service.class.getName())) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Generic Service was requested...");
                    }
                    ServiceContext serviceContext = null;
                    QName qName = clientServiceMetaData.getQName();
                    if (string4 == null) {
                        serviceContext = new ServiceContext(null, null, qName);
                    } else {
                        Definition definition = clientServiceMetaData.getWsdlDoc();
                        Map map3 = clientServiceMetaData.getNamespaceToPackageMapping();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "RefWsdlDoc on java:comp lookup is " + definition);
                            Tr.debug(_tc, "refNamespace2PackageMapping on java:comp lookup is " + map3);
                        }
                        URL uRL = null;
                        uRL = string4.indexOf(":") == -1 ? new URL("file", null, string4) : new URL(string4);
                        serviceContext = new ServiceContext(uRL, definition, qName);
                        serviceContext.setNamespace2PackageMapping(map3);
                    }
                    serviceContext.setSEIToPortTypeMapping(clientServiceMetaData.getSeiToPortTypeMapping());
                    serviceContext.setPortTypeToPortMapping(map);
                    serviceContext.setServiceRefName(string3);
                    serviceContext.setClientMetaData(clientEntityMetaData);
                    serviceContext.setManagedEnvironment(true);
                    serviceContext.setOverriddingEndpointURIs(clientServiceMetaData.getOverriddingEndpointURIs());
                    serviceContext.setOverriddingBindingNamespaces(clientServiceMetaData.getOverriddingBindingNamespaces());
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Created the following ServiceContext: \n" + serviceContext.toString());
                    }
                    service = this.createService(qName, serviceContext);
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Generated ServiceLocator was requested...");
                    }
                    ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    Class<?> clazz = null;
                    try {
                        clazz = classLoader.loadClass(ObjectFactoryImpl.getClassLocator(clientServiceMetaData.getServiceInterface()));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webservices.multiprotocol.naming.ObjectFactoryImpl.getObjectInstance", "132", this);
                        Tr.error(_tc, "internal.error", classNotFoundException);
                        throw classNotFoundException;
                    }
                    if (!javax.xml.rpc.Service.class.isAssignableFrom(clazz)) {
                        throw new Exception(Messages.getMessage("invalidService1", clazz.getName(), "javax.xml.rpc.Service"));
                    }
                    if (GeneratedService.class.isAssignableFrom(clazz)) {
                        Constructor<?> constructor;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "This is a new ServiceLocator...");
                        }
                        if ((constructor = clazz.getConstructor(ServiceContext.class)) == null) {
                            throw new Exception(Messages.getMessage("noSvcCtor", clazz.getName()));
                        }
                        ServiceContext serviceContext = null;
                        QName qName = clientServiceMetaData.getQName();
                        if (string4 == null) {
                            serviceContext = new ServiceContext(null, null, qName);
                        } else {
                            Definition definition = clientServiceMetaData.getWsdlDoc();
                            Map map4 = clientServiceMetaData.getNamespaceToPackageMapping();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "RefWsdlDoc on java:comp lookup is " + definition);
                                Tr.debug(_tc, "refNamespace2PackageMapping on java:comp lookup is " + map4);
                            }
                            URL uRL = null;
                            uRL = string4.indexOf(":") == -1 ? new URL("file", null, string4) : new URL(string4);
                            serviceContext = new ServiceContext(uRL, definition, qName);
                            serviceContext.setNamespace2PackageMapping(map4);
                        }
                        serviceContext.setSEIToPortTypeMapping(map2);
                        serviceContext.setPortTypeToPortMapping(map);
                        serviceContext.setServiceRefName(string3);
                        serviceContext.setClientMetaData(clientEntityMetaData);
                        serviceContext.setManagedEnvironment(true);
                        serviceContext.setOverriddingEndpointURIs(clientServiceMetaData.getOverriddingEndpointURIs());
                        serviceContext.setOverriddingBindingNamespaces(clientServiceMetaData.getOverriddingBindingNamespaces());
                        service = (javax.xml.rpc.Service)constructor.newInstance(serviceContext);
                        ((GeneratedService)service).setPortNamePrefix(string3);
                    } else {
                        if (!javax.xml.rpc.Service.class.isAssignableFrom(clazz)) {
                            Tr.error(_tc, "internal.error", "Specified service " + clazz + " is not assignable from javax.xml.rpc.Service");
                            throw new Exception("Specified service does not inherit from javax.xml.rpc.Service");
                        }
                        service = (javax.xml.rpc.Service)clazz.newInstance();
                        if (service instanceof Service) {
                            ((Service)service).setEngine(clientEntityMetaData.getEngine());
                        }
                        Method[] methodArray = clazz.getMethods();
                        String[] stringArray = this.getWsdlPortsFromReferencable(clientServiceMetaData);
                        for (int i = 0; i < stringArray.length; ++i) {
                            Object object2;
                            int n;
                            Method method2 = null;
                            String string5 = null;
                            if (stringArray[i] == UNSPECIFIED_PORT_NAME) {
                                string5 = SET_WSDDPORT_METHOD_PREFIX + "<PortName>" + SET_WSDDPORT_METHOD_SUFFIX;
                                if (i != 0) {
                                    Tr.error(_tc, "internal.error", "ObjectFactoryImpl: Empty PortName in WSDL Port Names Array");
                                }
                                for (n = 0; n < methodArray.length; ++n) {
                                    object2 = methodArray[n].getName();
                                    if (!object2.startsWith(SET_WSDDPORT_METHOD_PREFIX) || !object2.endsWith(SET_WSDDPORT_METHOD_SUFFIX)) continue;
                                    method2 = methodArray[n];
                                    break;
                                }
                            } else {
                                string5 = SET_WSDDPORT_METHOD_PREFIX + stringArray[i] + SET_WSDDPORT_METHOD_SUFFIX;
                                for (n = 0; n < methodArray.length; ++n) {
                                    object2 = methodArray[n].getName();
                                    if (!object2.equals(string5)) continue;
                                    method2 = methodArray[n];
                                    break;
                                }
                            }
                            String string6 = ClientModuleMetaData.clientConfigurationPortName(clientServiceMetaData.getName(), stringArray[i]);
                            if (method2 != null) {
                                object2 = new Object[]{string6};
                                method2.invoke((Object)service, object2);
                                if (!_tc.isDebugEnabled()) continue;
                                Tr.debug(_tc, "ServiceLocator " + clazz + " WSDDPort name set to " + string6);
                                continue;
                            }
                            object2 = new Object[]{clazz, string5, clientServiceMetaData.getName(), string6};
                            Tr.warning(_tc, "warning.ServiceNameSetter.notfound", object2);
                        }
                        ((Service)service).setServiceRefName(string3);
                        ((Service)service).setWSDLFileName(string4);
                        ((Service)service).setPortTypeToPortMapping(map);
                        ((Service)service).setSEIToPortTypeMapping(map2);
                        ((Service)service).setOverriddingEndpointURIs(clientServiceMetaData.getOverriddingEndpointURIs());
                    }
                }
            } else {
                Object[] objectArray = new Object[]{string, ClientServiceMetaData.class.getName()};
                Tr.warning(_tc, "warning.client.reference.wrong.type", objectArray);
            }
        } else {
            Tr.warning(_tc, "warning.client.reference.not.found");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getObjectInstance");
        }
        return service;
    }

    private String[] getWsdlPortsFromReferencable(ClientServiceMetaData clientServiceMetaData) {
        String[] stringArray = clientServiceMetaData.getWsdlPortNames();
        if (stringArray == null) {
            stringArray = new String[]{UNSPECIFIED_PORT_NAME};
        }
        return stringArray;
    }
}

