/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.tools;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMapping;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.encoding.custom.CustomRegistry;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.wsdl.ImportResolver;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import com.ibm.ws.webservices.wsdl.query.ImportResolverDelegate;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaDeployGenerator;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSDLQuery {
    private Emitter emitter = null;
    private HashMap allServices = new HashMap();
    private HashMap allBindings = new HashMap();
    private HashMap allPortTypes = new HashMap();
    private boolean lazyAnalyzed = false;

    public WSDLQuery() throws WebServicesFault {
        this(new HashMap(), true);
    }

    public WSDLQuery(HashMap hashMap) throws WebServicesFault {
        this(new HashMap(), true);
    }

    public WSDLQuery(boolean bl) throws WebServicesFault {
        this(new HashMap(), bl);
    }

    public WSDLQuery(HashMap hashMap, boolean bl) throws WebServicesFault {
        this.emitter = new Emitter(bl);
        this.emitter.setToolEnv(DefaultToolEnv.create(bl));
        this.emitter.setDisplayDevelopmentMessages(false);
        JavaGeneratorFactory javaGeneratorFactory = (JavaGeneratorFactory)this.emitter.getFactory();
        javaGeneratorFactory.removeAllGenerators();
        javaGeneratorFactory.addGenerator(Definition.class, JavaDeployGenerator.class);
        this.emitter.setNamespaceMap(hashMap);
        this.emitter.setRole(Role.DEPLOY_SERVER.toString());
        this.emitter.setResolver(new ImportResolverDelegate(this.emitter), false);
        this.emitter.setVerbose(true);
        this.emitter.setLogToConsole(false);
        this.emitter.allowRelativeNamespace(true);
    }

    public void parse(String string) throws Exception {
        this.lazyAnalyzed = false;
        this.emitter.run(string);
    }

    public void parse(String string, Document document) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (document == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "Document"));
        }
        this.lazyAnalyzed = false;
        this.emitter.run(string, document);
    }

    public void parse(String string, InputStream inputStream) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (inputStream == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "InputStream"));
        }
        this.lazyAnalyzed = false;
        this.emitter.run(string, XMLUtils.newDocument(new InputSource(inputStream)));
    }

    public void parse(String string, Document document, Definition definition) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (document == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "Document"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "Definition"));
        }
        this.lazyAnalyzed = false;
        this.emitter.run(string, document, definition);
    }

    private void analyze() {
        if (!this.lazyAnalyzed) {
            SymbolTable symbolTable = this.emitter.getSymbolTable();
            Iterator iterator = symbolTable.getHashMap().values().iterator();
            while (iterator.hasNext()) {
                Vector vector = (Vector)iterator.next();
                for (int i = 0; i < vector.size(); ++i) {
                    String string;
                    SymTabEntry symTabEntry;
                    SymTabEntry symTabEntry2 = (SymTabEntry)vector.elementAt(i);
                    if (symTabEntry2 instanceof ServiceEntry) {
                        symTabEntry = (ServiceEntry)symTabEntry2;
                        string = symTabEntry.getQName().toString();
                        this.allServices.put(string, symTabEntry);
                        continue;
                    }
                    if (symTabEntry2 instanceof PortTypeEntry) {
                        symTabEntry = (PortTypeEntry)symTabEntry2;
                        string = symTabEntry.getQName().toString();
                        this.allPortTypes.put(string, symTabEntry);
                        continue;
                    }
                    if (!(symTabEntry2 instanceof BindingEntry)) continue;
                    symTabEntry = (BindingEntry)symTabEntry2;
                    string = symTabEntry.getQName().toString();
                    this.allBindings.put(string, symTabEntry);
                }
            }
            this.lazyAnalyzed = true;
        }
    }

    public HashMap getNamespaces() {
        this.analyze();
        return this.emitter.getNamespaces();
    }

    public void setNamespaces(HashMap hashMap) {
        this.emitter.setNamespaceMap(hashMap);
    }

    public SymbolTable getSymbolTable() {
        this.analyze();
        return this.emitter.getSymbolTable();
    }

    public Vector getTypeMappings(String string) {
        this.analyze();
        HashMap hashMap = (HashMap)this.emitter.getDynamicVar("queryTypeMappings");
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        return (Vector)hashMap.get(string);
    }

    public HashMap getServices() {
        this.analyze();
        return this.allServices;
    }

    public HashMap getPortTypes() {
        this.analyze();
        return this.allPortTypes;
    }

    public HashMap getBindings() {
        this.analyze();
        return this.allBindings;
    }

    public String getPortType(PortEntry portEntry) {
        Binding binding;
        this.analyze();
        String string = new String();
        Port port2 = portEntry.getPort();
        if (port2 != null && (binding = port2.getBinding()) != null) {
            string = binding.getQName().toString();
        }
        return string;
    }

    public HashMap getPorts(String string) {
        this.analyze();
        HashMap<String, PortEntry> hashMap = new HashMap<String, PortEntry>();
        ServiceEntry serviceEntry = (ServiceEntry)this.allServices.get(string);
        if (serviceEntry != null) {
            for (int i = 0; i < serviceEntry.numPorts(); ++i) {
                PortEntry portEntry = serviceEntry.getPort(i);
                String string2 = portEntry.getQName().toString();
                hashMap.put(string2, portEntry);
            }
        }
        return hashMap;
    }

    public HashMap getTypeMappings() {
        this.analyze();
        HashMap hashMap = (HashMap)this.emitter.getDynamicVar("queryTypeMappings");
        return hashMap;
    }

    public Vector getOperationDescs(String string) {
        this.analyze();
        HashMap hashMap = (HashMap)this.emitter.getDynamicVar("queryOperations");
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        return (Vector)hashMap.get(string);
    }

    public HashMap getOperationDescs() {
        this.analyze();
        HashMap hashMap = (HashMap)this.emitter.getDynamicVar("queryOperations");
        return hashMap;
    }

    public CustomRegistry getCustomRegistry() {
        return this.emitter.getCustomRegistry();
    }

    public void setCustomRegistry(CustomRegistry customRegistry) {
        this.emitter.setCustomRegistry(customRegistry);
    }

    public void setInputMappingFile(String string) {
        this.emitter.setInputMappingFile(string);
    }

    public void setInputMapping(MappingMetaData mappingMetaData) {
        this.emitter.setInputMapping(mappingMetaData);
    }

    public void setNoDataBinding(boolean bl) {
        this.emitter.setNoDataBinding(bl);
    }

    public void setResolver(ImportResolver importResolver) {
        this.emitter.setResolver(importResolver, false);
    }

    public boolean getNoDataBinding() {
        return this.emitter.getNoDataBinding();
    }

    public boolean isLogToConsole() {
        return this.emitter.getLogToConsole();
    }

    public void setLogToConsole(boolean bl) {
        this.emitter.setLogToConsole(bl);
        this.emitter.setVerbose(bl);
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            Iterator iterator;
            HashMap hashMap;
            WSDLQuery wSDLQuery;
            if (!(stringArray.length > 1 && (stringArray[1].equals("all") || stringArray[1].equals("typeMappings") || stringArray[1].equals("namespaces") || stringArray[1].equals("operations") || stringArray[1].equals("bindings") || stringArray[1].equals("services") || stringArray[1].equals("portTypes") || stringArray[1].equals("symbolTable")))) {
                System.out.println("Usage: WSDLQuery <wsdlFile> <option> [<mappingFile>]");
                System.out.println("       <option> := all | bindings | namespaces | operations | portTypes | services | symbolTable | typeMappings");
            }
            if (stringArray.length == 3) {
                wSDLQuery = new WSDLQuery(false);
                wSDLQuery.setInputMappingFile(stringArray[2]);
            } else {
                wSDLQuery = new WSDLQuery(true);
            }
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("This is a test namespace", "com.here.is.the.test.pkg");
            wSDLQuery.setNamespaces(hashMap2);
            wSDLQuery.parse(stringArray[0]);
            if (stringArray.length >= 2 && (stringArray[1].equals("symbolTable") || stringArray[1].equals("all"))) {
                wSDLQuery.emitter.getSymbolTable().dump(System.out);
            }
            if (stringArray.length >= 2 && (stringArray[1].equals("namespaces") || stringArray[1].equals("all"))) {
                System.out.println();
                System.out.println(" Namespace -> Java Package");
                System.out.println("--------------------------");
                System.out.println();
                hashMap = wSDLQuery.getNamespaces();
                if (hashMap != null && (iterator = hashMap.keySet()) != null) {
                    object2 = iterator.iterator();
                    while (object2 != null && object2.hasNext()) {
                        object = (String)object2.next();
                        String string = (String)hashMap.get(object);
                        if (object == null || ((String)object).equals("")) continue;
                        System.out.println("\"" + (String)object + "\" -> \"" + string + "\"");
                    }
                }
            }
            if (stringArray.length >= 2 && (stringArray[1].equals("typeMappings") || stringArray[1].equals("all"))) {
                System.out.println();
                System.out.println(" TypeMappings");
                System.out.println("-------------");
                System.out.println();
                hashMap = wSDLQuery.getTypeMappings();
                iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    System.out.println("Port name = " + (String)object2);
                    object = (Vector)hashMap.get(object2);
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        System.out.println("TypeMapping " + ((WSDDTypeMapping)((Vector)object).get(i)).toString());
                    }
                }
            }
            if (stringArray.length >= 2 && (stringArray[1].equals("operations") || stringArray[1].equals("all"))) {
                System.out.println();
                System.out.println(" Operations");
                System.out.println("-------------");
                System.out.println();
                hashMap = wSDLQuery.getOperationDescs();
                iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    System.out.println("Port name = " + (String)object2);
                    object = (Vector)hashMap.get(object2);
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        System.out.println("Operation " + ((OperationDesc)((Vector)object).get(i)).getName() + " " + ((OperationDesc)((Vector)object).get(i)).toString());
                    }
                }
            }
            if (stringArray.length >= 2 && (stringArray[1].equals("services") || stringArray[1].equals("all"))) {
                System.out.println();
                System.out.println(" Services");
                System.out.println("----------");
                System.out.println();
                hashMap = wSDLQuery.getServices();
                iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    System.out.println("Service Name = " + (String)object2);
                    object = wSDLQuery.getPorts((String)object2);
                    Iterator iterator2 = ((HashMap)object).keySet().iterator();
                    Iterator iterator3 = ((HashMap)object).values().iterator();
                    while (iterator2.hasNext()) {
                        String string = (String)iterator2.next();
                        String string2 = new String();
                        if (iterator3.hasNext()) {
                            PortEntry portEntry = (PortEntry)iterator3.next();
                            string2 = wSDLQuery.getPortType(portEntry);
                        }
                        System.out.println("  Port Name = " + string + ", of type " + string2);
                    }
                }
            }
            if (stringArray.length >= 2 && (stringArray[1].equals("portTypes") || stringArray[1].equals("all"))) {
                System.out.println();
                System.out.println(" Port Types");
                System.out.println("------------");
                System.out.println();
                hashMap = wSDLQuery.getPortTypes();
                iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    System.out.println("Port Type Name = " + (String)object2);
                }
            }
            if (stringArray.length >= 2 && (stringArray[1].equals("bindings") || stringArray[1].equals("all"))) {
                System.out.println();
                System.out.println(" Bindings");
                System.out.println("----------");
                System.out.println();
                hashMap = wSDLQuery.getBindings();
                iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    System.out.println("Binding Name = " + (String)object2);
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.axis.ext.wsdl.WSDLQuery.main", "498");
            throwable.printStackTrace();
        }
    }
}

