/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.tools.resource;

import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.ProgressMonitor;
import com.ibm.etools.environment.common.SimpleStatus;
import com.ibm.etools.environment.common.Status;
import com.ibm.etools.environment.console.ConsoleEnvironment;
import com.ibm.etools.environment.resource.ResourceException;
import com.ibm.etools.environment.resource.ResourceManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.tools.resource.FileWriteDenialException;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.toJava.JavaSearchCriteria;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.java.util.JavaContext;

public class WSADToolEnv
extends ToolEnv {
    private Environment env;
    private ResourceSet javaContext;
    private SimpleStatus status = new SimpleStatus("", "", 0);
    private URL[] classpathURLs;

    public WSADToolEnv() {
        this.javaContext = JavaContext.createJavaContext();
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    public SimpleStatus getStatus() {
        return this.status;
    }

    public void setStatus(SimpleStatus simpleStatus) {
        this.status = simpleStatus;
    }

    public boolean fileExists(String string) {
        Object object;
        this.checkEnv();
        JavaSearchCriteria javaSearchCriteria = this.getJavaSearch();
        if (javaSearchCriteria.equals(JavaSearchCriteria.BOTH) || javaSearchCriteria.equals(JavaSearchCriteria.FILE)) {
            try {
                URL uRL = new URL(string);
                object = this.env.getResourceManager();
                if (object.exists(uRL)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            int n;
            if ((javaSearchCriteria.equals(JavaSearchCriteria.BOTH) || javaSearchCriteria.equals(JavaSearchCriteria.CLASSPATH)) && (n = string.lastIndexOf(46)) >= 0 && ".java".equals(object = string.substring(n))) {
                if (this.javaOutputDir != null && this.javaOutputDir.length() < string.length()) {
                    string = string.substring(this.javaOutputDir.length() + 1);
                }
                String string2 = string.substring(0, string.lastIndexOf(46));
                string2 = string2.replace(this.getSeparatorChar(), '.');
                if (this.getClassFactory().forName(string2) != null) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public PrintWriter getPrintWriter(String string) throws IOException, FileWriteDenialException {
        this.checkEnv();
        OutputStream outputStream = this.getOutputStream(string);
        if (outputStream != null) {
            return new PrintWriter(outputStream);
        }
        throw new FileWriteDenialException(Messages.getMessage("FileWriteDenied", string), string);
    }

    public OutputStream getOutputStream(String string) throws IOException {
        OutputStream outputStream;
        this.checkEnv();
        try {
            URL uRL = new URL(string);
            ResourceManager resourceManager = this.env.getResourceManager();
            outputStream = resourceManager.getOutputStream(uRL);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.webservices.tools.resource.WSADToolEnv.getOutputStream", "125", this);
            return null;
        }
        return outputStream;
    }

    public InputStream getInputStream(String string) throws IOException {
        InputStream inputStream;
        this.checkEnv();
        try {
            URL uRL = new URL(string);
            ResourceManager resourceManager = this.env.getResourceManager();
            inputStream = resourceManager.getInputStream(uRL);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.webservices.tools.resource.WSADToolEnv.getInputStream", "154", this);
            throw new IOException(resourceException.getStatus().getMessage() + (string == null ? "" : ": " + string));
        }
        return inputStream;
    }

    public void mkdir(String string) throws IOException {
        this.checkEnv();
        try {
            URL uRL = new URL(string);
            ResourceManager resourceManager = this.env.getResourceManager();
            resourceManager.createFolders(uRL);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.webservices.tools.resource.WSADToolEnv.mkdir", "179", this);
            throw new IOException(resourceException.getStatus().getMessage());
        }
    }

    private void checkEnv() {
        if (this.env == null) {
            this.setEnvironment(new ConsoleEnvironment());
        }
    }

    public char getSeparatorChar() {
        this.checkEnv();
        ResourceManager resourceManager = this.env.getResourceManager();
        return resourceManager.getSeparatorChar();
    }

    public void report(String string) {
        this.checkEnv();
        ProgressMonitor progressMonitor = this.env.getProgressMonitor();
        progressMonitor.report(string);
    }

    public void reportWarning(String string) {
        this.checkEnv();
        ProgressMonitor progressMonitor = this.env.getProgressMonitor();
        progressMonitor.report(string);
        this.updateStatus(2, string, null);
    }

    public void reporterr(String string) {
        this.checkEnv();
        ProgressMonitor progressMonitor = this.env.getProgressMonitor();
        progressMonitor.report(string);
        this.updateStatus(4, string, null);
    }

    public void reportException(Throwable throwable) {
        this.checkEnv();
        String string = "Error: " + throwable.getMessage();
        ProgressMonitor progressMonitor = this.env.getProgressMonitor();
        progressMonitor.report(string);
        this.updateStatus(4, string, throwable);
    }

    public void updateStatus(int n, String string, Throwable throwable) {
        Object object;
        if (n > this.status.getSeverity()) {
            object = "Error messages were issued.";
            if (n == 2) {
                object = "Warning messages were issued.";
            }
            this.status = new SimpleStatus(this.status.getId(), (String)object, this.status.getChildren());
        }
        object = new SimpleStatus("", string, n, throwable);
        this.status.addChild((Status)object);
    }

    public boolean isJavaIntrospectionAllowed() {
        return this.isJavaIntrospectionAllowed;
    }

    public void setJavaContext(ResourceSet resourceSet) {
        this.javaContext = resourceSet;
    }

    public ResourceSet getJavaContext() {
        return this.javaContext;
    }

    public void setClasspathURLs(URL[] uRLArray) {
        this.classpathURLs = uRLArray;
    }

    public List getCustomBindingProviders(Object object) {
        return this.getCustomBindingProviders();
    }

    public List getCustomBindingProviders() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.classpathURLs != null && this.classpathURLs.length > 0) {
            classLoader = new URLClassLoader(this.classpathURLs, classLoader);
        }
        return this.loadCustomProviders(classLoader);
    }
}

