/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.utils.BAIS;
import com.ibm.ws.webservices.utils.BufferedWriter;
import com.ibm.ws.webservices.utils.LowFlushFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;

public final class WebServicesInputSource
extends InputSource {
    protected boolean copyIfNotResettable = false;
    protected static Log log = LogFactory.getLog(WebServicesInputSource.class.getName());
    private String _stringContent = null;
    private byte[] _byteArrayContent = null;
    private BAIS _baisContent = null;
    private Boolean _isPossiblyFault = null;

    public static WebServicesInputSource create(InputStream inputStream) {
        return new WebServicesInputSource(inputStream);
    }

    public static WebServicesInputSource create(Source source) {
        InputSource inputSource = XMLUtils.sourceToInputSource(source);
        return WebServicesInputSource.create(inputSource);
    }

    public static WebServicesInputSource create(InputSource inputSource) {
        if (inputSource instanceof WebServicesInputSource) {
            return (WebServicesInputSource)inputSource;
        }
        WebServicesInputSource webServicesInputSource = new WebServicesInputSource();
        webServicesInputSource.setPublicId(inputSource.getPublicId());
        webServicesInputSource.setSystemId(inputSource.getSystemId());
        webServicesInputSource.setEncoding(inputSource.getEncoding());
        webServicesInputSource.setByteStream(inputSource.getByteStream());
        webServicesInputSource.setCharacterStream(inputSource.getCharacterStream());
        return webServicesInputSource;
    }

    public static WebServicesInputSource create(byte[] byArray) {
        WebServicesInputSource webServicesInputSource = new WebServicesInputSource();
        webServicesInputSource.setByteArrayContent(byArray);
        return webServicesInputSource;
    }

    public static WebServicesInputSource create(String string) {
        WebServicesInputSource webServicesInputSource = new WebServicesInputSource();
        webServicesInputSource.setStringContent(string);
        return webServicesInputSource;
    }

    private WebServicesInputSource() {
    }

    private WebServicesInputSource(String string) {
        super(string);
    }

    private WebServicesInputSource(InputStream inputStream) {
        super(inputStream);
    }

    private WebServicesInputSource(Reader reader) {
        super(reader);
    }

    public boolean getCopyIfNotResettable() {
        return this.copyIfNotResettable;
    }

    public void setCopyIfNotResettable(boolean bl) {
        this.copyIfNotResettable = bl;
    }

    public void setEncoding(String string) {
        if (log.isDebugEnabled()) {
            log.debug("Enter::setEncoding() with parameter " + string);
        }
        if (this.getEncoding() != null && !this.getEncoding().equalsIgnoreCase(string)) {
            boolean bl = false;
            if (string != null && (string.equalsIgnoreCase("utf-8") || string.equalsIgnoreCase("utf-16") || string.equalsIgnoreCase("ISO-8859-1"))) {
                bl = true;
            }
            if (!bl) {
                throw new InternalException(Messages.getMessage("cantChangeEncoding", this.getEncoding(), string));
            }
            if (log.isDebugEnabled()) {
                log.debug("Allowing character encoding to be changed; this encoding will also be cached.");
            }
            String string2 = this.getStringContent();
            this._byteArrayContent = null;
            this._baisContent = null;
            byte[] byArray = JavaUtils.convertStringToBytes(string2, string);
            this.setByteArrayContent(byArray);
        }
        super.setEncoding(string);
    }

    public String getEncoding() {
        return super.getEncoding();
    }

    public void setCharacterStream(Reader reader) {
        this.clearCache();
        super.setCharacterStream(reader);
    }

    public Reader getCharacterStream() {
        return super.getCharacterStream();
    }

    public void setByteStream(InputStream inputStream) {
        this.clearCache();
        super.setByteStream(inputStream);
    }

    public InputStream getByteStream() {
        InputStream inputStream;
        if (log.isDebugEnabled()) {
            log.debug("Enter getByteStream()");
        }
        if ((inputStream = super.getByteStream()) == null || !inputStream.markSupported() && this.copyIfNotResettable) {
            if (log.isDebugEnabled()) {
                log.debug("get BAISContent");
            }
            inputStream = this.getBAISContent();
        } else if (!(inputStream instanceof FilterIS)) {
            if (log.isDebugEnabled()) {
                log.debug("Create FilterIS");
            }
            inputStream = new FilterIS(inputStream);
        }
        this.autoReset(inputStream);
        super.setByteStream(inputStream);
        if (log.isDebugEnabled()) {
            log.debug(this.dumpStats());
            log.debug("Exit getByteStream()");
        }
        return inputStream;
    }

    private void autoReset(InputStream inputStream) {
        block6: {
            if (inputStream instanceof BAIS || inputStream instanceof FilterIS && ((FilterIS)inputStream).isFilteringBAIS()) {
                try {
                    if (inputStream.available() == 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("The InputStream " + inputStream + " for " + this + " appears to be consumed.  Attempting to reset.");
                        }
                        inputStream.reset();
                        if (log.isDebugEnabled()) {
                            log.debug("Successfully reset.  There are " + inputStream.available() + " bytes available.");
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.utils.WebServicesInputSource.autoReset", "%C", this);
                    if (!log.isDebugEnabled()) break block6;
                    log.debug("Could not attempt auto reset due to error: " + exception + " Processing continues.");
                }
            }
        }
    }

    public int getContentLength() {
        int n = 0;
        if (this.hasBAISContent()) {
            BAIS bAIS = this.getBAISContent();
            n = bAIS.getContentLength();
        } else {
            InputStream inputStream = this.getByteStream();
            if (inputStream instanceof FilterIS) {
                n = (int)((FilterIS)inputStream).getLength();
            } else if (inputStream != null && inputStream.markSupported()) {
                try {
                    inputStream.reset();
                    int n2 = inputStream.available();
                    inputStream.skip(n2);
                    n = n2;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.utils.WebServicesInputSource.getContentLength", "271", this);
                    throw new InternalException(iOException);
                }
            } else {
                BAIS bAIS = this.getBAISContent();
                n = bAIS.getContentLength();
            }
        }
        return n;
    }

    public byte[] getBytes() {
        return this.getByteArrayContent();
    }

    public String getString() {
        return this.getStringContent();
    }

    public void reset() {
        try {
            InputStream inputStream = this.getByteStream();
            if (inputStream.markSupported()) {
                inputStream.reset();
            }
        }
        catch (IOException iOException) {
            log.error(Messages.getMessage("exception00"), iOException);
        }
    }

    public boolean isPossiblyFault() {
        boolean bl = false;
        if (this._isPossiblyFault != null) {
            bl = this._isPossiblyFault;
        } else if (this.hasStringContent()) {
            String string = this.getStringContent();
            int n = string.lastIndexOf(62);
            bl = n >= 0 && string.lastIndexOf("Fault", n) >= 0;
        } else if (this.hasByteArrayContent()) {
            byte[] byArray = this.getByteArrayContent();
            int n = 0;
            int n2 = byArray.length - 1;
            bl = this.isPossiblyFault(byArray, n, n2, this.getEncoding());
        } else if (this.hasBAISContent()) {
            BAIS bAIS = this.getBAISContent();
            byte[] byArray = bAIS.getBuff();
            int n = bAIS.getMark();
            int n3 = bAIS.getCount() - 1;
            bl = this.isPossiblyFault(byArray, n, n3, this.getEncoding());
        } else {
            InputStream inputStream = super.getByteStream();
            if (inputStream == null || !inputStream.markSupported()) {
                BAIS bAIS = this.getBAISContent();
                byte[] byArray = bAIS.getBuff();
                int n = bAIS.getMark();
                int n4 = bAIS.getCount() - 1;
                bl = this.isPossiblyFault(byArray, n, n4, this.getEncoding());
            } else {
                try {
                    inputStream.reset();
                    int n = inputStream.available();
                    int n5 = 4096;
                    byte[] byArray = new byte[n5];
                    for (int i = n - n5; i > 0 && !bl; i -= n5 / 2) {
                        inputStream.skip(i);
                        inputStream.read(byArray, 0, n5);
                        inputStream.reset();
                        if (!this.isPossiblyFault(byArray, 0, n5 - 1, this.getEncoding())) continue;
                        bl = true;
                    }
                    if (!bl) {
                        inputStream.reset();
                        int n6 = n > n5 ? n5 : n;
                        inputStream.read(byArray, 0, n6);
                        inputStream.reset();
                        bl = this.isPossiblyFault(byArray, 0, n6 - 1, this.getEncoding());
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.utils.WebServicesInputSource.isPossiblyFault", "381", this);
                    throw new InternalException(iOException);
                }
            }
        }
        this._isPossiblyFault = new Boolean(bl);
        return bl;
    }

    private boolean isPossiblyFault(byte[] byArray, int n, int n2, String string) {
        byte[] byArray2;
        byte[] byArray3;
        if (string == null || string.length() == 0) {
            byArray3 = new String(">").getBytes();
            byArray2 = new String("Fault").getBytes();
        } else {
            try {
                byArray3 = new String(">").getBytes(string);
                byArray2 = new String("Fault").getBytes(string);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.utils.WebServicesInputSource.isPossiblyFault", "411", this);
                return true;
            }
        }
        int n3 = JavaUtils.find(byArray3, byArray, n, n2, false);
        return n3 >= 0 && JavaUtils.find(byArray2, byArray, n, n3, false) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream, String string) throws IOException {
        if (this.hasByteArrayContent() && this.getEncoding().equalsIgnoreCase(string)) {
            byte[] byArray = this.getByteArrayContent();
            if (byArray.length == 0) {
                throw new IOException(Messages.getMessage("wsisWriteError"));
            }
            outputStream.write(this.getByteArrayContent());
        } else {
            outputStream = new LowFlushFilter(outputStream);
            Writer writer = null;
            writer = string != null ? new OutputStreamWriter(outputStream, string) : new OutputStreamWriter(outputStream);
            writer = new BufferedWriter(writer, outputStream, string);
            try {
                this.writeTo(writer);
            }
            finally {
                writer.flush();
            }
        }
    }

    public void writeTo(Writer writer) throws IOException {
        String string = this.getStringContent();
        if (string == null || string.length() == 0) {
            throw new IOException(Messages.getMessage("wsisWriteError"));
        }
        writer.write(string);
    }

    public Source createTransformSource() {
        BAIS bAIS = this.getBAISContent();
        bAIS.reset();
        return new StreamSource(bAIS);
    }

    public String dumpStats() {
        return "WebServicesInputSource Stats: " + this + " hasStringContent()?" + this.hasStringContent() + " hasByteArrayContent()?" + this.hasByteArrayContent() + " hasBAISContent()?" + this.hasBAISContent() + " BAIS available =" + (this.hasBAISContent() ? String.valueOf(this.getBAISContent().available()) : "n/a") + " BAIS mark =" + (this.hasBAISContent() ? String.valueOf(this.getBAISContent().getMark()) : "n/a") + " BAIS count =" + (this.hasBAISContent() ? String.valueOf(this.getBAISContent().getCount()) : "n/a") + " character encoding = " + this.getEncoding() + " StringContent = " + (this.hasStringContent() ? this.getStringContent() : "n/a");
    }

    private void clearCache() {
        this._stringContent = null;
        this._byteArrayContent = null;
        this._baisContent = null;
        this._isPossiblyFault = null;
    }

    private boolean hasStringContent() {
        return this._stringContent != null;
    }

    private String getStringContent() {
        if (!this.hasStringContent()) {
            byte[] byArray = this.getByteArrayContent();
            String string = JavaUtils.convertBytesToString(byArray, this.getEncoding());
            this.setStringContent(string);
        }
        return this._stringContent;
    }

    private void setStringContent(String string) {
        this._stringContent = string;
    }

    private boolean hasByteArrayContent() {
        return this._byteArrayContent != null;
    }

    private byte[] getByteArrayContent() {
        if (!this.hasByteArrayContent()) {
            if (this.hasBAISContent()) {
                BAIS bAIS = this.getBAISContent();
                byte[] byArray = bAIS.getBuff();
                if (bAIS.getContentLength() != byArray.length) {
                    byArray = new byte[bAIS.getContentLength()];
                    System.arraycopy(bAIS.getBuff(), bAIS.getMark(), byArray, 0, bAIS.getContentLength());
                }
                this.setByteArrayContent(byArray);
            } else if (this.hasStringContent()) {
                String string = this.getStringContent();
                byte[] byArray = JavaUtils.convertStringToBytes(string, this.getEncoding());
                this.setByteArrayContent(byArray);
            } else {
                BAIS bAIS = this.getBAISContent();
                byte[] byArray = bAIS.getBuff();
                if (bAIS.getContentLength() != byArray.length) {
                    byArray = new byte[bAIS.getContentLength()];
                    System.arraycopy(bAIS.getBuff(), bAIS.getMark(), byArray, 0, bAIS.getContentLength());
                }
                this.setByteArrayContent(byArray);
            }
        }
        return this._byteArrayContent;
    }

    private void setByteArrayContent(byte[] byArray) {
        this._byteArrayContent = byArray;
    }

    private boolean hasBAISContent() {
        return this._baisContent != null;
    }

    private BAIS getBAISContent() {
        if (!this.hasBAISContent()) {
            if (this.hasByteArrayContent() || this.hasStringContent()) {
                byte[] byArray = this.getByteArrayContent();
                BAIS bAIS = BAIS.create(byArray);
                this.setBAISContent(bAIS);
            } else if (super.getByteStream() != null) {
                try {
                    InputStream inputStream = super.getByteStream();
                    BAIS bAIS = BAIS.create(inputStream);
                    this.setBAISContent(bAIS);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.utils.WebServicesInputSource.getBAISContent", "450", this);
                    throw new InternalException(iOException);
                }
            } else if (this.getCharacterStream() != null) {
                try {
                    BAIS bAIS = BAIS.create(this.getCharacterStream(), this.getEncoding());
                    this.setCharacterStream(null);
                    this.setBAISContent(bAIS);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.utils.WebServicesInputSource.getBAISContent", "453", this);
                    throw new InternalException(iOException);
                }
            } else {
                throw new InternalException(Messages.getMessage("wsisInternal", "getBAISContent"));
            }
        }
        return this._baisContent;
    }

    private void setBAISContent(BAIS bAIS) {
        this._baisContent = bAIS;
        super.setByteStream(bAIS);
    }

    private static class FilterIS
    extends FilterInputStream {
        private long length = 0L;
        private boolean isBAIS;

        FilterIS(InputStream inputStream) {
            super(inputStream);
            this.isBAIS = inputStream instanceof BAIS;
        }

        public final int read() throws IOException {
            int n = super.read();
            if (n != -1) {
                ++this.length;
            }
            return n;
        }

        public final int read(byte[] byArray) throws IOException {
            int n = super.read(byArray);
            if (n != -1) {
                this.length += (long)n;
            }
            return n;
        }

        public final int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 != -1) {
                this.length += (long)n3;
            }
            return n3;
        }

        public final void close() throws IOException {
            super.close();
        }

        long getLength() {
            return this.length;
        }

        public final void reset() throws IOException {
            this.length = 0L;
            super.reset();
        }

        public boolean isFilteringBAIS() {
            return this.isBAIS;
        }
    }
}

