/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.custom.CustomPropertyProviderFactory;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DefaultSOAP12TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingBase;
import com.ibm.ws.webservices.engine.encoding.TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.custom.CustomRegistry;
import com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerSerializerFactory;
import com.ibm.ws.webservices.engine.enumtype.MIMEStyle;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.provider.BindingGenerator;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.utils.OptionDescriptor;
import com.ibm.ws.webservices.wsdl.fromJava.BeanWriter;
import com.ibm.ws.webservices.wsdl.fromJava.Namespaces;
import com.ibm.ws.webservices.wsdl.fromJava.Style;
import com.ibm.ws.webservices.wsdl.fromJava.Types;
import com.ibm.ws.webservices.wsdl.fromJava.description.FaultDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.OperationDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.ParameterDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.PortDesc;
import java.awt.Image;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.mail.internet.MimeMultipart;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaPackage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Emitter {
    private static String binaryCopyright = Version.getBinaryCopyright();
    private static final String FUL = "file:undefined_location";
    protected static Log log = LogFactory.getLog(Emitter.class.getName());
    private static final String SuppressMessagesValue = (String)CustomPropertyProviderFactory.getProvider().getValue("com.ibm.ws.webservices.startup.wsdl.suppressMessages");
    private static OptionDescriptor[] commonOptions = new OptionDescriptor[]{new OptionDescriptor("servicePortName", false, null), new OptionDescriptor("portTypeName", false, null), new OptionDescriptor("bindingName", false, null), new OptionDescriptor("location", false, null), new OptionDescriptor("soapAction", false, null), new OptionDescriptor("style", false, null), new OptionDescriptor("use", false, null), new OptionDescriptor("wrapped", false, null), new OptionDescriptor("verbose", false, null), new OptionDescriptor("debug", false, null), new OptionDescriptor("encodingStyle", false, null), new OptionDescriptor("MIMEStyle", false, null), new OptionDescriptor("intfNS", false, null), new OptionDescriptor("elementFormDefault", false, null), new OptionDescriptor("attributeFormDefault", false, null)};
    public static final int MODE_ALL = 0;
    public static final int MODE_INTERFACE = 1;
    public static final int MODE_IMPLEMENTATION = 2;
    private static final int REQUEST = 0;
    private static final int RESPONSE = 1;
    private static final int FAULT = 2;
    private static final String BINDING_TYPE_HTTP = "http";
    private static final String BINDING_TYPE_DELIMITERS = " ,;";
    private static final String CBP_NS_WSA = "http://www.w3.org/2005/08/addressing";
    private static final String CBP_SL_WSA = "http://www.w3.org/2005/08/addressing/ws-addr.xsd";
    private static final String CBP_NS_WSAW = "http://www.w3.org/2006/05/addressing/wsdl";
    private static final String CBP_SL_WSAW = "http://www.w3.org/2006/05/addressing/wsdl/ws-addr-wsdl.xsd";
    private static final String CBP_NS_WSAW_O = "http://www.w3.org/2006/02/addressing/wsdl";
    private static final String CBP_SL_WSAW_O = "http://www.w3.org/2006/02/addressing/wsdl/ws-addr-wsdl.xsd";
    private static final String CBP_NS_WSRF_R = "http://docs.oasis-open.org/wsrf/r-2";
    private static final String CBP_SL_WSRF_R = "http://docs.oasis-open.org/wsrf/r-2.xsd";
    private static final String CBP_NS_WSRF_RP = "http://docs.oasis-open.org/wsrf/rp-2";
    private static final String CBP_SL_WSRF_RP = "http://docs.oasis-open.org/wsrf/rp-2.xsd";
    private static final String CBP_NS_WSRF_RL = "http://docs.oasis-open.org/wsrf/rl-2";
    private static final String CBP_SL_WSRF_RL = "http://docs.oasis-open.org/wsrf/rl-2.xsd";
    private static final String CBP_NS_WSRF_BF = "http://docs.oasis-open.org/wsrf/bf-2";
    private static final String CBP_SL_WSRF_BF = "http://docs.oasis-open.org/wsrf/bf-2.xsd";
    private static final String CBP_NS_WSRF_SG = "http://docs.oasis-open.org/wsrf/sg-2";
    private static final String CBP_SL_WSRF_SG = "http://docs.oasis-open.org/wsrf/sg-2.xsd";
    private static final String CBP_NS_WSN_B = "http://docs.oasis-open.org/wsn/b-2";
    private static final String CBP_SL_WSN_B = "http://docs.oasis-open.org/wsn/b-2.xsd";
    private static final String CBP_NS_WSN_BR = "http://docs.oasis-open.org/wsn/br-2";
    private static final String CBP_SL_WSN_BR = "http://docs.oasis-open.org/wsn/br-2.xsd";
    private static final String CBP_NS_WSN_T = "http://docs.oasis-open.org/wsn/t-1";
    private static final String CBP_SL_WSN_T = "http://docs.oasis-open.org/wsn/t-1.xsd";
    private static final String CBP_NS_WSAT = "http://schemas.xmlsoap.org/ws/2004/10/wsat";
    private static final String CBP_SL_WSAT = "http://schemas.xmlsoap.org/ws/2004/10/wsat/wsat.xsd";
    private static final String CBP_NS_WSCOOR = "http://schemas.xmlsoap.org/ws/2004/10/wscoor";
    private static final String CBP_SL_WSCOOR = "http://schemas.xmlsoap.org/ws/2004/10/wscoor/wscoor.xsd";
    private static final String CBP_NS_WSBA = "http://schemas.xmlsoap.org/ws/2004/10/wsba";
    private static final String CBP_SL_WSBA = "http://schemas.xmlsoap.org/ws/2004/10/wsba/wsba.xsd";
    protected HashMap ns2Location = new HashMap();
    private String clsString = null;
    private JavaClass cls;
    private ArrayList extraClassesStrings = null;
    private JavaClass[] extraClasses;
    private String implClsString = null;
    private JavaClass implCls;
    private ArrayList stopClasses = new ArrayList();
    private ArrayList methods = null;
    private String intfNS;
    private String implNS;
    private String inputWSDL;
    private String locationUrl;
    private String importUrl;
    private String servicePortName;
    private String serviceElementName;
    private MIMEStyle mimeStyle = MIMEStyle.WSDL11;
    private Style style = Style.DOCUMENT;
    private Use use = null;
    private boolean wrappedSpecified = false;
    private boolean wrapped = true;
    private TypeMapping defaultTM = null;
    private String voidReturn = null;
    private boolean verbose = false;
    private boolean debug = false;
    private boolean removeBinding = false;
    private Namespaces namespaces;
    private Map exceptionMsg = null;
    private boolean elementFormDefault = false;
    private boolean elementFormDefaultOption = false;
    private boolean attributeFormDefault = false;
    private boolean attributeFormDefaultOption = false;
    private String encodingList = null;
    private Types types;
    private String clsName;
    private String portTypeName;
    private String bindingName;
    private ArrayList bindingTypes = null;
    private PortDesc portDesc;
    private PortDesc portDesc2;
    private String soapAction = "DEFAULT";
    private Map commonNSMap = new Hashtable();
    private String classpath = null;
    protected String propertiesFilename = "extraOptions.properties";
    private HashMap validOptions = null;
    protected ToolEnv env = null;
    protected HashMap availableBindingGenerators = new HashMap();
    private ArrayList useBindingGenerators = new ArrayList();
    private Properties XProperties = new Properties();
    private boolean parsed = false;
    private Namespaces editedNamespaces = null;
    private HashMap oldNewNSs = null;
    private Document intfDoc;
    private Document implDoc;
    private String implFileName = null;
    private String intfFileName = null;
    private CustomRegistry customRegistry = null;

    public Emitter() {
        this.namespaces = new Namespaces();
        this.exceptionMsg = new HashMap();
        this.stopClasses.add("javax.ejb.EJBObject");
        this.stopClasses.add("javax.ejb.SessionBean");
        this.stopClasses.add("javax.ejb.EntityBean");
        this.stopClasses.add("javax.ejb.EnterpriseBean");
        this.stopClasses.add("javax.rmi.RemoteException");
        this.initPluggableBindings();
    }

    public void preEmit(String string, String string2) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Definition definition = this.getIntfWSDL();
        Definition definition2 = this.getImplWSDL();
        if (string == null) {
            string = this.getServicePortName() + "_interface.wsdl";
        }
        if (string2 == null) {
            string2 = this.getServicePortName() + "_implementation.wsdl";
        }
        for (int i = 0; this.extraClasses != null && i < this.extraClasses.length; ++i) {
            this.types.writeTypeForPart((JavaHelpers)this.extraClasses[i], null);
        }
        this.intfDoc = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(definition);
        this.types.insertTypesFragment(this.intfDoc);
        this.intfFileName = string;
        this.implDoc = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(definition2);
        this.implFileName = string2;
        this.parsed = true;
    }

    public void emit(String string, String string2) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (!this.parsed) {
            this.preEmit(string, string2);
        }
        this.intfDoc = this.updateNamespacesInDOM(this.intfDoc);
        this.prettyDocumentToFile(this.intfDoc, this.intfFileName);
        this.implDoc = this.updateNamespacesInDOM(this.implDoc);
        this.prettyDocumentToFile(this.implDoc, this.implFileName);
    }

    private void preEmit(String string, int n) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.implDoc = this.emit(n);
        if (string == null) {
            string = this.getServicePortName();
            switch (n) {
                case 0: {
                    string = string + ".wsdl";
                    break;
                }
                case 1: {
                    string = string + "_interface.wsdl";
                    break;
                }
                case 2: {
                    string = string + "_implementation.wsdl";
                }
            }
        }
        this.implFileName = string;
        this.parsed = true;
    }

    private void emit(String string, int n) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (!this.parsed) {
            this.preEmit(string, n);
        }
        this.implDoc = this.updateNamespacesInDOM(this.implDoc);
        this.prettyDocumentToFile(this.implDoc, this.implFileName);
    }

    public void preEmit(String string) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.preEmit(string, 0);
    }

    public void emit(String string) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.emit(string, 0);
    }

    private Document emit(int n) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Document document = null;
        Definition definition = null;
        switch (n) {
            case 0: {
                definition = this.getWSDL();
                for (int i = 0; this.extraClasses != null && i < this.extraClasses.length; ++i) {
                    this.types.writeTypeForPart((JavaHelpers)this.extraClasses[i], null);
                }
                document = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(definition);
                this.types.insertTypesFragment(document);
                break;
            }
            case 1: {
                definition = this.getIntfWSDL();
                for (int i = 0; this.extraClasses != null && i < this.extraClasses.length; ++i) {
                    this.types.writeTypeForPart((JavaHelpers)this.extraClasses[i], null);
                }
                document = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(definition);
                this.types.insertTypesFragment(document);
                break;
            }
            case 2: {
                definition = this.getImplWSDL();
                document = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(definition);
            }
        }
        return document;
    }

    private String emitToString(int n) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Document document = this.emit(n);
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        XMLUtils.PrettyDocumentToWriter(document, bufferedWriter);
        bufferedWriter.close();
        return stringWriter.getBuffer().toString();
    }

    public Definition getWSDL() throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.init(0);
        Definition definition = this.createDefinition();
        this.addDefinitionHeader(definition, this.intfNS);
        this.types = this.createTypes(definition);
        PortType portType = this.addPortType(definition);
        this.checkPortType(definition, portType);
        for (int i = 0; i < this.useBindingGenerators.size(); ++i) {
            BindingGenerator bindingGenerator = (BindingGenerator)this.useBindingGenerators.get(i);
            Binding binding = this.addBinding(definition, portType, bindingGenerator);
            this.addService(definition, binding, bindingGenerator);
        }
        return definition;
    }

    public Definition getIntfWSDL() throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.init(1);
        Definition definition = this.createDefinition();
        this.addDefinitionHeader(definition, this.intfNS);
        this.types = this.createTypes(definition);
        PortType portType = this.addPortType(definition);
        this.checkPortType(definition, portType);
        for (int i = 0; i < this.useBindingGenerators.size(); ++i) {
            BindingGenerator bindingGenerator = (BindingGenerator)this.useBindingGenerators.get(i);
            this.addBinding(definition, portType, bindingGenerator);
        }
        return definition;
    }

    public Definition getImplWSDL() throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.init(2);
        Definition definition = this.createDefinition();
        this.addDefinitionHeader(definition, this.implNS);
        this.addImport(definition, this.intfNS, this.importUrl);
        for (int i = 0; i < this.useBindingGenerators.size(); ++i) {
            BindingGenerator bindingGenerator = (BindingGenerator)this.useBindingGenerators.get(i);
            Binding binding = definition.createBinding();
            binding.setUndefined(false);
            QName qName = QNameTable.createQName(this.intfNS, bindingGenerator.getBindingName(this.XProperties));
            binding.setQName(qName);
            this.addService(definition, binding, bindingGenerator);
        }
        return definition;
    }

    private void init(int n) throws IOException {
        if (this.env == null) {
            this.env = DefaultToolEnv.create();
        }
        if (this.classpath != null && this.env instanceof DefaultToolEnv) {
            ((DefaultToolEnv)this.env).setIntrospectionClassPath(this.classpath);
        }
        try {
            this.findCls();
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webservices.wsdl.fromJava.Emitter.init", "725", this);
            log.error(Messages.getMessage("j2werror00", classNotFoundException.toString()));
            throw new IOException(classNotFoundException.toString());
        }
        try {
            this.findImplCls();
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webservices.wsdl.fromJava.Emitter.init", "733", this);
            log.error(Messages.getMessage("j2werror00", classNotFoundException.toString()));
            throw new IOException(classNotFoundException.toString());
        }
        try {
            this.findExtraClasses();
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webservices.wsdl.fromJava.Emitter.init", "740", this);
            log.error(Messages.getMessage("j2woptBadClass00", classNotFoundException.toString()));
            throw new IOException(classNotFoundException.toString());
        }
        if (this.voidReturn == null) {
            this.voidReturn = "TWOWAY";
        }
        if (this.use == null) {
            this.use = this.style == Style.RPC ? Use.ENCODED : Use.LITERAL;
        }
        if (this.style == Style.DOCUMENT && this.use == Use.ENCODED) {
            this.env.reportWarning(Messages.getMessage("invalidDocEnc00", this.style.getName(), this.use.getName()));
            this.use = Use.LITERAL;
        }
        if (this.use == Use.ENCODED || this.style == Style.RPC) {
            if (this.wrappedSpecified && this.wrapped) {
                this.env.reportWarning(Messages.getMessage("j2woptBadWrapped00"));
            }
            this.wrapped = false;
        }
        this.initCustomBindingRegistry();
        this.initNs2Location();
        this.defaultTM = this.use == Use.ENCODED ? DefaultSOAP12TypeMappingImpl.getSingleton() : DefaultTypeMappingImpl.getSingleton();
        this.defaultTM = this.mimeTypeMapping((TypeMappingBase)this.defaultTM);
        if (this.bindingTypes == null) {
            this.initBindingTypes();
        }
        if (this.portDesc == null) {
            this.portDesc = new PortDesc(this);
            this.portDesc.setUniqueParamNames(this.style == Style.DOCUMENT && this.use == Use.LITERAL && !this.wrapped);
            this.portDesc.setImplClass(this.cls);
            this.portDesc.setTypeMapping(this.defaultTM);
            this.portDesc.setStopClasses(this.stopClasses);
            this.portDesc.setMethods(this.methods);
            if (this.implCls != null && this.implCls != this.cls && this.portDesc2 == null) {
                this.portDesc2 = new PortDesc(this);
                this.portDesc2.setUniqueParamNames(this.style == Style.DOCUMENT && this.use == Use.LITERAL && !this.wrapped);
                this.portDesc2.setImplClass(this.implCls);
                this.portDesc2.setTypeMapping(this.defaultTM);
                this.portDesc2.setStopClasses(this.stopClasses);
                this.portDesc2.setMethods(this.methods);
            }
        }
        if (this.encodingList == null) {
            this.clsName = this.cls.getName();
            if (this.getPortTypeName() == null) {
                this.setPortTypeName(JavaUtils.java2NCName(this.clsName));
            }
            if (this.getServiceElementName() == null) {
                this.setServiceElementName(this.getPortTypeName() + "Service");
            }
            if (this.getServicePortName() == null) {
                this.initServicePortName();
            }
            this.encodingList = Constants.URI_DEFAULT_SOAP_ENC;
            if (this.intfNS == null) {
                JavaPackage javaPackage = this.cls.getJavaPackage();
                this.intfNS = this.namespaces.getCreate(javaPackage == null ? null : javaPackage.getPackageName());
            }
            if (this.getBindingName() == null) {
                this.setBindingName(this.getServicePortName());
            }
            if (this.implNS == null) {
                int n2;
                this.implNS = n == 0 ? this.intfNS : ((n2 = this.intfNS.indexOf("://")) > 0 ? this.intfNS.substring(0, n2 += 3) + "impl." + this.intfNS.substring(n2) : this.intfNS + "-impl");
            }
            this.namespaces.put(this.cls.getJavaName(), this.intfNS, "intf");
            this.namespaces.putPrefix(this.implNS, "impl");
        }
        this.initLocation();
        this.seedProperties();
        this.validatePluginOptions();
    }

    private void initCustomBindingRegistry() {
        if (this.customRegistry == null) {
            List list = null;
            try {
                list = this.env.getCustomBindingProviders(this.classpath);
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
            if (list != null) {
                this.customRegistry = new CustomRegistry();
                this.customRegistry.populate(list);
            }
        }
    }

    private TypeMapping mimeTypeMapping(TypeMappingBase typeMappingBase) {
        if (this.mimeStyle == MIMEStyle.SWAREF) {
            typeMappingBase = new TypeMappingImpl(typeMappingBase);
            if (JavaUtils.isAttachmentSupported()) {
                typeMappingBase.register(Image.class, Constants.WSI_SWAREF, new JAFDataHandlerSerializerFactory(Image.class, Constants.WSI_SWAREF), new JAFDataHandlerDeserializerFactory(Image.class, Constants.WSI_SWAREF));
                typeMappingBase.register(MimeMultipart.class, Constants.WSI_SWAREF, new JAFDataHandlerSerializerFactory(MimeMultipart.class, Constants.WSI_SWAREF), new JAFDataHandlerDeserializerFactory(MimeMultipart.class, Constants.WSI_SWAREF));
                typeMappingBase.register(Source.class, Constants.WSI_SWAREF, new JAFDataHandlerSerializerFactory(Source.class, Constants.WSI_SWAREF), new JAFDataHandlerDeserializerFactory(Source.class, Constants.WSI_SWAREF));
                typeMappingBase.register(DataHandler.class, Constants.WSI_SWAREF, new JAFDataHandlerSerializerFactory(DataHandler.class, Constants.WSI_SWAREF), new JAFDataHandlerDeserializerFactory(DataHandler.class, Constants.WSI_SWAREF));
            }
        } else if (this.mimeStyle == MIMEStyle.AXIS) {
            typeMappingBase = new TypeMappingImpl(typeMappingBase);
            if (JavaUtils.isAttachmentSupported()) {
                typeMappingBase.register(DataHandler.class, Constants.MIME_DATA_HANDLER, new JAFDataHandlerSerializerFactory(DataHandler.class, Constants.MIME_DATA_HANDLER), new JAFDataHandlerDeserializerFactory(DataHandler.class, Constants.MIME_DATA_HANDLER));
            }
        }
        return typeMappingBase;
    }

    private Definition createDefinition() throws WSDLException, SAXException, IOException, ParserConfigurationException {
        Definition definition;
        if (this.inputWSDL == null) {
            definition = new ServiceProviderManager(null).getWSDLFactory().newDefinition();
        } else {
            WSDLReader wSDLReader = new ServiceProviderManager(null).getWSDLFactory().newWSDLReader();
            Document document = XMLUtils.newDocument(this.inputWSDL);
            definition = wSDLReader.readWSDL(this.inputWSDL, document);
            definition.setTypes(null);
        }
        return definition;
    }

    private Types createTypes(Definition definition) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.types = new Types(this, definition, this.defaultTM, this.namespaces, this.intfNS, this.stopClasses, this.style, this.use, this.verbose, this.elementFormDefault, this.attributeFormDefault);
        if (this.inputWSDL != null) {
            this.types.loadInputTypes(this.inputWSDL);
        }
        return this.types;
    }

    private void addDefinitionHeader(Definition definition, String string) {
        definition.setTargetNamespace(string);
        definition.addNamespace("intf", this.intfNS);
        definition.addNamespace("impl", this.implNS);
        definition.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/soap/", "wsdlsoap");
        definition.addNamespace("wsi", "http://ws-i.org/profiles/basic/1.1/xsd");
        this.namespaces.putPrefix("http://ws-i.org/profiles/basic/1.1/xsd", "wsi");
        definition.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        this.commonNSMap.put("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        if (this.use != Use.LITERAL) {
            definition.addNamespace("soapenc", Constants.URI_DEFAULT_SOAP_ENC);
            this.namespaces.putPrefix(Constants.URI_DEFAULT_SOAP_ENC, "soapenc");
            this.commonNSMap.put("soapenc", Constants.URI_DEFAULT_SOAP_ENC);
        }
        definition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.namespaces.putPrefix("http://www.w3.org/2001/XMLSchema", "xsd");
        this.commonNSMap.put("xsd", "http://www.w3.org/2001/XMLSchema");
    }

    Map getCommonNSMap() {
        return this.commonNSMap;
    }

    private void addImport(Definition definition, String string, String string2) {
        Import import_ = definition.createImport();
        import_.setNamespaceURI(string);
        if (string2 != null && !string2.equals("")) {
            import_.setLocationURI(string2);
        }
        definition.addImport(import_);
    }

    private PortType addPortType(Definition definition) throws WSDLException {
        PortType portType;
        QName qName = QNameTable.createQName(this.intfNS, this.getPortTypeName());
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "portType", qName.toString()));
        }
        if ((portType = definition.getPortType(qName)) != null) {
            return portType;
        }
        portType = definition.createPortType();
        portType.setUndefined(false);
        portType.setQName(qName);
        definition.addPortType(portType);
        ArrayList arrayList = this.portDesc.getOperations();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            OperationDesc[] operationDescArray;
            OperationDesc operationDesc;
            OperationDesc operationDesc2 = operationDesc = (OperationDesc)iterator.next();
            if (this.style == Style.DOCUMENT && this.use == Use.LITERAL && this.wrapped && (operationDescArray = this.portDesc.getOperationsByName(operationDesc.getName())) != null && operationDescArray.length > 1) {
                this.env.reportFatalErr(Messages.getMessage("DocLitWrappedOverloaded", operationDesc.getName()));
            }
            if (this.portDesc2 != null) {
                operationDescArray = this.portDesc2.getOperationsByName(operationDesc.getName());
                boolean bl = false;
                if (operationDescArray != null) {
                    for (int i = 0; i < operationDescArray.length && !bl; ++i) {
                        OperationDesc operationDesc3 = operationDescArray[i];
                        if (operationDesc3.getParameters().size() != operationDesc.getParameters().size()) continue;
                        boolean bl2 = true;
                        for (int j = 0; j < operationDesc.getParameters().size() && bl2; ++j) {
                            if (operationDesc3.getParameter(j).getMode() == operationDesc.getParameter(j).getMode() && operationDesc3.getParameter(j).getJavaType().equals(operationDesc.getParameter(j).getJavaType())) continue;
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        operationDesc2 = operationDesc3;
                        bl = true;
                    }
                }
            }
            this.addOperation(definition, portType, operationDesc2);
        }
        return portType;
    }

    private Operation addOperation(Definition definition, PortType portType, OperationDesc operationDesc) throws WSDLException {
        Object object;
        Operation operation = definition.createOperation();
        operation.setName(operationDesc.getName());
        operation.setUndefined(false);
        portType.addOperation(operation);
        Message message = this.addRequestMessage(definition, operationDesc);
        Input input = definition.createInput();
        input.setMessage(message);
        String string = message.getQName().getLocalPart();
        input.setName(string);
        operation.setInput(input);
        message = this.addResponseMessage(definition, operationDesc);
        Output output = definition.createOutput();
        output.setMessage(message);
        string = message.getQName().getLocalPart();
        output.setName(string);
        operation.setOutput(output);
        ArrayList arrayList = operationDesc.getFaults();
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            object = (FaultDesc)arrayList.get(i);
            message = this.addFaultMessage(definition, (FaultDesc)object);
            Fault fault2 = definition.createFault();
            fault2.setMessage(message);
            fault2.setName(JavaUtils.java2NCName(((FaultDesc)object).getJavaClass().getName()));
            operation.addFault(fault2);
        }
        ArrayList arrayList2 = operationDesc.getParameters();
        object = new Vector();
        for (int i = 0; i < arrayList2.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)arrayList2.get(i);
            ((Vector)object).add(parameterDesc.getName());
        }
        if (((Vector)object).size() > 0 && !this.isWrapped()) {
            operation.setParameterOrdering((List)object);
        }
        return operation;
    }

    private Message addRequestMessage(Definition definition, OperationDesc operationDesc) throws WSDLException {
        Message message = definition.createMessage();
        QName qName = this.createMessageName(definition, operationDesc.getName(), "Request");
        message.setQName(qName);
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "message", qName.toString()));
        }
        message.setUndefined(false);
        ArrayList arrayList = operationDesc.getParameters();
        if (this.isWrapped() && arrayList.size() == 0) {
            QName qName2 = QNameTable.createQName(message.getQName().getNamespaceURI(), message.getQName().getLocalPart().substring(0, message.getQName().getLocalPart().lastIndexOf("Request")));
            if (this.types.writeWrapperForPart(qName2, null, null, false, false)) {
                Part part = definition.createPart();
                part.setName("parameters");
                part.setElementName(qName2);
                message.addPart(part);
            }
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                ParameterDesc parameterDesc = (ParameterDesc)arrayList.get(i);
                this.addPartToMessage(definition, message, 0, parameterDesc);
            }
        }
        definition.addMessage(message);
        return message;
    }

    private Message addResponseMessage(Definition definition, OperationDesc operationDesc) throws WSDLException {
        Serializable serializable;
        Message message = definition.createMessage();
        QName qName = this.createMessageName(definition, operationDesc.getName(), "Response");
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "message", qName.toString()));
        }
        message.setQName(qName);
        message.setUndefined(false);
        JavaHelpers javaHelpers = operationDesc.getReturnClass();
        if (this.isWrapped() && (javaHelpers == null || javaHelpers.getJavaName().equals("void"))) {
            this.types.writeWrapperForPart(qName, null, null, false, false);
            serializable = definition.createPart();
            serializable.setName("parameters");
            serializable.setElementName(qName);
            message.addPart((Part)serializable);
        } else {
            serializable = new ParameterDesc();
            ((ParameterDesc)serializable).setName(operationDesc.getName() + "Return");
            ((ParameterDesc)serializable).setMode((byte)2);
            ((ParameterDesc)serializable).setIsReturn(true);
            ((ParameterDesc)serializable).setJavaType(operationDesc.getReturnClass(), this);
            this.addPartToMessage(definition, message, 1, (ParameterDesc)serializable);
        }
        serializable = operationDesc.getParameters();
        Iterator iterator = ((ArrayList)serializable).iterator();
        while (iterator.hasNext()) {
            ParameterDesc parameterDesc = (ParameterDesc)iterator.next();
            this.addPartToMessage(definition, message, 1, parameterDesc);
        }
        definition.addMessage(message);
        return message;
    }

    private Message addFaultMessage(Definition definition, FaultDesc faultDesc) throws WSDLException {
        String string = faultDesc.getJavaClass().getJavaPackage().getName();
        String string2 = JavaUtils.java2NCName(faultDesc.getJavaClass().getName());
        Message message = (Message)this.exceptionMsg.get(faultDesc.getJavaClass().getJavaName());
        if (message == null) {
            message = definition.createMessage();
            QName qName = this.createMessageName(definition, string2, "");
            if (this.verbose) {
                this.env.report(Messages.getMessage("j2wGen00", "message", qName.toString()));
            }
            message.setQName(qName);
            message.setUndefined(false);
            ParameterDesc parameterDesc = new ParameterDesc(QNameTable.createQName("", "fault"), 1, this.types.getTypeQName((JavaHelpers)faultDesc.getJavaClass()), (JavaHelpers)faultDesc.getJavaClass(), false, false);
            this.addPartToMessage(definition, message, 2, parameterDesc);
            this.exceptionMsg.put(faultDesc.getJavaClass().getJavaName(), message);
            definition.addMessage(message);
        }
        return message;
    }

    public Part addPartToMessage(Definition definition, Message message, int n, ParameterDesc parameterDesc) throws WSDLException {
        if (parameterDesc == null || parameterDesc.getJavaType().getJavaName().equals("void")) {
            return null;
        }
        if (n == 2 && parameterDesc.getMode() != 1) {
            return null;
        }
        if (n == 0 && parameterDesc.getMode() == 2) {
            return null;
        }
        if (n == 1 && parameterDesc.getMode() == 1) {
            return null;
        }
        Part part = definition.createPart();
        JavaHelpers javaHelpers = parameterDesc.getHeldJavaType(this);
        if (this.isWrapped() && n != 2) {
            boolean bl = false;
            JavaHelpers javaHelpers2 = javaHelpers;
            QName qName = this.types.writeTypeForPart(javaHelpers2, parameterDesc.getTypeQName());
            QName qName2 = null;
            qName2 = n == 0 ? QNameTable.createQName(message.getQName().getNamespaceURI(), message.getQName().getLocalPart().substring(0, message.getQName().getLocalPart().lastIndexOf("Request"))) : message.getQName();
            if (qName != null && this.types.writeWrapperForPart(qName2, parameterDesc.getName(), qName, bl, this.types.isNullable(javaHelpers2))) {
                part.setName("parameters");
                part.setElementName(qName2);
                message.addPart(part);
            }
        } else if (this.use == Use.ENCODED || this.style == Style.RPC) {
            QName qName = this.types.writeTypeForPart(javaHelpers, parameterDesc.getTypeQName());
            this.types.writeElementForPart(javaHelpers, parameterDesc.getTypeQName(), parameterDesc.getName());
            if (qName != null) {
                part.setName(parameterDesc.getName());
                part.setTypeName(qName);
                message.addPart(part);
            }
        } else if (this.use == Use.LITERAL) {
            QName qName = this.types.writeTypeForPart(javaHelpers, parameterDesc.getTypeQName());
            QName qName3 = this.types.writeElementForPart(javaHelpers, parameterDesc.getTypeQName(), parameterDesc.getName());
            if (!BeanWriter.isMIMEType(javaHelpers.getJavaName())) {
                if (qName3 != null) {
                    part.setName(parameterDesc.getName());
                    part.setElementName(qName3);
                    message.addPart(part);
                } else if (qName != null) {
                    part.setName(parameterDesc.getName());
                    part.setTypeName(qName);
                    message.addPart(part);
                }
            } else if (qName != null) {
                part.setName(parameterDesc.getName());
                part.setTypeName(qName);
                message.addPart(part);
            } else if (qName3 != null) {
                part.setName(parameterDesc.getName());
                part.setElementName(qName3);
                message.addPart(part);
            }
        }
        return part;
    }

    private Binding addBinding(Definition definition, PortType portType, BindingGenerator bindingGenerator) {
        if (bindingGenerator == null) {
            return null;
        }
        QName qName = QNameTable.createQName(this.intfNS, bindingGenerator.getBindingName(this.XProperties));
        Binding binding = definition.getBinding(qName);
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "binding", qName.toString()));
        }
        if (binding != null) {
            this.env.reportWarning(Messages.getMessage("duplicateBinding", qName.toString()));
            return binding;
        }
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "binding", qName.toString()));
        }
        if (bindingGenerator != null) {
            binding = bindingGenerator.makeBinding(definition, portType, qName, this.XProperties);
            definition.addBinding(binding);
        }
        return binding;
    }

    private void addService(Definition definition, Binding binding, BindingGenerator bindingGenerator) {
        QName qName = QNameTable.createQName(this.implNS, this.getServiceElementName());
        Service service = definition.getService(qName);
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "service", qName.toString()));
        }
        if (service == null) {
            service = definition.createService();
            service.setQName(qName);
            definition.addService(service);
        }
        Port port2 = definition.createPort();
        port2.setBinding(binding);
        if (bindingGenerator != null) {
            ExtensibilityElement extensibilityElement;
            port2.setName(bindingGenerator.getPortName(this.XProperties));
            if (this.verbose) {
                this.env.report(Messages.getMessage("j2wGen00", "port", port2.getName()));
            }
            if ((extensibilityElement = bindingGenerator.makePortAddress(definition, port2, this.XProperties)) != null) {
                port2.addExtensibilityElement(extensibilityElement);
            }
        }
        service.addPort(port2);
    }

    private void checkPortType(Definition definition, PortType portType) {
        Object object;
        Object object2;
        Serializable serializable;
        Iterator<Object> iterator;
        if (this.voidReturn.equals("TWOWAY")) {
            return;
        }
        if (portType.getOperations() != null) {
            iterator = portType.getOperations().iterator();
            while (iterator.hasNext()) {
                serializable = (Operation)iterator.next();
                if (this.isWrapped()) {
                    object2 = null;
                    boolean bl = false;
                    object = this.portDesc.getOperations();
                    Iterator iterator2 = ((ArrayList)object).iterator();
                    while (iterator2.hasNext() && !bl) {
                        OperationDesc operationDesc = (OperationDesc)iterator2.next();
                        if (!operationDesc.getName().equals(serializable.getName())) continue;
                        object2 = operationDesc;
                        bl = true;
                    }
                    if (object2 != null && (((OperationDesc)object2).getReturnClass() == null || ((OperationDesc)object2).getReturnClass().getJavaName().equals("void"))) {
                        serializable.setOutput(null);
                    }
                } else if (serializable.getOutput() == null || serializable.getOutput().getMessage() == null || serializable.getOutput().getMessage().getParts() == null || serializable.getOutput().getMessage().getParts().size() <= 0) {
                    serializable.setOutput(null);
                }
                if (serializable.getOutput() != null || (object2 = serializable.getFaults()) == null || object2.size() <= 0) continue;
                log.warn(Messages.getMessage("j2wonewayfaulterr00", serializable.getName(), portType.getQName().toString()));
                this.env.reportWarning(Messages.getMessage("j2wonewayfaulterr00", serializable.getName(), portType.getQName().toString()));
                serializable.setOutput(null);
                if (object2 == null) continue;
                object2.clear();
            }
        }
        if (definition.getBindings() != null) {
            iterator = definition.getBindings().values().iterator();
            while (iterator.hasNext()) {
                serializable = (Binding)iterator.next();
                if (serializable.getPortType() != portType || serializable.getBindingOperations() == null) continue;
                object2 = serializable.getBindingOperations().iterator();
                while (object2.hasNext()) {
                    BindingOperation bindingOperation = (BindingOperation)object2.next();
                    if (bindingOperation.getOperation() == null || bindingOperation.getOperation().getOutput() != null) continue;
                    object = bindingOperation.getBindingFaults();
                    if (bindingOperation.getBindingOutput() == null && (object == null || object.size() <= 0)) continue;
                    bindingOperation.setBindingOutput(null);
                    if (object == null) continue;
                    object.clear();
                }
            }
        }
    }

    private QName createMessageName(Definition definition, String string, String string2) {
        QName qName = QNameTable.createQName(this.intfNS, string.concat(string2));
        int n = 1;
        while (definition.getMessage(qName) != null) {
            StringBuffer stringBuffer = new StringBuffer(string.concat(string2));
            stringBuffer.append(n);
            qName = QNameTable.createQName(this.intfNS, stringBuffer.toString());
            ++n;
        }
        return qName;
    }

    private void prettyDocumentToFile(Document document, String string) throws IOException {
        OutputStream outputStream = this.env.getOutputStream(string);
        if (outputStream != null) {
            XMLUtils.PrettyDocumentToStream(document, outputStream);
            outputStream.close();
        }
    }

    public void setMIMEStyle(String string) {
        this.mimeStyle = MIMEStyle.getMIMEStyle(string);
    }

    public void setMIMEStyle(MIMEStyle mIMEStyle) {
        this.mimeStyle = mIMEStyle;
    }

    public MIMEStyle getMIMEStyle() {
        return this.mimeStyle;
    }

    public void setCls(String string) {
        this.clsString = string;
    }

    private void findCls() throws ClassNotFoundException {
        if (this.clsString != null) {
            this.cls = (JavaClass)this.env.getClassFactory().forName(this.clsString);
            if (this.cls == null) {
                throw new ClassNotFoundException(this.clsString);
            }
        }
    }

    public void setImplCls(String string) {
        this.implClsString = string;
    }

    private void findImplCls() throws ClassNotFoundException {
        if (this.implClsString != null) {
            this.implCls = (JavaClass)this.env.getClassFactory().forName(this.implClsString);
            if (this.implCls == null) {
                throw new ClassNotFoundException(this.implClsString);
            }
        }
    }

    public String getIntfNamespace() {
        return this.intfNS;
    }

    public void setIntfNamespace(String string) {
        this.intfNS = string;
    }

    public String getImplNamespace() {
        return this.implNS;
    }

    public void setImplNamespace(String string) {
        this.implNS = string;
    }

    public void setStopClasses(ArrayList arrayList) {
        if (this.stopClasses == null) {
            this.stopClasses = new ArrayList();
        }
        this.stopClasses.addAll(arrayList);
    }

    public void setStopClasses(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,+");
            if (this.stopClasses == null) {
                this.stopClasses = new ArrayList();
            }
            while (stringTokenizer.hasMoreTokens()) {
                this.stopClasses.add(stringTokenizer.nextToken());
            }
        }
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public void setMethods(ArrayList arrayList) {
        if (this.methods == null) {
            this.methods = new ArrayList();
        }
        this.methods.addAll(arrayList);
    }

    public void setMethods(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,+");
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            while (stringTokenizer.hasMoreTokens()) {
                this.methods.add(stringTokenizer.nextToken());
            }
        }
    }

    public ArrayList getMethods() {
        return this.methods;
    }

    public Map getNamespaceMap() {
        return this.namespaces;
    }

    public void setNamespaceMap(Map map) {
        if (map != null) {
            this.namespaces.putAll(map);
        }
    }

    public HashMap getPkg2NSMap() {
        return this.namespaces;
    }

    public void setPkg2NSMap(HashMap hashMap) {
        if (hashMap != null) {
            this.editedNamespaces = new Namespaces();
            this.editedNamespaces.putAll((Map)hashMap);
        }
    }

    public String getInputWSDL() {
        return this.inputWSDL;
    }

    public void setInputWSDL(String string) {
        this.inputWSDL = string;
    }

    public String getLocationUrl() {
        return this.locationUrl;
    }

    public void setLocationUrl(String string) {
        this.locationUrl = string;
    }

    public String getImportUrl() {
        return this.importUrl;
    }

    public void setImportUrl(String string) {
        this.importUrl = string;
    }

    public String getServicePortName() {
        return this.servicePortName;
    }

    public void setServicePortName(String string) {
        this.servicePortName = string;
    }

    public String getServiceElementName() {
        return this.serviceElementName;
    }

    public void setServiceElementName(String string) {
        this.serviceElementName = string;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(String string) {
        this.portTypeName = string;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String string) {
        this.bindingName = string;
    }

    public void setBindingTypes(String string) {
        this.bindingTypes = new ArrayList();
        this.useBindingGenerators.clear();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, BINDING_TYPE_DELIMITERS);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                BindingGenerator bindingGenerator = (BindingGenerator)this.availableBindingGenerators.get(string2);
                if (bindingGenerator == null) {
                    this.env.reportFatalErr(Messages.getMessage("noGenerator", string2));
                    continue;
                }
                this.addBindingGenerator(bindingGenerator);
                this.bindingTypes.add(string2);
                if (!this.verbose) continue;
                this.env.report(Messages.getMessage("foundGenerator", string2));
            }
        }
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String string) {
        this.soapAction = string;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(String string) {
        this.style = Style.getStyle(string);
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Use getUse() {
        return this.use;
    }

    public void setUse(String string) {
        this.use = Use.getUse(string);
    }

    public void setUse(Use use) {
        this.use = use;
    }

    public void setWrapped(boolean bl) {
        this.wrappedSpecified = true;
        this.wrapped = bl;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public void setTransport(String string) {
        if (string == null || string.length() == 0) {
            string = BINDING_TYPE_HTTP;
        }
        this.setBindingTypes(string);
    }

    public void setVerbose(boolean bl) {
        this.verbose = SuppressMessagesValue.equals("NONE") ? bl : false;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setElementFormDefault(boolean bl) {
        this.elementFormDefault = bl;
    }

    public boolean getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefaultOption(boolean bl) {
        this.elementFormDefaultOption = bl;
    }

    public boolean getElementFormDefaultOption() {
        return this.elementFormDefaultOption;
    }

    public void setAttributeFormDefault(boolean bl) {
        this.attributeFormDefault = bl;
    }

    public boolean getAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    public void setAttributeFormDefaultOption(boolean bl) {
        this.attributeFormDefaultOption = bl;
    }

    public boolean getAttributeFormDefaultOption() {
        return this.attributeFormDefaultOption;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setToolEnv(ToolEnv toolEnv) {
        this.env = toolEnv;
    }

    public ToolEnv getToolEnv() {
        return this.env;
    }

    public void setVoidReturn(String string) {
        if (string.equalsIgnoreCase("ONEWAY")) {
            this.voidReturn = "ONEWAY";
        } else if (string.equalsIgnoreCase("TWOWAY")) {
            this.voidReturn = "TWOWAY";
        } else {
            log.error(Messages.getMessage("j2voidreturnerr00"));
            this.env.reportFatalErr(Messages.getMessage("j2wvoidreturnerr00"));
        }
    }

    public void setExtraClasses(String string) {
        boolean bl = false;
        if (string != null) {
            if (this.extraClassesStrings == null) {
                this.extraClassesStrings = new ArrayList();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.extraClassesStrings.add(string2);
            }
        }
    }

    private void findExtraClasses() throws ClassNotFoundException {
        if (this.extraClassesStrings != null) {
            JavaClass javaClass;
            JavaClass[] javaClassArray;
            int n;
            ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
            for (n = 0; n < this.extraClassesStrings.size(); ++n) {
                javaClassArray = (JavaClass[])this.extraClassesStrings.get(n);
                JavaClass javaClass2 = (JavaClass)this.env.getClassFactory().forName((String)javaClassArray);
                if (javaClass2 == null) {
                    throw new ClassNotFoundException((String)javaClassArray);
                }
                arrayList.add(javaClass2);
            }
            n = 0;
            if (this.extraClasses != null) {
                javaClassArray = new JavaClass[arrayList.size() + this.extraClasses.length];
                for (int i = 0; i < this.extraClasses.length; ++i) {
                    javaClassArray[i] = javaClass = this.extraClasses[i];
                }
                n = this.extraClasses.length;
            } else {
                javaClassArray = new JavaClass[arrayList.size()];
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                javaClassArray[i + n] = javaClass = (JavaClass)arrayList.get(i);
            }
            this.extraClasses = javaClassArray;
        }
    }

    public void setPropertiesFile(String string) throws ClassNotFoundException {
        if (string != null) {
            this.propertiesFilename = string;
        }
        try {
            Properties properties = new Properties();
            properties.load(this.env.getInputStream(this.propertiesFilename));
            int n = 0;
            if (properties.size() > 0) {
                String string2 = null;
                string2 = properties.getProperty("extraClasses");
                if (string2 != null) {
                    this.setExtraClasses(string2);
                    n = 1;
                }
                if (properties.size() > n) {
                    this.setXProperties(properties);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Document updateNamespacesInDOM(Document document) {
        if (this.editedNamespaces != null && !this.editedNamespaces.isEmpty()) {
            this.oldNewNSs = new HashMap();
            Iterator iterator = this.editedNamespaces.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                String string3 = (String)this.namespaces.get(string);
                if (string3 == null || string3.equals(string2)) continue;
                this.oldNewNSs.put(string3, string2);
            }
            if (this.oldNewNSs != null && !this.oldNewNSs.isEmpty()) {
                this.walkDOM(document);
            }
        }
        return document;
    }

    private void walkDOM(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                Document document = (Document)node;
                this.walkDOM(document.getDocumentElement());
                break;
            }
            case 1: {
                Object object = node.getAttributes();
                if (object != null) {
                    for (int i = 0; i < object.getLength(); ++i) {
                        String string;
                        Node node2 = object.item(i);
                        String string2 = node2.getNodeName();
                        String string3 = node2.getNodeValue();
                        if (string2 == null || string3 == null || !string2.equals("targetNamespace") && !string2.equals("namespace") && !string2.equals("xmlns") && !string2.startsWith("xmlns:") || (string = (String)this.oldNewNSs.get(string3)) == null) continue;
                        node2.setNodeValue(string);
                    }
                }
            }
            case 5: {
                Object object;
                for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                    this.walkDOM((Node)object);
                }
                break;
            }
        }
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public String getClasspath() {
        return this.classpath;
    }

    private void initLocation() {
        if (this.locationUrl == null) {
            this.locationUrl = FUL;
            if (this.bindingTypes.size() == 1) {
                if (this.XProperties.getProperty(this.bindingTypes.get(0) + ".location") == null) {
                    this.env.reportWarning(Messages.getMessage("java2wsdl.UndefinedLocation", FUL));
                }
            } else {
                for (int i = 0; i < this.bindingTypes.size(); ++i) {
                    if (this.XProperties.getProperty(this.bindingTypes.get(i) + ".location") != null) continue;
                    this.env.reportWarning(Messages.getMessage("missingLocation", (String)this.bindingTypes.get(i), FUL));
                }
            }
        } else if (this.bindingTypes.size() > 1) {
            this.locationUrl = FUL;
            this.env.reportWarning(Messages.getMessage("genericLocation"));
        }
    }

    private void initServicePortName() {
        if (this.getServicePortName() == null) {
            String string = this.getLocationUrl();
            if (string != null) {
                if ((string = string.lastIndexOf(47) > 0 ? string.substring(string.lastIndexOf(47) + 1) : (string.lastIndexOf(92) > 0 ? string.substring(string.lastIndexOf(92) + 1) : null)) != null && string.endsWith(".jws")) {
                    string = string.substring(0, string.length() - ".jws".length());
                }
                if (string != null && string.length() > 0) {
                    string = Character.isUpperCase(string.charAt(0)) ? JavaUtils.xmlNameToJavaClass(string) : JavaUtils.xmlNameToJava(string);
                }
            }
            if ((string == null || string.equals("")) && Character.isLowerCase((string = JavaUtils.java2NCName(this.clsName)).charAt(0))) {
                JavaUtils.capitalizeFirstChar(string);
            }
            this.setServicePortName(string);
        }
    }

    private void initBindingTypes() throws IOException {
        if (this.bindingTypes == null) {
            this.bindingTypes = new ArrayList();
            this.bindingTypes.add(BINDING_TYPE_HTTP);
            BindingGenerator bindingGenerator = (BindingGenerator)this.availableBindingGenerators.get(BINDING_TYPE_HTTP);
            if (bindingGenerator != null) {
                this.addBindingGenerator(bindingGenerator);
            } else {
                throw new IOException(Messages.getMessage("noGenerator", BINDING_TYPE_HTTP));
            }
        }
    }

    protected void initPluggableBindings() {
        ServiceProviderManager serviceProviderManager = new ServiceProviderManager(null);
        Iterator iterator = serviceProviderManager.getAllServiceProviders();
        while (iterator.hasNext()) {
            ServiceProvider serviceProvider = (ServiceProvider)iterator.next();
            BindingGenerator[] bindingGeneratorArray = serviceProvider.getBindingGenerators();
            if (bindingGeneratorArray == null) continue;
            for (int i = 0; i < bindingGeneratorArray.length; ++i) {
                if (this.verbose) {
                    this.env.report(Messages.getMessage("foundGenerator", bindingGeneratorArray[i].getBindingTypeName()));
                }
                this.availableBindingGenerators.put(bindingGeneratorArray[i].getBindingTypeName(), bindingGeneratorArray[i]);
            }
        }
    }

    public void addBindingGenerator(BindingGenerator bindingGenerator) {
        this.useBindingGenerators.add(bindingGenerator);
    }

    public ArrayList getAvailableBindingGeneratorsTypeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.availableBindingGenerators.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || string.equals("")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void setXProperties(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, BINDING_TYPE_DELIMITERS);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(61);
                if (n == -1) {
                    this.XProperties.setProperty(string2, "");
                    continue;
                }
                this.XProperties.setProperty(string2.substring(0, n), string2.substring(n + 1));
            }
        }
    }

    public void setXProperties(Properties properties) {
        this.makeValidOptions();
        Iterator iterator = this.validOptions.values().iterator();
        while (iterator.hasNext()) {
            OptionDescriptor optionDescriptor = (OptionDescriptor)iterator.next();
            if (!properties.containsKey(optionDescriptor.getName()) || this.XProperties.containsKey(optionDescriptor.getName())) continue;
            this.XProperties.setProperty(optionDescriptor.getName(), (String)properties.get(optionDescriptor.getName()));
        }
    }

    public Properties getXProperties() {
        return this.XProperties;
    }

    private void seedProperties() {
        this.XProperties.setProperty("servicePortName", this.getServicePortName());
        this.XProperties.setProperty("portTypeName", this.getPortTypeName());
        this.XProperties.setProperty("bindingName", this.getBindingName());
        this.XProperties.setProperty("location", this.getLocationUrl());
        this.XProperties.setProperty("soapAction", this.getSoapAction());
        this.XProperties.setProperty("style", this.getStyle().toString().toLowerCase());
        this.XProperties.setProperty("use", this.getUse().toString());
        this.XProperties.setProperty("wrapped", this.isWrapped() ? "true" : "false");
        this.XProperties.setProperty("verbose", this.verbose ? "true" : "false");
        this.XProperties.setProperty("debug", this.debug ? "true" : "false");
        this.XProperties.setProperty("encodingStyle", this.encodingList);
        this.XProperties.setProperty("MIMEStyle", this.getMIMEStyle().toString());
        this.XProperties.setProperty("intfNS", this.intfNS);
        if (this.verbose) {
            this.env.report(Messages.getMessage("bsProps1", this.XProperties.toString()));
        }
    }

    public String getPluggableHelpInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.availableBindingGenerators.keySet().iterator();
        while (iterator.hasNext()) {
            BindingGenerator bindingGenerator = (BindingGenerator)this.availableBindingGenerators.get(iterator.next());
            OptionDescriptor[] optionDescriptorArray = bindingGenerator.getOptionDescriptors();
            if (optionDescriptorArray == null) continue;
            stringBuffer.append("\n    ");
            stringBuffer.append(Messages.getMessage("bsProps2", bindingGenerator.getBindingTypeName()));
            stringBuffer.append("\n");
            for (int i = 0; i < optionDescriptorArray.length; ++i) {
                String string = optionDescriptorArray[i].getName();
                String string2 = optionDescriptorArray[i].getDescription();
                stringBuffer.append("        ");
                stringBuffer.append(string);
                stringBuffer.append("\n");
                stringBuffer.append("            ");
                stringBuffer.append(string2 == null ? "" : string2);
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private void makeValidOptions() {
        if (this.validOptions == null) {
            int n;
            this.validOptions = new HashMap();
            for (n = 0; n < commonOptions.length; ++n) {
                this.validOptions.put(commonOptions[n].getName(), commonOptions[n]);
            }
            for (n = 0; n < this.useBindingGenerators.size(); ++n) {
                BindingGenerator bindingGenerator = (BindingGenerator)this.useBindingGenerators.get(n);
                OptionDescriptor[] optionDescriptorArray = bindingGenerator.getOptionDescriptors();
                if (optionDescriptorArray == null) continue;
                for (int i = 0; i < optionDescriptorArray.length; ++i) {
                    this.validOptions.put(optionDescriptorArray[i].getName(), optionDescriptorArray[i]);
                }
            }
        }
    }

    private void validatePluginOptions() throws IOException {
        OptionDescriptor optionDescriptor;
        Object object;
        this.makeValidOptions();
        int n = 0;
        Enumeration<?> enumeration = this.XProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            optionDescriptor = (OptionDescriptor)this.validOptions.get(object);
            if (optionDescriptor != null) continue;
            ++n;
            if (((String)object).equalsIgnoreCase("jms.location")) {
                this.env.reportFatalErr(Messages.getMessage("jms.location.error", (String)object));
            }
            if (((String)object).equalsIgnoreCase("http.location")) {
                this.env.reportFatalErr(Messages.getMessage("http.location.error", (String)object));
            }
            if (!((String)object).equalsIgnoreCase("ejb.location")) continue;
            this.env.reportFatalErr(Messages.getMessage("ejb.location.error", (String)object));
        }
        object = this.validOptions.values().iterator();
        while (object.hasNext()) {
            optionDescriptor = (OptionDescriptor)object.next();
            if (!optionDescriptor.isRequired() || this.XProperties.containsKey(optionDescriptor.getName())) continue;
            this.env.reportFatalErr(Messages.getMessage("missingRequiredProperty", optionDescriptor.getName()));
            ++n;
        }
        object = this.XProperties.getProperty("elementFormDefault");
        if (object != null) {
            if (((String)object).equalsIgnoreCase("QUALIFIED") || ((String)object).equalsIgnoreCase("TRUE")) {
                this.setElementFormDefault(true);
                this.setElementFormDefaultOption(true);
            } else if (((String)object).equalsIgnoreCase("UNQUALIFIED") || ((String)object).equalsIgnoreCase("FALSE")) {
                this.setElementFormDefault(false);
                this.setElementFormDefaultOption(true);
            } else {
                this.setElementFormDefaultOption(false);
                this.env.reportWarning(Messages.getMessage("j2wInvalidElementFormDefaultArg00", (String)object));
            }
        }
        if ((object = this.XProperties.getProperty("attributeFormDefault")) != null) {
            if (((String)object).equalsIgnoreCase("QUALIFIED") || ((String)object).equalsIgnoreCase("TRUE")) {
                this.setAttributeFormDefault(true);
                this.setAttributeFormDefaultOption(true);
            } else if (((String)object).equalsIgnoreCase("UNQUALIFIED") || ((String)object).equalsIgnoreCase("FALSE")) {
                this.setAttributeFormDefault(false);
                this.setAttributeFormDefaultOption(true);
            } else {
                this.setAttributeFormDefaultOption(false);
                this.env.reportWarning(Messages.getMessage("j2wInvalidAttributeFormDefaultArg00", (String)object));
            }
        }
        if (n > 0) {
            throw new IOException(Messages.getMessage("propValidationError"));
        }
    }

    JavaClass getSEIClass() {
        return this.cls;
    }

    JavaClass getImplClass() {
        return this.implCls;
    }

    public CustomRegistry getCustomRegistry() {
        return this.customRegistry;
    }

    public void setCustomRegistry(CustomRegistry customRegistry) {
        this.customRegistry = customRegistry;
    }

    private void initNs2Location() {
        this.setNs2Location(CBP_NS_WSA, CBP_SL_WSA);
        this.setNs2Location(CBP_NS_WSAW, CBP_SL_WSAW);
        this.setNs2Location(CBP_NS_WSAW_O, CBP_SL_WSAW_O);
        this.setNs2Location(CBP_NS_WSRF_R, CBP_SL_WSRF_R);
        this.setNs2Location(CBP_NS_WSRF_RP, CBP_SL_WSRF_RP);
        this.setNs2Location(CBP_NS_WSRF_RL, CBP_SL_WSRF_RL);
        this.setNs2Location(CBP_NS_WSRF_BF, CBP_SL_WSRF_BF);
        this.setNs2Location(CBP_NS_WSRF_SG, CBP_SL_WSRF_SG);
        this.setNs2Location(CBP_NS_WSAT, CBP_SL_WSAT);
        this.setNs2Location(CBP_NS_WSCOOR, CBP_SL_WSCOOR);
        this.setNs2Location(CBP_NS_WSBA, CBP_SL_WSBA);
        this.setNs2Location(CBP_NS_WSN_B, CBP_SL_WSN_B);
        this.setNs2Location(CBP_NS_WSN_BR, CBP_SL_WSN_BR);
        this.setNs2Location(CBP_NS_WSN_T, CBP_SL_WSN_T);
    }

    public void setNs2Location(String string, String string2) {
        this.ns2Location.put(string, string2);
    }

    public String getNs2Location(String string) {
        return (String)this.ns2Location.get(string);
    }
}

