/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava.description;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.wsdl.fromJava.Emitter;
import com.ibm.ws.webservices.wsdl.fromJava.description.FaultDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.ParameterDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.PortDesc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;

public class OperationDesc {
    protected static Log log = LogFactory.getLog(OperationDesc.class.getName());
    private PortDesc parent;
    private ArrayList parameters = new ArrayList();
    private QName elementQName;
    private Method method;
    private int numInParams = 0;
    private String soapAction = null;
    private ArrayList faults = null;
    private ParameterDesc returnDesc = null;
    private boolean hasOutParams = false;

    private void initReturnDesc() {
        if (this.returnDesc == null) {
            this.returnDesc = new ParameterDesc();
            this.returnDesc.setMode((byte)2);
            this.returnDesc.setIsReturn(true);
            this.hasOutParams = true;
        }
    }

    public String getName() {
        return this.elementQName.getLocalPart();
    }

    public JavaHelpers getReturnClass() {
        return this.returnDesc == null ? null : this.returnDesc.getJavaType();
    }

    public void setReturnClass(JavaHelpers javaHelpers, Emitter emitter) {
        if (javaHelpers != null) {
            this.initReturnDesc();
            this.returnDesc.setJavaType(javaHelpers, emitter);
        }
    }

    public QName getElementQName() {
        return this.elementQName;
    }

    public void setElementQName(QName qName) {
        this.elementQName = qName;
    }

    public PortDesc getParent() {
        return this.parent;
    }

    public void setParent(PortDesc portDesc) {
        this.parent = portDesc;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String string) {
        this.soapAction = string;
    }

    public void addParameter(ParameterDesc parameterDesc) {
        this.parameters.add(parameterDesc);
        if (parameterDesc.getMode() != 1) {
            this.hasOutParams = true;
        }
        if (parameterDesc.getMode() == 1 || parameterDesc.getMode() == 3) {
            parameterDesc.setOrder(this.numInParams++);
        }
        if (log.isDebugEnabled()) {
            log.debug("@" + Integer.toHexString(this.hashCode()) + " added parameter >" + parameterDesc + "@" + Integer.toHexString(parameterDesc.hashCode()) + "<total parameters:" + this.getNumParams());
        }
    }

    public ParameterDesc getParameter(int n) {
        if (this.parameters.size() <= n) {
            return null;
        }
        return (ParameterDesc)this.parameters.get(n);
    }

    public ArrayList getParameters() {
        return this.parameters;
    }

    void setParameters(ArrayList arrayList) {
        arrayList = new ArrayList();
        ListIterator listIterator = this.parameters.listIterator();
        while (listIterator.hasNext()) {
            ParameterDesc parameterDesc = (ParameterDesc)listIterator.next();
            this.addParameter(parameterDesc);
            if (parameterDesc.getMode() == 1) continue;
            this.hasOutParams = true;
        }
    }

    public int getNumInParams() {
        return this.numInParams;
    }

    public int getNumParams() {
        return this.parameters.size();
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method2) {
        this.method = method2;
    }

    public boolean isReturnHeader() {
        return this.returnDesc == null ? false : this.returnDesc.isOutHeader();
    }

    public void setReturnHeader(boolean bl) {
        this.initReturnDesc();
        this.returnDesc.setOutHeader(bl);
    }

    public ParameterDesc getParamByQName(QName qName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)this.parameters.get(i);
            if (!parameterDesc.getQName().equals(qName)) continue;
            return parameterDesc;
        }
        return null;
    }

    public ParameterDesc getInputParamByQName(QName qName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)this.parameters.get(i);
            if (parameterDesc.getMode() == 2 || !parameterDesc.getQName().equals(qName)) continue;
            return parameterDesc;
        }
        return null;
    }

    public ParameterDesc getOutputParamByQName(QName qName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)this.parameters.get(i);
            if (parameterDesc.getMode() == 1 || !parameterDesc.getQName().equals(qName)) continue;
            return parameterDesc;
        }
        ParameterDesc parameterDesc = null;
        if (this.returnDesc != null && this.returnDesc.getQName() == null) {
            parameterDesc = new ParameterDesc(this.returnDesc);
            parameterDesc.setQName(qName);
        } else if (this.returnDesc != null && qName.equals(this.returnDesc.getQName())) {
            parameterDesc = this.returnDesc;
        }
        return parameterDesc;
    }

    public ArrayList getOutParams() {
        ArrayList<ParameterDesc> arrayList = new ArrayList<ParameterDesc>();
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            ParameterDesc parameterDesc = (ParameterDesc)iterator.next();
            if (parameterDesc.getMode() != 2) continue;
            arrayList.add(parameterDesc);
        }
        return arrayList;
    }

    public void addFault(FaultDesc faultDesc) {
        if (this.faults == null) {
            this.faults = new ArrayList();
        }
        this.faults.add(faultDesc);
    }

    public ArrayList getFaults() {
        return this.faults;
    }

    public FaultDesc getFaultByClass(JavaClass javaClass) {
        if (this.faults == null || javaClass == null) {
            return null;
        }
        Iterator iterator = this.faults.iterator();
        while (iterator.hasNext()) {
            FaultDesc faultDesc = (FaultDesc)iterator.next();
            if (!javaClass.getJavaName().equals(faultDesc.getJavaClass().getJavaName())) continue;
            return faultDesc;
        }
        return null;
    }

    public ParameterDesc getReturnParamDesc() {
        return this.returnDesc;
    }

    public boolean isOneway() {
        return this.returnDesc == null && !this.hasOutParams;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        int n;
        String string2 = "";
        string2 = string2 + string + "returnClass: " + this.getReturnClass() + "\n";
        string2 = string2 + string + "elementQName:" + this.getElementQName() + "\n";
        string2 = string2 + string + "soapAction:  " + this.getSoapAction() + "\n";
        string2 = string2 + string + "numInParams: " + this.getNumInParams() + "\n";
        string2 = string2 + string + "method:" + this.getMethod() + "\n";
        for (n = 0; n < this.parameters.size(); ++n) {
            string2 = string2 + string + " ParameterDesc[" + n + "]:\n";
            string2 = string2 + string + ((ParameterDesc)this.parameters.get(n)).toString("  ") + "\n";
        }
        if (this.faults != null) {
            for (n = 0; n < this.faults.size(); ++n) {
                string2 = string2 + string + " FaultDesc[" + n + "]:\n";
                string2 = string2 + string + ((FaultDesc)this.faults.get(n)).toString() + "\n";
            }
        }
        return string2;
    }
}

