/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.introspect;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.wsdl.introspect.TypeEntryIntrospector;
import com.ibm.ws.webservices.wsdl.mapping.Utils;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.holders.BooleanHolder;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;

public class BindingEntryIntrospector {
    private Emitter emitter;
    private ClassFactory classFactory;
    private SymbolTable symbolTable;

    BindingEntryIntrospector(Emitter emitter) {
        this.emitter = emitter;
        this.classFactory = emitter.getToolEnv().getClassFactory();
        this.symbolTable = emitter.getSymbolTable();
    }

    void introspect1(BindingEntry bindingEntry) {
        JavaClass javaClass = this.findSEI(bindingEntry);
        if (javaClass == null) {
            return;
        }
    }

    void introspect2(BindingEntry bindingEntry) {
        JavaClass javaClass = this.findSEI(bindingEntry);
        if (javaClass == null) {
            return;
        }
        if (this.emitter.isDebug()) {
            this.symbolTable.getToolEnv().report(Messages.getMessage("introspectSEI00", bindingEntry.getQName().toString(), javaClass.infoString()));
        }
        Iterator iterator = bindingEntry.getOperations();
        while (iterator.hasNext()) {
            BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator.next();
            Method method2 = this.findMethod(javaClass, bindingOperationEntry);
            if (method2 == null) continue;
            this.processParameters(method2, bindingOperationEntry, false);
        }
    }

    JavaClass findSEI(BindingEntry bindingEntry) {
        PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(bindingEntry.getBinding().getPortType().getQName());
        String string = (String)bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
        JavaClass javaClass = (JavaClass)this.classFactory.forName(string);
        if (javaClass == null) {
            javaClass = (JavaClass)TypeEntryIntrospector.locateClass(portTypeEntry, this.emitter, this.classFactory);
        }
        if (javaClass != null) {
            bindingEntry.setDynamicVar(JavaGeneratorFactory.INTERFACE_NAME, javaClass.getJavaName());
        }
        return javaClass;
    }

    Method findMethod(JavaClass javaClass, BindingOperationEntry bindingOperationEntry) {
        Method method2;
        int n;
        Method method3 = null;
        List list = javaClass.getPublicMethodsExtendedNamed(bindingOperationEntry.getName());
        List list2 = null;
        if (list != null) {
            for (n = 0; n < list.size() && method3 == null; ++n) {
                method2 = (Method)list.get(n);
                if (!this.processParameters(method2, bindingOperationEntry, true)) continue;
                method3 = method2;
            }
        }
        if (method3 == null && !bindingOperationEntry.getName().equals(bindingOperationEntry.getQName().getLocalPart()) && (list2 = javaClass.getPublicMethodsExtendedNamed(bindingOperationEntry.getQName().getLocalPart())) != null) {
            for (n = 0; n < list2.size() && method3 == null; ++n) {
                method2 = (Method)list2.get(n);
                if (!this.processParameters(method2, bindingOperationEntry, true)) continue;
                method3 = method2;
            }
        }
        if (method3 == null) {
            int n2;
            n = list == null ? 0 : list.size();
            int n3 = n2 = list2 == null ? 0 : list2.size();
            if (n + n2 == 1) {
                Method method4 = method3 = n == 0 ? (Method)list2.get(0) : (Method)list.get(0);
            }
        }
        if (method3 != null && !method3.getName().equals(bindingOperationEntry.getName())) {
            Utils.setJavaName(this.symbolTable, bindingOperationEntry, method3.getName(), false);
        }
        return method3;
    }

    private boolean processParameters(Method method2, BindingOperationEntry bindingOperationEntry, boolean bl) {
        boolean bl2 = true;
        EList eList = method2.getParameters();
        if (eList == null || bindingOperationEntry.numParameters() != eList.size()) {
            return false;
        }
        JavaHelpers javaHelpers = method2.getReturnType();
        BindingParamEntry bindingParamEntry = bindingOperationEntry.getReturn();
        TypeEntry typeEntry = null;
        if (bindingParamEntry != null) {
            typeEntry = bindingParamEntry.getType();
            while (!(typeEntry instanceof Type) && !typeEntry.isCollectionTypeEntry()) {
                typeEntry = typeEntry.getRefType();
            }
        }
        String string = null;
        if (bindingParamEntry != null && (string = (String)bindingParamEntry.getDynamicVar("parameterType")) == null) {
            string = JavaGeneratorFactory.defaultParamType(bindingParamEntry);
            if (!bl) {
                bindingParamEntry.setDynamicVar("parameterType", string);
            }
        }
        BooleanHolder booleanHolder = new BooleanHolder();
        if (javaHelpers != null && bindingParamEntry != null) {
            String string2 = TypeEntryIntrospector.compatibleTypeTest(javaHelpers, string, typeEntry, this.emitter.getFactory().getBaseTypeMapping().getTypeMapping(), this.classFactory, this.symbolTable, this.emitter, bl, true, booleanHolder);
            if (!bl) {
                if (string2 == null) {
                    this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("incompatibleTypes00", method2.getMethodElementSignature(), javaHelpers.getJavaName(), string));
                } else if (!string2.equals(string)) {
                    bindingParamEntry.setDynamicVar("parameterType", string2);
                    bindingParamEntry.setDynamicVar("parameterSignatureType", javaHelpers.getJavaName());
                    if (booleanHolder.value) {
                        this.emitter.getToolEnv().reportWarning(Messages.getMessage("incompatibleTypes00", method2.getMethodElementSignature(), javaHelpers.getJavaName(), string));
                    }
                }
            }
        }
        if (eList != null) {
            for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
                JavaParameter javaParameter = (JavaParameter)eList.get(i);
                javaHelpers = javaParameter.getJavaType();
                JavaHelpers javaHelpers2 = com.ibm.ws.webservices.wsdl.fromJava.Utils.getHolderValueType(javaHelpers, this.classFactory);
                if (javaHelpers2 != null) {
                    javaHelpers = javaHelpers2;
                }
                bindingParamEntry = bindingOperationEntry.getParameter(i);
                typeEntry = null;
                if (bindingParamEntry != null) {
                    typeEntry = bindingParamEntry.getType();
                    while (!(typeEntry instanceof Type) && !typeEntry.isCollectionTypeEntry()) {
                        typeEntry = typeEntry.getRefType();
                    }
                }
                if ((string = (String)bindingParamEntry.getDynamicVar("parameterType")) == null) {
                    string = JavaGeneratorFactory.defaultParamType(bindingParamEntry);
                    if (!bl) {
                        bindingParamEntry.setDynamicVar("parameterType", string);
                    }
                }
                booleanHolder.value = false;
                if (javaHelpers != null) {
                    String string3 = TypeEntryIntrospector.compatibleTypeTest(javaHelpers, string, typeEntry, this.emitter.getFactory().getBaseTypeMapping().getTypeMapping(), this.classFactory, this.symbolTable, this.emitter, bl, true, booleanHolder);
                    if (string3 == null) {
                        bl2 = false;
                    }
                    if (bl) continue;
                    if (string3 == null) {
                        this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("incompatibleTypes01", method2.getMethodElementSignature(), javaHelpers.getJavaName(), string));
                        continue;
                    }
                    if (!string3.equals(string)) {
                        bindingParamEntry.setDynamicVar("parameterType", string3);
                        if (javaHelpers2 == null) {
                            bindingParamEntry.setDynamicVar("parameterSignatureType", string3);
                        }
                    }
                    if (javaHelpers2 != null) {
                        String string4 = javaParameter.getJavaType().getJavaName();
                        bindingParamEntry.setDynamicVar("parameterSignatureType", string4);
                        typeEntry.setDynamicVar("HolderName", string4);
                    }
                    if (!booleanHolder.value) continue;
                    this.emitter.getToolEnv().reportWarning(Messages.getMessage("incompatibleTypes01", method2.getMethodElementSignature(), javaHelpers.getJavaName(), string));
                    continue;
                }
                bl2 = false;
            }
        }
        return bl2;
    }
}

