/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.introspect;

import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.wsdl.fromJava.BeanUtils;
import com.ibm.ws.webservices.wsdl.introspect.TypeEntryIntrospector;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;

public class MessageEntryIntrospector {
    protected static Log log = LogFactory.getLog(MessageEntryIntrospector.class.getName());
    private Emitter emitter;
    private ClassFactory classFactory;
    private SymbolTable symbolTable;

    MessageEntryIntrospector(Emitter emitter) {
        this.emitter = emitter;
        this.classFactory = emitter.getToolEnv().getClassFactory();
        this.symbolTable = emitter.getSymbolTable();
    }

    void introspect1(MessageEntry messageEntry) {
        Entry entry = (Entry)messageEntry.getDynamicVar(JavaGeneratorFactory.EXCEPTION_SYMTAB_ENTRY);
        if (entry != messageEntry) {
            return;
        }
        JavaHelpers javaHelpers = this.findSimpleException(messageEntry);
    }

    void introspect2(MessageEntry messageEntry) {
        Entry entry = (Entry)messageEntry.getDynamicVar(JavaGeneratorFactory.EXCEPTION_SYMTAB_ENTRY);
        if (entry != messageEntry) {
            return;
        }
        JavaHelpers javaHelpers = this.findSimpleException(messageEntry);
        if (javaHelpers == null) {
            return;
        }
        JavaClass javaClass = (JavaClass)javaHelpers;
        if (this.emitter.isDebug()) {
            this.symbolTable.getToolEnv().report(Messages.getMessage("introspectClass00", messageEntry.getQName().toString(), javaClass.infoString()));
        }
        List list = BeanUtils.getPd(javaClass, this.emitter.getToolEnv());
        this.processFaultParts(messageEntry, list);
        this.validateException(messageEntry, javaHelpers);
    }

    private void validateException(MessageEntry messageEntry, JavaHelpers javaHelpers) {
        JavaClass javaClass = (JavaClass)javaHelpers;
        JavaClass javaClass2 = (JavaClass)this.classFactory.forName("java.lang.Exception");
        if (javaClass2 == null) {
            throw new InternalException(new ClassNotFoundException("java.lang.Exception"));
        }
        if (!javaClass2.isAssignableFrom((EClassifier)javaHelpers)) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidFault00", javaHelpers.getJavaName(), javaClass2.getName()));
        } else {
            boolean bl = false;
            String string = javaHelpers.getJavaName().substring(javaHelpers.getJavaName().lastIndexOf(46) + 1);
            List list = javaClass.getPublicMethodsNamed(string);
            ArrayList arrayList = (ArrayList)messageEntry.getDynamicVar("constructorOrder");
            for (int i = 0; i < list.size(); ++i) {
                Method method2 = (Method)list.get(i);
                EList eList = method2.getParameters();
                if (arrayList != null && eList.size() != arrayList.size()) continue;
                bl = true;
                if (method2.getJavaExceptions() == null || method2.getJavaExceptions().size() <= 0) continue;
                messageEntry.setDynamicVar("throwsCheckedException", Boolean.TRUE);
            }
            if (!bl) {
                this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidFault01", javaHelpers.getJavaName(), string, String.valueOf(arrayList.size())));
            }
        }
    }

    JavaHelpers findSimpleException(MessageEntry messageEntry) {
        return TypeEntryIntrospector.locateClass(messageEntry, this.emitter, this.classFactory);
    }

    private void processFaultParts(MessageEntry messageEntry, List list) {
        for (int i = 0; i < messageEntry.getFaultParts().size(); ++i) {
            ChildEntry childEntry = (ChildEntry)messageEntry.getFaultParts().get(i);
            TypeEntryIntrospector.processChild(messageEntry, childEntry, list, true, this.emitter, this.symbolTable, this.classFactory);
        }
    }
}

