/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.query;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsdl.ImportResolver;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.Namespaces;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;

public class ImportResolverDelegate
implements ImportResolver {
    private Emitter emitter;
    private boolean lookForResolver = true;
    private ImportResolver resolver = null;
    protected static Log log = LogFactory.getLog(ImportResolverDelegate.class.getName());

    public ImportResolverDelegate(Emitter emitter) {
        this.emitter = emitter;
    }

    public InputStream resolve(String string) {
        if (this.lookForResolver) {
            this.lookForResolver();
        }
        if (this.resolver != null) {
            return this.resolver.resolve(string);
        }
        return null;
    }

    private void lookForResolver() {
        block10: {
            if (log.isDebugEnabled()) {
                log.debug("ImportResolverDelegate.lookForResolver() > Entry");
            }
            this.lookForResolver = false;
            try {
                if (this.emitter.getSymbolTable() != null && this.emitter.getSymbolTable().getDefinition() != null && this.emitter.getSymbolTable().getDefinition().getTargetNamespace() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Will use the WSDL to find the _AbsoluteImportResolver class");
                    }
                    String string = this.emitter.getSymbolTable().getDefinition().getTargetNamespace();
                    Namespaces namespaces = this.emitter.getNamespaces();
                    String string2 = namespaces.getCreate(string);
                    Class clazz = ClassUtils.forName(string2 + "._AbsoluteImportResolver");
                    this.resolver = (ImportResolver)clazz.newInstance();
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("A WSDL is not available, so will try to find _AbsoluteImportResolver in the application's packages");
                    }
                    Namespaces namespaces = this.emitter.getNamespaces();
                    Iterator iterator = namespaces.keySet().iterator();
                    while (iterator.hasNext() && this.resolver == null) {
                        String string = (String)iterator.next();
                        String string3 = namespaces.getCreate(string);
                        try {
                            Class clazz = ClassUtils.forName(string3 + "._AbsoluteImportResolver");
                            this.resolver = (ImportResolver)clazz.newInstance();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Throwable throwable) {
                if (!log.isDebugEnabled()) break block10;
                log.debug("The _AbsoluteImportResolver was not found due to " + throwable.toString() + " " + JavaUtils.stackToString(throwable));
            }
        }
    }
}

