/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Base64;
import com.ibm.ws.webservices.engine.utils.URLHashSet;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.ImportResolver;
import com.ibm.ws.webservices.wsdl.symbolTable.Utils;
import com.ibm.ws.webservices.wsdl.symbolTable.WSIUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class Resolver
implements WSDLLocator {
    protected static Log log = LogFactory.getLog(Resolver.class.getName());
    private ToolEnv env;
    private WSIUtils myWSIUtils;
    private long timeoutms = 45000L;
    private int retry = 0;
    private ImportResolver w2jResolver;
    private URLHashSet importedLocations = new URLHashSet();
    private URLHashSet importedNSs = new URLHashSet();
    private HashMap includedLocations = new HashMap();
    public boolean isIncludedMultipleTimes = false;
    private WSDLWriter writer = null;
    private String username;
    private String password;
    private URL baseURL;
    private InputSource baseInputSource = null;
    private URL latestURL;

    Resolver(String string, ImportResolver importResolver) throws MalformedURLException, IOException {
        this.baseURL = string == null || string.length() == 0 ? null : this._makeAbsoluteURL(string);
        this.latestURL = this.baseURL;
        this.w2jResolver = importResolver;
        this.myWSIUtils = new WSIUtils();
    }

    Info resolveWSDLImport(URL uRL, Import import_, WSDLReader wSDLReader) throws IOException, WSDLException, ParserConfigurationException, SAXException {
        String string;
        Info info;
        block9: {
            info = new Info();
            info.url = Utils.getURL(uRL, import_.getLocationURI());
            String string2 = string = uRL == null ? "" : uRL.getFile();
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("loadingFile00", "imported", info.url.toString(), string));
                log.debug(Messages.getMessage("Namespace00", import_.getNamespaceURI()));
            }
            if (import_.getNamespaceURI() != null && import_.getNamespaceURI().indexOf(58) == -1) {
                this.env.reportWarning(Messages.getMessage("notWSICompliantWSDLImportNamespace00", import_.getNamespaceURI(), string));
            }
            if (this.importedLocations.contains(info.url)) {
                return null;
            }
            this.importedLocations.add(info.url);
            this.importedNSs.add(import_.getNamespaceURI());
            try {
                this.setInfoDoc(info, import_.getLocationURI(), string);
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block9;
                log.debug(Messages.getMessage("failConnect00", import_.getLocationURI(), exception.getMessage()));
            }
        }
        this.myWSIUtils.checkValidWSDLImport(info.doc, info.url.toString(), string);
        Node node = this.myWSIUtils.getRootDoc(info.doc, info.url.toString());
        this.myWSIUtils.checkNamespaceTargetNamespace(import_.getNamespaceURI(), this.myWSIUtils.getTargetNamespace(node), string, info.url.toString());
        info.def = import_.getDefinition();
        if (info.doc == null && info.def != null) {
            if (this.writer == null) {
                this.writer = WSDLFactory.newInstance().newWSDLWriter();
            }
            info.doc = this.writer.getDocument(info.def);
        } else if (info.def == null) {
            info.def = wSDLReader.readWSDL(this);
        }
        return info;
    }

    Info resolveXSDImport(URL uRL, String string, String string2, String string3) throws IOException, ParserConfigurationException, SAXException {
        return this._resolveXSD(uRL, string, string2, true, false, string3);
    }

    Info resolveXSDInclude(URL uRL, String string, String string2) throws IOException, ParserConfigurationException, SAXException {
        return this._resolveXSD(uRL, "", string, false, true, string2);
    }

    Info resolveXSDRedefine(URL uRL, String string, String string2) throws IOException, ParserConfigurationException, SAXException {
        return this._resolveXSD(uRL, "", string, false, false, string2);
    }

    private Info _resolveXSD(URL uRL, String string, String string2, boolean bl, boolean bl2, String string3) throws IOException, ParserConfigurationException, SAXException {
        String string4;
        Info info = new Info();
        info.url = Utils.getURL(uRL, string2);
        String string5 = string4 = uRL == null ? "" : uRL.getFile();
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("loadingFile00", "imported", info.url.toString(), string4));
                log.debug(Messages.getMessage("Namespace00", string));
            }
            if (this.importedLocations.contains(info.url)) {
                if (log.isDebugEnabled()) {
                    log.debug("File " + info.url.toString() + " was not imported " + "because it has already been imported under the namespace \"" + string + "\".");
                }
                return null;
            }
            this.importedNSs.add(string);
        }
        this.setInfoDoc(info, string2, string4);
        Node node = this.myWSIUtils.getRootSchema(info.doc, info.url.toString(), true);
        String string6 = this.myWSIUtils.getTargetNamespace(node);
        if (bl) {
            this.myWSIUtils.checkNamespaceTargetNamespace(string, string6, string4, info.url.toString());
        } else {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("loadingFile00", "included/redefined", info.url.toString(), string4));
            }
            if (string6 != null) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("targetNameSpace00", string6));
                }
                if (this.importedLocations.contains(info.url)) {
                    if (log.isDebugEnabled()) {
                        log.debug("File " + info.url.toString() + " was not included/redefined " + "because it has a targetNamespace and has already been included/redefined.");
                    }
                    return null;
                }
                this.importedNSs.add(string6);
            } else if (log.isDebugEnabled()) {
                log.debug("File " + info.url.toString() + " will be included/redefined with namespace context \"" + string3 + "\".");
            }
        }
        this.importedLocations.add(info.url);
        if (bl2) {
            if (this.includedLocations.containsKey(string3)) {
                URLHashSet uRLHashSet = (URLHashSet)this.includedLocations.get(string3);
                if (uRLHashSet.contains(info.url)) {
                    this.isIncludedMultipleTimes = true;
                    if (log.isDebugEnabled()) {
                        log.debug("File " + info.url.toString() + " was not included " + "because it has already been included with namespace context \"" + string3 + "\".");
                    }
                    return null;
                }
                uRLHashSet.add(info.url);
            } else {
                URLHashSet uRLHashSet = new URLHashSet();
                uRLHashSet.add(info.url);
                this.includedLocations.put(string3, uRLHashSet);
            }
        }
        return info;
    }

    public String getBaseURI() {
        return this.baseURL.toString();
    }

    public InputSource getBaseInputSource() {
        if (this.baseInputSource == null) {
            this.baseInputSource = this._getInputSource(this.baseURL.toString(), null);
        }
        return this.baseInputSource;
    }

    public InputSource getImportInputSource(String string, String string2) {
        try {
            URL uRL = null;
            if (string != null && string.length() > 0) {
                uRL = this._makeAbsoluteURL(string);
            }
            URL uRL2 = Utils.getURL(uRL, string2);
            InputSource inputSource = this._getInputSource(uRL2.toString(), string2);
            this.latestURL = uRL2;
            return inputSource;
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ws.webservices.engine.wsdl.symbolTable.Resolver.getImportInputSource", "252", this);
            throw new RuntimeException(malformedURLException.toString());
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.wsdl.symbolTable.Resolver.getImportInputSource", "255", this);
            throw new RuntimeException(iOException.toString());
        }
    }

    public String getLatestImportURI() {
        return this.latestURL.toString();
    }

    private InputSource _getInputSource(String string, String string2) {
        InputStream inputStream = null;
        String string3 = string;
        if (this.w2jResolver != null) {
            inputStream = this.w2jResolver.resolve(string);
            if (inputStream == null && string2 != null) {
                string3 = string2;
                inputStream = this.w2jResolver.resolve(string2);
            }
            if (inputStream == null) {
                string3 = string.substring(string.lastIndexOf("META-INF/wsdl/") + 14);
                inputStream = this.w2jResolver.resolve(string3);
            }
        }
        if (inputStream != null) {
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(string3);
            return inputSource;
        }
        try {
            return XMLUtils.getInputSourceFromURI(string, this.username, this.password);
        }
        catch (Exception exception) {
            return XMLUtils.getInputSourceFromURI(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL _makeAbsoluteURL(String string) throws MalformedURLException, IOException {
        URL uRL;
        block17: {
            uRL = null;
            InputStream inputStream = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("resolving00", string));
                }
                uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                String string2 = uRL.getUserInfo();
                String string3 = null;
                if (string2 != null) {
                    string3 = string2;
                } else if (this.username != null) {
                    String string4 = string3 = this.password == null ? this.username : this.username + ":" + this.password;
                }
                if (string3 != null) {
                    uRLConnection.setRequestProperty("Authorization", "Basic " + XMLUtils.base64encode(string3.getBytes("ISO-8859-1")));
                }
                String string5 = null;
                String string6 = null;
                boolean bl = false;
                if (string.startsWith("https")) {
                    string5 = System.getProperty("https.proxyUserName");
                    string6 = System.getProperty("https.proxyPassword");
                    bl = true;
                } else if (string.startsWith("http")) {
                    string5 = System.getProperty("http.proxyUserName");
                    string6 = System.getProperty("http.proxyPassword");
                    bl = true;
                }
                if (bl) {
                    String string7 = new String(Base64.encode(new String(string5 + ":" + string6).getBytes()));
                    uRLConnection.setRequestProperty("Proxy-Authorization", "Basic " + string7);
                }
                inputStream = uRLConnection.getInputStream();
                uRL = uRLConnection.getURL();
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("resolved00", uRL.toString()));
                }
            }
            catch (MalformedURLException malformedURLException) {
                File file = new File(string);
                if (file != null) {
                    uRL = file.toURL();
                    break block17;
                }
                throw malformedURLException;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return uRL;
    }

    public void setId(String string) {
        this.username = string;
    }

    public void setPass(String string) {
        this.password = string;
    }

    public void setEnv(ToolEnv toolEnv) {
        this.env = toolEnv;
        this.myWSIUtils.setEnv(toolEnv);
    }

    public void setTimeout(long l) {
        this.timeoutms = l;
    }

    public void setRetry(int n) {
        this.retry = n;
    }

    public void enableWSIChecking(boolean bl) {
        this.myWSIUtils.enableWSIChecking(bl);
    }

    private void setInfoDoc(Info info, String string, String string2) throws MalformedURLException, IOException, ParserConfigurationException, SAXException {
        block10: {
            try {
                InputSource inputSource = this._getInputSource(info.url.toString(), string);
                if (info.url.toString().startsWith("file:") && inputSource != null) {
                    info.doc = XMLUtils.newDocument(inputSource, this.w2jResolver);
                } else if (inputSource != null) {
                    info.doc = XMLUtils.newDocument(inputSource, this.w2jResolver, this.retry, this.timeoutms);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                InputSource inputSource;
                info.url = Utils.getURL(this.latestURL, string);
                info.url = this._makeAbsoluteURL(info.url.toString());
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("loadingFile00", "imported", info.url.toString(), string2));
                }
                if ((inputSource = this._getInputSource(info.url.toString(), string)) != null) {
                    info.doc = XMLUtils.newDocument(inputSource, this.w2jResolver, this.retry, this.timeoutms);
                }
            }
            catch (IOException iOException) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("failConnect00", info.url.toString(), iOException.getMessage()));
                }
                throw iOException;
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block10;
                log.debug(Messages.getMessage("failConnect00", info.url.toString(), exception.getMessage()));
            }
        }
    }

    class Info {
        public URL url;
        public Document doc;
        public Definition def;

        Info() {
        }
    }
}

