/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.custom.CustomRegistry;
import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Namespaces;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.extensions.ejb.EJBBinding;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.symbolTable.Attribute;
import com.ibm.ws.webservices.wsdl.symbolTable.AttributeGroup;
import com.ibm.ws.webservices.wsdl.symbolTable.BaseTypeMapping;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildFaultPartEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedAttributeGroup;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedElement;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedGroup;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedType;
import com.ibm.ws.webservices.wsdl.symbolTable.Element;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.Group;
import com.ibm.ws.webservices.wsdl.symbolTable.GroupEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MMDEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaInfo;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaOperationKey;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaOperationValue;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Resolver;
import com.ibm.ws.webservices.wsdl.symbolTable.SchemaUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntryComparator;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Undefined;
import com.ibm.ws.webservices.wsdl.symbolTable.UndefinedAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.UndefinedAttributeGroup;
import com.ibm.ws.webservices.wsdl.symbolTable.UndefinedElement;
import com.ibm.ws.webservices.wsdl.symbolTable.UndefinedGroup;
import com.ibm.ws.webservices.wsdl.symbolTable.UndefinedType;
import com.ibm.ws.webservices.wsdl.symbolTable.Utils;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.StringHolder;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SymbolTable {
    protected static Log log = LogFactory.getLog(SymbolTable.class.getName());
    private boolean addImports;
    private HashMap symbolTable = new HashMap();
    private Vector types = new Vector();
    private Vector groups = new Vector();
    private Vector attributeGroups = new Vector();
    private ArrayList entryList = new ArrayList();
    private Type unmappableType = null;
    private HashMap mmdMap = new HashMap();
    private boolean isDuringProcessingOfRedefine = false;
    private boolean verbose;
    private boolean debug = false;
    private boolean warnUnmappableTypes = true;
    private BaseTypeMapping btm = null;
    public static final String ANON_TOKEN = ">";
    private Definition def = null;
    private Document document = null;
    private String wsdlURI = null;
    private WSDLReader reader;
    private MetaInfo metaInfo;
    private Resolver resolver;
    private ToolEnv env;
    private boolean needInit = true;
    private Map allServices = new LinkedHashMap();
    private LinkedHashSet servicesToWrite = null;
    private LinkedHashSet unmappableTypes = null;
    public static String LEGACY_QNAME = "legacyQName";
    public static String WRAPPED_ARRAY_PATTERN = "wrapped array pattern component";
    public static String REF_IN_RESTRICTED_SIMPLETYPE = "reference in restriction of simpleType";
    public static String NON_BOUND_WSDL = "nonBoundWSDL";
    static final int TYPE = 0;
    static final int ELEMENT = 1;
    static final int ATTRIBUTE = 2;
    TreeSet allTypes = null;
    private static final int ABOVE_SCHEMA_LEVEL = -1;
    private static final int SCHEMA_LEVEL = 0;

    public SymbolTable(ToolEnv toolEnv, MetaInfo metaInfo, boolean bl, boolean bl2) {
        this.env = toolEnv;
        this.btm = metaInfo.getBaseTypeMapping();
        this.addImports = bl;
        this.verbose = bl2;
        this.metaInfo = metaInfo;
        if (metaInfo.getProperty("debugMode") != null && metaInfo.getProperty("debugMode") instanceof Boolean) {
            this.debug = (Boolean)metaInfo.getProperty("debugMode");
        }
    }

    public void setWarnUnmappableTypes(boolean bl) {
        this.warnUnmappableTypes = bl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public ToolEnv getToolEnv() {
        return this.env;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public HashMap getHashMap() {
        return this.symbolTable;
    }

    public Vector getSymbols(QName qName) {
        return (Vector)this.symbolTable.get(qName);
    }

    public SymTabEntry get(QName qName, Class clazz) {
        Vector vector = (Vector)this.symbolTable.get(qName);
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
            if (!clazz.isInstance(symTabEntry)) continue;
            return symTabEntry;
        }
        return null;
    }

    public MMDEntry getMMDEntry(QName qName) {
        return (MMDEntry)this.mmdMap.get(qName);
    }

    public Iterator getMMDEntries() {
        return this.mmdMap.values().iterator();
    }

    public Type getType(QName qName) {
        Vector vector = this.getSymbols(qName);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.get(i);
                if (!symTabEntry.getQName().equals(qName) || !(symTabEntry instanceof Type)) continue;
                return (Type)symTabEntry;
            }
        }
        return null;
    }

    Type getUnmappableType() {
        if (this.unmappableType == null) {
            this.unmappableType = this.getType(Constants.WEBSERVICES_SOAPELEMENT);
            if (this.unmappableType == null) {
                this.unmappableType = new DefinedType(Constants.WEBSERVICES_SOAPELEMENT, this);
                this.unmappableType.setName("javax.xml.soap.SOAPElement");
                try {
                    this.symbolTablePut(this.unmappableType);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.wsdl.symbolTable.SymbolTable.getUnmappableType", "450", this);
                }
            }
        }
        return this.unmappableType;
    }

    public Element getElement(QName qName) {
        Vector vector = this.getSymbols(qName);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.get(i);
                if (!symTabEntry.getQName().equals(qName) || !(symTabEntry instanceof Element)) continue;
                return (Element)symTabEntry;
            }
        }
        return null;
    }

    private ExtensibilityElement getHttpSoapEJBBindingExtElement(Binding binding) {
        Iterator iterator = binding.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof SOAPBinding) && !(e2 instanceof HTTPBinding) && !(e2 instanceof EJBBinding)) continue;
            return (ExtensibilityElement)e2;
        }
        return null;
    }

    public Attribute getAttribute(QName qName) {
        Vector vector = this.getSymbols(qName);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.get(i);
                if (!symTabEntry.getQName().equals(qName) || !(symTabEntry instanceof Attribute)) continue;
                return (Attribute)symTabEntry;
            }
        }
        return null;
    }

    public MessageEntry getMessageEntry(QName qName) {
        return (MessageEntry)this.get(qName, MessageEntry.class);
    }

    public PortTypeEntry getPortTypeEntry(QName qName) {
        return (PortTypeEntry)this.get(qName, PortTypeEntry.class);
    }

    public BindingEntry getBindingEntry(QName qName) {
        return (BindingEntry)this.get(qName, BindingEntry.class);
    }

    public ServiceEntry getServiceEntry(QName qName) {
        return (ServiceEntry)this.get(qName, ServiceEntry.class);
    }

    public AttributeGroup getAttributeGroup(QName qName) {
        return (AttributeGroup)this.get(qName, AttributeGroup.class);
    }

    public Group getGroup(QName qName) {
        return (Group)this.get(qName, Group.class);
    }

    public Vector getTypes() {
        return this.types;
    }

    Set _getAllTypes() {
        if (this.allTypes == null) {
            this.allTypes = new TreeSet(new SymTabEntryComparator());
            this.allTypes.addAll(this.types);
        }
        return this.allTypes;
    }

    public Vector getGroups() {
        return this.groups;
    }

    public Vector getAttributeGroups() {
        return this.attributeGroups;
    }

    public void addServices(Service service) {
        this.allServices.put(service.getQName(), service);
    }

    public Map getServices() {
        return this.allServices;
    }

    public boolean shouldServiceBeWritten(String string) {
        return this.servicesToWrite != null ? this.servicesToWrite.contains(string) : true;
    }

    public void setServicesToBeWritten(Set set) {
        this.servicesToWrite = set == null ? null : new LinkedHashSet(set);
    }

    public Definition getDefinition() {
        return this.def;
    }

    public String getWSDLURI() {
        return this.wsdlURI;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public void dump(PrintStream printStream) {
        int n;
        ArrayList arrayList = new ArrayList();
        printStream.println();
        printStream.println("-----------------------");
        printStream.println(Messages.getMessage("symbolTable00") + "          |");
        printStream.println("-----------------------");
        Iterator iterator = this.symbolTable.values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < vector.size(); ++i) {
                arrayList.add(vector.elementAt(i));
            }
        }
        arrayList = this.entrySort(arrayList);
        ArrayList arrayList2 = this.getChildren(arrayList);
        ArrayList arrayList3 = this.formatEntries(arrayList, arrayList2);
        for (n = 0; n < arrayList3.size(); ++n) {
            printStream.println();
            printStream.println(arrayList3.get(n));
            printStream.println("======================================================================================");
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            printStream.println();
            printStream.println(n + 1 + "c --");
            printStream.println(arrayList2.get(n));
        }
        printStream.println("======================================================================================");
        printStream.println("-----------------------");
    }

    private ArrayList entrySort(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = 0; j < arrayList.size() - i - 1; ++j) {
                if (((SymTabEntry)arrayList.get(j)).getSIDX() <= ((SymTabEntry)arrayList.get(j + 1)).getSIDX()) continue;
                Object e2 = arrayList.get(j);
                arrayList.set(j, arrayList.get(j + 1));
                arrayList.set(j + 1, e2);
            }
        }
        return arrayList;
    }

    private ArrayList getChildren(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Vector vector = null;
            if (arrayList.get(i) instanceof GroupEntry) {
                vector = ((GroupEntry)arrayList.get(i)).getChildren();
            } else if (arrayList.get(i) instanceof MessageEntry) {
                vector = ((MessageEntry)arrayList.get(i)).getFaultParts();
            } else if (arrayList.get(i) instanceof Type) {
                vector = ((Type)arrayList.get(i)).getChildren();
            }
            if (vector == null) continue;
            for (int j = 0; j < vector.size(); ++j) {
                if (arrayList2.contains(vector.get(j))) continue;
                arrayList2.add(vector.get(j));
            }
        }
        return arrayList2;
    }

    private ArrayList formatEntries(ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i).toString();
            if (string.indexOf("Children       [QName") != -1) {
                string = string.substring(0, string.indexOf("Children       [") + 16) + " ";
                Vector vector = null;
                if (arrayList.get(i) instanceof GroupEntry) {
                    vector = ((GroupEntry)arrayList.get(i)).getChildren();
                } else if (arrayList.get(i) instanceof MessageEntry) {
                    vector = ((MessageEntry)arrayList.get(i)).getFaultParts();
                } else if (arrayList.get(i) instanceof Type) {
                    vector = ((Type)arrayList.get(i)).getChildren();
                }
                if (vector != null) {
                    for (int j = 0; j < vector.size(); ++j) {
                        int n = arrayList2.indexOf(vector.get(j));
                        if (n == -1) continue;
                        string = string + "(" + (n + 1) + "c) ";
                    }
                }
                string = string + "]\n";
            }
            arrayList3.add(string);
        }
        return arrayList3;
    }

    public void populate(String string) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.populate(string, null, null);
    }

    public void populate(String string, String string2, String string3) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (this.verbose) {
            this.env.report(Messages.getMessage("parsing00", string));
        }
        Document document = XMLUtils.newDocument(string, string2, string3, this.metaInfo.getRetry(), this.metaInfo.getTimeout());
        this.wsdlURI = string;
        try {
            string = new URL(string).toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.populate(string, document, true, string2, string3);
    }

    public void populate(String string, Document document) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.populate(string, document, false, null, null);
    }

    private void populate(String string, Document document, boolean bl, String string2, String string3) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.resolver = new Resolver(this.wsdlURI, this.metaInfo.getImportResolver());
        this.resolver.enableWSIChecking(this.metaInfo.getWSICheck());
        this.resolver.setId(string2);
        this.resolver.setPass(string3);
        this.resolver.setEnv(this.env);
        this.resolver.setRetry(this.metaInfo.getRetry());
        this.resolver.setTimeout(this.metaInfo.getTimeout());
        ServiceProviderManager serviceProviderManager = new ServiceProviderManager(null);
        this.reader = serviceProviderManager.getWSDLFactory().newWSDLReader();
        this.reader.setFeature("javax.wsdl.verbose", this.verbose);
        try {
            this.def = bl ? this.reader.readWSDL(this.resolver) : this.reader.readWSDL(string, document);
        }
        catch (WSDLException wSDLException) {
            FFDCFilter.processException((Throwable)wSDLException, "com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable.populate", "556", this);
            this.env.reportFatalErr(Messages.getMessage("errorReadingImport", wSDLException.getMessage()));
            return;
        }
        this.firstPass(string, this.def, document);
    }

    public void populateUsingDefinition(String string, Document document, Definition definition) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.def = definition;
        if (this.resolver == null) {
            this.resolver = new Resolver(null, this.metaInfo.getImportResolver());
            this.resolver.enableWSIChecking(this.metaInfo.getWSICheck());
            this.resolver.setEnv(this.env);
            this.resolver.setRetry(this.metaInfo.getRetry());
            this.resolver.setTimeout(this.metaInfo.getTimeout());
        }
        ServiceProviderManager serviceProviderManager = new ServiceProviderManager(null);
        this.reader = serviceProviderManager.getWSDLFactory().newWSDLReader();
        this.reader.setFeature("javax.wsdl.verbose", this.verbose);
        this.firstPass(string, this.def, document);
    }

    private void firstPass(String string, Definition definition, Document document) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        URL uRL = string == null ? null : Utils.getURL(null, string);
        this.populate(uRL, definition, document, null, new ArrayList());
        this.checkForUndefined();
        this.expandGroupReferences();
        this.document = document;
        this.collectNamespaces();
    }

    public void secondPass() {
        this.processEnumerations();
        for (int i = 0; i < this.types.size(); ++i) {
            TypeEntry typeEntry = (TypeEntry)this.types.get(i);
            if (typeEntry != null && typeEntry instanceof DefinedType && ((Type)typeEntry).getExtensionBase() == null && ((Type)typeEntry).getRestrictionBase() == null && (((Type)typeEntry).getChildren() == null || ((Type)typeEntry).getChildren().size() == 0)) {
                Utils.getNestedTypes(typeEntry, this);
            }
            this.setLegacyQName(typeEntry);
        }
        this.setReferences(this.def, this.document);
    }

    private void setLegacyQName(TypeEntry typeEntry) {
        boolean bl = this.metaInfo != null && "1.0".equals(this.metaInfo.getProperty("MMDVersion"));
        QName qName = null;
        if (bl && (typeEntry instanceof Type || typeEntry.isCollectionTypeEntry()) && typeEntry.getNode() != null && typeEntry.getNodeStack() != null) {
            qName = typeEntry.isCollectionTypeEntry() ? Utils.getTypeQName(typeEntry.getNode(), new BooleanHolder(), false, typeEntry.getNodeStack(), this.env, true) : Utils.getNodeNameQName_v5(typeEntry.getNode(), typeEntry.getNodeStack());
        }
        if (qName != null && !typeEntry.getQName().equals(qName)) {
            typeEntry.setDynamicVar(LEGACY_QNAME, qName);
            this.mmdMap.put(qName, new MMDEntry(qName, typeEntry, this));
        }
    }

    private void processEnumerations() {
        for (int i = 0; i < this.types.size(); ++i) {
            Vector vector;
            Type type;
            TypeEntry typeEntry = (TypeEntry)this.types.get(i);
            if (!(typeEntry instanceof DefinedType) || typeEntry.getNode() == null || !(type = (Type)typeEntry).isSimpleType() || type.getDynamicVar(REF_IN_RESTRICTED_SIMPLETYPE) != null) continue;
            Vector vector2 = SchemaUtils.getEnumerationBaseAndValuesToEmit(type.getNode(), this, type.getNodeStack());
            if (vector2 != null) {
                type.setEnumeration(true);
                type.setChildren(vector2);
                type.setRestrictionBase((Type)((ChildEnumValueEntry)vector2.get(0)).getType());
            }
            if (type.isEnumeration || (vector = SchemaUtils.getEnumerationBaseAndValues(type.getNode(), this, type.getNodeStack())) == null) continue;
            type.setEnumeration(true);
            type.setChildren(vector);
            type.setRestrictionBase((Type)((ChildEnumValueEntry)vector.get(0)).getType());
            type.setDynamicVar("disable generation", new Boolean(true));
        }
    }

    private void checkValidXSDImportFromSchema(Node node, String string, String string2, String string3) {
        if (node.getNodeName().indexOf("schema") == -1) {
            this.env.reportWarning(Messages.getMessage("notWSICompliantXSDImportNotFromSchema00", string, string2, string3));
        }
    }

    private void checkForWSDLElemOrder(Node node, String string) {
        if (node != null) {
            boolean bl = false;
            boolean bl2 = false;
            String string2 = "";
            String string3 = null;
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                String string4;
                if (node2.getNodeName().indexOf("definitions") > -1) {
                    string3 = node2.getNamespaceURI();
                    node2 = node2.getFirstChild();
                    bl = false;
                    bl2 = false;
                    continue;
                }
                if (node2.getNodeName().indexOf("import") > -1) {
                    if (!bl && !bl2) continue;
                    this.env.reportWarning(Messages.getMessage("notWSICompliantWSDLImportWrongOrder00", string, string2));
                    continue;
                }
                if (node2.getNodeName().indexOf("types") > -1) {
                    bl = true;
                    if (bl2) {
                        this.env.reportWarning(Messages.getMessage("notWSICompliantWSDLImportWrongOrder01", string, string2));
                    }
                    string2 = node2.getNodeName();
                    continue;
                }
                if (node2.getNodeName().indexOf("documentation") != -1 || node2.getNodeName().indexOf("#text") != -1 || node2.getNodeName().indexOf("#comment") != -1 || (string4 = node2.getNamespaceURI()) == null || !string4.equals(string3)) continue;
                bl2 = true;
                string2 = node2.getNodeName();
            }
        }
    }

    private void checkForUndefined(Definition definition, String string) throws IOException {
        if (definition != null) {
            Object object;
            Iterator iterator = definition.getBindings().values().iterator();
            while (iterator.hasNext()) {
                object = (Binding)iterator.next();
                if (!object.isUndefined()) continue;
                if (string == null) {
                    throw new IOException(Messages.getMessage("emitFailtUndefinedBinding01", object.getQName().getLocalPart()));
                }
                throw new IOException(Messages.getMessage("emitFailtUndefinedBinding02", object.getQName().getLocalPart(), string));
            }
            object = definition.getPortTypes().values().iterator();
            while (object.hasNext()) {
                PortType portType = (PortType)object.next();
                if (!portType.isUndefined()) continue;
                if (string == null) {
                    throw new IOException(Messages.getMessage("emitFailtUndefinedPort01", portType.getQName().getLocalPart()));
                }
                throw new IOException(Messages.getMessage("emitFailtUndefinedPort02", portType.getQName().getLocalPart(), string));
            }
        }
    }

    private void checkForUndefined() throws IOException {
        Vector<DefinedType> vector = null;
        Iterator iterator = this.symbolTable.values().iterator();
        while (iterator.hasNext()) {
            Vector vector2 = (Vector)iterator.next();
            for (int i = 0; i < vector2.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector2.get(i);
                if (symTabEntry instanceof UndefinedType) {
                    QName qName = symTabEntry.getQName();
                    if (qName.getLocalPart().equals("dateTime") && !qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || qName.getLocalPart().equals("timeInstant") && qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        throw new IOException(Messages.getMessage("wrongNamespace00", qName.getLocalPart(), qName.getNamespaceURI()));
                    }
                    if (SchemaUtils.isXSDType(symTabEntry.getQName())) {
                        this.env.reporterr(Messages.getMessage("unsupportedSchemaType00", qName.getLocalPart()));
                        this.reportUnmappableConstruct(qName);
                        if (vector == null) {
                            vector = new Vector<DefinedType>();
                        }
                        Type type = this.getUnmappableType();
                        DefinedType definedType = new DefinedType(qName, this);
                        definedType.setSimpleType(((Type)symTabEntry).isSimpleType());
                        definedType.setSimpleContent(((Type)symTabEntry).isSimpleContent());
                        definedType.setRefType(type, null);
                        vector.add(definedType);
                        continue;
                    }
                    this.env.reportFatalErr(Messages.getMessage("undefined00", symTabEntry.getQName().toString()));
                    return;
                }
                if (symTabEntry instanceof UndefinedElement) {
                    throw new IOException(Messages.getMessage("undefinedElem00", symTabEntry.getQName().toString()));
                }
                if (symTabEntry instanceof UndefinedAttribute) {
                    throw new IOException(Messages.getMessage("undefinedAttr00", symTabEntry.getQName().toString()));
                }
                if (symTabEntry instanceof UndefinedGroup) {
                    throw new IOException(Messages.getMessage("undefinedGroup00", symTabEntry.getQName().toString()));
                }
                if (!(symTabEntry instanceof UndefinedAttributeGroup)) continue;
                throw new IOException(Messages.getMessage("undefinedAttributeGroup00", symTabEntry.getQName().toString()));
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.symbolTablePut((Type)vector.get(i));
            }
        }
    }

    private void populate(URL uRL, Definition definition, Document document, String string, List list) throws IOException, ParserConfigurationException, SAXException, WSDLException {
        if (document != null) {
            this.populateTypes(uRL, document, list);
            if (this.addImports) {
                this.lookForImports(uRL, document, list);
            }
        }
        if (definition != null) {
            String string2 = uRL == null ? "" : uRL.getFile();
            this.checkForWSDLElemOrder(document, string2);
            this.checkForUndefined(definition, string);
            this.enhance();
            if (this.addImports) {
                Map map = definition.getImports();
                Object[] objectArray = map.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    Vector vector = (Vector)map.get(objectArray[i]);
                    for (int j = 0; j < vector.size(); ++j) {
                        Import import_ = (Import)vector.get(j);
                        if (import_.getLocationURI() == null) {
                            throw new IOException(Messages.getMessage("notWSICompliantWSDLImportNoLocation00", string2, import_.getNamespaceURI()));
                        }
                        Resolver.Info info = this.resolver.resolveWSDLImport(uRL, import_, this.reader);
                        if (info == null) continue;
                        this.populate(info.url, info.def, info.doc, info.url != null ? info.url.toString() : null, new ArrayList());
                    }
                }
            }
            this.populateMessages(definition);
            this.populatePortTypes(definition);
            this.populateBindings(definition);
            this.populateServices(definition);
        }
    }

    private void lookForImports(URL uRL, Node node, List list) throws IOException, ParserConfigurationException, SAXException, WSDLException {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("import".equals(node2.getLocalName())) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                Node node3 = namedNodeMap.getNamedItem("namespace");
                if (node3 != null && Constants.isSOAP_ENC(node3.getNodeValue())) continue;
                Node node4 = namedNodeMap.getNamedItem("schemaLocation");
                if (node4 != null) {
                    this.checkValidXSDImportFromSchema(node, uRL == null ? "" : uRL.getFile(), node4.getNodeValue(), "import");
                    Resolver.Info info = this.resolver.resolveXSDImport(uRL, node3 == null ? null : node3.getNodeValue(), node4.getNodeValue(), Utils.getAbsoluteNamespace(node, list, this.env));
                    if (this.verbose) {
                        this.env.report(Messages.getMessage("loadingFile00", "imported", Utils.getURL(uRL, node4.getNodeValue()).toString(), uRL == null ? "" : uRL.getFile()));
                    }
                    if (info != null) {
                        this.populate(info.url, null, info.doc, info.url.toString(), new ArrayList());
                    }
                }
            }
            this.lookForImports(uRL, node2, list);
        }
    }

    private void populateTypes(URL uRL, Document document, List list) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.addTypes(uRL, document, -1, list);
    }

    private void initSymbolTable() throws IOException {
        this.needInit = false;
        this.getUnmappableType();
        DefinedType definedType = new DefinedType(Constants.SOAP_ELEMENT, null, this);
        definedType.setName("org.w3c.dom.Element");
        this.symbolTablePut(definedType);
    }

    private void addTypes(URL uRL, Node node, int n, List list) throws IOException, ParserConfigurationException, WSDLException, SAXException {
        Serializable serializable;
        Object object;
        Object object2;
        int n2;
        Object object3;
        if (this.needInit) {
            this.initSymbolTable();
        }
        if (node == null) {
            return;
        }
        String string = uRL == null ? "" : uRL.getFile();
        boolean bl = false;
        boolean bl2 = true;
        QName qName = Utils.getNodeQName(node);
        if (qName != null) {
            object3 = qName.getLocalPart();
            n2 = Constants.isSchemaXSD(qName.getNamespaceURI());
            if (n2 != 0 && ((String)object3).equals("complexType") || ((String)object3).equals("simpleType")) {
                object2 = SchemaUtils.getRestrictionOrExtensionNode(node);
                if (object2 != null) {
                    if (this.isDuringProcessingOfRedefine && (object = Utils.getNodeQName((Node)object2)) != null && ((QName)object).getLocalPart().equals("extension")) {
                        throw new IOException(Messages.getMessage("unsupportedExtension00"));
                    }
                    if (Utils.getAttribute((Node)object2, "base") != null) {
                        this.createTypeFromRef((Node)object2, list, false);
                    }
                }
                bl2 = this.createTypeFromDef(node, 0, false, list);
            } else if (n2 != 0 && ((String)object3).equals("element")) {
                this.createTypeFromRef(node, list, false);
                object2 = SchemaUtils.getRestrictionOrExtensionNode(node);
                if (object2 != null && Utils.getAttribute((Node)object2, "base") != null) {
                    this.createTypeFromRef((Node)object2, list, false);
                }
                bl2 = this.createTypeFromDef(node, 1, n > 0, list);
            } else if (n2 != 0 && ((String)object3).equals("attribute") && (object = Utils.getTypeQName(node, (BooleanHolder)(object2 = new BooleanHolder()), false, list, this.env)) != null && !((BooleanHolder)object2).value) {
                this.createTypeFromRef(node, list, true);
                if (object != null) {
                    serializable = this.getType((QName)object);
                    if (serializable != null && serializable instanceof Undefined) {
                        ((Type)serializable).setSimpleType(true);
                    } else if (serializable == null || !((Type)serializable).isSimpleType()) {
                        throw new IOException(Messages.getMessage("AttrNotSimpleType01", ((QName)object).toString()));
                    }
                }
                bl2 = this.createTypeFromDef(node, 2, n > 0, list);
            }
            if (n2 != 0 && ((String)object3).equals("group") || ((String)object3).equals("attributeGroup")) {
                this.createGroupFromRef(node, list, qName);
                this.createGroupFromDef(node, n > 0, list, qName);
            } else if (n2 != 0 && ((String)object3).equals("any")) {
                this.createTypeFromRef(node, list, false);
            } else if (((String)object3).equals("part") && Constants.isWSDL(qName.getNamespaceURI())) {
                this.createTypeFromRef(node, list, false);
            } else if (n2 != 0 && ((String)object3).equals("include")) {
                object2 = Utils.getAttribute(node, "schemaLocation");
                if (object2 != null) {
                    this.checkValidXSDImportFromSchema(node.getParentNode(), string, (String)object2, "include");
                    object = this.resolver.resolveXSDInclude(uRL, (String)object2, Utils.getAbsoluteNamespace(node, list, this.env));
                    if (this.verbose) {
                        this.env.report(Messages.getMessage("loadingFile00", "included", Utils.getURL(uRL, (String)object2).toString(), uRL == null ? "" : uRL.getFile()));
                    }
                    if (object != null) {
                        serializable = new ArrayList(list);
                        ((ArrayList)serializable).add(node);
                        this.populate(((Resolver.Info)object).url, (Definition)null, ((Resolver.Info)object).doc, ((Resolver.Info)object).url.toString(), (List)((Object)serializable));
                    }
                    this.resolver.isIncludedMultipleTimes = false;
                }
            } else if (n2 != 0 && ((String)object3).equals("redefine")) {
                bl = true;
            }
        }
        if (n == -1) {
            if (qName != null && qName.getLocalPart().equals("schema")) {
                n = 0;
            }
        } else {
            ++n;
        }
        if (bl2) {
            object3 = node.getChildNodes();
            for (n2 = 0; n2 < object3.getLength(); ++n2) {
                this.addTypes(uRL, object3.item(n2), n, list);
            }
        }
        if (bl && (object3 = Utils.getAttribute(node, "schemaLocation")) != null) {
            this.checkValidXSDImportFromSchema(node.getParentNode(), string, (String)object3, "redefine");
            QName qName2 = Utils.getNodeNameQName(node, list, this.env);
            object2 = null;
            object2 = qName2 == null || qName2.getNamespaceURI() == null ? "" : qName2.getNamespaceURI();
            object = this.resolver.resolveXSDRedefine(uRL, (String)object3, (String)object2);
            if (this.verbose) {
                this.env.report(Messages.getMessage("loadingFile00", "included", Utils.getURL(uRL, (String)object3).toString(), uRL == null ? "" : uRL.getFile()));
            }
            if (object != null) {
                this.isDuringProcessingOfRedefine = true;
                serializable = new ArrayList(list);
                ((ArrayList)serializable).add(node);
                this.populate(((Resolver.Info)object).url, (Definition)null, ((Resolver.Info)object).doc, ((Resolver.Info)object).url.toString(), (List)((Object)serializable));
                this.isDuringProcessingOfRedefine = false;
            }
        }
    }

    private boolean createTypeFromDef(Node node, int n, boolean bl, List list) throws IOException {
        boolean bl2 = true;
        QName qName = Utils.getNodeNameQName(node, list, this.env);
        if (qName != null) {
            if (n == 0 && this.btm.getBaseName(qName) != null) {
                return bl2;
            }
            boolean bl3 = JavaUtils.isTrueExplicitly(Utils.getAttribute(node, "abstract"));
            BooleanHolder booleanHolder = new BooleanHolder();
            QName qName2 = Utils.getTypeQName(node, booleanHolder, false, list, this.env);
            if (qName2 != null) {
                if (qName.getLocalPart().length() == 0) {
                    String string = Utils.getAttribute(node, "name");
                    if (string == null) {
                        string = "unknown";
                    }
                    throw new IOException(Messages.getMessage("emptyref00", string));
                }
                TypeEntry typeEntry = null;
                typeEntry = booleanHolder.value ? (n == 2 ? this.getAttribute(qName2) : this.getElement(qName2)) : this.getType(qName2);
                if (!bl) {
                    TypeEntry typeEntry2 = null;
                    if (n == 2) {
                        typeEntry2 = new DefinedAttribute(qName, node, list, this);
                    } else {
                        typeEntry2 = new DefinedElement(qName, node, list, this);
                        this.setNillable((Element)typeEntry2, node);
                    }
                    typeEntry2.setRefType(typeEntry, null);
                    typeEntry2.setAbstract(bl3);
                    if (bl3 && typeEntry != null && typeEntry instanceof Type && ((Type)typeEntry).isAnonType()) {
                        typeEntry.setAbstract(bl3);
                    }
                    this.symbolTablePut(typeEntry2);
                }
            } else {
                IntHolder intHolder = new IntHolder();
                intHolder.value = 0;
                QName qName3 = SchemaUtils.getArrayComponentQName(node, intHolder, list, this);
                if (qName3 != null) {
                    qName2 = qName3;
                    TypeEntry typeEntry = this.getType(qName2);
                    if (typeEntry == null) {
                        typeEntry = this.createBaseType(qName2);
                        if (typeEntry == null) {
                            typeEntry = new UndefinedType(qName2, this);
                        }
                        this.symbolTablePut(typeEntry);
                    }
                    String string = "";
                    while (intHolder.value > 0) {
                        string = string + "[]";
                        --intHolder.value;
                    }
                    TypeEntry typeEntry3 = null;
                    if (n == 0 || !bl) {
                        if (n == 1) {
                            typeEntry3 = new DefinedElement(qName, node, list, this);
                            this.setNillable((Element)typeEntry3, node);
                        } else if (n == 2) {
                            typeEntry3 = new DefinedAttribute(qName, node, list, this);
                        } else {
                            typeEntry3 = new DefinedType(qName, node, list, this);
                            if (SchemaUtils.isSimpleType(node, list)) {
                                ((Type)typeEntry3).setSimpleType(true);
                            }
                            if (SchemaUtils.isSimpleContent(node, list)) {
                                ((Type)typeEntry3).setSimpleContent(true);
                            }
                        }
                        typeEntry3.setAbstract(bl3);
                        typeEntry3.setRefType(typeEntry, string);
                    }
                    if (typeEntry3 != null) {
                        this.symbolTablePut(typeEntry3);
                    }
                } else {
                    String string = this.btm.getBaseName(qName);
                    if (string != null) {
                        DefinedType definedType = new DefinedType(qName, this);
                        if (!Constants.equals(qName, Constants.XSD_ANY)) {
                            definedType.setSimpleType(true);
                        }
                        this.symbolTablePut(definedType);
                    } else {
                        TypeEntry typeEntry = null;
                        if (SchemaUtils.isNotMappable(node, this, list)) {
                            Type type = this.getUnmappableType();
                            if (n == 0) {
                                typeEntry = new DefinedType(qName, node, list, this);
                            } else if (!bl) {
                                if (n == 1) {
                                    typeEntry = new DefinedElement(qName, node, list, this);
                                    this.setNillable((Element)typeEntry, node);
                                } else if (n == 2) {
                                    typeEntry = new DefinedAttribute(qName, node, list, this);
                                }
                            }
                            typeEntry.setRefType(type, null);
                            if (SchemaUtils.isSimpleType(node, list)) {
                                ((Type)typeEntry).setSimpleType(true);
                            }
                            if (SchemaUtils.isSimpleContent(node, list)) {
                                ((Type)typeEntry).setSimpleContent(true);
                            }
                            this.reportUnmappableConstruct(qName);
                            typeEntry.setDynamicVar("notMappable", Boolean.TRUE);
                            bl2 = false;
                        } else if (n == 0) {
                            typeEntry = new DefinedType(qName, node, list, this);
                            if (SchemaUtils.isSimpleType(node, list)) {
                                ((Type)typeEntry).setSimpleType(true);
                            }
                            if (SchemaUtils.isSimpleContent(node, list)) {
                                ((Type)typeEntry).setSimpleContent(true);
                            }
                        } else if (!bl) {
                            if (n == 1) {
                                typeEntry = new DefinedElement(qName, node, list, this);
                                this.setNillable((Element)typeEntry, node);
                            } else if (n == 2) {
                                typeEntry = new DefinedAttribute(qName, node, list, this);
                            }
                        }
                        if (typeEntry != null) {
                            typeEntry.setAbstract(bl3);
                            this.symbolTablePut(typeEntry);
                        }
                    }
                }
            }
        }
        return bl2;
    }

    private void createTypeFromRef(Node node, List list, boolean bl) throws IOException {
        BooleanHolder booleanHolder = new BooleanHolder();
        QName qName = Utils.getTypeQName(node, booleanHolder, false, list, this.env);
        if (qName != null) {
            Serializable serializable;
            Serializable serializable2;
            if (qName.getLocalPart().length() == 0) {
                String string = Utils.getAttribute(node, "name");
                if (string == null) {
                    string = "unknown";
                }
                throw new IOException(Messages.getMessage("emptyref00", string));
            }
            TypeEntry typeEntry = null;
            typeEntry = booleanHolder.value ? (bl ? this.getAttribute(qName) : this.getElement(qName)) : this.getType(qName);
            if (typeEntry == null) {
                if (qName.getLocalPart().indexOf("[") > 0) {
                    serializable2 = Utils.getTypeQName(node, booleanHolder, true, list, this.env);
                    serializable = null;
                    serializable = booleanHolder.value ? this.getElement((QName)serializable2) : this.getType((QName)serializable2);
                    if (!booleanHolder.value) {
                        if (serializable == null) {
                            serializable = this.createBaseType((QName)serializable2);
                            if (serializable == null) {
                                serializable = new UndefinedType((QName)serializable2, this);
                            }
                            this.symbolTablePut((SymTabEntry)((Object)serializable));
                        }
                        typeEntry = new DefinedType(qName, node, list, this);
                        typeEntry.setRefType((TypeEntry)serializable, "[]");
                        this.symbolTablePut(typeEntry);
                    } else {
                        if (serializable == null) {
                            serializable = new UndefinedElement((QName)serializable2, this);
                            this.symbolTablePut((SymTabEntry)((Object)serializable));
                        }
                        typeEntry = new DefinedElement(qName, node, list, this);
                        this.setNillable((Element)typeEntry, node);
                        typeEntry.setRefType((TypeEntry)serializable, "[]");
                        this.symbolTablePut(typeEntry);
                    }
                } else {
                    serializable2 = this.createBaseType(qName);
                    if (serializable2 != null) {
                        serializable = this.getType(qName);
                        if (serializable == null) {
                            this.symbolTablePut((SymTabEntry)((Object)serializable2));
                            serializable = serializable2;
                        }
                        if (booleanHolder.value) {
                            typeEntry = bl ? new DefinedAttribute(qName, node, list, this) : new DefinedElement(qName, node, list, this);
                            typeEntry.setRefType((TypeEntry)serializable, null);
                            this.symbolTablePut(typeEntry);
                        }
                    } else if (!booleanHolder.value) {
                        typeEntry = new UndefinedType(qName, this);
                        this.symbolTablePut(typeEntry);
                    } else {
                        typeEntry = bl ? new UndefinedAttribute(qName, this) : new UndefinedElement(qName, this);
                        this.symbolTablePut(typeEntry);
                    }
                }
            }
            if (!(qName.getLocalPart().indexOf("[") <= 0 || ((QName)(serializable2 = Utils.getNodeNameQName(node, list, this.env))).getNamespaceURI().equals(qName.getNamespaceURI()) && ((QName)serializable2).getLocalPart().equals(qName.getLocalPart().substring(0, qName.getLocalPart().indexOf("["))))) {
                serializable = QNameTable.createQName(((QName)serializable2).getNamespaceURI(), ((QName)serializable2).getLocalPart() + qName.getLocalPart().substring(qName.getLocalPart().indexOf("[")));
                this.mmdMap.put(serializable, new MMDEntry((QName)serializable, typeEntry, this));
            }
        }
    }

    private void setNillable(Element element, Node node) {
        if (!element.isCollectionTypeEntry()) {
            String string = Utils.getAttribute(node, "nillable");
            element.setNillable(JavaUtils.isTrueExplicitly(string));
        }
    }

    private void createGroupFromRef(Node node, List list, QName qName) throws IOException {
        QName qName2 = Utils.getTypeQNameFromAttr(node, "ref", list, this.env, false);
        if (qName2 == null) {
            return;
        }
        if (qName2.getLocalPart().equals("Array") && Constants.isSOAP_ENC(qName2.getNamespaceURI())) {
            return;
        }
        GroupEntry groupEntry = null;
        if (qName.getLocalPart().equals("attributeGroup")) {
            groupEntry = this.getAttributeGroup(qName2);
            if (groupEntry == null) {
                groupEntry = new UndefinedAttributeGroup(qName2, this);
                this.symbolTablePut(groupEntry);
            }
        } else if (qName.getLocalPart().equals("group") && (groupEntry = this.getGroup(qName2)) == null) {
            groupEntry = new UndefinedGroup(qName2, this);
            this.symbolTablePut(groupEntry);
        }
    }

    private void createGroupFromDef(Node node, boolean bl, List list, QName qName) throws IOException {
        QName qName2 = Utils.getTypeQNameFromAttr(node, "ref", list, this.env, false);
        if (qName2 != null) {
            return;
        }
        if (bl) {
            return;
        }
        QName qName3 = Utils.getNodeNameQName(node, list, this.env);
        GroupEntry groupEntry = null;
        if (qName.getLocalPart().equals("attributeGroup")) {
            groupEntry = new DefinedAttributeGroup(qName3, node, list, this);
        } else if (qName.getLocalPart().equals("group")) {
            groupEntry = new DefinedGroup(qName3, node, list, this);
        }
        this.symbolTablePut(groupEntry);
    }

    private void enhance() throws IOException {
        SymTabEntry symTabEntry;
        int n;
        for (n = 0; n < this.groups.size(); ++n) {
            symTabEntry = (Group)this.groups.get(n);
            if (!(symTabEntry instanceof DefinedGroup) || ((GroupEntry)symTabEntry).getNode() == null) continue;
            this.enhance((GroupEntry)symTabEntry);
        }
        for (n = 0; n < this.attributeGroups.size(); ++n) {
            symTabEntry = (AttributeGroup)this.attributeGroups.get(n);
            if (!(symTabEntry instanceof DefinedAttributeGroup) || ((GroupEntry)symTabEntry).getNode() == null) continue;
            this.enhance((GroupEntry)symTabEntry);
        }
        for (n = 0; n < this.types.size(); ++n) {
            symTabEntry = (TypeEntry)this.types.get(n);
            if (!(symTabEntry instanceof DefinedType) || ((TypeEntry)symTabEntry).getNode() == null) continue;
            this.enhance((Type)symTabEntry);
        }
    }

    private void enhance(Type type) throws IOException {
        Serializable serializable;
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        if (type.getChildren() != null) {
            return;
        }
        Type type2 = SchemaUtils.getComplexElementExtensionBase(type.getNode(), this, type.getNodeStack());
        if (type2 != null) {
            this.enhance(type2);
            type.setExtensionBase(type2);
            type2.setDynamicVar(WRAPPED_ARRAY_PATTERN, null);
        } else {
            object3 = SchemaUtils.getSimpleTypeBase(type.getNode(), this, type.getNodeStack());
            if (object3 != null) {
                type2 = this.getType((QName)object3);
                this.enhance(type2);
                type.setRestrictionBase(type2);
                type2.setDynamicVar(WRAPPED_ARRAY_PATTERN, null);
                type2.setDynamicVar(REF_IN_RESTRICTED_SIMPLETYPE, type);
            }
        }
        if (type2 != null && type2.getRefType() != null && type2.getRefType() == this.getUnmappableType()) {
            object3 = type.getDimensions();
            if (!type.isCollectionTypeEntry()) {
                object3 = null;
            }
            type.setRefType(this.getUnmappableType(), (String)object3);
            this.reportUnmappableConstruct(type2.getQName());
        } else {
            object3 = new Vector();
            bl = this.getChildren(type.getNode(), type.getNodeStack(), (Vector)object3);
            type.setChildren((Vector)object3);
            if (this.metaInfo.getProperty("noWrappedArrays") != Boolean.TRUE && bl && type2 == null && (object2 = ((ChildEntry)(object = (ChildElement)type.getChildren().get(0))).getType()) instanceof Type && ((TypeEntry)object2).isCollectionTypeEntry() && (serializable = ((TypeEntry)object2).getRefType()) instanceof Type) {
                type.setDynamicVar(WRAPPED_ARRAY_PATTERN, serializable);
            }
        }
        boolean bl2 = false;
        if (type2 != null) {
            bl2 = SchemaUtils.isComplexType(type2.getNode(), type2.getNodeStack());
        }
        if (bl2 && type.getChildren() != null) {
            bl = false;
            object = type.getChildren().iterator();
            while (object.hasNext() && !bl) {
                object2 = (ChildEntry)object.next();
                serializable = ((Entry)object2).getQName();
                if (serializable == null || !((QName)serializable).getNamespaceURI().equals("") || !((QName)serializable).getLocalPart().equals("_value")) continue;
                bl = true;
            }
            if (bl) {
                object2 = type.getDimensions();
                if (!type.isCollectionTypeEntry()) {
                    object2 = null;
                }
                type.setRefType(this.getUnmappableType(), (String)object2);
                type.setChildren(null);
                this.reportUnmappableConstruct(type.getQName());
            }
        }
    }

    private void enhance(GroupEntry groupEntry) throws IOException {
        if (groupEntry.getChildren() != null) {
            return;
        }
        Vector vector = new Vector();
        boolean bl = this.getChildren(groupEntry.getNode(), groupEntry.getNodeStack(), vector);
        groupEntry.setChildren(vector);
    }

    private boolean getChildren(Node node, List list, Vector vector) {
        Vector vector2;
        Vector vector3;
        Vector vector4;
        boolean bl = true;
        Vector vector5 = SchemaUtils.getContainedAttributeTypes(node, this, list);
        if (vector5 != null && vector5.size() > 0) {
            bl = false;
            vector.addAll(vector5);
        }
        if ((vector4 = SchemaUtils.getContainedElementDeclarations(node, this, list)) != null && vector4.size() > 0) {
            vector.addAll(vector4);
        }
        if ((vector3 = SchemaUtils.getContainedGroupRefs(node, this, list)) != null && vector3.size() > 0) {
            bl = false;
            vector.addAll(vector3);
        }
        if ((vector2 = SchemaUtils.getContainedAttributeGroupRefs(node, this, list)) != null && vector2.size() > 0) {
            bl = false;
            vector.addAll(vector2);
        }
        if (vector.size() != 1) {
            bl = false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            TypeEntry typeEntry;
            ChildEntry childEntry = (ChildEntry)vector.get(i);
            if (childEntry instanceof ChildElement) {
                typeEntry = ((ChildElement)childEntry).getType();
                while (typeEntry instanceof Element && !typeEntry.isCollectionTypeEntry() && typeEntry.getRefType() != null) {
                    if (((Element)typeEntry).isNillable()) {
                        ((ChildElement)childEntry).setNillable(true);
                    }
                    typeEntry = typeEntry.getRefType();
                    bl = false;
                }
                ((ChildElement)childEntry).setType(typeEntry);
                continue;
            }
            if (!(childEntry instanceof ChildAttribute)) continue;
            typeEntry = ((ChildAttribute)childEntry).getType();
            while (typeEntry instanceof Attribute && typeEntry.getRefType() != null) {
                typeEntry = typeEntry.getRefType();
            }
            ((ChildAttribute)childEntry).setType(typeEntry);
        }
        return bl;
    }

    private void expandGroupReferences() throws IOException {
        for (int i = 0; i < this.types.size(); ++i) {
            TypeEntry typeEntry = (TypeEntry)this.types.get(i);
            if (!(typeEntry instanceof DefinedType) || typeEntry.getNode() == null) continue;
            this.expandGroupReferences((Type)typeEntry);
        }
    }

    private void expandGroupReferences(Type type) throws IOException {
        Object object;
        Vector vector = type.getChildren();
        if (vector == null || vector != null && vector.size() == 0) {
            return;
        }
        int n = 0;
        QName qName = null;
        while (n < vector.size()) {
            object = (ChildEntry)vector.elementAt(n);
            SymTabEntry symTabEntry = ((ChildEntry)object).getReference();
            if (symTabEntry instanceof GroupEntry) {
                vector.remove(n);
                Vector vector2 = ((GroupEntry)symTabEntry).getChildren();
                if (vector2 == null || vector2.size() == 0) continue;
                vector.addAll(vector2);
                continue;
            }
            if (this.containsQName(vector, n)) {
                qName = ((Entry)object).getQName();
            }
            ++n;
        }
        if (qName != null) {
            object = type.getDimensions();
            if (!type.isCollectionTypeEntry()) {
                object = null;
            }
            type.setRefType(this.getUnmappableType(), (String)object);
            type.setChildren(null);
            this.reportUnmappableConstruct(type.getQName());
        }
    }

    private boolean containsQName(List list, int n) {
        QName qName = ((Entry)list.get(n)).getQName();
        for (int i = 0; i < n; ++i) {
            QName qName2 = ((Entry)list.get(i)).getQName();
            if (qName2 == null || !qName2.equals(qName)) continue;
            return true;
        }
        return false;
    }

    private void populateMessages(Definition definition) throws IOException {
        Iterator iterator = definition.getMessages().values().iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            MessageEntry messageEntry = new MessageEntry(message, this);
            this.symbolTablePut(messageEntry);
        }
    }

    private void populatePortTypes(Definition definition) throws IOException {
        Iterator iterator = definition.getPortTypes().values().iterator();
        while (iterator.hasNext()) {
            PortType portType = (PortType)iterator.next();
            if (portType.isUndefined()) continue;
            PortTypeEntry portTypeEntry = new PortTypeEntry(portType, this);
            this.symbolTablePut(portTypeEntry);
        }
    }

    private void populateBindings(Definition definition) throws IOException {
        Iterator iterator = definition.getBindings().values().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Binding binding = (Binding)iterator.next();
            BindingEntry bindingEntry = new BindingEntry(binding, this);
            this.symbolTablePut(bindingEntry);
            ExtensibilityElement extensibilityElement = this.getHttpSoapEJBBindingExtElement(binding);
            if (extensibilityElement != null) {
                bindingEntry.setDynamicVar(BindingEntry.BINDING_NAMESPACE, extensibilityElement.getElementType().getNamespaceURI());
            }
            if (extensibilityElement instanceof SOAPBinding) {
                bindingEntry.setBindingType(0);
                object2 = (SOAPBinding)extensibilityElement;
                bindingEntry.setDynamicVar(BindingEntry.SOAP_TRANSPORT_URI, object2.getTransportURI());
                object = object2.getStyle();
                if ("rpc".equalsIgnoreCase((String)object)) {
                    bindingEntry.setBindingStyle(Style.RPC);
                }
            } else if (extensibilityElement instanceof HTTPBinding) {
                object2 = (HTTPBinding)extensibilityElement;
                if (object2.getVerb().equalsIgnoreCase("post")) {
                    bindingEntry.setBindingType(2);
                } else {
                    bindingEntry.setBindingType(1);
                }
            } else {
                bindingEntry.setBindingType(4);
            }
            object2 = binding.getBindingOperations();
            object = object2.iterator();
            while (object.hasNext()) {
                BindingOperation bindingOperation = (BindingOperation)object.next();
                this.addBindingOperation(bindingEntry, bindingOperation);
            }
            this.checkOperations(binding.getPortType(), binding);
        }
    }

    private void checkOperations(PortType portType, Binding binding) throws IOException {
        List list = portType.getOperations();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Operation operation = (Operation)iterator.next();
            Input input = operation.getInput();
            Output output = operation.getOutput();
            String string3 = operation.getName();
            if (binding.getBindingOperation(string3, string2 = input == null ? null : input.getName(), string = output == null ? null : output.getName()) != null) continue;
            boolean bl = false;
            try {
                portType.getOperation(string3, null, null);
                bl = binding.getBindingOperation(string3, null, null) == null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = true;
            }
            if (!bl) continue;
            this.env.reportFatalErr(Messages.getMessage("unmatchedBindOp00", new String[]{string3, string2, string}));
        }
    }

    private void addBindingOperation(BindingEntry bindingEntry, BindingOperation bindingOperation) throws IOException {
        String string;
        Operation operation = bindingOperation.getOperation();
        BindingInput bindingInput = bindingOperation.getBindingInput();
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        String string2 = bindingOperation.getName();
        String string3 = bindingInput == null ? null : bindingInput.getName();
        String string4 = string = bindingOutput == null ? null : bindingOutput.getName();
        if (bindingEntry.getBinding().getPortType().getOperation(string2, string3, string) == null) {
            throw new IOException(Messages.getMessage("unmatchedOp", new String[]{string2, string3, string}));
        }
        BindingOperationEntry bindingOperationEntry = new BindingOperationEntry(bindingOperation, this);
        bindingEntry.addOperation(operation, bindingOperationEntry);
        List list = bindingOperationEntry.getBindingOperation().getExtensibilityElements();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof SOAPOperation)) continue;
            String string5 = ((SOAPOperation)e2).getStyle();
            bindingOperationEntry.setDynamicVar(BindingOperationEntry.SOAP_ACTION_URI, ((SOAPOperation)e2).getSoapActionURI());
            if (string5 == null || string5.equals(bindingEntry.getBindingStyle().toString())) continue;
            throw new IOException(Messages.getMessage("useMismatch", new String[]{string2, "binding style", bindingEntry.getBindingStyle().toString(), "operation style", string5}));
        }
        if (bindingInput != null) {
            this.setBodyUseAndNamespace(bindingOperationEntry, bindingInput.getExtensibilityElements(), true);
        }
        if (bindingOutput != null) {
            this.setBodyUseAndNamespace(bindingOperationEntry, bindingOutput.getExtensibilityElements(), false);
        }
        if (bindingOperationEntry.getInputBodyUse() != null && bindingOperationEntry.getOutputBodyUse() != null && bindingOperationEntry.getInputBodyUse() != bindingOperationEntry.getOutputBodyUse()) {
            throw new IOException(Messages.getMessage("useMismatch", new String[]{string2, "input use", bindingOperationEntry.getInputBodyUse().toString(), "output use", bindingOperationEntry.getOutputBodyUse().toString()}));
        }
        if (bindingEntry.getBindingStyle() == Style.DOCUMENT && bindingOperationEntry.getInputBodyUse() == Use.ENCODED) {
            this.env.reportFatalErr(Messages.getMessage("invalidDocEnc01", Style.DOCUMENT.getName(), Use.ENCODED.getName(), bindingEntry.getQName().getLocalPart(), bindingOperationEntry.getBindingOperation().getName()));
        }
        this.addOperationParameters(bindingEntry, bindingOperationEntry);
        if (bindingInput != null) {
            this.setHeaderInfo(bindingOperationEntry, bindingInput.getExtensibilityElements(), true);
        }
        if (bindingOutput != null) {
            this.setHeaderInfo(bindingOperationEntry, bindingOutput.getExtensibilityElements(), false);
        }
        if (bindingInput != null) {
            this.setMIMEInfo(bindingOperationEntry, bindingInput.getExtensibilityElements(), true);
        }
        if (bindingOutput != null) {
            this.setMIMEInfo(bindingOperationEntry, bindingOutput.getExtensibilityElements(), false);
        }
        this.addOperationFaults(bindingEntry, bindingOperationEntry);
        if (bindingInput != null) {
            this.setHeaderFaultInfo(bindingOperationEntry, bindingInput.getExtensibilityElements(), true);
        }
        if (bindingOutput != null) {
            this.setHeaderFaultInfo(bindingOperationEntry, bindingOutput.getExtensibilityElements(), false);
        }
    }

    public void addOperationParameters(BindingEntry bindingEntry, BindingOperationEntry bindingOperationEntry) throws IOException {
        int n;
        int n2;
        List list;
        Vector vector;
        Object object;
        Binding binding = bindingEntry.getBinding();
        PortType portType = binding.getPortType();
        String string = portType.getQName().getNamespaceURI();
        Operation operation = bindingOperationEntry.getBindingOperation().getOperation();
        Input input = operation.getInput();
        Output output = operation.getOutput();
        QName qName = null;
        QName qName2 = null;
        if (input != null && input.getMessage() != null && input.getMessage().getParts() != null && input.getMessage().getParts().values().size() != 0) {
            qName = input.getMessage().getQName();
        }
        if (output != null && output.getMessage() != null) {
            qName2 = output.getMessage().getQName();
        }
        MetaOperationKey metaOperationKey = new MetaOperationKey(bindingEntry.getQName(), operation.getName(), qName, qName2);
        MetaOperationValue metaOperationValue = (MetaOperationValue)this.metaInfo.getOperationMap().get(metaOperationKey);
        if (metaOperationValue == null) {
            metaOperationKey = new MetaOperationKey(bindingEntry.getQName(), operation.getName(), qName, null);
            metaOperationValue = (MetaOperationValue)this.metaInfo.getOperationMap().get(metaOperationKey);
        }
        boolean bl = false;
        if (metaOperationValue != null) {
            bl = !metaOperationValue.isWrapped();
        } else if (this.metaInfo != null) {
            bl = this.metaInfo.getProperty("noWrappedOperations") == Boolean.TRUE || this.metaInfo.getProperty("noDataBinding") == Boolean.TRUE;
        }
        List list2 = null;
        ArrayList arrayList = null;
        if (metaOperationValue != null) {
            list2 = metaOperationValue.getParameterOrder();
            arrayList = metaOperationValue.getModeOrder();
        } else {
            list2 = operation.getParameterOrdering();
        }
        if (list2 != null && list2.isEmpty()) {
            list2 = null;
        }
        if (!(list2 == null || metaOperationValue != null && metaOperationValue.isWrapped() || input == null)) {
            object = input.getMessage();
            vector = object.getParts();
            list = list2;
            if (arrayList != null) {
                list = new ArrayList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!arrayList.get(i).equals("IN") && !arrayList.get(i).equals("INOUT")) continue;
                    list.add(list2.get(i));
                }
            }
            List list3 = object.getOrderedParts(list);
            if (vector.size() != list3.size()) {
                throw new IOException(Messages.getMessage("emitFail00", operation.getName()));
            }
        }
        object = null;
        if (metaOperationValue != null) {
            object = metaOperationValue.getReturnPart();
        }
        vector = new Vector();
        list = new Vector();
        boolean bl2 = false;
        boolean bl3 = false;
        StringHolder stringHolder = new StringHolder();
        Style style = bindingEntry.getBindingStyle();
        if (input != null && input.getMessage() != null && (bl2 = this.createBindingParams(vector, this.getMessageEntry(input.getMessage().getQName()), true, bindingOperationEntry, bindingEntry, stringHolder, bl, style))) {
            style = Style.WRAPPED;
        }
        if (output != null && output.getMessage() != null) {
            bl3 = this.createBindingParams((Vector)list, this.getMessageEntry(output.getMessage().getQName()), false, bindingOperationEntry, bindingEntry, null, bl, style);
        }
        if (bl2) {
            if (output == null || bl3) {
                bindingOperationEntry.setWrapped(true);
                bindingOperationEntry.setNamespace(stringHolder.value);
            } else {
                style = bindingEntry.getBindingStyle();
                vector = new Vector();
                list = new Vector();
                if (input != null && input.getMessage() != null) {
                    this.createBindingParams(vector, this.getMessageEntry(input.getMessage().getQName()), true, bindingOperationEntry, bindingEntry, stringHolder, true, style);
                }
                if (output != null && output.getMessage() != null) {
                    this.createBindingParams((Vector)list, this.getMessageEntry(output.getMessage().getQName()), false, bindingOperationEntry, bindingEntry, null, true, style);
                }
            }
        }
        if (list2 != null) {
            n2 = 0;
            if (bl3) {
                n2 = this.checkInOutOrdering(vector, (Vector)list, operation.getName(), qName2) ? 1 : 0;
            }
            bindingOperationEntry.setDynamicVar(JavaGeneratorFactory.OUT_ORDERING_REQUIRED, String.valueOf(n2 != 0));
            for (int i = 0; i < list2.size(); ++i) {
                String string2 = (String)list2.get(i);
                n = -1;
                if (arrayList == null || arrayList.get(i).equals("IN") || arrayList.get(i).equals("INOUT")) {
                    n = this.getParamIndex(string2, vector);
                }
                int n3 = -1;
                if (arrayList == null || arrayList.get(i).equals("OUT") || arrayList.get(i).equals("INOUT")) {
                    n3 = this.getParamIndex(string2, (Vector)list);
                }
                if (n >= 0) {
                    BindingParamEntry bindingParamEntry;
                    if (string2.equals(object) && n3 >= 0) {
                        bindingParamEntry = (BindingParamEntry)((Vector)list).get(n3);
                        bindingParamEntry.setMode((byte)2);
                        bindingOperationEntry.setReturn(bindingParamEntry);
                        ((Vector)list).remove(n3);
                        n3 = -1;
                    } else if (n3 >= 0 && n2 == 1) {
                        bindingParamEntry = (BindingParamEntry)vector.get(n);
                        BindingParamEntry bindingParamEntry2 = (BindingParamEntry)((Vector)list).get(n3);
                        bindingParamEntry.setDynamicVar(JavaGeneratorFactory.OUT_POSITION, (String)bindingParamEntry2.getDynamicVar(JavaGeneratorFactory.OUT_POSITION));
                    }
                    this.addInishParm(vector, (Vector)list, n, n3, bindingOperationEntry);
                    vector.remove(n);
                    continue;
                }
                if (n3 >= 0) {
                    this.addOutParm((Vector)list, n3, bindingOperationEntry);
                    ((Vector)list).remove(n3);
                    continue;
                }
                if (bl2) continue;
                System.err.println(Messages.getMessage("noPart00", string2));
            }
        }
        if (bl2 && bl3 && vector.size() == 1 && ((Vector)list).size() == 1 && ((BindingParamEntry)vector.get(0)).getQName().equals(((BindingParamEntry)((Vector)list).get(0)).getQName()) && (metaOperationValue == null || metaOperationValue.getReturnPart() != null)) {
            this.addInishParm(vector, null, 0, -1, bindingOperationEntry);
        } else {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                BindingParamEntry bindingParamEntry = (BindingParamEntry)vector.get(n2);
                int n4 = -1;
                for (n = 0; n < ((Vector)list).size() && n4 == -1; ++n) {
                    if (!bindingParamEntry.getQName().equals(((BindingParamEntry)((Vector)list).get(n)).getQName())) continue;
                    n4 = n;
                }
                this.addInishParm(vector, (Vector)list, n2, n4, bindingOperationEntry);
            }
        }
        if (((Vector)list).size() == 1 && (metaOperationValue == null || metaOperationValue.getReturnPart() != null)) {
            BindingParamEntry bindingParamEntry = (BindingParamEntry)((Vector)list).get(0);
            bindingParamEntry.setMode((byte)2);
            bindingOperationEntry.setReturn(bindingParamEntry);
        } else {
            for (n2 = 0; n2 < ((Vector)list).size(); ++n2) {
                this.addOutParm((Vector)list, n2, bindingOperationEntry);
            }
        }
    }

    private int getParamIndex(String string, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            BindingParamEntry bindingParamEntry = (BindingParamEntry)vector.get(i);
            if (!bindingParamEntry.getQName().getLocalPart().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void addInishParm(Vector vector, Vector vector2, int n, int n2, BindingOperationEntry bindingOperationEntry) {
        BindingParamEntry bindingParamEntry = (BindingParamEntry)vector.get(n);
        bindingParamEntry.setMode((byte)1);
        if (n2 >= 0) {
            BindingParamEntry bindingParamEntry2 = (BindingParamEntry)vector2.get(n2);
            if (bindingParamEntry.getType().equals(bindingParamEntry2.getType())) {
                vector2.remove(n2);
                bindingParamEntry.setMode((byte)3);
                bindingParamEntry.setOutMessageEntry(bindingParamEntry2.getOutMessageEntry());
            }
        }
        bindingOperationEntry.addParameter(bindingParamEntry);
    }

    private void addOutParm(Vector vector, int n, BindingOperationEntry bindingOperationEntry) {
        BindingParamEntry bindingParamEntry = (BindingParamEntry)vector.get(n);
        bindingParamEntry.setMode((byte)2);
        bindingOperationEntry.addParameter(bindingParamEntry);
    }

    private boolean createBindingParams(Vector vector, MessageEntry messageEntry, boolean bl, BindingOperationEntry bindingOperationEntry, BindingEntry bindingEntry, StringHolder stringHolder, boolean bl2, Style style) throws IOException {
        Object object;
        Object object2;
        Object object3;
        int n;
        Use use = bl ? bindingOperationEntry.getInputBodyUse() : bindingOperationEntry.getOutputBodyUse();
        String string = bindingOperationEntry.getQName().getLocalPart();
        boolean bl3 = false;
        if (bl) {
            n = 0;
            boolean bl4 = false;
            object3 = messageEntry.getMessage().getOrderedParts(null);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Part)object2.next();
                if (use == Use.ENCODED && object.getTypeName() == null) {
                    throw new IOException(Messages.getMessage("emitFailBadUse00", object.getName(), bindingOperationEntry.getBindingOperation().getName()));
                }
                if (object.getElementName() == null) continue;
                ++n;
                if (!bl || !object.getElementName().getLocalPart().equals(string)) continue;
                bl4 = true;
            }
            if (!bl2 && style == Style.DOCUMENT && use == Use.LITERAL && n == 1 && bl4) {
                bl3 = true;
            }
        } else {
            n = 0;
            List list = messageEntry.getMessage().getOrderedParts(null);
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (Part)object3.next();
                if (use == Use.ENCODED && object2.getTypeName() == null) {
                    throw new IOException(Messages.getMessage("emitFailBadUse00", object2.getName(), bindingOperationEntry.getBindingOperation().getName()));
                }
                if (object2.getElementName() == null) continue;
                ++n;
            }
            if (!bl2 && style == Style.WRAPPED && use == Use.LITERAL && n <= 1) {
                bl3 = true;
            }
        }
        Iterator iterator = messageEntry.getMessage().getOrderedParts(null).iterator();
        while (iterator.hasNext()) {
            Serializable serializable;
            Object object4;
            Part part = (Part)iterator.next();
            object3 = part.getElementName();
            object2 = part.getTypeName();
            object = part.getName();
            if (bl3) {
                if (bl) {
                    stringHolder.value = ((QName)object3).getNamespaceURI();
                }
                if (object2 != null && bindingEntry.hasMIMETypes()) {
                    object4 = bindingEntry == null ? "unknown" : bindingEntry.getBinding().getQName().toString();
                    throw new IOException(Messages.getMessage("literalTypePart00", new String[]{object, string, object4}));
                }
                object4 = this.getType((QName)object2);
                if (object4 == null) {
                    serializable = this.getElement((QName)object3);
                    while (serializable instanceof Element) {
                        serializable = ((TypeEntry)serializable).getRefType();
                    }
                    object4 = (Type)serializable;
                }
                if (object4 == null) {
                    throw new IOException(Messages.getMessage("badTypeNode", new String[]{object, string, ((QName)object3).toString()}));
                }
                if (((Type)object4).getExtensionBase() != null || ((Type)object4).getRestrictionBase() != null || ((TypeEntry)object4).isCollectionTypeEntry() || ((TypeEntry)object4).isBaseType() || ((Type)object4).isSimpleType() || ((TypeEntry)object4).isNotMappable()) {
                    bl3 = false;
                }
                if (bl3) {
                    int n2;
                    serializable = ((Type)object4).getChildren();
                    if (serializable == null) {
                        bl3 = false;
                    } else {
                        for (n2 = 0; n2 < ((Vector)serializable).size() && bl3; ++n2) {
                            if (((Vector)serializable).get(n2) instanceof ChildElement) continue;
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        if (serializable != null) {
                            for (n2 = 0; n2 < ((Vector)serializable).size(); ++n2) {
                                ChildElement childElement = (ChildElement)((Vector)serializable).elementAt(n2);
                                BindingParamEntry bindingParamEntry = new BindingParamEntry(childElement.getQName(), this);
                                if (bl) {
                                    bindingParamEntry.setInMessageEntry(messageEntry);
                                    bindingParamEntry.setDynamicVar(JavaGeneratorFactory.IN_POSITION, String.valueOf(n2));
                                } else {
                                    bindingParamEntry.setOutMessageEntry(messageEntry);
                                    bindingParamEntry.setDynamicVar(JavaGeneratorFactory.OUT_POSITION, String.valueOf(n2));
                                }
                                bindingParamEntry.setType(childElement.getType());
                                bindingParamEntry.setMinOccursIs0(childElement.getMinOccursIs0());
                                bindingParamEntry.setMaxOccursIs1(!childElement.getType().isCollectionTypeEntry());
                                bindingParamEntry.setNillable(childElement.isNillable());
                                bindingParamEntry.setParentNamespace(((Entry)object4).getQName().getNamespaceURI());
                                vector.add(bindingParamEntry);
                            }
                        }
                        return true;
                    }
                }
            }
            object4 = new BindingParamEntry(QNameTable.createQName("", (String)object), this);
            if (bl) {
                ((BindingParamEntry)object4).setInMessageEntry(messageEntry);
            } else {
                ((BindingParamEntry)object4).setOutMessageEntry(messageEntry);
            }
            ((Entry)object4).setName((String)object);
            if (object2 != null) {
                ((BindingParamEntry)object4).setType(this.getType((QName)object2));
            } else if (object3 != null) {
                serializable = this.getElement((QName)object3);
                ((BindingParamEntry)object4).setType((TypeEntry)serializable);
                ((BindingParamEntry)object4).setNillable(serializable != null && ((Element)serializable).isNillable());
            } else {
                throw new IOException(Messages.getMessage("noTypeOrElement00", new String[]{object, string}));
            }
            vector.add(object4);
        }
        return bl3;
    }

    private void setMIMEInfo(BindingOperationEntry bindingOperationEntry, List list, boolean bl) throws IOException {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof MIMEMultipartRelated)) continue;
            MIMEMultipartRelated mIMEMultipartRelated = (MIMEMultipartRelated)e2;
            List list2 = mIMEMultipartRelated.getMIMEParts();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                MIMEPart mIMEPart = (MIMEPart)iterator2.next();
                List list3 = mIMEPart.getExtensibilityElements();
                Iterator iterator3 = list3.iterator();
                while (iterator3.hasNext()) {
                    Object e3 = iterator3.next();
                    if (!(e3 instanceof MIMEContent)) continue;
                    MIMEContent mIMEContent = (MIMEContent)e3;
                    BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(mIMEContent.getPart());
                    if (bindingParamEntry == null) {
                        bindingParamEntry = bindingOperationEntry.getReturn();
                    }
                    if (bindingParamEntry == null) continue;
                    bindingParamEntry.setMIMEType(mIMEContent.getType());
                }
            }
        }
    }

    private void setMIMEType(BindingParamEntry bindingParamEntry, String string) {
        QName qName;
        if (string == null && (qName = bindingParamEntry.getType().getQName()).getNamespaceURI().equals("http://xml.apache.org/xml-soap")) {
            if (Constants.MIME_IMAGE.equals(qName)) {
                string = "image/jpeg";
            } else if (Constants.MIME_PLAINTEXT.equals(qName)) {
                string = "text/plain";
            } else if (Constants.MIME_MULTIPART.equals(qName)) {
                string = "multipart/related";
            } else if (Constants.MIME_SOURCE.equals(qName)) {
                string = "text/xml";
            }
        }
        bindingParamEntry.setMIMEType(string);
    }

    private void setHeaderInfo(BindingOperationEntry bindingOperationEntry, List list, boolean bl) throws IOException {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            ExtensibilityElement extensibilityElement;
            Object e2 = iterator.next();
            if (e2 instanceof SOAPHeader) {
                extensibilityElement = (SOAPHeader)e2;
                object = bindingOperationEntry.getParameter(extensibilityElement.getPart());
                if (object == null) continue;
                if (bl) {
                    ((BindingParamEntry)object).setInHeader(true);
                    continue;
                }
                ((BindingParamEntry)object).setOutHeader(true);
                continue;
            }
            if (!(e2 instanceof MIMEMultipartRelated)) continue;
            extensibilityElement = (MIMEMultipartRelated)e2;
            object = extensibilityElement.getMIMEParts().iterator();
            while (object.hasNext()) {
                MIMEPart mIMEPart = (MIMEPart)object.next();
                Iterator iterator2 = mIMEPart.getExtensibilityElements().iterator();
                while (iterator2.hasNext()) {
                    Object object2;
                    Object e3 = iterator2.next();
                    String string = null;
                    if (e3 instanceof SOAPHeader) {
                        string = ((SOAPHeader)e3).getPart();
                    } else {
                        object2 = ((ExtensibilityElement)e3).getElementType();
                        if (((QName)object2).getLocalPart().equals("header") && e3 instanceof UnknownExtensibilityElement) {
                            org.w3c.dom.Element element = ((UnknownExtensibilityElement)e3).getElement();
                            string = element.getAttributeNode("part").getValue();
                        }
                    }
                    if (string == null || (object2 = bindingOperationEntry.getParameter(string)) == null) continue;
                    if (bl) {
                        ((BindingParamEntry)object2).setInHeader(true);
                        continue;
                    }
                    ((BindingParamEntry)object2).setOutHeader(true);
                }
            }
        }
    }

    private void setHeaderFaultInfo(BindingOperationEntry bindingOperationEntry, List list, boolean bl) throws IOException {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof SOAPHeader)) continue;
            SOAPHeader sOAPHeader = (SOAPHeader)e2;
            Iterator iterator2 = sOAPHeader.getSOAPHeaderFaults().iterator();
            while (iterator2.hasNext()) {
                SOAPHeaderFault sOAPHeaderFault = (SOAPHeaderFault)iterator2.next();
                BindingFaultRefEntry bindingFaultRefEntry = bindingOperationEntry.getFault(sOAPHeaderFault.getMessage().getLocalPart());
                if (bindingFaultRefEntry == null) {
                    bindingFaultRefEntry = this.createBindingFaultRef(this.getMessageEntry(sOAPHeaderFault.getMessage()), bindingOperationEntry);
                }
                if (bl) {
                    bindingFaultRefEntry.setInHeader(true);
                } else {
                    bindingFaultRefEntry.setOutHeader(true);
                }
                bindingFaultRefEntry.setUse(Use.getUse(sOAPHeaderFault.getUse()));
            }
        }
    }

    private void addOperationFaults(BindingEntry bindingEntry, BindingOperationEntry bindingOperationEntry) throws IOException {
        BindingOperation bindingOperation = bindingOperationEntry.getBindingOperation();
        Binding binding = bindingEntry.getBinding();
        Iterator iterator = bindingOperation.getBindingFaults().values().iterator();
        while (iterator.hasNext()) {
            Object object;
            BindingFault bindingFault = (BindingFault)iterator.next();
            String string = bindingFault.getName();
            if (string == null || string.length() == 0) {
                throw new IOException(Messages.getMessage("unNamedFault00", bindingOperation.getName(), binding.getQName().toString()));
            }
            SOAPFault sOAPFault = null;
            Iterator iterator2 = bindingFault.getExtensibilityElements().iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                if (!(object instanceof SOAPFault)) continue;
                sOAPFault = (SOAPFault)object;
                break;
            }
            if (sOAPFault == null && bindingEntry.getBindingType() != 4) {
                throw new IOException(Messages.getMessage("missingSoapFault00", string, bindingOperation.getName(), binding.getQName().toString()));
            }
            object = bindingOperation.getOperation().getFault(bindingFault.getName());
            if (object == null) {
                throw new IOException(Messages.getMessage("noPortTypeFault", new String[]{bindingFault.getName(), bindingOperation.getName(), binding.getQName().toString()}));
            }
            MessageEntry messageEntry = this.getMessageEntry(object.getMessage().getQName());
            BindingFaultRefEntry bindingFaultRefEntry = this.createBindingFaultRef(messageEntry, bindingOperationEntry);
            if (bindingEntry.getBindingType() == 4) continue;
            bindingFaultRefEntry.setUse(Use.getUse(sOAPFault.getUse()));
            if (bindingOperationEntry.getInputBodyUse() == null || bindingFaultRefEntry.getUse() == null || bindingOperationEntry.getInputBodyUse() == bindingFaultRefEntry.getUse()) continue;
            throw new IOException(Messages.getMessage("useMismatch", new String[]{bindingOperation.getName(), "input use", bindingOperationEntry.getInputBodyUse().toString(), "fault use", bindingFaultRefEntry.getUse().toString()}));
        }
    }

    private BindingFaultRefEntry createBindingFaultRef(MessageEntry messageEntry, BindingOperationEntry bindingOperationEntry) {
        this.setMessageEntryAsFault(messageEntry);
        BindingFaultRefEntry bindingFaultRefEntry = new BindingFaultRefEntry(messageEntry, this);
        bindingOperationEntry.addFault(bindingFaultRefEntry);
        return bindingFaultRefEntry;
    }

    public void setMessageEntryAsFault(MessageEntry messageEntry) {
        if (messageEntry.isFault()) {
            return;
        }
        messageEntry.setFault(true);
        Vector<ChildFaultPartEntry> vector = new Vector<ChildFaultPartEntry>();
        List list = messageEntry.getMessage().getOrderedParts(null);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            QName qName = QNameTable.createQName("", part.getName());
            TypeEntry typeEntry = null;
            typeEntry = part.getTypeName() != null ? this.getType(part.getTypeName()) : this.getElement(part.getElementName());
            vector.add(new ChildFaultPartEntry(qName, typeEntry, this));
        }
        messageEntry.setFaultParts(vector);
    }

    private void setBodyUseAndNamespace(BindingOperationEntry bindingOperationEntry, List list, boolean bl) throws IOException {
        this.setBodyUse(bindingOperationEntry, "literal", null, bl);
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ExtensibilityElement extensibilityElement;
            Object e2 = iterator.next();
            if (e2 instanceof SOAPBody) {
                extensibilityElement = (SOAPBody)e2;
                this.setBodyUse(bindingOperationEntry, extensibilityElement.getUse(), extensibilityElement.getEncodingStyles(), bl);
                if (bl && extensibilityElement.getNamespaceURI() != null) {
                    bindingOperationEntry.setNamespace(extensibilityElement.getNamespaceURI());
                }
                if (bl || extensibilityElement.getNamespaceURI() == null) continue;
                bindingOperationEntry.setOutputNamespace(extensibilityElement.getNamespaceURI());
                continue;
            }
            if (e2 instanceof SOAPHeader) {
                extensibilityElement = (SOAPHeader)e2;
                this.setBodyUse(bindingOperationEntry, extensibilityElement.getUse(), extensibilityElement.getEncodingStyles(), bl);
                continue;
            }
            if (!(e2 instanceof MIMEMultipartRelated)) continue;
            extensibilityElement = (MIMEMultipartRelated)e2;
            List list2 = extensibilityElement.getMIMEParts();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                MIMEPart mIMEPart = (MIMEPart)iterator2.next();
                List list3 = mIMEPart.getExtensibilityElements();
                Iterator iterator3 = list3.iterator();
                while (iterator3.hasNext()) {
                    Object e3 = iterator3.next();
                    if (e3 instanceof SOAPBody) {
                        this.setBodyUse(bindingOperationEntry, ((SOAPBody)e3).getUse(), ((SOAPBody)e3).getEncodingStyles(), bl);
                        if (!bl || ((SOAPBody)e3).getNamespaceURI() == null) continue;
                        bindingOperationEntry.setNamespace(((SOAPBody)e3).getNamespaceURI());
                        continue;
                    }
                    if (!(e3 instanceof SOAPHeader)) continue;
                    SOAPHeader sOAPHeader = (SOAPHeader)e3;
                    this.setBodyUse(bindingOperationEntry, sOAPHeader.getUse(), sOAPHeader.getEncodingStyles(), bl);
                }
            }
        }
    }

    private void setBodyUse(BindingOperationEntry bindingOperationEntry, String string, List list, boolean bl) throws IOException {
        Use use = string == null ? Use.LITERAL : Use.getUse(string);
        if (bl) {
            bindingOperationEntry.setInputBodyUse(use);
            if (list != null && list.size() > 0) {
                if (use == Use.LITERAL) {
                    if (log.isDebugEnabled()) {
                        log.debug("setBodyUse: input encodingStyle [" + list.get(0) + "]provided with literal use and is being ignored");
                    }
                } else {
                    bindingOperationEntry.setInputEncodingStyle((String)list.get(0));
                }
            }
        } else {
            bindingOperationEntry.setOutputBodyUse(use);
            if (list != null && list.size() > 0) {
                if (use == Use.LITERAL) {
                    if (log.isDebugEnabled()) {
                        log.debug("setBodyUse: output encodingStyle [" + list.get(0) + "]provided with literal use and is being ignored");
                    }
                } else {
                    bindingOperationEntry.setOutputEncodingStyle((String)list.get(0));
                }
            }
        }
    }

    private void populateServices(Definition definition) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Entry entry = null;
        Iterator iterator = definition.getServices().values().iterator();
        while (iterator.hasNext()) {
            object4 = (Service)iterator.next();
            if (object4.getQName() == null || object4.getQName().getLocalPart() == null || object4.getQName().getLocalPart().equals("")) {
                throw new IOException(Messages.getMessage("BadServiceName00"));
            }
            this.addServices((Service)object4);
            entry = new ServiceEntry((Service)object4, this);
            this.symbolTablePut((SymTabEntry)entry);
            object3 = object4.getPorts();
            object2 = object3.values().iterator();
            while (object2.hasNext()) {
                object = (Port)object2.next();
                QName qName = QNameTable.createQName(object4.getQName().getNamespaceURI(), object.getName());
                ((ServiceEntry)entry).addPort(new PortEntry(qName, (Port)object, this));
                BindingEntry bindingEntry = this.getBindingEntry(object.getBinding().getQName());
                bindingEntry.setServiceName(object4.getQName());
            }
        }
        if (entry != null && this.isNonBoundWSDL(definition)) {
            entry.setDynamicVar(NON_BOUND_WSDL, Boolean.TRUE);
            object4 = ((ServiceEntry)entry).getPort(0);
            object3 = ((PortEntry)object4).getPort();
            object2 = object3.getBinding();
            object = this.getBindingEntry(object2.getQName());
            ((BindingEntry)object).setBindingType(4);
        }
    }

    private void setReferences(Definition definition, Document document) {
        SymTabEntry symTabEntry;
        Serializable serializable;
        int n;
        boolean bl = false;
        Map map = this.getServices();
        if (map.isEmpty()) {
            map = definition.getBindings();
            if (map.isEmpty()) {
                map = definition.getPortTypes();
                if (map.isEmpty()) {
                    map = definition.getMessages();
                    if (map.isEmpty()) {
                        for (n = 0; n < this.types.size() && !bl; ++n) {
                            serializable = (TypeEntry)this.types.get(n);
                            bl = this.setTypeReferences((TypeEntry)serializable, document, false) || bl;
                        }
                    } else {
                        Iterator iterator = map.values().iterator();
                        while (iterator.hasNext()) {
                            serializable = (Message)iterator.next();
                            symTabEntry = this.getMessageEntry(serializable.getQName());
                            bl = this.setMessageReferences((MessageEntry)symTabEntry, definition, document, false, bl) || bl;
                        }
                    }
                } else {
                    Iterator iterator = map.values().iterator();
                    while (iterator.hasNext()) {
                        serializable = (PortType)iterator.next();
                        symTabEntry = this.getPortTypeEntry(serializable.getQName());
                        bl = this.setPortTypeReferences((PortTypeEntry)symTabEntry, null, definition, document, bl) || bl;
                    }
                }
            } else {
                Iterator iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    serializable = (Binding)iterator.next();
                    symTabEntry = this.getBindingEntry(serializable.getQName());
                    bl = this.setBindingReferences((BindingEntry)symTabEntry, definition, document, bl) || bl;
                }
            }
        } else {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                serializable = (Service)iterator.next();
                symTabEntry = this.getServiceEntry(serializable.getQName());
                String string = serializable.getQName().getLocalPart();
                if (!this.shouldServiceBeWritten(string) || this.env.getSuspendGen()) continue;
                bl = this.setServiceReferences((ServiceEntry)symTabEntry, definition, document, bl) || bl;
            }
        }
        if (bl) {
            for (n = 0; n < this.types.size(); ++n) {
                serializable = (TypeEntry)this.types.get(n);
                if (((SymTabEntry)((Object)serializable)).isReferenced()) continue;
                this.setTypeReferences((TypeEntry)serializable, document, false, true);
            }
        }
    }

    private boolean setTypeReferences(TypeEntry typeEntry, Document document, boolean bl) {
        return this.setTypeReferences(typeEntry, document, bl, false);
    }

    private boolean setTypeReferences(TypeEntry typeEntry, Document document, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        boolean bl3 = false;
        if (typeEntry.isReferenced() && !bl || typeEntry.isOnlyWrappedLiteralReferenced() && bl) {
            typeEntry.setOnlyWrappedLiteralReference(bl);
            return bl3;
        }
        if (!typeEntry.isReferenced() && bl) {
            typeEntry.setOnlyWrappedLiteralReference(true);
        } else if (typeEntry.isOnlyWrappedLiteralReferenced() && !bl) {
            typeEntry.setOnlyWrappedLiteralReference(false);
        }
        CustomRegistry customRegistry = this.metaInfo.getCustomRegistry();
        Node node = typeEntry.getNode();
        if (this.addImports || node == null || node.getOwnerDocument() == document) {
            typeEntry.setIsReferenced(true);
            if (typeEntry instanceof DefinedElement) {
                object3 = new BooleanHolder();
                object2 = Utils.getTypeQName(node, (BooleanHolder)object3, false, typeEntry.getNodeStack(), this.env);
                if (object2 != null) {
                    if ((this.debug || log.isDebugEnabled()) && Constants.isSchemaXSD(((QName)object2).getNamespaceURI()) && ("anyType".equals(((QName)object2).getLocalPart()) || "any".equals(((QName)object2).getLocalPart()))) {
                        object = "Debug: SIDX " + typeEntry.getSIDX() + " " + typeEntry.getQName().getLocalPart() + " refers to an anyType, ALL types will be generated. ";
                        if (log.isDebugEnabled()) {
                            log.debug(object);
                        } else {
                            this.env.report((String)object);
                        }
                    }
                    object = null;
                    object = ((BooleanHolder)object3).value ? this.getElement((QName)object2) : this.getType((QName)object2);
                    if (object != null) {
                        if (customRegistry != null && customRegistry.getJavaName(((Entry)object).getQName()) != null) {
                            ((SymTabEntry)object).setIsReferenced(true);
                        } else {
                            bl3 = this.setTypeReferences((TypeEntry)object, document, bl, bl2) || bl3;
                        }
                        return bl3;
                    }
                }
                object = typeEntry.getRefType();
                while (object instanceof Element) {
                    object = ((TypeEntry)object).getRefType();
                }
                if (object != null && ((Type)object).isAnonType()) {
                    bl3 = this.setTypeReferences((TypeEntry)object, document, bl, bl2) || bl3;
                    return bl3;
                }
            }
        }
        if (customRegistry != null && customRegistry.getJavaName(typeEntry.getQName()) != null) {
            return false;
        }
        if (!bl2) {
            object3 = typeEntry;
            if (bl) {
                while (object3 instanceof Element) {
                    object3 = ((TypeEntry)object3).getRefType();
                }
            }
            if (this.isReferencedViaAny((Set)(object2 = Utils.getNestedTypes((TypeEntry)object3, this)))) {
                return true;
            }
            object = object2.iterator();
            while (object.hasNext()) {
                TypeEntry typeEntry2 = (TypeEntry)object.next();
                if (typeEntry2 == object3 || typeEntry2.isReferenced() && !typeEntry2.isOnlyWrappedLiteralReferenced()) continue;
                this.setTypeReferences(typeEntry2, document, false, true);
            }
        }
        return bl3;
    }

    private boolean isReferencedViaAny(Set set) {
        if (set.size() == this.getTypes().size()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                TypeEntry typeEntry = (TypeEntry)iterator.next();
                if (!Constants.isSchemaXSD(typeEntry.getQName().getNamespaceURI()) || !typeEntry.getQName().getLocalPart().equals("anyType") && !typeEntry.getQName().getLocalPart().equals("any")) continue;
                if (this.debug || log.isDebugEnabled()) {
                    String string = "Debug: SIDX " + typeEntry.getSIDX() + " is an anyType, ALL types will  be generated.";
                    if (log.isDebugEnabled()) {
                        log.debug(string);
                    } else {
                        this.env.report(string);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean setMessageReferences(MessageEntry messageEntry, Definition definition, Document document, boolean bl, boolean bl2) {
        Object object;
        Message message = messageEntry.getMessage();
        if (this.addImports) {
            messageEntry.setIsReferenced(true);
        } else {
            object = definition.getMessages();
            if (object.containsValue(message)) {
                messageEntry.setIsReferenced(true);
            }
        }
        object = message.getParts().values().iterator();
        while (object.hasNext()) {
            Part part = (Part)object.next();
            TypeEntry typeEntry = this.getType(part.getTypeName());
            if (typeEntry == null) {
                typeEntry = this.getElement(part.getElementName());
            }
            if (typeEntry == null) continue;
            boolean bl3 = false;
            TypeEntry typeEntry2 = typeEntry.getRefType();
            if (typeEntry2 != null) {
                bl3 = typeEntry2.isOnlyWrappedLiteralReferenced();
            }
            if (!bl && bl2 && !typeEntry.isOnlyWrappedLiteralReferenced() && !bl3) continue;
            boolean bl4 = bl2 = this.setTypeReferences(typeEntry, document, bl) || bl2;
            if (typeEntry2 == null || bl || !bl3) continue;
            bl2 = this.setTypeReferences(typeEntry2, document, bl) || bl2;
        }
        return bl2;
    }

    private boolean setPortTypeReferences(PortTypeEntry portTypeEntry, BindingEntry bindingEntry, Definition definition, Document document, boolean bl) {
        Object object;
        PortType portType = portTypeEntry.getPortType();
        if (this.addImports) {
            portTypeEntry.setIsReferenced(true);
        } else {
            object = definition.getPortTypes();
            if (object.containsValue(portType)) {
                portTypeEntry.setIsReferenced(true);
            }
        }
        object = portType.getOperations().iterator();
        while (object.hasNext()) {
            Object object2;
            Object object3;
            Operation operation = (Operation)object.next();
            Input input = operation.getInput();
            Output output = operation.getOutput();
            boolean bl2 = false;
            boolean bl3 = false;
            if (bindingEntry != null) {
                object3 = bindingEntry.getOperation(operation);
                bl2 = ((BindingOperationEntry)object3).getInputBodyUse() == Use.LITERAL && ((BindingOperationEntry)object3).isWrapped();
                boolean bl4 = bl3 = ((BindingOperationEntry)object3).getOutputBodyUse() == Use.LITERAL && ((BindingOperationEntry)object3).isWrapped();
            }
            if (input != null && (object3 = input.getMessage()) != null && (object2 = this.getMessageEntry(object3.getQName())) != null) {
                boolean bl5 = bl = this.setMessageReferences((MessageEntry)object2, definition, document, bl2, bl) || bl;
            }
            if (output != null && (object3 = output.getMessage()) != null && (object2 = this.getMessageEntry(object3.getQName())) != null) {
                bl = this.setMessageReferences((MessageEntry)object2, definition, document, bl3, bl) || bl;
            }
            object3 = operation.getFaults().values().iterator();
            while (object3.hasNext()) {
                MessageEntry messageEntry;
                object2 = ((Fault)object3.next()).getMessage();
                if (object2 == null || (messageEntry = this.getMessageEntry(object2.getQName())) == null) continue;
                bl = this.setMessageReferences(messageEntry, definition, document, false, bl) || bl;
            }
        }
        return bl;
    }

    private boolean setBindingReferences(BindingEntry bindingEntry, Definition definition, Document document, boolean bl) {
        if (bindingEntry.getBindingType() == 0 || bindingEntry.getBindingType() == 4) {
            Object object;
            Binding binding = bindingEntry.getBinding();
            if (this.addImports) {
                bindingEntry.setIsReferenced(true);
            } else {
                object = definition.getBindings();
                if (object.containsValue(binding)) {
                    bindingEntry.setIsReferenced(true);
                }
            }
            object = binding.getPortType();
            PortTypeEntry portTypeEntry = this.getPortTypeEntry(object.getQName());
            if (portTypeEntry != null) {
                bl = this.setPortTypeReferences(portTypeEntry, bindingEntry, definition, document, bl) || bl;
            }
            Iterator iterator = bindingEntry.getOperations();
            while (iterator.hasNext()) {
                BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator.next();
                for (int i = 0; i < bindingOperationEntry.numFaults(); ++i) {
                    MessageEntry messageEntry = bindingOperationEntry.getFault(i).getMessageEntry();
                    bl = this.setMessageReferences(messageEntry, definition, document, false, bl) || bl;
                }
            }
        }
        return bl;
    }

    private boolean setServiceReferences(ServiceEntry serviceEntry, Definition definition, Document document, boolean bl) {
        Object object;
        Service service = serviceEntry.getService();
        if (this.addImports) {
            serviceEntry.setIsReferenced(true);
        } else {
            object = this.getServices();
            if (object.containsValue(service)) {
                serviceEntry.setIsReferenced(true);
            }
        }
        object = service.getPorts().values().iterator();
        while (object.hasNext()) {
            Port port2 = (Port)object.next();
            Binding binding = port2.getBinding();
            BindingEntry bindingEntry = this.getBindingEntry(binding.getQName());
            if (bindingEntry == null) continue;
            bl = this.setBindingReferences(bindingEntry, definition, document, bl) || bl;
        }
        return bl;
    }

    private void symbolTablePut(SymTabEntry symTabEntry) throws IOException {
        QName qName = symTabEntry.getQName();
        SymTabEntry symTabEntry2 = this.get(qName, symTabEntry.getClass());
        if (symTabEntry2 == null) {
            if (symTabEntry instanceof Type && this.get(qName, UndefinedType.class) != null) {
                if (((Type)this.get(qName, UndefinedType.class)).isSimpleType() && !((Type)symTabEntry).isSimpleType()) {
                    throw new IOException(Messages.getMessage("AttrNotSimpleType01", qName.toString()));
                }
                this.replaceUndefined(symTabEntry, qName, Type.class);
            } else if (symTabEntry instanceof Element && this.get(qName, UndefinedElement.class) != null) {
                this.replaceUndefined(symTabEntry, qName, Element.class);
            } else if (symTabEntry instanceof Attribute && this.get(qName, UndefinedAttribute.class) != null) {
                this.replaceUndefined(symTabEntry, qName, Attribute.class);
            } else if (symTabEntry instanceof Group && this.get(qName, UndefinedGroup.class) != null) {
                this.replaceUndefined(symTabEntry, qName, Group.class);
            } else if (symTabEntry instanceof AttributeGroup && this.get(qName, UndefinedAttributeGroup.class) != null) {
                this.replaceUndefined(symTabEntry, qName, AttributeGroup.class);
            } else {
                Vector<SymTabEntry> vector = (Vector<SymTabEntry>)this.symbolTable.get(qName);
                if (vector == null) {
                    vector = new Vector<SymTabEntry>();
                    this.symbolTable.put(qName, vector);
                }
                vector.add(symTabEntry);
                this.entryList.add(symTabEntry);
                symTabEntry.setSIDX(this.entryList.size());
                if (symTabEntry instanceof TypeEntry) {
                    this.types.add(symTabEntry);
                } else if (symTabEntry instanceof Group) {
                    this.groups.add(symTabEntry);
                } else if (symTabEntry instanceof AttributeGroup) {
                    this.attributeGroups.add(symTabEntry);
                }
            }
        } else if (!(this.isDuringProcessingOfRedefine || this.resolver.isIncludedMultipleTimes || symTabEntry2 instanceof TypeEntry && ((TypeEntry)symTabEntry2).isBaseType())) {
            this.env.reporterr(Messages.getMessage("alreadyExists00", "" + qName));
        }
    }

    protected SymTabEntry lookup(int n) {
        if (n <= 0) {
            return null;
        }
        return (SymTabEntry)this.entryList.get(n - 1);
    }

    private void replaceUndefined(SymTabEntry symTabEntry, QName qName, Class clazz) throws IOException {
        Vector vector = (Vector)this.symbolTable.get(qName);
        for (int i = 0; i < vector.size(); ++i) {
            SymTabEntry symTabEntry2 = (SymTabEntry)vector.elementAt(i);
            if (!(symTabEntry2 instanceof Undefined) || !clazz.isAssignableFrom(symTabEntry2.getClass())) continue;
            vector.setElementAt(symTabEntry, i);
            Vector vector2 = null;
            if (symTabEntry instanceof TypeEntry) {
                vector2 = this.types;
            } else if (symTabEntry instanceof Group) {
                vector2 = this.groups;
            } else if (symTabEntry instanceof AttributeGroup) {
                vector2 = this.attributeGroups;
            }
            if (vector2 != null) {
                for (int j = 0; j < vector2.size(); ++j) {
                    if (vector2.elementAt(j) != symTabEntry2) continue;
                    vector2.setElementAt(symTabEntry, j);
                }
            }
            symTabEntry.setSIDX(symTabEntry2.getSIDX());
            this.entryList.set(symTabEntry.getSIDX() - 1, symTabEntry);
        }
    }

    private TypeEntry createBaseType(QName qName) {
        DefinedType definedType = null;
        String string = qName.getLocalPart();
        String string2 = this.btm.getBaseName(qName);
        if (string2 != null) {
            definedType = new DefinedType(qName, this);
            if (!Constants.equals(qName, Constants.XSD_ANY)) {
                definedType.setSimpleType(true);
            }
        }
        return definedType;
    }

    private void reportUnmappableConstruct(QName qName) {
        if ((this.metaInfo == null || this.metaInfo.getProperty("noDataBinding") != Boolean.TRUE) && (this.metaInfo.getCustomRegistry() == null || this.metaInfo.getCustomRegistry().getJavaName(qName, "complexType") == null && this.metaInfo.getCustomRegistry().getJavaName(qName, "element") == null)) {
            if (this.unmappableTypes == null) {
                this.unmappableTypes = new LinkedHashSet();
            }
            if (this.unmappableTypes.contains(qName)) {
                return;
            }
            if (this.warnUnmappableTypes) {
                this.unmappableTypes.add(qName);
                this.env.reportWarning(Messages.getMessage("w2junmap00", qName.toString()));
            }
        }
    }

    private boolean isNonBoundWSDL(Definition definition) {
        boolean bl = false;
        Map map = this.getServices();
        if (map != null && map.size() > 0) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                Map map2 = service.getPorts();
                if (map2 == null || map2.size() <= 0) continue;
                Iterator iterator2 = map2.values().iterator();
                while (iterator2.hasNext()) {
                    Port port2 = (Port)iterator2.next();
                    Binding binding = port2.getBinding();
                    bl = this.getHttpSoapEJBBindingExtElement(binding) == null;
                }
            }
        }
        return bl;
    }

    public void collectNamespaces() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Namespaces namespaces;
        Namespaces namespaces2 = namespaces = this.metaInfo == null ? null : this.metaInfo.getNamespaces();
        if (namespaces == null) {
            return;
        }
        TreeSet<Object> treeSet = new TreeSet<Object>();
        Iterator<Object> iterator = this.symbolTable.keySet().iterator();
        while (iterator.hasNext()) {
            object4 = ((QName)iterator.next()).getNamespaceURI();
            treeSet.add(object4);
        }
        object4 = new TreeSet();
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            if (namespaces.get(object3) != null || Constants.isSchemaXSD((String)object3) || Constants.isSchemaXSI((String)object3) || Constants.isWSDL((String)object3) || Constants.isWSDLSOAP((String)object3) || Constants.isSOAP_ENV((String)object3) || Constants.isSOAP_ENC((String)object3) || "http://websphere.ibm.com/webservices/".equals(object3) || "http://xml.apache.org/xml-soap".equals(object3)) continue;
            object4.add(object3);
            namespaces.getCreate((String)object3);
        }
        if (object4.size() == 0) {
            return;
        }
        object3 = new HashMap();
        iterator = namespaces.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (String)namespaces.get(object2);
            ArrayList<Object> arrayList = (ArrayList<Object>)((HashMap)object3).get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                ((HashMap)object3).put(object, arrayList);
            }
            arrayList.add(object2);
        }
        iterator = ((HashMap)object3).values().iterator();
        while (iterator.hasNext()) {
            object2 = (List)iterator.next();
            if (object2.size() <= 1) continue;
            object = this.symbolTable.keySet().iterator();
            boolean bl = false;
            while (object.hasNext() && !bl) {
                String string = ((QName)object.next()).getLocalPart();
                int n = 0;
                for (int i = 0; i < object2.size() && n < 2; ++i) {
                    QName qName = QNameTable.createQName((String)object2.get(i), string);
                    if (this.getSymbols(qName) == null) continue;
                    ++n;
                }
                bl = n > 1;
            }
            if (!bl) continue;
            for (int i = 0; i < object2.size(); ++i) {
                String string = (String)object2.get(i);
                if (!object4.contains(string)) continue;
                String string2 = JavaUtils.makePackageName2(string);
                namespaces.put(string, string2);
            }
        }
    }

    boolean checkInOutOrdering(Vector vector, Vector vector2, String string, QName qName) {
        if (log.isDebugEnabled()) {
            log.debug("Entry");
            log.debug("operationName: " + string);
            log.debug("outMessageQName: " + qName);
        }
        boolean bl = false;
        if (vector2.size() == 1) {
            if (log.isDebugEnabled()) {
                log.debug("Only one output");
            }
        } else if (vector2.size() > vector.size()) {
            if (log.isDebugEnabled()) {
                log.debug("More outputs than inputs");
            }
            bl = true;
        } else {
            for (int i = 0; i < vector2.size(); ++i) {
                QName qName2 = null;
                QName qName3 = null;
                try {
                    qName2 = ((BindingParamEntry)vector.get(i)).getQName();
                    qName3 = ((BindingParamEntry)vector2.get(i)).getQName();
                    if (qName3 == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug(" input" + i + "=" + qName2);
                        log.debug("output" + i + "=" + qName3);
                    }
                    if (qName3.equals(qName2)) continue;
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
        }
        if (log.isDebugEnabled()) {
            if (bl) {
                log.debug("Output ordering does not match input ordering; response element ordering is required.");
            } else {
                log.debug("Output ordering matches input ordering; response element ordering is not required.");
            }
            log.debug("Exit - needParameterOrdering=" + bl);
        }
        return bl;
    }
}

