/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Vector;

public class JavaBeanFaultProxyWriter
extends JavaBeanWriter {
    static final String SUFFIX = "_DeserProxy";

    protected JavaBeanFaultProxyWriter(Emitter emitter, Type type) {
        super(emitter, type, type.getName() + SUFFIX, "proxy");
        this.enableDefaultConstructor = true;
        this.enableSetters = true;
        this.setDeployPhaseOnly(true);
    }

    protected String getExtendsText() {
        String string = super.getExtendsText();
        string = string.equals("") ? " extends java.lang.Exception " : " " + string.trim() + SUFFIX + " ";
        return string;
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        super.writeFileBody(printWriter);
        this.writeConvertMethod(printWriter);
    }

    protected void writeConvertMethod(PrintWriter printWriter) throws IOException {
        printWriter.println("    public java.lang.Object convert() {");
        this.startTolerateCheckedException(printWriter, "     ");
        if (this.type.isAbstract()) {
            printWriter.println("      return null;");
            printWriter.println("    }");
            return;
        }
        String string = "      ";
        String string2 = "        ";
        printWriter.println(string + this.type.getName() + " _e;");
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.getTypesAndNames(this.type, vector, vector2, false, false, false);
        List list = (List)this.type.getDynamicVar("ExceptionInitStyles");
        if (list == null) {
            if (vector.size() == 0) {
                this.writeInitJAXRPC_NOARG(printWriter, this.type, vector, vector2, string);
            } else {
                this.writeInitJAXRPC_NORMAL(printWriter, this.type, vector, vector2, string);
            }
        } else if (list.contains("JAXRPC-NoArg")) {
            this.writeInitJAXRPC_NOARG(printWriter, this.type, vector, vector2, string);
        } else if (list.contains("JAXRPC-Normal")) {
            this.writeInitJAXRPC_NORMAL(printWriter, this.type, vector, vector2, string);
            boolean bl = list.contains("Non-JAXRPC-NoArg");
            boolean bl2 = list.contains("Non-JAXRPC-MessageArg");
            if (bl || bl2) {
                this.writeCheckInit(printWriter, this.type, vector, vector2, string);
                if (bl) {
                    this.writeInitNOARG(printWriter, this.type, vector, vector2, string2);
                } else {
                    this.writeInitMESSAGEARG(printWriter, this.type, vector, vector2, string2);
                }
                printWriter.println("      }");
            }
        } else if (list.contains("Non-JAXRPC-NoArg")) {
            this.writeInitNOARG(printWriter, this.type, vector, vector2, string);
        } else if (list.contains("Non-JAXRPC-MessageArg")) {
            this.writeInitMESSAGEARG(printWriter, this.type, vector, vector2, string);
        } else if (vector.size() == 0) {
            this.writeInitJAXRPC_NOARG(printWriter, this.type, vector, vector2, string);
        } else {
            this.writeInitJAXRPC_NORMAL(printWriter, this.type, vector, vector2, string);
        }
        printWriter.println(string + "return _e;");
        this.endTolerateCheckedException(printWriter, "     ");
        printWriter.println("    }");
    }

    protected void writeInitJAXRPC_NORMAL(PrintWriter printWriter, Type type, Vector vector, Vector vector2, String string) {
        printWriter.println(string + "_e = new " + type.getName() + "(");
        for (int i = 0; i < vector.size(); ++i) {
            ChildEntry childEntry = (ChildEntry)vector.elementAt(i);
            if (!JavaBeanFaultProxyWriter.isDataMember(childEntry)) {
                printWriter.print(string + "  " + JavaBeanFaultProxyWriter.getterMethodName(childEntry) + "()");
            } else {
                printWriter.print(string + "  " + childEntry.getName());
            }
            if (i + 1 >= vector.size()) continue;
            printWriter.println(",");
        }
        printWriter.println(");");
    }

    protected void writeInitJAXRPC_NOARG(PrintWriter printWriter, Type type, Vector vector, Vector vector2, String string) {
        printWriter.println(string + "_e = new " + type.getName() + "();");
    }

    protected void writeInitNOARG(PrintWriter printWriter, Type type, Vector vector, Vector vector2, String string) {
        printWriter.println(string + "_e = new " + type.getName() + "();");
        for (int i = 0; i < vector.size(); ++i) {
            ChildEntry childEntry = (ChildEntry)vector.elementAt(i);
            if (!JavaBeanFaultProxyWriter.isDataMember(childEntry)) {
                printWriter.println(string + "_e." + JavaBeanFaultProxyWriter.setterMethodName(childEntry) + "(" + JavaBeanFaultProxyWriter.getterMethodName(childEntry) + "());");
                continue;
            }
            printWriter.println(string + "_e." + childEntry.getName() + " = " + childEntry.getName() + ";");
        }
    }

    protected void writeInitMESSAGEARG(PrintWriter printWriter, Type type, Vector vector, Vector vector2, String string) {
        int n;
        ChildEntry childEntry = null;
        for (n = 0; n < vector2.size(); ++n) {
            if (!vector2.elementAt(n).equals("message")) continue;
            childEntry = (ChildEntry)vector.elementAt(n);
        }
        printWriter.println(string + "_e = new " + type.getName() + "(");
        if (!JavaBeanFaultProxyWriter.isDataMember(childEntry)) {
            printWriter.println(JavaBeanFaultProxyWriter.getterMethodName(childEntry) + "());");
        } else {
            printWriter.println(childEntry.getName() + ");");
        }
        for (n = 0; n < vector.size(); ++n) {
            ChildEntry childEntry2 = (ChildEntry)vector.elementAt(n);
            if (childEntry2 == childEntry) continue;
            if (!JavaBeanFaultProxyWriter.isDataMember(childEntry2)) {
                printWriter.println(string + "_e." + JavaBeanFaultProxyWriter.setterMethodName(childEntry2) + "(" + JavaBeanFaultProxyWriter.getterMethodName(childEntry2) + "());");
                continue;
            }
            printWriter.println(string + "_e." + childEntry2.getName() + " = " + childEntry2.getName() + ";");
        }
    }

    protected void writeCheckInit(PrintWriter printWriter, Type type, Vector vector, Vector vector2, String string) {
        printWriter.print(string + "if (");
        for (int i = 0; i < vector.size(); ++i) {
            ChildEntry childEntry = (ChildEntry)vector.elementAt(i);
            String string2 = !JavaBeanFaultProxyWriter.isDataMember(childEntry) ? JavaBeanFaultProxyWriter.getterMethodName(childEntry) + "()" : childEntry.getName();
            String string3 = (String)childEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
            if (Utils.isPrimitiveType(string3) || string3.endsWith("[]")) {
                printWriter.print("(" + string2 + "!= _e." + string2 + ")");
            } else {
                printWriter.print("!((" + string2 + "== null && " + string2 + "== _e." + string2 + ") || " + "(" + string2 + "!= null && " + string2 + ".equals(_e." + string2 + ")))");
            }
            if (i + 1 >= vector.size()) continue;
            printWriter.println(" || ");
        }
        printWriter.println(string + ") {");
    }
}

