/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanBaseWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanDeserializerWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanSerializerWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaWriter;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.namespace.QName;

public class JavaBeanHelperWriter
extends JavaBeanBaseWriter {
    protected JavaWriter serWriter = null;
    protected JavaWriter deserWriter = null;

    protected JavaBeanHelperWriter(Emitter emitter, Type type) {
        super(emitter, type, type.getName() + "_Helper", "helper");
        this.serWriter = new JavaBeanSerializerWriter(emitter, type);
        this.deserWriter = new JavaBeanDeserializerWriter(emitter, type);
        this.setDeployPhaseOnly(true);
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        this.writeMetaData(printWriter);
        this.writeSerializer(printWriter);
        this.writeDeserializer(printWriter);
    }

    protected void writeMetaData(PrintWriter printWriter) throws IOException {
        printWriter.println("    // " + Messages.getMessage("typeMeta"));
        printWriter.println("    private static final com.ibm.ws.webservices.engine.description.TypeDesc typeDesc =");
        printWriter.println("        new com.ibm.ws.webservices.engine.description.TypeDesc(" + Utils.getJavaLocalName(this.type.getName()) + ".class);");
        printWriter.println();
        printWriter.println("    static {");
        printWriter.println("        typeDesc.setOption(\"buildNum\",\"" + Version.getRawBuildNum() + "\");");
        if (this.attributes != null || this.elements != null) {
            QName qName;
            Object object;
            Object object2;
            ChildEntry childEntry;
            int n;
            boolean bl = false;
            if (this.attributes != null) {
                for (n = 0; n < this.attributes.size(); ++n) {
                    childEntry = (ChildAttribute)this.attributes.get(n);
                    object2 = childEntry.getType();
                    object = childEntry.getName();
                    qName = ((Entry)object2).getQName();
                    printWriter.print("        ");
                    if (!bl) {
                        printWriter.print("com.ibm.ws.webservices.engine.description.FieldDesc ");
                        bl = true;
                    }
                    printWriter.println("field = new com.ibm.ws.webservices.engine.description.AttributeDesc();");
                    printWriter.println("        field.setFieldName(\"" + (String)object + "\");");
                    printWriter.println("        field.setXmlName(" + Utils.getNewQName(childEntry.getQName()) + ");");
                    if (qName != null) {
                        printWriter.println("        field.setXmlType(" + Utils.getNewQName(qName) + ");");
                    }
                    printWriter.println("        typeDesc.addFieldDesc(field);");
                }
            }
            if (this.elements != null) {
                for (n = 0; n < this.elements.size(); ++n) {
                    childEntry = (ChildElement)this.elements.elementAt(n);
                    object2 = childEntry.getName();
                    object = childEntry.getQName();
                    qName = Utils.getXSIType(childEntry.getType());
                    if (qName != null && qName.getLocalPart().indexOf("[") > 0) {
                        qName = null;
                    }
                    printWriter.print("        ");
                    if (!bl) {
                        printWriter.print("com.ibm.ws.webservices.engine.description.FieldDesc ");
                        bl = true;
                    }
                    printWriter.println("field = new com.ibm.ws.webservices.engine.description.ElementDesc();");
                    printWriter.println("        field.setFieldName(\"" + (String)object2 + "\");");
                    printWriter.println("        field.setXmlName(" + Utils.getNewQName((QName)object) + ");");
                    if (qName != null) {
                        printWriter.println("        field.setXmlType(" + Utils.getNewQName(qName) + ");");
                    }
                    if (((ChildElement)childEntry).getMinOccursIs0()) {
                        printWriter.println("        field.setMinOccursIs0(true);");
                    }
                    if (((ChildElement)childEntry).getMaxOccurs()) {
                        printWriter.println("        field.setMaxOccurs(true);");
                    }
                    printWriter.println("        typeDesc.addFieldDesc(field);");
                }
            }
        }
        printWriter.println("    };");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * " + Messages.getMessage("returnTypeMeta"));
        printWriter.println("     */");
        printWriter.println("    public static com.ibm.ws.webservices.engine.description.TypeDesc getTypeDesc() {");
        printWriter.println("        return typeDesc;");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeSerializer(PrintWriter printWriter) throws IOException {
        String string = this.getClassName().substring(0, this.getClassName().lastIndexOf("_Helper")) + "_Ser";
        printWriter.println("    /**");
        printWriter.println("     * Get Custom Serializer");
        printWriter.println("     */");
        printWriter.println("    public static com.ibm.ws.webservices.engine.encoding.Serializer getSerializer(");
        printWriter.println("           java.lang.String mechType, ");
        printWriter.println("           java.lang.Class javaType,  ");
        printWriter.println("           javax.xml.namespace.QName xmlType) {");
        printWriter.println("        return ");
        printWriter.println("          new " + string + "(");
        printWriter.println("            javaType, xmlType, typeDesc);");
        printWriter.println("    };");
        printWriter.println();
        if (string != null) {
            this.serWriter.generate();
        }
    }

    protected void writeDeserializer(PrintWriter printWriter) throws IOException {
        String string = this.getClassName().substring(0, this.getClassName().lastIndexOf("_Helper")) + "_Deser";
        printWriter.println("    /**");
        printWriter.println("     * Get Custom Deserializer");
        printWriter.println("     */");
        printWriter.println("    public static com.ibm.ws.webservices.engine.encoding.Deserializer getDeserializer(");
        printWriter.println("           java.lang.String mechType, ");
        printWriter.println("           java.lang.Class javaType,  ");
        printWriter.println("           javax.xml.namespace.QName xmlType) {");
        printWriter.println("        return ");
        printWriter.println("          new " + string + "(");
        printWriter.println("            javaType, xmlType, typeDesc);");
        printWriter.println("    };");
        printWriter.println();
        if (string != null) {
            this.deserWriter.generate();
        }
    }
}

