/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.custom.CustomRegistry;
import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.GeneratorFactory;
import com.ibm.ws.webservices.wsdl.NoopGenerator;
import com.ibm.ws.webservices.wsdl.introspect.Introspector;
import com.ibm.ws.webservices.wsdl.symbolTable.BaseTypeMapping;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildFaultPartEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Element;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.GroupEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.GeneratorTable;
import com.ibm.ws.webservices.wsdl.toJava.JavaBindingWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaDefinitionWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaServiceWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaTypeWriter;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.toJava.XMLIBMWebServicesBndWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLIBMWebServicesClientBndWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLIBMWebServicesClientExtWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLIBMWebServicesExtWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLMappingWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLWebServicesClientWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLWebServicesWriter;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jem.java.JavaHelpers;

public class JavaGeneratorFactory
implements GeneratorFactory {
    private static boolean skipWCCMMappingPass = false;
    protected Emitter emitter;
    protected GeneratorTable genTable = new GeneratorTable();
    protected static NoopGenerator noGenerator = new NoopGenerator();
    public static final String OLD_NAME = "oldName";
    public static final String OLD_NAME2 = "oldName2";
    public static String INTERFACE_NAME = "interface name";
    public static String IMPL_NAME = "implName";
    public static String SIGNATURE = "signature";
    public static final String PARAM_SIG_TYPE = "parameterSignatureType";
    public static final String PARAM_TYPE = "parameterType";
    public static final String PARAM_WIRE_QNAME = "parameterWireQName";
    public static String COMPLEX_TYPE_FAULT = "ComplexTypeFault";
    public static String EXCEPTION_SYMTAB_ENTRY = "ExceptionSymTabEntry";
    public static String COMPLEX_TYPE_FAULT_COLLECTION = "ComplexTypeFaultList";
    public static final String CUSTOM_BINDER_NAME = "CustomBinderName";
    public static final String HOLDER_NAME = "HolderName";
    public static final String CONSTRUCTOR_ORDER = "constructorOrder";
    private static final String ANON_TYPE_PREPEND = "anonTypePrepend";
    public static final String DISABLE_HOLDER_GENERATION = "DisableHolderGeneration";
    public static final String DISABLE_GENERATION = "disable generation";
    public static final String OTHER_NAMES = "otherNames";
    private static final String RESOLVED_CHILDNAMES = "resolvedChildNames";
    public static final String THROWS_CHECKED_EXCEPTION = "throwsCheckedException";
    public static final String NOT_MAPPABLE = "notMappable";
    public static final String CUSTOM = "custom";
    public static final String EXCEPTION_INIT_STYLES = "ExceptionInitStyles";
    public static final String JAXRPC_NORMAL_INIT = "JAXRPC-Normal";
    public static final String JAXRPC_NOARG_INIT = "JAXRPC-NoArg";
    public static final String NOARG_INIT = "Non-JAXRPC-NoArg";
    public static final String MESSAGE_ARG_INIT = "Non-JAXRPC-MessageArg";
    public static String JAVA_TYPE = "javaType";
    public static String IS_DATA_MEMBER = "isDataMember";
    public static String SET_METHOD_NAME = "setMethodName";
    public static String GET_METHOD_NAME = "getMethodName";
    public static String MISSING_SETTER_NAME = "missingSetterName";
    public static String OUT_ORDERING_REQUIRED = "inoutOrderingReq";
    public static String IN_POSITION = "inputPosition";
    public static String OUT_POSITION = "outputPosition";
    public static String OLD_EXCEPTION_MAPPING = "Old exception mapping";
    int uniqueNum = 0;
    BaseTypeMapping btm = null;

    public JavaGeneratorFactory() {
        this.addGenerators();
    }

    public JavaGeneratorFactory(Emitter emitter) {
        this.setEmitter(emitter);
        this.addGenerators();
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public JavaGeneratorFactory(Emitter emitter, boolean bl) {
        this.setEmitter(emitter);
        skipWCCMMappingPass = bl;
        this.addGenerators();
    }

    public void addGenerator(Class clazz, Class clazz2) {
        this.genTable.addGenerator(clazz, clazz2);
    }

    public void removeGenerator(Class clazz, Class clazz2) {
        this.genTable.removeGenerator(clazz, clazz2);
    }

    public void removeAllGenerators() {
        this.genTable.clear();
    }

    public Iterator getGenerators(Class clazz) {
        return this.genTable.getGenerators(clazz);
    }

    private void addGenerators() {
        this.addMessageGenerators();
        this.addPortTypeGenerators();
        this.addBindingGenerators();
        this.addServiceGenerators();
        this.addTypeGenerators();
        this.addDefinitionGenerators();
    }

    private void addMessageGenerators() {
    }

    private void addPortTypeGenerators() {
    }

    private void addBindingGenerators() {
        this.genTable.addGenerator(Binding.class, JavaBindingWriter.class);
    }

    private void addServiceGenerators() {
        this.genTable.addGenerator(Service.class, JavaServiceWriter.class);
    }

    private void addTypeGenerators() {
        this.genTable.addGenerator(TypeEntry.class, JavaTypeWriter.class);
    }

    private void addDefinitionGenerators() {
        this.genTable.addGenerator(Definition.class, JavaDefinitionWriter.class);
        if (!skipWCCMMappingPass) {
            this.genTable.addGenerator(Definition.class, XMLWebServicesClientWriter.class);
            this.genTable.addGenerator(Definition.class, XMLIBMWebServicesClientBndWriter.class);
            this.genTable.addGenerator(Definition.class, XMLIBMWebServicesClientExtWriter.class);
            this.genTable.addGenerator(Definition.class, XMLWebServicesWriter.class);
            this.genTable.addGenerator(Definition.class, XMLIBMWebServicesBndWriter.class);
            this.genTable.addGenerator(Definition.class, XMLIBMWebServicesExtWriter.class);
            this.genTable.addGenerator(Definition.class, XMLMappingWriter.class);
        }
    }

    public final Generator getGenerator(Message message, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(Message.class, this.emitter, message, symbolTable);
    }

    public final Generator getGenerator(PortType portType, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(PortType.class, this.emitter, portType, symbolTable);
    }

    public final Generator getGenerator(Binding binding, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(Binding.class, this.emitter, binding, symbolTable);
    }

    public final Generator getGenerator(Service service, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(Service.class, this.emitter, service, symbolTable);
    }

    public final Generator getGenerator(TypeEntry typeEntry, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(TypeEntry.class, this.emitter, typeEntry, symbolTable);
    }

    public final Generator getGenerator(Definition definition, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(Definition.class, this.emitter, definition, symbolTable);
    }

    public void generatorPass(Definition definition, SymbolTable symbolTable) {
        this.setFaultContext(symbolTable);
        this.javifyNames(symbolTable);
        this.resolveNameClashes(symbolTable);
        if (this.emitter.inputMMD != null) {
            this.emitter.inputMMD.postSymbolTable(symbolTable);
        }
        this.customMappingSubstitution(symbolTable);
        if (this.emitter.isAllWanted()) {
            this.setAllReferencesToTrue(symbolTable);
        } else {
            this.ignoreNonSOAPBindings(symbolTable);
        }
        if (this.emitter.isIntrospect()) {
            Introspector introspector = new Introspector(this.emitter);
            introspector.run();
        }
        this.setChildJavaTypes(symbolTable);
        this.disableGeneration(symbolTable);
        this.constructSignatures(symbolTable);
        if (!skipWCCMMappingPass) {
            this.emitter.outputMMD.addPackageMappings(this.emitter.getNamespaces());
            this.emitter.outputMMD.fromSymbolTable(symbolTable);
        }
    }

    protected void javifyNames(SymbolTable symbolTable) {
        this.markAnonTypeClashes(symbolTable);
        HashMap hashMap = new HashMap();
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
                if (symTabEntry.getName() != null) continue;
                if (symTabEntry instanceof TypeEntry) {
                    this.javifyTypeEntry((TypeEntry)symTabEntry, hashMap, symbolTable);
                    continue;
                }
                if (symTabEntry instanceof MessageEntry) {
                    this.javifyMessageEntry((MessageEntry)symTabEntry);
                    continue;
                }
                if (symTabEntry instanceof ServiceEntry) {
                    this.javifyServiceEntry((ServiceEntry)symTabEntry);
                    continue;
                }
                if (symTabEntry instanceof BindingEntry) {
                    this.javifyBindingEntry((BindingEntry)symTabEntry);
                    continue;
                }
                if (symTabEntry instanceof GroupEntry) continue;
                symTabEntry.setName(this.createClassName(symTabEntry.getQName()));
            }
        }
    }

    protected void javifyTypeEntry(TypeEntry typeEntry, HashMap hashMap, SymbolTable symbolTable) {
        Object object;
        TypeEntry typeEntry2;
        if (typeEntry.getName() != null) {
            return;
        }
        if (typeEntry instanceof Type && this.emitter.jsr101v11) {
            this.javifyArrayPattern(typeEntry, hashMap, symbolTable);
            if (((Type)typeEntry).isSimpleType() && !((Type)typeEntry).isEnumeration() && !((Type)typeEntry).isList() && (typeEntry2 = ((Type)(object = (Type)typeEntry)).getRestrictionBase()) != null) {
                this.javifyTypeEntry(typeEntry2, hashMap, symbolTable);
                typeEntry.setName(typeEntry2.getName());
            }
            this.javifyChildNames(symbolTable, ((Type)typeEntry).getChildren());
        }
        if (typeEntry.getName() != null) {
            return;
        }
        object = typeEntry.getDimensions();
        typeEntry2 = typeEntry.getRefType();
        if (typeEntry2 != null) {
            this.javifyTypeEntry(typeEntry2, hashMap, symbolTable);
            typeEntry.setName(typeEntry2.getName() + (String)object);
            return;
        }
        if (typeEntry.getName() == null) {
            QName qName = typeEntry.getQName();
            if (!(typeEntry instanceof Type) || !((Type)typeEntry).isAnonType()) {
                typeEntry.setName(this.emitter.getJavaName(qName));
            } else {
                String string = qName.getLocalPart();
                string = string.substring(string.lastIndexOf(">") + 1);
                String string2 = (String)typeEntry.getDynamicVar(ANON_TYPE_PREPEND);
                if (string2 != null) {
                    string = string2 + string;
                }
                qName = QNameTable.createQName(qName.getNamespaceURI(), string);
                symbolTable.getType(qName);
                if (hashMap.get(qName) != null) {
                    string = string + "Type" + this.uniqueNum++;
                    qName = QNameTable.createQName(qName.getNamespaceURI(), string);
                }
                hashMap.put(qName, qName);
                typeEntry.setName(this.emitter.getJavaName(qName));
            }
        }
    }

    private void javifyArrayPattern(TypeEntry typeEntry, HashMap hashMap, SymbolTable symbolTable) {
        Type type = (Type)typeEntry.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN);
        if (type != null) {
            this.javifyTypeEntry(type, hashMap, symbolTable);
            String string = type.getName();
            Vector vector = ((Type)typeEntry).getChildren();
            if (vector != null && vector.get(0) instanceof ChildElement && ((ChildElement)vector.get(0)).isNillable()) {
                string = Utils.getWrapperType(string);
            }
            typeEntry.setName(string + "[]");
        }
    }

    private void javifyMessageEntry(MessageEntry messageEntry) {
        MessageEntry messageEntry2 = messageEntry;
        if (messageEntry2.isFault() && (messageEntry2.getDynamicVar(COMPLEX_TYPE_FAULT) == null || !((Boolean)messageEntry2.getDynamicVar(COMPLEX_TYPE_FAULT)).booleanValue())) {
            messageEntry.setName(this.createClassName(messageEntry.getQName()));
            Vector vector = messageEntry2.getFaultParts();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < vector.size(); ++i) {
                ChildFaultPartEntry childFaultPartEntry = (ChildFaultPartEntry)vector.elementAt(i);
                childFaultPartEntry.setName(JavaUtils.xmlNameToJava(childFaultPartEntry.getQName().getLocalPart()));
                arrayList.add(childFaultPartEntry.getQName().getLocalPart());
            }
            messageEntry2.setDynamicVar(CONSTRUCTOR_ORDER, arrayList);
        }
    }

    private void javifyServiceEntry(ServiceEntry serviceEntry) {
        serviceEntry.setName(this.createClassName(serviceEntry.getQName()));
        ServiceEntry serviceEntry2 = serviceEntry;
        for (int i = 0; i < serviceEntry2.numPorts(); ++i) {
            PortEntry portEntry = serviceEntry2.getPort(i);
            String string = portEntry.getPort().getName();
            if (!JavaUtils.isJavaId(string)) {
                string = JavaUtils.xmlNameToJavaClass(string);
            }
            portEntry.setName(string);
        }
    }

    protected void javifyChildNames(SymbolTable symbolTable, Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        if (!(vector.get(0) instanceof ChildEnumValueEntry)) {
            for (int i = 0; i < vector.size(); ++i) {
                ChildEntry childEntry = (ChildEntry)vector.get(i);
                String string = JavaUtils.xmlNameToJava(childEntry.getQName().getLocalPart());
                childEntry.setName(this.getAsBeanPropertyName(string));
                if (!(childEntry instanceof ChildElement) || !((ChildElement)childEntry).getAnyElement()) continue;
                childEntry.setName("_any");
            }
        } else {
            ChildEnumValueEntry childEnumValueEntry;
            int n;
            boolean bl = true;
            for (n = 0; n < vector.size() && bl; ++n) {
                childEnumValueEntry = (ChildEnumValueEntry)vector.get(n);
                bl = JavaUtils.isJavaId(childEnumValueEntry.getEnumValue());
            }
            for (n = 0; n < vector.size(); ++n) {
                childEnumValueEntry = (ChildEnumValueEntry)vector.get(n);
                if (bl) {
                    childEnumValueEntry.setName(childEnumValueEntry.getEnumValue());
                    continue;
                }
                childEnumValueEntry.setName("value" + (n + 1));
            }
        }
    }

    protected void javifyBindingEntry(BindingEntry bindingEntry) {
        bindingEntry.setName(this.createClassName(bindingEntry.getQName()));
        Iterator iterator = bindingEntry.getOperations();
        while (iterator.hasNext()) {
            BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator.next();
            bindingOperationEntry.setName(JavaUtils.xmlNameToJava(bindingOperationEntry.getQName().getLocalPart()));
            for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
                BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(i);
                bindingParamEntry.setName(JavaUtils.xmlNameToJava(bindingParamEntry.getQName().getLocalPart()));
            }
            Vector<String> vector = new Vector<String>(bindingOperationEntry.numParameters());
            for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
                BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(i);
                int n = 2;
                while (vector.contains(bindingParamEntry.getName())) {
                    bindingParamEntry.setName(bindingParamEntry.getName() + Integer.toString(n++));
                }
                vector.add(bindingParamEntry.getName());
            }
        }
    }

    private String createClassName(QName qName) {
        String string = this.emitter.getPackage(qName.getNamespaceURI());
        String string2 = JavaUtils.xmlNameToJavaClass(qName.getLocalPart());
        if (string != null && string != "") {
            string2 = string + "." + string2;
        }
        return string2;
    }

    private String getAsBeanPropertyName(String string) {
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1))) {
            return JavaUtils.capitalizeFirstChar(string);
        }
        return string;
    }

    private boolean messageEntryClassExists(MessageEntry messageEntry) {
        String string = this.emitter.getJavaName(messageEntry.getQName());
        Class clazz = null;
        try {
            if (string != null && this.emitter.getToolEnv().isJavaIntrospectionAllowed()) {
                clazz = ClassUtils.forName(string, false, this.emitter.getToolEnv().getClassLoader());
            }
        }
        catch (Exception exception) {
            return false;
        }
        return clazz != null;
    }

    protected void setFaultContext(SymbolTable symbolTable) {
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
                if (!(symTabEntry instanceof BindingEntry)) continue;
                BindingEntry bindingEntry = (BindingEntry)symTabEntry;
                Iterator iterator2 = bindingEntry.getOperations();
                while (iterator2.hasNext()) {
                    BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator2.next();
                    for (int j = 0; j < bindingOperationEntry.numFaults(); ++j) {
                        this.setFaultContext(bindingOperationEntry.getFault(j), symbolTable);
                    }
                }
            }
        }
    }

    private void setFaultContext(BindingFaultRefEntry bindingFaultRefEntry, SymbolTable symbolTable) {
        MessageEntry messageEntry = bindingFaultRefEntry.getMessageEntry();
        if (messageEntry.getFaultParts().size() == 0) {
            messageEntry.setDynamicVar(EXCEPTION_SYMTAB_ENTRY, messageEntry);
            messageEntry.setDynamicVar(CONSTRUCTOR_ORDER, new ArrayList());
            return;
        }
        ChildFaultPartEntry childFaultPartEntry = (ChildFaultPartEntry)messageEntry.getFaultParts().elementAt(0);
        TypeEntry typeEntry = childFaultPartEntry.getType();
        TypeEntry typeEntry2 = null;
        if (typeEntry instanceof Element) {
            typeEntry2 = typeEntry;
            typeEntry = typeEntry.getRefType();
        }
        Type type = (Type)typeEntry;
        boolean bl = false;
        if (type.isSimpleContent() && this.messageEntryClassExists(messageEntry)) {
            bl = true;
            messageEntry.setDynamicVar(OLD_EXCEPTION_MAPPING, messageEntry);
        }
        if (messageEntry.getFaultParts().size() > 1 || type.isSimpleType() || type.getDimensions().length() > 0 && ((Type)type.getRefType()).isSimpleType() || bl) {
            messageEntry.setDynamicVar(EXCEPTION_SYMTAB_ENTRY, messageEntry);
            ArrayList<String> arrayList = new ArrayList<String>();
            Vector vector = messageEntry.getFaultParts();
            for (int i = 0; i < vector.size(); ++i) {
                ChildFaultPartEntry childFaultPartEntry2 = (ChildFaultPartEntry)vector.elementAt(i);
                arrayList.add(childFaultPartEntry2.getQName().getLocalPart());
            }
            messageEntry.setDynamicVar(CONSTRUCTOR_ORDER, arrayList);
        } else {
            messageEntry.setDynamicVar(EXCEPTION_SYMTAB_ENTRY, type);
            messageEntry.setDynamicVar(COMPLEX_TYPE_FAULT, Boolean.TRUE);
            Set set = com.ibm.ws.webservices.wsdl.symbolTable.Utils.getDerivedTypes(type, symbolTable);
            set.add(type);
            Type type2 = type;
            while (type2.getExtensionBase() != null && !type2.getExtensionBase().isSimpleType()) {
                type2 = type2.getExtensionBase();
                set.add(type2);
            }
            messageEntry.setDynamicVar(COMPLEX_TYPE_FAULT_COLLECTION, set);
            Boolean bl2 = (Boolean)type.getDynamicVar(COMPLEX_TYPE_FAULT);
            if (bl2 == null || !bl2.booleanValue()) {
                Set set2 = com.ibm.ws.webservices.wsdl.symbolTable.Utils.getDerivedTypes(type2, symbolTable);
                set2.add(type2);
                set2.add(type);
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    TypeEntry typeEntry3 = (TypeEntry)iterator.next();
                    typeEntry3.setDynamicVar(COMPLEX_TYPE_FAULT, Boolean.TRUE);
                    typeEntry3.setDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN, null);
                    this.setConstructorOrder((Type)typeEntry3);
                }
            }
        }
    }

    private void setConstructorOrder(Type type) {
        Vector<Type> vector = new Vector<Type>();
        Type type2 = type;
        while (type2 != null) {
            vector.add(type2);
            if (type2.getExtensionBase() != null) {
                type2 = type2.getExtensionBase();
                continue;
            }
            type2 = type2.getRestrictionBase();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = vector.size() - 1; i >= 0; --i) {
            ChildEntry childEntry;
            int n;
            Type type3 = (Type)vector.elementAt(i);
            Vector vector2 = type3.getChildren();
            if (vector2 == null) continue;
            for (n = 0; n < vector2.size(); ++n) {
                if (!(vector2.get(n) instanceof ChildAttribute)) continue;
                childEntry = (ChildAttribute)vector2.get(n);
                arrayList.add(childEntry.getQName().getLocalPart());
            }
            for (n = 0; n < vector2.size(); ++n) {
                if (!(vector2.get(n) instanceof ChildElement)) continue;
                childEntry = (ChildElement)vector2.get(n);
                arrayList.add(childEntry.getQName().getLocalPart());
            }
        }
        type.setDynamicVar(CONSTRUCTOR_ORDER, arrayList);
    }

    protected void resolveNameClashes(SymbolTable symbolTable) {
        Object object;
        Object object2;
        AbstractCollection abstractCollection;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Iterator<Object> iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            abstractCollection = (Vector)iterator.next();
            for (int i = 0; i < ((Vector)abstractCollection).size(); ++i) {
                Boolean bl;
                Object object3;
                boolean bl2 = true;
                object2 = (SymTabEntry)((Vector)abstractCollection).elementAt(i);
                if (object2 instanceof MessageEntry) {
                    object3 = (MessageEntry)object2;
                    bl = (Boolean)((Entry)object3).getDynamicVar(COMPLEX_TYPE_FAULT);
                    if (!((MessageEntry)object3).isFault() || bl != null && bl.booleanValue()) {
                        bl2 = false;
                    }
                }
                if (object2 instanceof BindingEntry || object2 instanceof GroupEntry) {
                    bl2 = false;
                }
                if (object2 instanceof TypeEntry && ((TypeEntry)object2).isOnlyWrappedLiteralReferenced()) {
                    bl2 = false;
                }
                if ((object3 = ((Entry)object2).getName()) == null) {
                    bl2 = false;
                }
                if (object3 != null && ((String)object3).indexOf(91) >= 0) {
                    object3 = ((String)object3).substring(0, ((String)object3).indexOf(91));
                }
                if ("javax.xml.soap.SOAPElement".equals(object3)) {
                    bl2 = false;
                }
                if (!bl2) continue;
                bl = hashMap.get(object3);
                if (bl == null) {
                    hashMap.put(object3, object2);
                    continue;
                }
                if (bl instanceof List) {
                    ((List)((Object)bl)).add(object2);
                    continue;
                }
                object = new ArrayList();
                object.add(bl);
                object.add(object2);
                hashMap.put(object3, object);
            }
        }
        iterator = hashMap.keySet().iterator();
        abstractCollection = new LinkedHashSet();
        while (iterator.hasNext()) {
            SymTabEntry symTabEntry;
            int n;
            Object object4;
            Object object5;
            int n2;
            boolean bl;
            String string = (String)iterator.next();
            Object v = hashMap.get(string);
            if (!(v instanceof List) || !(bl = !this.sameTypeEntryClasses((List)(object2 = (List)v)))) continue;
            ((HashSet)abstractCollection).clear();
            for (n2 = 0; n2 < object2.size(); ++n2) {
                object = (SymTabEntry)object2.get(n2);
                if (!(object instanceof Type) || ((Entry)object).getQName().getLocalPart().startsWith(">") || ((Entry)object).getName().indexOf(91) >= 0) continue;
                object5 = "";
                object4 = (Boolean)((Entry)object).getDynamicVar(COMPLEX_TYPE_FAULT);
                object5 = object4 != null && ((Boolean)object4).booleanValue() ? "_Exception" : (((Type)object).isEnumeration() ? "_Enumeration" : "_Type");
                ((Entry)object).setName(this.mangleName(((Entry)object).getName(), (String)object5));
                ((HashSet)abstractCollection).add(object);
                for (n = 0; n < object2.size(); ++n) {
                    symTabEntry = (SymTabEntry)object2.get(n);
                    if (object == symTabEntry || !(symTabEntry instanceof TypeEntry)) continue;
                    TypeEntry typeEntry = Utils.getReferencedType((TypeEntry)symTabEntry);
                    while (typeEntry != null && typeEntry != object) {
                        typeEntry = Utils.getReferencedType(typeEntry);
                    }
                    if (typeEntry != object) continue;
                    symTabEntry.setName(this.mangleName(symTabEntry.getName(), (String)object5));
                    ((HashSet)abstractCollection).add(symTabEntry);
                }
            }
            for (n2 = 0; n2 < object2.size(); ++n2) {
                object = (SymTabEntry)object2.get(n2);
                if (!(object instanceof Element) || ((HashSet)abstractCollection).contains(object)) continue;
                ((Entry)object).setName(this.mangleName(((Entry)object).getName(), "_Element"));
                ((HashSet)abstractCollection).add(object);
                object5 = Utils.getReferencedType((TypeEntry)object);
                while (object5 != null) {
                    object4 = (Boolean)((Entry)object5).getDynamicVar(COMPLEX_TYPE_FAULT);
                    if (object4 == null || !((Boolean)object4).booleanValue()) {
                        ((Entry)object5).setName(this.mangleName(((Entry)object5).getName(), "_Element"));
                    }
                    ((HashSet)abstractCollection).add(object5);
                    object5 = Utils.getReferencedType((TypeEntry)object5);
                }
            }
            for (n2 = 0; n2 < object2.size(); ++n2) {
                object = (SymTabEntry)object2.get(n2);
                if (!(object instanceof Type) || ((HashSet)abstractCollection).contains(object)) continue;
                object5 = (Boolean)((Entry)object).getDynamicVar(COMPLEX_TYPE_FAULT);
                if (object5 != null && ((Boolean)object5).booleanValue()) {
                    ((Entry)object).setName(this.mangleName(((Entry)object).getName(), "_Exception"));
                } else if (((Type)object).isEnumeration()) {
                    ((Entry)object).setName(this.mangleName(((Entry)object).getName(), "_Enumeration"));
                } else {
                    ((Entry)object).setName(this.mangleName(((Entry)object).getName(), "_Type"));
                }
                ((HashSet)abstractCollection).add(object);
            }
            for (n2 = 0; n2 < object2.size(); ++n2) {
                object = (SymTabEntry)object2.get(n2);
                if (object instanceof Element || object instanceof Type) continue;
                if (object instanceof PortTypeEntry) {
                    ((Entry)object).setName(this.mangleName(((Entry)object).getName(), "_PortType"));
                    ((HashSet)abstractCollection).add(object);
                    continue;
                }
                if (object instanceof ServiceEntry) {
                    ((Entry)object).setName(this.mangleName(((Entry)object).getName(), "_Service"));
                    ((HashSet)abstractCollection).add(object);
                    continue;
                }
                if (object instanceof MessageEntry) {
                    object5 = this.mangleName(((Entry)object).getName(), "_Exception");
                    object4 = ((HashSet)abstractCollection).iterator();
                    n = 0;
                    while (object4.hasNext() && n == 0) {
                        symTabEntry = (SymTabEntry)object4.next();
                        n = symTabEntry.getName().equals(object5) ? 1 : 0;
                    }
                    if (n != 0) {
                        object5 = this.mangleName(((Entry)object).getName(), "_SimpleException");
                    }
                    ((Entry)object).setName((String)object5);
                    ((HashSet)abstractCollection).add(object);
                    continue;
                }
                if (!(object instanceof BindingEntry)) continue;
                ((Entry)object).setName(this.mangleName(((Entry)object).getName(), "_Binding"));
                ((HashSet)abstractCollection).add(object);
            }
        }
        this.resolveJavaNameClashes(symbolTable);
        this.resolveChildEntryNameClashes(symbolTable);
    }

    private boolean sameTypeEntryClasses(List list) {
        if (list.size() < 2) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof TypeEntry) continue;
            return false;
        }
        TypeEntry typeEntry = (TypeEntry)list.get(0);
        while (Utils.getReferencedType(typeEntry) != null) {
            typeEntry = Utils.getReferencedType(typeEntry);
        }
        for (int i = 1; i < list.size(); ++i) {
            TypeEntry typeEntry2 = (TypeEntry)list.get(i);
            while (Utils.getReferencedType(typeEntry2) != null) {
                typeEntry2 = Utils.getReferencedType(typeEntry2);
            }
            if (typeEntry2 == typeEntry || typeEntry2.isBaseType() || typeEntry.isBaseType()) continue;
            return false;
        }
        return true;
    }

    private String mangleName(String string, String string2) {
        int n = string.indexOf("[");
        if (n >= 0) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n);
            return string3 + string2 + string4;
        }
        return string + string2;
    }

    protected void resolveJavaNameClashes(SymbolTable symbolTable) {
        Object object;
        Object object2;
        HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>();
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            object2 = (Vector)iterator.next();
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                object = (SymTabEntry)((Vector)object2).elementAt(i);
                String string = ((Entry)object).getName();
                if (!(object instanceof BindingEntry)) continue;
                ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(object);
            }
        }
        object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            if (string == null || string.equals("") || ((ArrayList)(object = (ArrayList)hashMap.get(string))).size() <= 1) continue;
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                this.createNonJAXRPCName((SymTabEntry)((ArrayList)object).get(i));
            }
        }
    }

    private void createNonJAXRPCName(SymTabEntry symTabEntry) {
        String string = symTabEntry.getQName().getLocalPart();
        string = JavaUtils.createNonJAXRPCName(string);
        String string2 = symTabEntry.getName();
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            n = string2.length() - 1;
        }
        string2 = string2.substring(0, n + 1);
        symTabEntry.setName(string2 + string);
    }

    private void resolveChildEntryNameClashes(SymbolTable symbolTable) {
        Vector vector = symbolTable.getTypes();
        for (int i = 0; i < vector.size(); ++i) {
            TypeEntry typeEntry = (TypeEntry)vector.get(i);
            if (!(typeEntry instanceof Type) || ((Type)typeEntry).getChildren() == null || typeEntry.getDynamicVar(RESOLVED_CHILDNAMES) != null) continue;
            this.resolveChildEntryNameClashes((Type)typeEntry);
        }
    }

    private List resolveChildEntryNameClashes(Type type) {
        ArrayList arrayList = null;
        Type type2 = type.getExtensionBase();
        if (type2 == null) {
            type2 = type.getRestrictionBase();
        }
        arrayList = type2 != null ? this.resolveChildEntryNameClashes(type2) : new ArrayList();
        AbstractList abstractList = type.getChildren();
        if (abstractList == null) {
            abstractList = new ArrayList();
        }
        if (type.getDynamicVar(RESOLVED_CHILDNAMES) == null) {
            type.setDynamicVar(RESOLVED_CHILDNAMES, Boolean.TRUE);
            String string = type.getName();
            int n = string.lastIndexOf(".");
            string = n > 0 ? "_" + string.substring(n + 1) : "_" + string;
            this.resolveJavaNameClashes(arrayList, abstractList, string);
        } else {
            arrayList.addAll(abstractList);
        }
        return arrayList;
    }

    private void resolveJavaNameClashes(List arrayList, List list, String string) {
        if (list == null) {
            return;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<Entry>();
        }
        for (int i = 0; i < list.size(); ++i) {
            Entry entry = (Entry)list.get(i);
            boolean bl = false;
            int n = 1;
            while (!bl) {
                Entry entry2 = null;
                for (int j = 0; j < arrayList.size() && entry2 == null; ++j) {
                    Entry entry3 = (Entry)arrayList.get(j);
                    if (!entry3.getName().equals(entry.getName())) continue;
                    entry2 = entry3;
                }
                if (entry2 != null) {
                    switch (n) {
                        case 1: {
                            entry.setName(JavaUtils.createNonJAXRPCName(entry.getName()));
                            break;
                        }
                        case 2: {
                            entry.setName(entry.getName() + string);
                            break;
                        }
                        default: {
                            entry.setName("_" + entry.getName());
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
                ++n;
            }
            arrayList.add(entry);
        }
    }

    protected void setAllReferencesToTrue(SymbolTable symbolTable) {
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
                if (symTabEntry instanceof BindingEntry) {
                    int n = ((BindingEntry)symTabEntry).getBindingType();
                    if (n == 0 || n == 4) {
                        symTabEntry.setIsReferenced(true);
                        continue;
                    }
                    symTabEntry.setIsReferenced(false);
                    continue;
                }
                symTabEntry.setIsReferenced(true);
            }
        }
    }

    protected void ignoreNonSOAPBindings(SymbolTable symbolTable) {
        Vector<PortTypeEntry> vector = new Vector<PortTypeEntry>();
        Vector<PortTypeEntry> vector2 = new Vector<PortTypeEntry>();
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector3 = (Vector)iterator.next();
            for (int i = 0; i < vector3.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector3.elementAt(i);
                if (!(symTabEntry instanceof BindingEntry)) continue;
                BindingEntry bindingEntry = (BindingEntry)symTabEntry;
                Binding binding = bindingEntry.getBinding();
                PortType portType = binding.getPortType();
                PortTypeEntry portTypeEntry = symbolTable.getPortTypeEntry(portType.getQName());
                if (bindingEntry.getBindingType() == 0 || bindingEntry.getBindingType() == 4) {
                    vector2.add(portTypeEntry);
                    if (!vector.contains(portTypeEntry)) continue;
                    vector.remove(portTypeEntry);
                    continue;
                }
                bindingEntry.setIsReferenced(false);
                if (vector2.contains(portTypeEntry)) continue;
                vector.add(portTypeEntry);
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            PortTypeEntry portTypeEntry = (PortTypeEntry)vector.get(i);
            portTypeEntry.setIsReferenced(false);
        }
    }

    protected void setChildJavaTypes(SymbolTable symbolTable) {
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            block1: for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
                Vector vector2 = null;
                if (symTabEntry instanceof Type) {
                    vector2 = ((Type)symTabEntry).getChildren();
                } else if (symTabEntry instanceof MessageEntry) {
                    vector2 = ((MessageEntry)symTabEntry).getFaultParts();
                }
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    ChildEntry childEntry = (ChildEntry)vector2.get(j);
                    if (childEntry != null && childEntry.getType() != null && childEntry.getType().isOnlyWrappedLiteralReferenced()) {
                        symTabEntry.setDynamicVar(DISABLE_GENERATION, new Boolean(true));
                        continue block1;
                    }
                    JavaGeneratorFactory.defaultChildJavaType(childEntry);
                }
            }
        }
    }

    public static void defaultChildJavaType(ChildEntry childEntry) {
        if (childEntry != null && childEntry.getDynamicVar(JAVA_TYPE) == null) {
            TypeEntry typeEntry;
            for (typeEntry = childEntry.getType(); typeEntry != null && !(typeEntry instanceof Type) && !typeEntry.isCollectionTypeEntry(); typeEntry = typeEntry.getRefType()) {
            }
            String string = null;
            if (typeEntry != null) {
                string = typeEntry.getName();
            }
            if (childEntry instanceof ChildAttribute) {
                if (((ChildAttribute)childEntry).isOptional()) {
                    string = Utils.getWrapperType(string);
                }
            } else if (childEntry instanceof ChildElement) {
                ChildElement childElement = (ChildElement)childEntry;
                if (childElement.isNillable() && childElement.getMaxOccurs()) {
                    if (string.endsWith("[]")) {
                        String string2 = string.substring(0, string.length() - 2);
                        string2 = Utils.getWrapperType(string2);
                        string = string2 + "[]";
                    }
                } else if (childElement.isNillable() || childElement.getMinOccursIs0()) {
                    string = Utils.getWrapperType(string);
                }
            }
            childEntry.setDynamicVar(JAVA_TYPE, string);
        }
    }

    protected void constructSignatures(SymbolTable symbolTable) {
        SymTabEntry symTabEntry;
        int n;
        Vector vector;
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            vector = (Vector)iterator.next();
            for (n = 0; n < vector.size(); ++n) {
                symTabEntry = (SymTabEntry)vector.elementAt(n);
                if (!(symTabEntry instanceof BindingEntry) || !symTabEntry.isReferenced()) continue;
                BindingEntry bindingEntry = (BindingEntry)symTabEntry;
                Binding binding = bindingEntry.getBinding();
                PortTypeEntry portTypeEntry = symbolTable.getPortTypeEntry(binding.getPortType().getQName());
                PortType portType = portTypeEntry.getPortType();
                if (bindingEntry.getBindingType() != 0) {
                    this.emitter.setGenImplSer(true);
                }
                if (bindingEntry.getDynamicVar(INTERFACE_NAME) == null) {
                    bindingEntry.setDynamicVar(INTERFACE_NAME, portTypeEntry.getName());
                }
                if (portTypeEntry.getDynamicVar(IMPL_NAME) == null) {
                    portTypeEntry.setDynamicVar(IMPL_NAME, bindingEntry.getName() + "Impl");
                } else {
                    portTypeEntry.setDynamicVar(IMPL_NAME, (String)bindingEntry.getDynamicVar(INTERFACE_NAME) + "Impl");
                }
                boolean bl = false;
                Iterator iterator2 = portType.getOperations().iterator();
                while (iterator2.hasNext()) {
                    String string;
                    Operation operation = (Operation)iterator2.next();
                    OperationType operationType = operation.getStyle();
                    String string2 = operation.getName();
                    BindingOperationEntry bindingOperationEntry = bindingEntry.getOperation(operation);
                    if (bindingEntry.getBindingStyle() == Style.DOCUMENT && bindingEntry.getBindingType() == 0 && !bindingOperationEntry.isWrapped() && bindingOperationEntry.getInputBodyUse() == Use.LITERAL) {
                        bl = true;
                    }
                    if (operationType == OperationType.SOLICIT_RESPONSE) {
                        string = "    // " + Messages.getMessage("invalidSolResp00", string2);
                        bindingOperationEntry.setDynamicVar(SIGNATURE, string);
                        this.emitter.getToolEnv().reporterr(Messages.getMessage("invalidSolResp00", string2));
                        continue;
                    }
                    if (operationType == OperationType.NOTIFICATION) {
                        string = "    // " + Messages.getMessage("invalidNotif00", string2);
                        bindingOperationEntry.setDynamicVar(SIGNATURE, string);
                        this.emitter.getToolEnv().reporterr(Messages.getMessage("invalidNotif00", string2));
                        continue;
                    }
                    bindingOperationEntry.setDynamicVar(SIGNATURE, this.constructSignature(symbolTable, bindingOperationEntry));
                }
                if (!bl) continue;
                this.checkDocLitOperations(bindingEntry);
            }
        }
        iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            vector = (Vector)iterator.next();
            for (n = 0; n < vector.size(); ++n) {
                symTabEntry = (SymTabEntry)vector.elementAt(n);
                if (!(symTabEntry instanceof PortTypeEntry)) continue;
                symTabEntry.setName("");
            }
        }
    }

    private void checkDocLitOperations(BindingEntry bindingEntry) {
        String string;
        BindingOperationEntry bindingOperationEntry;
        Iterator iterator = bindingEntry.getOperations();
        HashMap<String, BindingOperationEntry> hashMap = new HashMap<String, BindingOperationEntry>();
        while (iterator.hasNext()) {
            bindingOperationEntry = (BindingOperationEntry)iterator.next();
            if (!bindingOperationEntry.isWrapped()) continue;
            string = bindingOperationEntry.getQName().toString();
            hashMap.put(string, bindingOperationEntry);
        }
        iterator = bindingEntry.getOperations();
        while (iterator.hasNext()) {
            bindingOperationEntry = (BindingOperationEntry)iterator.next();
            if (bindingOperationEntry.isWrapped() || bindingOperationEntry.getInputBodyUse() != Use.LITERAL) continue;
            string = "";
            for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
                BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(i);
                if (bindingParamEntry.getMode() == 2 || bindingParamEntry.isInHeader()) continue;
                string = string + bindingParamEntry.getDynamicVar(PARAM_WIRE_QNAME);
            }
            BindingOperationEntry bindingOperationEntry2 = (BindingOperationEntry)hashMap.get(string);
            if (bindingOperationEntry2 != null) {
                this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("matchingDocLitParams00", bindingOperationEntry2.getQName().toString(), bindingOperationEntry.getQName().toString()));
            }
            hashMap.put(string, bindingOperationEntry);
        }
    }

    private String constructSignature(SymbolTable symbolTable, BindingOperationEntry bindingOperationEntry) {
        Object object;
        Entry entry;
        int n;
        String string = bindingOperationEntry.getName();
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        LinkedHashSet<Object> linkedHashSet2 = new LinkedHashSet<Object>();
        String string2 = "void";
        if (bindingOperationEntry.getReturn() != null) {
            string2 = this.constructParamSigType(bindingOperationEntry.getReturn(), true, symbolTable);
            linkedHashSet2.add(bindingOperationEntry.getReturn().getDynamicVar(PARAM_WIRE_QNAME));
        }
        String string3 = "    public " + string2 + " " + string + "(";
        boolean bl = false;
        for (n = 0; n < bindingOperationEntry.numParameters(); ++n) {
            entry = bindingOperationEntry.getParameter(n);
            if (bl) {
                string3 = string3 + ", ";
            } else {
                bl = true;
            }
            string3 = string3 + this.constructParamSigType((BindingParamEntry)entry, false, symbolTable) + " " + entry.getName();
            object = (QName)entry.getDynamicVar(PARAM_WIRE_QNAME);
            if (((BindingParamEntry)entry).getMode() != 2) {
                if (linkedHashSet.contains(object)) {
                    this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("paramsNotUnique00", ((QName)object).toString(), "input", bindingOperationEntry.getQName().toString()));
                }
                linkedHashSet.add(object);
            }
            if (((BindingParamEntry)entry).getMode() == 1) continue;
            if (linkedHashSet2.contains(object)) {
                this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("paramsNotUnique00", ((QName)object).toString(), "output", bindingOperationEntry.getQName().toString()));
            }
            linkedHashSet2.add(object);
        }
        string3 = string3 + ") throws java.rmi.RemoteException";
        if (bindingOperationEntry.numFaults() > 0) {
            for (n = 0; n < bindingOperationEntry.numFaults(); ++n) {
                entry = bindingOperationEntry.getFault(n).getMessageEntry();
                object = (SymTabEntry)entry.getDynamicVar(EXCEPTION_SYMTAB_ENTRY);
                String string4 = ((Entry)object).getName();
                if ("javax.xml.soap.SOAPElement".equals(string4)) continue;
                string3 = string3 + ", " + string4;
            }
        }
        return string3;
    }

    protected String constructHolderName(BindingParamEntry bindingParamEntry, SymbolTable symbolTable) {
        String string = null;
        if (bindingParamEntry.getMode() != 1) {
            boolean bl;
            String string2 = bindingParamEntry.getMIMEType();
            if (string2 != null) {
                if (string2.equals("image/gif") || string2.equals("image/jpeg")) {
                    return "com.ibm.ws.webservices.engine.types.holders.ImageHolder";
                }
                if (string2.equals("text/plain")) {
                    return "javax.xml.rpc.holders.StringHolder";
                }
                if (string2.startsWith("multipart/")) {
                    return "com.ibm.ws.webservices.engine.types.holders.MimeMultipartHolder";
                }
                if (string2.equals("text/xml") || string2.equals("application/xml")) {
                    return "com.ibm.ws.webservices.engine.types.holders.SourceHolder";
                }
                return "com.ibm.ws.webservices.engine.types.holders.DataHandlerHolder";
            }
            TypeEntry typeEntry = bindingParamEntry.getType();
            string = (String)typeEntry.getDynamicVar(HOLDER_NAME);
            if (string == null && (string = (String)typeEntry.getDynamicVar(PARAM_SIG_TYPE)) == null) {
                string = this.defaultHolderName(bindingParamEntry, symbolTable);
            }
            typeEntry.setDynamicVar(HOLDER_NAME, string);
            boolean bl2 = bl = string.startsWith("javax.xml.rpc.holders") || string.startsWith("com.ibm.ws.webservices.engine.types.holders");
            if (bl) {
                typeEntry.setDynamicVar(DISABLE_HOLDER_GENERATION, Boolean.TRUE);
            }
            if (typeEntry instanceof Element && !typeEntry.isCollectionTypeEntry() && typeEntry.getRefType() != null) {
                typeEntry.getRefType().setDynamicVar(HOLDER_NAME, string);
                if (bl) {
                    typeEntry.getRefType().setDynamicVar(DISABLE_HOLDER_GENERATION, Boolean.TRUE);
                }
            }
        }
        return string;
    }

    protected String constructParamSigType(BindingParamEntry bindingParamEntry, boolean bl, SymbolTable symbolTable) {
        Object object;
        QName qName = bindingParamEntry.getQName();
        if (bindingParamEntry.getType() instanceof Element) {
            object = bindingParamEntry.getType();
            qName = ((Entry)object).getQName();
            while (object instanceof Element && ((TypeEntry)object).isCollectionTypeEntry()) {
                object = ((TypeEntry)object).getRefType();
            }
            if (object instanceof Element) {
                qName = ((Entry)object).getQName();
            }
        }
        bindingParamEntry.setDynamicVar(PARAM_WIRE_QNAME, qName);
        object = (String)bindingParamEntry.getDynamicVar(PARAM_TYPE);
        if (object == null) {
            object = JavaGeneratorFactory.defaultParamType(bindingParamEntry);
        }
        bindingParamEntry.setDynamicVar(PARAM_TYPE, object);
        Object object2 = object;
        if (bindingParamEntry.getMode() != 1 && !bl) {
            object2 = this.constructHolderName(bindingParamEntry, symbolTable);
        }
        bindingParamEntry.setDynamicVar(PARAM_SIG_TYPE, object2);
        return object2;
    }

    public static String defaultParamType(BindingParamEntry bindingParamEntry) {
        Object object;
        String string = null;
        String string2 = bindingParamEntry.getMIMEType();
        if (string2 != null) {
            string = JavaUtils.mimeToJava(string2);
        }
        if (string == null) {
            object = bindingParamEntry.getType();
            while (object instanceof Element && !((TypeEntry)object).isCollectionTypeEntry()) {
                object = ((TypeEntry)object).getRefType();
            }
            string = ((Entry)object).getName();
        }
        if (bindingParamEntry.isNillable() && !bindingParamEntry.isMaxOccursIs1()) {
            if (string.endsWith("[]")) {
                object = string.substring(0, string.length() - 2);
                object = Utils.getWrapperType((String)object);
                string = (String)object + "[]";
            }
        } else if (bindingParamEntry.isNillable() || bindingParamEntry.isMinOccursIs0()) {
            string = Utils.getWrapperType(string);
        }
        return string;
    }

    private String defaultHolderName(BindingParamEntry bindingParamEntry, SymbolTable symbolTable) {
        boolean bl;
        String string = bindingParamEntry.getMIMEType();
        if (string != null) {
            if (string.equals("image/gif") || string.equals("image/jpeg")) {
                return "com.ibm.ws.webservices.engine.types.holders.ImageHolder";
            }
            if (string.equals("text/plain")) {
                return "javax.xml.rpc.holders.StringHolder";
            }
            if (string.startsWith("multipart/")) {
                return "com.ibm.ws.webservices.engine.types.holders.MimeMultipartHolder";
            }
            if (string.equals("text/xml") || string.equals("application/xml")) {
                return "com.ibm.ws.webservices.engine.types.holders.SourceHolder";
            }
        }
        String string2 = (String)bindingParamEntry.getDynamicVar(PARAM_TYPE);
        QName qName = Utils.getXSIType(bindingParamEntry);
        Type type = symbolTable.getType(qName);
        while (type.isSimpleType() && type.getRestrictionBase() != null && type.getName().equals(type.getRestrictionBase().getName())) {
            type = type.getRestrictionBase();
            qName = type.getQName();
        }
        boolean bl2 = bl = Constants.isSchemaXSD(qName.getNamespaceURI()) || Constants.isSOAP_ENC(qName.getNamespaceURI());
        if (string2.endsWith("[]")) {
            if (string2.equals("byte[]") && bl) {
                return "javax.xml.rpc.holders.ByteArrayHolder";
            }
            if (!bindingParamEntry.getType().isCollectionTypeEntry()) {
                String string3 = this.emitter.getPackage(qName.getNamespaceURI()) + ".holders.";
                String string4 = JavaUtils.xmlNameToJavaClass(qName.getLocalPart()) + "Holder";
                return string3 + string4;
            }
            String string5 = JavaUtils.xmlNameToJavaClass(qName.getLocalPart()) + "ArrayHolder";
            String string6 = qName.getNamespaceURI();
            String string7 = this.emitter.getPackage(string6) + ".holders.";
            if (string7.startsWith("java") || Constants.isSchemaXSD(string6) || Constants.isSOAP_ENC(string6) || qName.getNamespaceURI().length() == 0) {
                string6 = bindingParamEntry.getParentNamespace();
                string7 = this.emitter.getPackage(string6) + ".holders.";
            }
            return string7 + string5;
        }
        if (bl) {
            if (string2.equals("String")) {
                return "javax.xml.rpc.holders.StringHolder";
            }
            if (string2.equals("java.lang.String")) {
                return "javax.xml.rpc.holders.StringHolder";
            }
            if (string2.equals("Object")) {
                return "javax.xml.rpc.holders.ObjectHolder";
            }
            if (string2.equals("java.lang.Object")) {
                return "javax.xml.rpc.holders.ObjectHolder";
            }
            if (string2.equals("int") || string2.equals("long") || string2.equals("short") || string2.equals("float") || string2.equals("double") || string2.equals("boolean") || string2.equals("byte")) {
                return "javax.xml.rpc.holders." + JavaUtils.capitalizeFirstChar(string2) + "Holder";
            }
            if (string2.startsWith("java.lang.")) {
                return "javax.xml.rpc.holders" + string2.substring(string2.lastIndexOf(".")) + "WrapperHolder";
            }
            if (string2.indexOf(".") < 0) {
                return "javax.xml.rpc.holders" + string2 + "WrapperHolder";
            }
            if (string2.equals("java.math.BigDecimal")) {
                return "javax.xml.rpc.holders.BigDecimalHolder";
            }
            if (string2.equals("java.math.BigInteger")) {
                return "javax.xml.rpc.holders.BigIntegerHolder";
            }
            if (string2.equals("java.util.Calendar")) {
                return "javax.xml.rpc.holders.CalendarHolder";
            }
            if (string2.equals("javax.xml.namespace.QName")) {
                return "javax.xml.rpc.holders.QNameHolder";
            }
        }
        if (string2.equals("javax.xml.soap.SOAPElement") || string2.equals("com.ibm.ws.webservices.engine.xmlsoap.SOAPElement")) {
            return "com.ibm.ws.webservices.engine.types.holders.SOAPElementHolder";
        }
        if (string2.equals("java.util.Date")) {
            return "com.ibm.ws.webservices.engine.types.holders.DateHolder";
        }
        if (string2.equals("java.net.URI")) {
            return "com.ibm.ws.webservices.engine.types.holders.URIHolder";
        }
        if (string2.equals("org.w3c.dom.Element")) {
            return "com.ibm.ws.webservices.engine.types.holders.ElementHolder";
        }
        if (string2.equals("javax.activation.DataHandler")) {
            return "com.ibm.ws.webservices.engine.types.holders.DataHandlerHolder";
        }
        if (string2.equals("java.awt.Image")) {
            return "com.ibm.ws.webservices.engine.types.holders.ImageHolder";
        }
        if (string2.equals("javax.mail.internet.MimeMultipart")) {
            return "com.ibm.ws.webservices.engine.types.holders.MimeMultipartHolder";
        }
        if (string2.equals("javax.xml.transform.Source")) {
            return "com.ibm.ws.webservices.engine.types.holders.SourceHolder";
        }
        if (string2.equals("java.lang.String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (string2.equals("char")) {
            return "com.ibm.ws.webservices.engine.types.holders.CharHolder";
        }
        if (string2.equals("Character")) {
            return "com.ibm.ws.webservices.engine.types.holders.CharacterWrapperHolder";
        }
        if (string2.equals("java.lang.Character")) {
            return "com.ibm.ws.webservices.engine.types.holders.CharacterWrapperHolder";
        }
        if (string2.equals("java.util.Vector")) {
            return "com.ibm.ws.webservices.engine.types.holders.VectorHolder";
        }
        if (string2.equals("java.util.Map")) {
            return "com.ibm.ws.webservices.engine.types.holders.MapHolder";
        }
        if (string2.equals("java.util.HashMap")) {
            return "com.ibm.ws.webservices.engine.types.holders.MapHolder";
        }
        if (string2.startsWith("com.ibm.ws.webservices.engine.types.")) {
            int n = string2.lastIndexOf(46);
            String string8 = string2.substring(n + 1);
            return "com.ibm.ws.webservices.engine.types.holders." + string8 + "Holder";
        }
        String string9 = JavaUtils.xmlNameToJavaClass(qName.getLocalPart()) + "Holder";
        String string10 = this.emitter.getPackage(qName.getNamespaceURI()) + ".holders.";
        return string10 + string9;
    }

    public void setBaseTypeMapping(BaseTypeMapping baseTypeMapping) {
        this.btm = baseTypeMapping;
    }

    public BaseTypeMapping getBaseTypeMapping() {
        if (this.btm == null) {
            this.btm = new BaseTypeMapping(){
                TypeMapping defaultTM = DefaultTypeMappingImpl.getSingleton();

                public String getBaseName(QName qName) {
                    QName qName2 = QNameTable.createQName(qName.getNamespaceURI(), qName.getLocalPart());
                    Class clazz = this.defaultTM.getClassForQName(qName2);
                    if (clazz == null) {
                        return null;
                    }
                    return JavaUtils.getTextClassName(clazz.getName());
                }

                public TypeMapping getTypeMapping() {
                    return this.defaultTM;
                }
            };
        }
        return this.btm;
    }

    private void markAnonTypeClashes(SymbolTable symbolTable) {
        Serializable serializable;
        int n;
        Serializable serializable2;
        Serializable serializable3;
        HashMap<Serializable, Serializable> hashMap = new HashMap<Serializable, Serializable>();
        Vector vector = symbolTable.getTypes();
        for (int i = 0; i < vector.size(); ++i) {
            serializable3 = (TypeEntry)vector.elementAt(i);
            serializable2 = ((Entry)((Object)serializable3)).getQName();
            String string = ((QName)serializable2).getLocalPart();
            n = (string = string.substring(string.lastIndexOf(">") + 1)).indexOf(93);
            if (n > 0) {
                string = string.substring(0, n);
            }
            string = JavaUtils.xmlNameToJavaClass(string);
            serializable = (Vector)hashMap.get(serializable2 = QNameTable.createQName(((QName)serializable2).getNamespaceURI(), string));
            if (serializable == null) {
                serializable = new Vector();
                hashMap.put(serializable2, serializable);
            }
            ((Vector)serializable).add(serializable3);
        }
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            String string;
            serializable3 = (Vector)iterator.next();
            serializable2 = new Vector();
            boolean bl = false;
            for (n = 0; n < ((Vector)serializable3).size() && !bl; ++n) {
                serializable = (TypeEntry)((Vector)serializable3).elementAt(n);
                string = "";
                n2 = ((Entry)((Object)serializable)).getQName().getLocalPart().lastIndexOf(">");
                if (n2 > 0) {
                    string = ((Entry)((Object)serializable)).getQName().getLocalPart().substring(0, n2);
                }
                if (!((Vector)serializable2).contains(string)) {
                    ((Vector)serializable2).add(string);
                }
                bl = ((Vector)serializable2).size() > 1;
            }
            if (!bl) continue;
            for (n = 0; n < ((Vector)serializable3).size(); ++n) {
                serializable = (TypeEntry)((Vector)serializable3).elementAt(n);
                string = "";
                n2 = ((Entry)((Object)serializable)).getQName().getLocalPart().lastIndexOf(">");
                if (n2 > 0) {
                    string = ((Entry)((Object)serializable)).getQName().getLocalPart().substring(0, n2);
                }
                if (string.length() <= 0) continue;
                string = JavaUtils.replace(string, ">", "_");
                string = this.reduceAnonTypePrependValue(string);
                string = string + '_';
                ((Entry)((Object)serializable)).setDynamicVar(ANON_TYPE_PREPEND, string);
            }
        }
    }

    private String reduceAnonTypePrependValue(String string) {
        int n = 80;
        if (string.length() <= n) {
            return string;
        }
        int n2 = string.hashCode();
        String string2 = string.substring(0, 20) + '_' + String.valueOf(n2);
        return string2;
    }

    private void disableGeneration(SymbolTable symbolTable) {
        Vector vector = symbolTable.getTypes();
        for (int i = 0; i < vector.size(); ++i) {
            Type type;
            Type type2;
            TypeEntry typeEntry = (TypeEntry)vector.get(i);
            if (this.disableGeneration(typeEntry)) {
                typeEntry.setDynamicVar(DISABLE_GENERATION, new Boolean(true));
            }
            if (!(typeEntry instanceof Type) || !((Type)typeEntry).isEnumeration() || !(type2 = (type = (Type)typeEntry).getRestrictionBase()).getName().equals(type.getName())) continue;
            type.setEnumeration(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disableGeneration(TypeEntry typeEntry) {
        Object object;
        if (typeEntry.isBaseType()) {
            return true;
        }
        if (!typeEntry.isReferenced() || typeEntry.isOnlyWrappedLiteralReferenced()) {
            return true;
        }
        if (typeEntry.getName().indexOf("javax.xml.soap.SOAPElement") == 0 || typeEntry.getName().indexOf("com.ibm.ws.webservices.engine.xmlsoap.SOAPElement") == 0 || typeEntry.getName().indexOf("org.w3c.dom.Element") == 0) {
            return true;
        }
        if (typeEntry instanceof Element && !typeEntry.isCollectionTypeEntry()) {
            return true;
        }
        if (typeEntry instanceof Type && ((Type)(object = (Type)typeEntry)).isSimpleType() && ((Type)object).getRestrictionBase() != null && ((Type)object).getRestrictionBase().getName().equals(((Entry)object).getName())) {
            return true;
        }
        if (!skipWCCMMappingPass && typeEntry instanceof Type && typeEntry.getName() != null) {
            if (this.emitter.getToolEnv().getJavaContext() == null) {
                System.err.println("Warning from JavaGeneratorFactory: getJavaContext() returns null");
            }
            try {
                object = this.emitter.getToolEnv().getClassFactory();
                JavaHelpers javaHelpers = ((ClassFactory)object).forName("java.util.Collection");
                JavaHelpers javaHelpers2 = ((ClassFactory)object).forName(typeEntry.getName());
                JavaHelpers javaHelpers3 = javaHelpers;
                synchronized (javaHelpers3) {
                    if (javaHelpers.isAssignableFrom((EClassifier)javaHelpers2)) {
                        this.emitter.getToolEnv().reportWarning(Messages.getMessage("typeNotSupported00", typeEntry.getName()));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void customMappingSubstitution(SymbolTable symbolTable) {
        CustomRegistry customRegistry = this.emitter.getCustomRegistry();
        if (customRegistry != null) {
            QName[] qNameArray = customRegistry.getQNames();
            for (int i = 0; i < qNameArray.length; ++i) {
                boolean bl;
                QName qName = qNameArray[i];
                String string = customRegistry.getJavaName(qName);
                Type type = symbolTable.getType(qName);
                boolean bl2 = bl = type != null && type.getDynamicVar(OLD_NAME) != null && !string.equals(type.getName());
                if (type == null || bl) continue;
                String string2 = customRegistry.getBinderName(qName, string);
                com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, type, string, string2, false);
                type.setDynamicVar(DISABLE_GENERATION, Boolean.TRUE);
            }
        }
    }
}

