/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.providers.soap;

import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.client.Call;
import com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerSerializerFactory;
import com.ibm.ws.webservices.wsif.providers.soap.WSIFSOAPUtils;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.swing.ImageIcon;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.attachments.WSIFAttachmentPart;
import org.apache.wsif.logging.Trc;

public class MIMEHelper {
    public static void registerAttachmentType(Call call, QName type) {
        call.registerTypeMapping(DataHandler.class, type, JAFDataHandlerSerializerFactory.class, JAFDataHandlerDeserializerFactory.class);
    }

    public static boolean addAttachementIfMIMEPart(Call call, Object o) {
        boolean ok;
        Trc.entry(null, call, o);
        if (o instanceof DataHandler) {
            call.addAttachmentPart(new AttachmentPart((DataHandler)o));
            ok = true;
        } else {
            ok = false;
        }
        Trc.exit(new Boolean(ok));
        return ok;
    }

    public static AttachmentPart getAttachementPart(Object o) throws WSIFException {
        Trc.entry(null, o);
        AttachmentPart ap = null;
        if (o instanceof WSIFAttachmentPart) {
            ap = WSIFSOAPUtils.wsifToSoapAttachmentPart((WSIFAttachmentPart)o);
        } else if (o instanceof DataHandler) {
            ap = new AttachmentPart((DataHandler)o);
        } else {
            throw new WSIFException("Object is not a DataHandler: " + o);
        }
        Trc.exit(ap);
        return ap;
    }

    public static void setMIMEMessagePart(WSIFMessage msg, String name2, Object value2, Class type) throws WSIFException {
        Trc.entry(null, msg, name2, value2, type);
        Class<?> valueType = value2 == null ? null : value2.getClass();
        try {
            if (valueType != null && DataHandler.class.equals(type) && AttachmentPart.class.isAssignableFrom(valueType)) {
                AttachmentPart ap = (AttachmentPart)value2;
                DataHandler dh = ap.getDataHandler();
                msg.setObjectPart(name2, dh);
            } else if (valueType != null && (String.class.equals(type) || Image.class.equals(type) || StreamSource.class.equals(type) || DOMSource.class.equals(type) || SAXSource.class.equals(type) || MimeMultipart.class.equals(type)) && AttachmentPart.class.isAssignableFrom(valueType)) {
                AttachmentPart ap = (AttachmentPart)value2;
                InputStream is = ap.getDataHandler().getInputStream();
                if (String.class.equals(type)) {
                    byte[] bBuff = new byte[is.available()];
                    is.read(bBuff);
                    msg.setObjectPart(name2, new String(bBuff));
                } else if (Image.class.equals(type)) {
                    byte[] bBuff = new byte[is.available()];
                    is.read(bBuff);
                    msg.setObjectPart(name2, new ImageIcon(bBuff).getImage());
                } else if (StreamSource.class.equals(type)) {
                    msg.setObjectPart(name2, new StreamSource(is));
                } else {
                    if (DOMSource.class.equals(type)) {
                        throw new WSIFException("DOMSource is not supported");
                    }
                    if (SAXSource.class.equals(type)) {
                        throw new WSIFException("SAXSource is not supported");
                    }
                    if (MimeMultipart.class.equals(type)) {
                        msg.setObjectPart(name2, new MimeMultipart(ap.getDataHandler().getDataSource()));
                    }
                }
            } else {
                if (valueType != null && type != null && !type.isPrimitive() && !type.isAssignableFrom(valueType)) {
                    throw new WSIFException("return value " + value2 + " has unexpected type " + valueType + " instead of " + type);
                }
                msg.setObjectPart(name2, value2);
            }
        }
        catch (SOAPException se) {
            Trc.exception(se);
            throw new WSIFException("WSIFOperation_SOAP.setMessagePart messageName=" + (msg.getName() == null ? "null" : msg.getName()) + " partName=" + name2 + "  caught " + (Object)((Object)se));
        }
        catch (IOException ioe) {
            Trc.exception(ioe);
            throw new WSIFException("WSIFOperation_SOAP.setMessagePart messageName=" + (msg.getName() == null ? "null" : msg.getName()) + " partName=" + name2 + "  caught " + ioe);
        }
        catch (MessagingException me) {
            Trc.exception(me);
            throw new WSIFException("WSIFOperation_SOAP.setMessagePart messageName=" + (msg.getName() == null ? "null" : msg.getName()) + " partName=" + name2 + "  caught " + (Object)((Object)me));
        }
        Trc.exit();
    }
}

