/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.providers.soap;

import com.ibm.ws.webservices.wsif.providers.soap.WSIFPort_SOAP;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPBinding;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.base.WSIFServiceImpl;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.spi.WSIFProvider;
import org.apache.wsif.wsdl.extensions.jms.JMSExtensionRegistry;

public class WSIFDynamicProvider_SOAP
implements WSIFProvider {
    private static final boolean maelstromAvailable = WSIFDynamicProvider_SOAP.isWebServicesAvailable();
    private static final boolean jmsAvailable = WSIFDynamicProvider_SOAP.isJMSAvailable();
    private static final String[] bindings = WSIFDynamicProvider_SOAP.setUpBindingNamespaceURIs();
    private static final String[] addresses = WSIFDynamicProvider_SOAP.setUpAddressNamespaceURIs();

    public WSIFDynamicProvider_SOAP() {
        Trc.entry(this);
        if (maelstromAvailable && jmsAvailable) {
            WSIFServiceImpl.addExtensionRegistry(new JMSExtensionRegistry());
        }
        Trc.exit();
    }

    public WSIFPort createDynamicWSIFPort(Definition definition, Service service, Port port2, WSIFDynamicTypeMap wsifdynamictypemap) throws WSIFException {
        Trc.entry(this, definition, service, port2, wsifdynamictypemap);
        Binding binding = port2.getBinding();
        List list = binding.getExtensibilityElements();
        WSIFPort_SOAP wp = null;
        Iterator i = list.iterator();
        while (i.hasNext() && wp == null) {
            Object o = i.next();
            if (!(o instanceof SOAPBinding)) continue;
            wp = new WSIFPort_SOAP(definition, port2, (SOAPBinding)o, wsifdynamictypemap);
        }
        Trc.exit(wp);
        return wp;
    }

    public String[] getBindingNamespaceURIs() {
        Trc.entry(this);
        Trc.exit(bindings);
        return bindings;
    }

    public String[] getAddressNamespaceURIs() {
        Trc.entry(this);
        Trc.exit(addresses);
        return addresses;
    }

    private static String[] setUpBindingNamespaceURIs() {
        String[] bindings = maelstromAvailable ? new String[]{"http://schemas.xmlsoap.org/wsdl/soap/"} : new String[]{};
        Trc.event("available binding namespace URIs: ", bindings);
        return bindings;
    }

    private static String[] setUpAddressNamespaceURIs() {
        ArrayList<String> l = new ArrayList<String>();
        if (WSIFDynamicProvider_SOAP.isWebServicesAvailable()) {
            l.add("http://schemas.xmlsoap.org/wsdl/soap/");
        }
        if (jmsAvailable) {
            l.add("http://schemas.xmlsoap.org/wsdl/jms/");
        }
        String[] addresses = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            addresses[i] = (String)l.get(i);
        }
        Trc.event("available address namespace URIs: ", addresses);
        return addresses;
    }

    private static boolean isWebServicesAvailable() {
        return WSIFDynamicProvider_SOAP.isClassAvailable("com.ibm.ws.webservices.engine.Constants");
    }

    private static boolean isJMSAvailable() {
        return WSIFDynamicProvider_SOAP.isClassAvailable("javax.jms.Queue");
    }

    private static boolean isClassAvailable(final String className) {
        Class c = (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                }
                catch (Throwable ignored) {
                    Trc.ignoredException(ignored);
                    return null;
                }
            }
        });
        return c != null;
    }
}

