/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.providers.soap;

import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.wsif.providers.soap.WSIFOperation_SOAP;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.soap.SOAPException;
import org.apache.wsif.WSIFCorrelationService;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFTransactionControl;
import org.apache.wsif.util.WSIFCorrelationServiceLocator;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.jms.WSIFJMSCorrelationId;
import org.apache.wsif.util.jms.WSIFJMSDestination;

public class WSIFJmsSender
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private static final long SYNC_TIMEOUT = WSIFProperties.getSyncTimeout();
    private static final long ASYNC_TIMEOUT = WSIFProperties.getAsyncTimeout();
    private static final String DUMMY_RESPONSE = "<?xml version='1.0' encoding='UTF-8'?>\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\">\n<SOAP-ENV:Body>\n<ns1:addEntryResponse xmlns:ns1=\"http://wsifservice.addressbook/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n</ns1:addEntryResponse>\n\n</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>";

    public void invoke(MessageContext messageContext) throws WebServicesFault {
        this._invoke(messageContext);
    }

    /*
     * Loose catch block
     */
    public void _invoke(MessageContext messageContext) throws WebServicesFault {
        block17: {
            boolean txnSuspended;
            WSIFTransactionControl transControl;
            block16: {
                Trc.entry((Object)this, messageContext);
                String resp = (String)messageContext.getProperty("response");
                if (resp != null) {
                    Trc.event(this, "found response in MessageContext");
                    Message responseMessage = new Message(resp);
                    messageContext.setResponseMessage(responseMessage);
                    Trc.exit();
                    return;
                }
                transControl = null;
                txnSuspended = false;
                transControl = this.getTransControl();
                boolean asyncMode = messageContext.isPropertyTrue("asyncOperation");
                WSIFJMSDestination dest = (WSIFJMSDestination)messageContext.getProperty("destination");
                Long transportSyncTimeoutValue = (Long)messageContext.getProperty("syncTimeout");
                long syncTimeout = transportSyncTimeoutValue == null ? SYNC_TIMEOUT : transportSyncTimeoutValue;
                Message message = messageContext.getRequestMessage();
                SOAPConstants sc = messageContext.getSOAPConstants();
                String ct = message.getContentType(sc);
                dest.setProperty("WSIFContentType", ct);
                dest.setProperty("contentType", ct);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                message.writeTo(baos);
                String contents = baos.toString();
                if (asyncMode) {
                    this.performAsyncSend(messageContext, dest, contents);
                    break block16;
                }
                boolean oneWay = dest.isOneWay();
                if (!oneWay && transControl != null) {
                    transControl.suspend();
                    txnSuspended = true;
                }
                String id = dest.send(contents, null);
                if (!oneWay) {
                    if (txnSuspended) {
                        transControl.resume();
                        txnSuspended = false;
                    }
                    String response = dest.receiveString(id, syncTimeout);
                    ct = (String)dest.getProperty("contentType");
                    if (ct == null) {
                        ct = (String)dest.getProperty("WSIFContentType");
                    }
                    String cl = (String)dest.getProperty("WSIFContentLocation");
                    Message responseMessage = ct != null || cl != null ? new Message(new ByteArrayInputStream(response.getBytes()), ct, cl) : new Message(response);
                    messageContext.setResponseMessage(responseMessage);
                    break block16;
                }
                Message responseMessage = new Message(DUMMY_RESPONSE);
                messageContext.setResponseMessage(responseMessage);
            }
            Object var21_23 = null;
            try {
                if (txnSuspended) {
                    transControl.resume();
                }
                break block17;
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
            break block17;
            {
                catch (IOException ioe) {
                    Trc.exception(ioe);
                    throw new WebServicesFault(ioe.toString());
                }
                catch (SOAPException se) {
                    Trc.exception(se);
                    throw new WebServicesFault(se.toString());
                }
            }
            catch (Throwable throwable) {
                Object var21_24 = null;
                try {
                    if (txnSuspended) {
                        transControl.resume();
                    }
                }
                catch (WSIFException ex) {
                    Trc.ignoredException(ex);
                }
                throw throwable;
            }
        }
        Trc.exit();
    }

    private WSIFTransactionControl getTransControl() {
        String tName;
        Trc.entry(this);
        final String name2 = tName = WSIFProperties.getProperty("wsif.transactioncontrol.impl");
        WSIFTransactionControl transControl = null;
        if (name2 != null) {
            Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return Class.forName(name2, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (Throwable ignored) {
                        Trc.ignoredException(ignored);
                        return null;
                    }
                }
            });
            if (clazz != null) {
                try {
                    transControl = (WSIFTransactionControl)clazz.newInstance();
                }
                catch (Exception ignored) {
                    Trc.ignoredException(ignored);
                    transControl = null;
                }
            } else {
                transControl = null;
            }
        }
        Trc.exit(transControl);
        return transControl;
    }

    public void undo(MessageContext messageContext) {
        Trc.entry((Object)this, messageContext);
        Trc.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAsyncSend(MessageContext messageContext, WSIFJMSDestination dest, String data) throws WSIFException {
        String msgID;
        WSIFOperation_SOAP wsifOp = (WSIFOperation_SOAP)messageContext.getProperty("wsifOperation");
        if (wsifOp.getResponseHandler() == null) {
            msgID = dest.send(data);
            WSIFJMSCorrelationId cid = new WSIFJMSCorrelationId(msgID);
        } else {
            WSIFCorrelationService correlator;
            Long transportAsyncTimeoutValue = (Long)messageContext.getProperty("asyncTimeout");
            long asyncTimeout = transportAsyncTimeoutValue == null ? ASYNC_TIMEOUT : transportAsyncTimeoutValue;
            WSIFCorrelationService wSIFCorrelationService = correlator = WSIFCorrelationServiceLocator.getCorrelationService();
            synchronized (wSIFCorrelationService) {
                msgID = dest.send(data);
                WSIFJMSCorrelationId cid = new WSIFJMSCorrelationId(msgID);
                if (correlator != null) {
                    correlator.put(cid, wsifOp, asyncTimeout);
                }
            }
        }
        wsifOp.setAsyncRequestID(new WSIFJMSCorrelationId(msgID));
        Message responseMessage = new Message(DUMMY_RESPONSE);
        messageContext.setResponseMessage(responseMessage);
    }
}

