/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.providers.soap;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.client.Call;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.client.Transport;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.ArraySerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializerFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.wsif.configuration.WSIFClientConfig;
import com.ibm.ws.webservices.wsif.providers.soap.MIMEHelper;
import com.ibm.ws.webservices.wsif.providers.soap.SOAPConstants;
import com.ibm.ws.webservices.wsif.providers.soap.WSIFJmsAsyncRespTransport;
import com.ibm.ws.webservices.wsif.providers.soap.WSIFJmsTransport;
import com.ibm.ws.webservices.wsif.providers.soap.WSIFPort_SOAP;
import com.ibm.ws.webservices.wsif.providers.soap.jrom.JROMUtils;
import com.ibm.ws.webservices.wsif.providers.soap.ser.BeanDescLite;
import com.ibm.ws.webservices.wsif.providers.soap.ser.BeanDescLiteSupplier;
import com.ibm.ws.webservices.wsif.providers.soap.ser.BeanDeserializerFactory;
import com.ibm.ws.webservices.wsif.providers.soap.ser.BeanSerializerFactory;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.jms.TextMessage;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMimeXml;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.wsif.WSIFCorrelationId;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFResponseHandler;
import org.apache.wsif.attachments.WSIFAttachmentPart;
import org.apache.wsif.base.WSIFDefaultOperation;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.ProviderUtils;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.WSIFDynamicTypeMapping;
import org.apache.wsif.util.TypeSerializerInfo;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.util.jms.WSIFJMSDestination;
import org.apache.wsif.wsdl.extensions.jms.JMSProperty;
import org.apache.wsif.wsdl.extensions.jms.JMSPropertyValue;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSIFOperation_SOAP
extends WSIFDefaultOperation {
    private static final long serialVersionUID = 2L;
    protected transient WSIFPort_SOAP wsifPort;
    protected transient Operation portTypeOperation;
    protected transient BindingOperation bindingOperation;
    protected transient SOAPOperation soapOperation;
    protected transient List inputSOAPParts;
    protected transient List inputUnwrappedSOAPParts;
    protected transient List inputMIMEParts;
    protected transient Part inputSOAPHeader;
    protected transient Part inputSOAPHeaderFault;
    protected List outputSOAPParts;
    protected List outputUnwrappedSOAPParts;
    protected List outputMIMEParts;
    protected Part outputSOAPHeader;
    protected Part outputSOAPHeaderFault;
    protected transient String inputEncodingStyle;
    protected transient String inputNamespace;
    protected transient String soapActionURI;
    protected transient String inputUse;
    protected transient HashMap responseMessageParameters;
    protected transient boolean asyncOperation;
    protected transient WSIFCorrelationId asyncRequestID;
    protected transient boolean oneWayOperation;
    protected WSIFResponseHandler responseHandler;
    protected String outputEncodingStyle;
    protected WSIFDynamicTypeMap typeMap;
    protected String operationStyle;
    protected List faultsList = null;
    protected boolean usingJROM;
    static /* synthetic */ Class class$javax$wsdl$extensions$soap$SOAPFault;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$encoding$SimpleType;

    public WSIFOperation_SOAP(WSIFPort_SOAP wsifPort, Operation portTypeOperation, WSIFDynamicTypeMap typeMap) throws WSIFException {
        Trc.entry(this, wsifPort, portTypeOperation, typeMap);
        this.wsifPort = wsifPort;
        this.portTypeOperation = portTypeOperation;
        this.typeMap = typeMap;
        this.bindingOperation = this.getBindingOperation(portTypeOperation);
        this.inputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        this.outputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    protected WSIFOperation_SOAP copy() throws WSIFException {
        Trc.entry(this);
        WSIFOperation_SOAP op = new WSIFOperation_SOAP(this.wsifPort, this.portTypeOperation, this.typeMap);
        op.inputSOAPParts = this.inputSOAPParts;
        op.inputUnwrappedSOAPParts = this.inputUnwrappedSOAPParts;
        op.inputMIMEParts = this.inputMIMEParts;
        op.inputSOAPHeader = this.inputSOAPHeader;
        op.inputSOAPHeaderFault = this.inputSOAPHeaderFault;
        op.outputSOAPParts = this.outputSOAPParts;
        op.outputUnwrappedSOAPParts = this.outputUnwrappedSOAPParts;
        op.outputMIMEParts = this.outputMIMEParts;
        op.outputSOAPHeader = this.outputSOAPHeader;
        op.outputSOAPHeaderFault = this.outputSOAPHeaderFault;
        op.faultsList = this.faultsList;
        op.soapOperation = this.soapOperation;
        op.setSoapActionURI(this.getSoapActionURI());
        op.setInputNamespace(this.getInputNamespace());
        op.setInputUse(this.getInputUse());
        op.setInputEncodingStyle(this.getInputEncodingStyle());
        op.setOutputEncodingStyle(this.getOutputEncodingStyle());
        op.setAsyncOperation(this.isAsyncOperation());
        op.setOneWayOperation(this.isOneWayOperation());
        op.setResponseHandler(this.getResponseHandler());
        op.setInputJmsProperties(this.getInputJmsProperties());
        op.setOutputJmsProperties(this.getOutputJmsProperties());
        op.setInputJmsPropertyValues(this.getInputJmsPropertyValues());
        op.setOperationStyle(this.getOperationStyle());
        if (Trc.ON) {
            Trc.exit(op.deep());
        }
        return op;
    }

    private void parseSoapOperation() throws WSIFException {
        this.soapOperation = this.wsifPort.getSOAPOperation(this.bindingOperation);
        this.soapActionURI = this.soapOperation.getSoapActionURI();
        this.operationStyle = this.soapOperation.getStyle();
        if (this.operationStyle == null || this.operationStyle.length() < 1) {
            this.operationStyle = this.wsifPort.getBindingStyle();
        } else if (!SOAPConstants.VALID_STYLES.contains(this.operationStyle)) {
            throw new WSIFException("unsupported style " + this.operationStyle + " for operation " + this.portTypeOperation.getName());
        }
        if (this.operationStyle == null || this.operationStyle.length() < 1) {
            this.operationStyle = "document";
        }
    }

    private void parseBindingInput() throws WSIFException {
        List inJmsPropVals;
        MIMEMimeXml inMimeMimeXml;
        List inExtElems;
        BindingInput bindinginput = this.bindingOperation.getBindingInput();
        SOAPBody inSoapBody = (SOAPBody)this.wsifPort.getExtElem(bindinginput, SOAPBody.class, inExtElems = bindinginput.getExtensibilityElements());
        if (inSoapBody != null) {
            this.inputSOAPParts = this.parseSoapBody(inSoapBody, true);
        }
        MIMEMultipartRelated inMimeMultipart = (MIMEMultipartRelated)this.wsifPort.getExtElem(bindinginput, MIMEMultipartRelated.class, inExtElems);
        if (inSoapBody != null && inMimeMultipart != null) {
            throw new WSIFException("In a binding operation that contains a mime:multipartRelated, a soap:body was found that was not in a mime:part. OperationName=" + this.getName());
        }
        if (inSoapBody == null && inMimeMultipart == null) {
            throw new WSIFException("binding operation input must contain either a soap:body or a mime:multipartRelated element. OperationName=" + this.getName());
        }
        if (inMimeMultipart != null) {
            this.parseMimeMultipart(inMimeMultipart, true);
        }
        if ((inMimeMimeXml = (MIMEMimeXml)this.wsifPort.getExtElem(bindinginput, MIMEMimeXml.class, inExtElems)) != null) {
            throw new WSIFException("WSIF does not support mime:mimeXml. Operation=" + this.getName());
        }
        this.parseSOAPHeaderElement(bindinginput);
        List inJmsProps = this.wsifPort.getExtElems(bindinginput, JMSProperty.class, bindinginput.getExtensibilityElements());
        if (inJmsProps != null && inJmsProps.size() > 0) {
            if (this.wsifPort.isTransportJMS()) {
                this.setInputJmsProperties(inJmsProps);
            } else {
                throw new WSIFException("jms:property found in non-jms binding");
            }
        }
        if ((inJmsPropVals = this.wsifPort.getExtElems(bindinginput, JMSPropertyValue.class, bindinginput.getExtensibilityElements())) != null && inJmsPropVals.size() > 0) {
            if (this.wsifPort.isTransportJMS()) {
                this.addInputJmsPropertyValues(inJmsPropVals);
            } else {
                throw new WSIFException("jms:propertyValue found in non-jms binding");
            }
        }
    }

    private void parseBindingOutput() throws WSIFException {
        BindingOutput bindingoutput = this.bindingOperation.getBindingOutput();
        if (bindingoutput != null) {
            MIMEMimeXml outMimeMimeXml;
            List outExtElems;
            SOAPBody outSoapBody = (SOAPBody)this.wsifPort.getExtElem(bindingoutput, SOAPBody.class, outExtElems = bindingoutput.getExtensibilityElements());
            if (outSoapBody != null) {
                this.outputSOAPParts = this.parseSoapBody(outSoapBody, false);
            }
            MIMEMultipartRelated outMimeMultipart = (MIMEMultipartRelated)this.wsifPort.getExtElem(bindingoutput, MIMEMultipartRelated.class, outExtElems);
            if (outSoapBody != null && outMimeMultipart != null) {
                throw new WSIFException("In a binding operation that contains a mime:multipartRelated, a soap:body was found that was not in a mime:part. OperationName=" + this.getName());
            }
            if (outSoapBody == null && outMimeMultipart == null) {
                throw new WSIFException("binding operation output must contain either a soap:body or a mime:multipartRelated element. OperationName=" + this.getName());
            }
            if (outMimeMultipart != null) {
                this.parseMimeMultipart(outMimeMultipart, false);
            }
            if ((outMimeMimeXml = (MIMEMimeXml)this.wsifPort.getExtElem(bindingoutput, MIMEMimeXml.class, outExtElems)) != null) {
                throw new WSIFException("WSIF does not support mime:mimeXml. Operation=" + this.getName());
            }
            this.parseSOAPHeaderElement(bindingoutput);
            Iterator iterator1 = this.bindingOperation.getBindingFaults().values().iterator();
            while (iterator1.hasNext()) {
                BindingFault bindingfault = (BindingFault)iterator1.next();
                SOAPFault soapfault = (SOAPFault)this.wsifPort.getExtElem(bindingfault, class$javax$wsdl$extensions$soap$SOAPFault == null ? WSIFOperation_SOAP.class$("javax.wsdl.extensions.soap.SOAPFault") : class$javax$wsdl$extensions$soap$SOAPFault, bindingfault.getExtensibilityElements());
            }
            List outJmsProps = this.wsifPort.getExtElems(bindingoutput, JMSProperty.class, outExtElems);
            if (outJmsProps != null && outJmsProps.size() > 0) {
                if (this.wsifPort.isTransportJMS()) {
                    this.setOutputJmsProperties(outJmsProps);
                } else {
                    throw new WSIFException("jms:properties found in non-jms binding");
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseSOAPHeaderElement(Object element) throws WSIFException {
        void var2_2;
        List extensabilityElements;
        if (element instanceof BindingInput) {
            extensabilityElements = ((BindingInput)element).getExtensibilityElements();
        } else if (element instanceof BindingOutput) {
            extensabilityElements = ((BindingOutput)element).getExtensibilityElements();
        } else {
            throw new WSIFException("internal error, unexpected object: " + element);
        }
        Part soapHeaderPart = null;
        Part soapHeaderFaultPart = null;
        List soapHeaderList = this.wsifPort.getExtElems(element, javax.wsdl.extensions.soap.SOAPHeader.class, (List)var2_2);
        javax.wsdl.extensions.soap.SOAPHeader soapHeader = null;
        if (soapHeaderList != null) {
            soapHeader = (javax.wsdl.extensions.soap.SOAPHeader)soapHeaderList.get(0);
        }
        if (soapHeader != null) {
            QName messageName = soapHeader.getMessage();
            if (messageName == null) {
                throw new WSIFException("no message attribute on soap:header: " + soapHeader);
            }
            String messagePart = soapHeader.getPart();
            if (messagePart == null) {
                throw new WSIFException("no part attribute on soap:header: " + soapHeader);
            }
            soapHeaderPart = this.getPart(messageName, messagePart);
            if (soapHeaderPart == null) {
                throw new WSIFException("non existent part specified on soap:header: " + soapHeader);
            }
            SOAPHeaderFault soapHeaderFault = (SOAPHeaderFault)this.wsifPort.getExtElem(soapHeader, SOAPHeaderFault.class, (List)var2_2);
            if (soapHeaderFault != null) {
                messageName = soapHeader.getMessage();
                if (messageName == null) {
                    throw new WSIFException("no message attribute on soap:header: " + soapHeader);
                }
                messagePart = soapHeader.getPart();
                if (messagePart == null) {
                    throw new WSIFException("no part attribute on soap:header: " + soapHeader);
                }
                soapHeaderFaultPart = this.getPart(messageName, messagePart);
                if (soapHeaderFaultPart == null) {
                    throw new WSIFException("non existent part specified on soap:header: " + soapHeader);
                }
            }
        }
        if (element instanceof BindingInput) {
            this.inputSOAPHeader = soapHeaderPart;
            this.inputSOAPHeaderFault = soapHeaderFaultPart;
        } else {
            this.outputSOAPHeader = soapHeaderPart;
            this.outputSOAPHeaderFault = soapHeaderFaultPart;
        }
    }

    private List parseSoapBody(SOAPBody soapbody, boolean isInput) throws WSIFException {
        List l;
        String use;
        String ns;
        Trc.entry(this, soapbody, new Boolean(isInput));
        if (isInput && (ns = soapbody.getNamespaceURI()) != null) {
            this.setInputNamespace(soapbody.getNamespaceURI());
        }
        if (!SOAPConstants.VALID_USES.contains(use = soapbody.getUse())) {
            throw new WSIFException("unsupported use " + use + " in " + this.soapOperation);
        }
        if (isInput) {
            this.setInputUse(use);
        }
        if (isInput && (l = soapbody.getEncodingStyles()) != null && l.size() > 0) {
            this.setInputEncodingStyle((String)l.get(0));
        }
        javax.wsdl.Message m = null;
        if (isInput) {
            Input in = this.portTypeOperation.getInput();
            if (in != null) {
                m = in.getMessage();
            }
        } else {
            Output out = this.portTypeOperation.getOutput();
            if (out != null) {
                m = out.getMessage();
            }
        }
        ArrayList al = this.getParts(m, soapbody.getParts());
        Trc.exit(al);
        return al;
    }

    private ArrayList getParts(javax.wsdl.Message m, List partNames) throws WSIFException {
        ArrayList<Part> al = new ArrayList<Part>();
        List parts = null;
        if (m != null) {
            parts = m.getOrderedParts(null);
        }
        if ((parts == null || parts.size() < 1) && partNames != null && partNames.size() > 0) {
            throw new WSIFException("part '" + partNames.get(0) + "' not defined in message " + m);
        }
        if (partNames == null) {
            if (parts != null) {
                al.addAll(parts);
            }
        } else {
            Iterator i = partNames.iterator();
            while (i.hasNext()) {
                String partName = (String)i.next();
                Part p = m.getPart(partName);
                if (p == null) {
                    throw new WSIFException("Part '" + partName + "' in soap:body parts not in message " + m);
                }
                if (al.contains(p)) continue;
                al.add(p);
            }
        }
        return al;
    }

    private void parseMimeMultipart(MIMEMultipartRelated mimeMultipart, boolean isInput) throws WSIFException {
        Trc.entry((Object)this, mimeMultipart);
        ArrayList<String> mimePartNames = new ArrayList<String>();
        SOAPBody soapBody = null;
        Operation op = this.bindingOperation.getOperation();
        Map inMessageParts = op.getInput().getMessage().getParts();
        Map outMessageParts = op.getOutput() == null ? new HashMap() : op.getOutput().getMessage().getParts();
        List mimeParts = mimeMultipart.getMIMEParts();
        Iterator mimePartIt = mimeParts.iterator();
        while (mimePartIt.hasNext()) {
            Object nextMimePart = mimePartIt.next();
            if (!(nextMimePart instanceof MIMEPart)) continue;
            MIMEPart mimePart = (MIMEPart)nextMimePart;
            if (!"http://schemas.xmlsoap.org/wsdl/mime/".equals(mimePart.getElementType().getNamespaceURI())) {
                throw new WSIFException("A MIME part in binding operation " + this.bindingOperation.getName() + " did not have the correct namespace URI of " + "http://schemas.xmlsoap.org/wsdl/mime/" + ".");
            }
            boolean containsSoapBody = false;
            boolean containsMimeContent = false;
            List mimePartChildren = mimePart.getExtensibilityElements();
            Iterator mimePartChildrenIt = mimePartChildren.iterator();
            while (mimePartChildrenIt.hasNext()) {
                Object nextChild = mimePartChildrenIt.next();
                if (nextChild instanceof MIMEContent) {
                    MIMEContent mimeContent = (MIMEContent)nextChild;
                    if (!"http://schemas.xmlsoap.org/wsdl/mime/".equals(mimePart.getElementType().getNamespaceURI())) {
                        throw new WSIFException("A MIME part in binding operation " + this.bindingOperation.getName() + " did not have the correct namespace URI of " + "http://schemas.xmlsoap.org/wsdl/mime/" + ".");
                    }
                    containsMimeContent = true;
                    if (containsSoapBody) {
                        throw new WSIFException("A mime:part that contains a mime:content also contains a soap:body. Operation=" + this.getName());
                    }
                    String partName = mimeContent.getPart();
                    if (partName == null || partName.length() == 0) {
                        throw new WSIFException("No part name for a mime:content. Operation=" + this.getName());
                    }
                    mimePartNames.add(partName);
                    continue;
                }
                if (nextChild instanceof SOAPBody) {
                    if (soapBody != null) {
                        throw new WSIFException("Multiple soap:body tags found in a mime:multipartRelated. Operation=" + this.getName());
                    }
                    soapBody = (SOAPBody)nextChild;
                    containsSoapBody = true;
                    if (!containsMimeContent) continue;
                    throw new WSIFException("A mime:part that contains a mime:content also contains a soap:body. Operation=" + this.getName());
                }
                if (nextChild instanceof MIMEMultipartRelated) {
                    throw new WSIFException("WSIF does not support nesting mime:multipartRelated inside a mime:part. Operation=" + this.getName());
                }
                if (!(nextChild instanceof MIMEMimeXml)) continue;
                throw new WSIFException("WSIF does not support mime:mimeXml. Operation=" + this.getName());
            }
        }
        ArrayList mimePartList = new ArrayList();
        if (mimePartNames != null && !mimePartNames.isEmpty()) {
            javax.wsdl.Message m = null;
            if (isInput) {
                Input in = this.portTypeOperation.getInput();
                if (in != null) {
                    m = in.getMessage();
                }
            } else {
                Output out = this.portTypeOperation.getOutput();
                if (out != null) {
                    m = out.getMessage();
                }
            }
            mimePartList = this.getParts(m, mimePartNames);
        }
        Map messageParts = null;
        messageParts = isInput ? inMessageParts : outMessageParts;
        List soapParts = null;
        if (soapBody != null) {
            soapParts = this.parseSoapBody(soapBody, isInput);
            if (isInput) {
                this.inputSOAPParts = soapParts;
            } else {
                this.outputSOAPParts = soapParts;
            }
        }
        if (isInput) {
            this.inputMIMEParts = mimePartList;
        } else {
            this.outputMIMEParts = mimePartList;
        }
        Trc.exit();
    }

    private void unwrapSOAPParts() throws WSIFException {
        if ("document".equals(this.operationStyle)) {
            Part p;
            QName elementName;
            String operationName = this.getName();
            if (this.inputSOAPParts.size() == 1 && (elementName = (p = (Part)this.inputSOAPParts.get(0)).getElementName()) != null && operationName.equals(elementName.getLocalPart())) {
                this.inputUnwrappedSOAPParts = ProviderUtils.unWrapPart(p, this.getDefinition(), this.context);
            }
            if (this.outputSOAPParts.size() == 1) {
                String s = operationName + "Response";
                Part p2 = (Part)this.outputSOAPParts.get(0);
                QName elementName2 = p2.getElementName();
                if (elementName2 != null && s.equals(elementName2.getLocalPart())) {
                    this.outputUnwrappedSOAPParts = ProviderUtils.unWrapPart(p2, this.getDefinition(), this.context);
                }
            }
        }
    }

    private BindingOperation getBindingOperation(Operation operation) throws WSIFException {
        Binding binding = this.wsifPort.getPort().getBinding();
        BindingOperation bindingOp = WSIFUtils.getBindingOperation(binding, operation);
        if (bindingOp == null) {
            throw new WSIFException("cannot find binding operation for port operation:" + operation.getName());
        }
        return bindingOp;
    }

    public Definition getDefinition() {
        Trc.entry(this);
        Definition d = this.wsifPort.getDefinition();
        Trc.exit(d);
        return d;
    }

    public WSIFPort_SOAP getDynamicWSIFPort() {
        Trc.entry(this);
        Trc.exit(this.wsifPort);
        return this.wsifPort;
    }

    public String getInputEncodingStyle() {
        Trc.entry(this);
        Trc.exit(this.inputEncodingStyle);
        return this.inputEncodingStyle;
    }

    public String getInputNamespace() {
        Trc.entry(this);
        Trc.exit(this.inputNamespace);
        return this.inputNamespace;
    }

    public String getName() {
        Trc.entry(this);
        String s = this.portTypeOperation.getName();
        Trc.exit(s);
        return s;
    }

    public Operation getOperation() {
        Trc.entry(this);
        Operation o = this.getPortTypeOperation();
        Trc.exit(o);
        return o;
    }

    private Part getPart(QName message, String partName) {
        Part p = null;
        Definition def = this.wsifPort.getDefinition();
        javax.wsdl.Message m = def.getMessage(message);
        if (m != null) {
            p = m.getPart(partName);
        }
        return p;
    }

    public Operation getPortTypeOperation() {
        Trc.entry(this);
        Trc.exit(this.portTypeOperation);
        return this.portTypeOperation;
    }

    public String getOutputEncodingStyle() {
        Trc.entry(this);
        Trc.exit(this.outputEncodingStyle);
        return this.outputEncodingStyle;
    }

    public String getSoapActionURI() {
        Trc.entry(this);
        Trc.exit(this.soapActionURI);
        return this.soapActionURI;
    }

    public Transport getTransport() throws WSIFException {
        Trc.entry(this);
        Transport t = this.wsifPort.getTransport();
        Trc.exit(t);
        return t;
    }

    public WSIFCorrelationId getAsyncRequestID() {
        Trc.entry(this);
        Trc.exit(this.asyncRequestID);
        return this.asyncRequestID;
    }

    private HashMap getResponseMessageParameters() {
        return this.responseMessageParameters;
    }

    public WSIFPort getWSIFPort() {
        Trc.entry(this);
        Trc.exit(this.wsifPort);
        return this.wsifPort;
    }

    public boolean isAsyncOperation() {
        Trc.entry(this);
        Trc.exit(this.asyncOperation);
        return this.asyncOperation;
    }

    public void executeInputOnlyOperation(WSIFMessage inMsg) throws WSIFException {
        Trc.entry((Object)this, inMsg);
        if (inMsg == null) {
            throw new IllegalArgumentException("input message is null");
        }
        this.setAsyncOperation(false);
        this.setOneWayOperation(true);
        this.invokeRequestResponseOperation(inMsg, null, null);
        Trc.exit();
    }

    public boolean executeRequestResponseOperation(WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        Trc.entry(this, inMsg, outMsg, faultMsg);
        if (inMsg == null) {
            throw new IllegalArgumentException("input message is null");
        }
        if (outMsg == null) {
            throw new IllegalArgumentException("output message is null");
        }
        if (faultMsg == null) {
            throw new IllegalArgumentException("fault message is null");
        }
        this.close();
        this.setAsyncOperation(false);
        this.setOneWayOperation(false);
        boolean succ = this.invokeRequestResponseOperation(inMsg, outMsg, faultMsg);
        Trc.exit(succ);
        return succ;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage inMsg) throws WSIFException {
        Trc.entry((Object)this, inMsg);
        if (inMsg == null) {
            throw new IllegalArgumentException("input message is null");
        }
        WSIFCorrelationId id = this.executeRequestResponseAsync(inMsg, null);
        Trc.exit(id);
        return id;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage inMsg, WSIFResponseHandler handler2) throws WSIFException {
        Trc.entry(this, inMsg, handler2);
        if (inMsg == null) {
            throw new IllegalArgumentException("input message is null");
        }
        this.close();
        if (!this.wsifPort.supportsAsync()) {
            throw new WSIFException("asynchronous operations not available");
        }
        this.setAsyncOperation(true);
        this.setOneWayOperation(false);
        this.setResponseHandler(handler2);
        WSIFJmsTransport transport2 = (WSIFJmsTransport)this.getTransport();
        transport2.setWsifOperation(this);
        transport2.setAsyncOperation("true");
        this.invokeRequestResponseOperation(inMsg, null, null);
        transport2.setAsyncOperation("false");
        WSIFCorrelationId id = this.getAsyncRequestID();
        Trc.exit(id);
        return id;
    }

    public void fireAsyncResponse(Object response) throws WSIFException {
        Trc.entry((Object)this, response);
        Object result = this.deserialiseResponseObject(response);
        WSIFMessage outMsg = this.createOutputMessage();
        WSIFMessage faultMsg = this.createFaultMessage();
        this.buildResponseMessages(result, outMsg, faultMsg);
        this.getResponseHandler().executeAsyncResponse(outMsg, faultMsg);
        Trc.exit(outMsg);
    }

    public boolean processAsyncResponse(Object response, WSIFMessage output, WSIFMessage fault2) throws WSIFException {
        Trc.entry(this, response, output, fault2);
        Object result = this.deserialiseResponseObject(response);
        boolean ok = this.buildResponseMessages(result, output, fault2);
        Trc.exit(ok);
        return ok;
    }

    private Object deserialiseResponseObject(Object msg) throws WSIFException {
        Trc.entry((Object)this, msg);
        if (msg == null) {
            throw new WSIFException("null response to async send");
        }
        if (!(msg instanceof TextMessage)) {
            throw new WSIFException("response not a javax.jms.TextMessage");
        }
        try {
            Map callParams;
            TextMessage m = (TextMessage)msg;
            String responseMsg = m.getText();
            Service s = new Service(new WSIFClientConfig());
            Call call = new Call(s);
            call.setPortName(new QName(null, "wsifAsyncPort"));
            this.prepare(call, true);
            WSIFJmsAsyncRespTransport soaptransport = new WSIFJmsAsyncRespTransport(responseMsg);
            call.setTransport(soaptransport);
            this.setCallContext(call, true);
            QName opName = new QName("", "fakeIt");
            call.setOperationName(opName);
            this.setCallParameterNames(call, true);
            Object[] inputValues = new Object[]{};
            if (!"rpc".equals(this.operationStyle)) {
                call.setProperty("send_type_attr", Boolean.FALSE);
                call.setProperty("sendMultiRefs", Boolean.FALSE);
                call.setOperationStyle(this.operationStyle);
            }
            Object response = null;
            try {
                response = call.invoke(opName, inputValues);
            }
            catch (RemoteException e2) {
                Trc.exception(e2);
                response = e2;
            }
            List soapParts = "wrapped".equals(this.operationStyle) ? this.outputUnwrappedSOAPParts : this.outputSOAPParts;
            if ((soapParts.size() > 0 || this.outputMIMEParts.size() > 0) && (callParams = call.getOutputParams()) != null) {
                HashMap outParams = new HashMap();
                Iterator i = callParams.keySet().iterator();
                while (i.hasNext()) {
                    QName qn = (QName)i.next();
                    outParams.put(qn.getLocalPart(), callParams.get(qn));
                }
                this.setResponseMessageParameters(outParams);
            }
            Trc.exit(response);
            return response;
        }
        catch (Exception ex) {
            Trc.exception(ex);
            throw new WSIFException(ex.getMessage());
        }
    }

    private boolean buildResponseMessages(Object resp, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        boolean respOK;
        if (resp instanceof WebServicesFault) {
            respOK = false;
            if (faultMsg != null) {
                WebServicesFault f = (WebServicesFault)resp;
                faultMsg.setName("org.apache.wsif.soap.fault");
                faultMsg.setObjectPart("org.apache.wsif.soap.fault.object", f);
                this.processFault(f, faultMsg);
            }
        } else {
            respOK = true;
            this.populateOutMsgReturnPart(resp, outMsg);
            this.populateOutMsgParts(outMsg);
        }
        return respOK;
    }

    private void processFault(WebServicesFault f, WSIFMessage faultMsg) throws WSIFException {
        Trc.entry(this, f, faultMsg);
        boolean throwException = false;
        Object obj = null;
        try {
            obj = this.context != null ? this.context.getObjectPart("org.apache.wsif.soap.throw.unchecked.fault") : this.getWSIFPort().getContext().getObjectPart("org.apache.wsif.soap.throw.unchecked.fault");
        }
        catch (WSIFException notFound) {
            // empty catch block
        }
        if (obj != null) {
            try {
                throwException = (Boolean)obj;
            }
            catch (ClassCastException ignored) {
                Trc.ignoredException(ignored);
            }
        }
        Trc.event(this, "throw WSIFException for unchecked faults is " + throwException);
        QName faultCodeToFind = f.getFaultCode();
        if (faultCodeToFind == null) {
            if (throwException) {
                throw new WSIFException("Cannot find fault code", f);
            }
            Trc.exit();
            return;
        }
        Exception userException = f.getUserException();
        if (userException == null) {
            if (throwException) {
                throw new WSIFException("Cannot find user exception", f);
            }
            Trc.exit();
            return;
        }
        if (this.faultsList == null) {
            if (throwException) {
                throw new WSIFException("No faults defined in wsdl", userException);
            }
            Trc.exit();
            return;
        }
        boolean foundFault = false;
        Iterator it = this.faultsList.iterator();
        while (it.hasNext() && !foundFault) {
            Fault fault2 = (Fault)it.next();
            QName[] qNames = this.getQNamesFromFault(fault2);
            if (qNames == null) {
                Trc.event(this, "nothing found in fault, trying next fault");
                continue;
            }
            QName faultCode = qNames[0];
            QName messageQName = qNames[1];
            QName partQName = qNames[2];
            QName partXmlType = qNames[3];
            String partName = qNames[4].getLocalPart();
            if (!faultCodeToFind.equals(faultCode)) continue;
            faultMsg.setName(fault2.getName());
            faultMsg.setMessageDefinition(fault2.getMessage());
            faultMsg.setObjectPart(partName, userException);
            foundFault = true;
        }
        if (!foundFault && throwException) {
            throw new WSIFException("Unable to match fault in wsdl", userException);
        }
        Trc.exit(faultMsg);
    }

    private void populateOutMsgReturnPart(Object resp, WSIFMessage outMsg) throws WSIFException {
        if (outMsg != null) {
            List soapParts = "wrapped".equals(this.operationStyle) ? this.outputUnwrappedSOAPParts : this.outputSOAPParts;
            Part returnPart = null;
            if (soapParts.size() > 0) {
                returnPart = (Part)soapParts.get(0);
                WSIFOperation_SOAP.setSOAPMessagePart(outMsg, returnPart.getName(), resp);
            } else if (this.outputMIMEParts.size() > 0) {
                returnPart = (Part)this.outputMIMEParts.get(0);
                WSIFOperation_SOAP.setMIMEMessagePart(outMsg, returnPart.getName(), resp, resp == null ? null : resp.getClass());
            }
        }
    }

    private void populateOutMsgParts(WSIFMessage outMsg) throws WSIFException {
        HashMap respParms;
        if (outMsg != null && (respParms = this.getResponseMessageParameters()) != null) {
            List soapParts = "wrapped".equals(this.operationStyle) ? this.outputUnwrappedSOAPParts : this.outputSOAPParts;
            if (!this.outputMIMEParts.isEmpty()) {
                soapParts = new ArrayList(soapParts);
                soapParts.removeAll(this.outputMIMEParts);
            }
            for (int i = 1; i < soapParts.size(); ++i) {
                Part p = (Part)soapParts.get(i);
                String name2 = p.getName();
                Object value2 = respParms.get(name2);
                WSIFOperation_SOAP.setSOAPMessagePart(outMsg, name2, value2);
            }
            int startMIMEindex = soapParts.size() > 0 ? 0 : 1;
            for (int i = startMIMEindex; i < this.outputMIMEParts.size(); ++i) {
                Object value3;
                String name3;
                Part p = (Part)this.outputMIMEParts.get(i);
                WSIFOperation_SOAP.setMIMEMessagePart(outMsg, name3, value3, (value3 = respParms.get(name3 = p.getName())) == null ? null : value3.getClass());
            }
        }
    }

    private static void setSOAPMessagePart(WSIFMessage msg, String name2, Object value2) throws WSIFException {
        Trc.entry(null, msg, name2, value2);
        msg.setObjectPart(name2, value2);
        Trc.exit();
    }

    private static void setMIMEMessagePart(WSIFMessage msg, String name2, Object value2, Class type) throws WSIFException {
        Trc.entry(null, msg, name2, value2, type);
        MIMEHelper.setMIMEMessagePart(msg, name2, value2, type);
        Trc.exit();
    }

    private QName getPartType(Part p) {
        QName type = p.getTypeName();
        if (type == null) {
            type = p.getElementName();
        }
        return type;
    }

    protected boolean invokeRequestResponseOperation(WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        String s;
        Trc.entry(this, inMsg, outMsg, faultMsg);
        boolean workedOK = false;
        this.usingJROM = "http://www.apache.org/namespaces/jrom".equals(inMsg.getRepresentationStyle());
        Call call = this.usingJROM ? this.wsifPort.getJROMCall() : this.wsifPort.getCall();
        call.removeAllParameters();
        call.clearHeaders();
        call.setReturnType(null, null);
        OperationDesc opDesc = call.getMessageContext().getOperation();
        opDesc.removeReturn();
        opDesc.removeFaults();
        URL transportUrl = this.wsifPort.getEndPoint();
        try {
            String transportUrlString = (String)this.getContext().getObjectPart("transport.url");
            if (transportUrlString != null) {
                transportUrl = new URL(transportUrlString);
                this.getTransport().setUrl(transportUrlString);
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        call.setTargetEndpointAddress(transportUrl);
        if (this.inputSOAPParts == null) {
            this.prepare(call, false);
        }
        if ((s = this.getSoapActionURI()) != null && s.length() > 0) {
            call.setSOAPActionURI(s);
            call.setUseSOAPAction(true);
        }
        this.operationStyle = this.getOperationStyle(inMsg);
        Transport soaptransport = this.getTransport();
        WSIFJMSDestination dest = null;
        if (soaptransport != null) {
            call.setTransport(soaptransport);
            if (soaptransport instanceof WSIFJmsTransport) {
                WSIFJmsTransport jmst = (WSIFJmsTransport)soaptransport;
                dest = jmst.getDestination();
                dest.setAsyncMode(this.isAsyncOperation());
                dest.setOneWayMode(this.isOneWayOperation());
                jmst.setSyncTimeout(null);
                jmst.setAsyncTimeout(null);
            }
        }
        if (dest != null && this.inJmsPropVals != null && !this.inJmsPropVals.isEmpty()) {
            this.checkForTimeoutProperties(this.inJmsPropVals, dest);
            dest.setProperties(this.inJmsPropVals);
        }
        this.setDestinationContext(dest);
        this.setCallContext(call, false);
        workedOK = "message".equals(this.operationStyle) ? this.invokeSOAPMessaging(call, inMsg, outMsg, faultMsg) : ("rpc".equals(this.operationStyle) ? this.invokeSOAPRPCStyle(call, inMsg, outMsg, faultMsg, dest) : ("lazyParse".equals(this.operationStyle) ? this.invokeSOAPLazyParse(call, inMsg, outMsg, faultMsg) : this.invokeSOAPDocStyle(call, inMsg, outMsg, faultMsg)));
        if (!this.isOneWayOperation()) {
            this.setResponseContext(call);
        }
        if (Trc.ON) {
            Trc.event(this, "WSIF resetting inputSOAPParts");
        }
        this.inputSOAPParts = null;
        Trc.exit(workedOK);
        return workedOK;
    }

    protected String getOperationStyle(WSIFMessage msg) {
        String style = this.operationStyle;
        try {
            Object part;
            Iterator i = msg.getPartNames();
            if (i.hasNext() && (part = msg.getObjectPart((String)i.next())) instanceof com.ibm.ws.webservices.engine.xmlsoap.SOAPBody) {
                style = "lazyParse";
                return style;
            }
            WSIFMessage context = this.getContext();
            style = (String)context.getObjectPart("org.apache.wsif.axis.operationStyle");
        }
        catch (WSIFException e2) {
            Trc.ignoredException(e2);
            if ("document".equals(this.operationStyle) && this.isInputMessageUnWrapped(msg)) {
                style = "wrapped";
            }
            if (this.isMessaging(msg)) {
                style = "message";
            }
            String partName = null;
            Object part = null;
            try {
                partName = (String)this.getContext().getObjectPart("wsif.operationStyle.message.element_part_name");
                part = msg.getObjectPart(partName);
                if (part != null) {
                    style = "message";
                }
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
        }
        return style;
    }

    private boolean isInputMessageUnWrapped(WSIFMessage msg) {
        boolean unWrapped = true;
        Object style = null;
        try {
            WSIFMessage context = this.getContext();
            style = context.getObjectPart("org.apache.wsif.axis.operationStyle");
        }
        catch (WSIFException e2) {
            Trc.ignoredException(e2);
        }
        if ("wrapped".equals(style)) {
            unWrapped = true;
        } else if ("unwrapped".equals(style)) {
            unWrapped = false;
        } else if (this.inputUnwrappedSOAPParts != null && this.inputUnwrappedSOAPParts.size() > 0) {
            unWrapped = true;
            Iterator i = this.inputUnwrappedSOAPParts.iterator();
            while (i.hasNext() && unWrapped) {
                Part p = (Part)i.next();
                try {
                    msg.getObjectPart(p.getName());
                }
                catch (WSIFException e3) {
                    unWrapped = false;
                }
            }
        } else {
            unWrapped = false;
        }
        return unWrapped;
    }

    private boolean isMessaging(WSIFMessage msg) {
        boolean allDOMElements = true;
        boolean anyDOMElements = false;
        if (msg != null) {
            Iterator i = this.inputSOAPParts.iterator();
            while (i.hasNext()) {
                Part p = (Part)i.next();
                try {
                    Object o = msg.getObjectPart(p.getName());
                    if (o instanceof Element) {
                        anyDOMElements = true;
                        continue;
                    }
                    allDOMElements = false;
                }
                catch (WSIFException e2) {
                    Trc.ignoredException(e2);
                }
            }
        }
        return anyDOMElements && allDOMElements;
    }

    private boolean invokeSOAPLazyParse(Call call, WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        Iterator i;
        SOAPEnvelope outEnv;
        SOAPEnvelope inEnv;
        boolean workedOK;
        block18: {
            workedOK = true;
            inEnv = null;
            outEnv = null;
            List attachments = this.addReferencedAttachments(inMsg, call);
            this.addUnreferencedAttachments(inMsg, call);
            try {
                inEnv = ((SOAPFactory)SOAPFactory.newInstance()).createSOAPEnvelope();
                WSIFMessage contextMsg = this.getContext();
                if (contextMsg != null) {
                    Hashtable namespaces = (Hashtable)contextMsg.getObjectPart("NamespaceScope");
                    if (namespaces != null) {
                        Iterator i2 = namespaces.keySet().iterator();
                        while (i2.hasNext()) {
                            String prefix = (String)i2.next();
                            String uri = (String)namespaces.get(prefix);
                            inEnv.addNamespaceDeclaration(prefix, uri);
                        }
                    }
                    try {
                        String requestType = (String)contextMsg.getObjectPart("com.ibm.wsgw.channels.soaphttp.ProxyOperationMode");
                        if (requestType.equals("requestresponse")) {
                            call.setReturnQName(new QName("local", "lazyParse"));
                        }
                    }
                    catch (Exception ignored) {
                        Trc.ignoredException(ignored);
                    }
                }
                if (!(i = inMsg.getPartNames()).hasNext()) break block18;
                Object part = inMsg.getObjectPart((String)i.next());
                if (part instanceof com.ibm.ws.webservices.engine.xmlsoap.SOAPBody) {
                    com.ibm.ws.webservices.engine.xmlsoap.SOAPBody soapBody = (com.ibm.ws.webservices.engine.xmlsoap.SOAPBody)part;
                    inEnv.addChildElement(soapBody);
                    break block18;
                }
                throw new WSIFException("exception on SOAP invoke: invalid part for lazy parse operation");
            }
            catch (SOAPException se) {
                throw new WSIFException("exception on SOAP invoke: " + se.getLocalizedMessage());
            }
        }
        call.setOperationStyle("rpc");
        Trc.event(this, "Invoking SOAP call", call, inEnv);
        try {
            outEnv = call.invoke(inEnv);
        }
        catch (RemoteException ex) {
            Trc.exception(ex);
            try {
                if (ex instanceof WebServicesFault) {
                    WebServicesFault f = (WebServicesFault)ex;
                    faultMsg.setName("org.apache.wsif.soap.fault");
                    faultMsg.setObjectPart("org.apache.wsif.soap.fault.object", f);
                }
                return false;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        try {
            Hashtable<String, String> namespaces = new Hashtable<String, String>();
            i = outEnv.getNamespacePrefixes();
            while (i.hasNext()) {
                String prefix = (String)i.next();
                String uri = outEnv.getNamespaceURI(prefix);
                namespaces.put(prefix, uri);
            }
            this.context.setObjectPart("ResponseNamespaceScope", namespaces);
            if (!this.oneWayOperation) {
                com.ibm.ws.webservices.engine.xmlsoap.SOAPBody outBody = (com.ibm.ws.webservices.engine.xmlsoap.SOAPBody)outEnv.getBody();
                outMsg.setObjectPart(outBody.getLocalPart(), outBody);
            }
        }
        catch (SOAPException e3) {
            throw new WSIFException("exception on SOAP invoke: " + e3.getLocalizedMessage());
        }
        return workedOK;
    }

    private boolean invokeSOAPRPCStyle(Call call, WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg, WSIFJMSDestination dest) throws WSIFException {
        QName opName = new QName(this.getInputNamespace(), this.portTypeOperation.getName());
        call.setOperationName(opName);
        this.setCallParameterNames(call, false);
        call.setOperationUse(this.getInputUse());
        Object[] inputValues = this.getInputMessageValues(inMsg, dest);
        this.addUnreferencedAttachments(inMsg, call);
        Object response = null;
        boolean respOK = true;
        try {
            String name2 = this.portTypeOperation.getName();
            Trc.event(this, "Invoking operation ", name2, " input namespace ", this.getInputNamespace(), " parameters ", inputValues, " call object ", call);
            if (this.isOneWayOperation() || this.isAsyncOperation()) {
                Trc.event(this, "invoke One Way");
                call.invokeOneWay(inputValues);
                response = null;
            } else {
                response = call.invoke(opName, inputValues);
            }
        }
        catch (RemoteException e2) {
            Trc.exception(e2);
            response = e2;
            respOK = false;
        }
        Trc.event(this, "Returned from operation, response ", response);
        if (!(this.isAsyncOperation() || this.isOneWayOperation() || this.outputSOAPParts.size() <= 0 && this.outputMIMEParts.size() <= 0)) {
            Map callParams = null;
            try {
                callParams = call.getOutputParams();
            }
            catch (Exception e3) {
                Trc.exception(e3);
            }
            if (callParams != null) {
                HashMap outParams = new HashMap();
                if (Trc.ON) {
                    Trc.event(this, "WSIF replaced QName with String");
                }
                Iterator i = callParams.keySet().iterator();
                while (i.hasNext()) {
                    String qn = (String)i.next();
                    outParams.put(qn, callParams.get(qn));
                }
                this.setResponseMessageParameters(outParams);
            }
            respOK = this.buildResponseMessages(response, outMsg, faultMsg);
        }
        return respOK;
    }

    private void setCallParameterNames(Call call, boolean asyncResponse) throws WSIFException {
        int startMIMEIndex;
        Part p;
        QName type;
        QName name2;
        List soapParts;
        Trc.entry(this, call, new Boolean(asyncResponse));
        boolean wrappedStyleOp = false;
        String inputNamespace = null;
        if (!asyncResponse) {
            wrappedStyleOp = ProviderUtils.isUnwrapable(this.getPortTypeOperation());
            inputNamespace = "literal".equals(this.getInputUse()) && !wrappedStyleOp ? "" : this.getInputNamespace();
        }
        String outputNamespace = "";
        if (!asyncResponse) {
            soapParts = "wrapped".equals(this.operationStyle) ? this.inputUnwrappedSOAPParts : this.inputSOAPParts;
            if (this.inputMIMEParts.isEmpty()) {
                for (int i = 0; i < soapParts.size(); ++i) {
                    QName qn;
                    Part p2 = (Part)soapParts.get(i);
                    String partName = p2.getName();
                    if (this.inJmsProps.containsKey(partName)) continue;
                    if ("document".equals(this.operationStyle) && (qn = p2.getElementName()) != null) {
                        partName = qn.getLocalPart();
                    }
                    name2 = new QName(inputNamespace, partName);
                    type = this.getPartType(p2);
                    call.addParameter(name2, type, ParameterMode.IN);
                }
            } else {
                List order = this.portTypeOperation.getInput().getMessage().getOrderedParts(null);
                Iterator it = order.iterator();
                while (it.hasNext()) {
                    p = (Part)it.next();
                    if (!this.inputMIMEParts.contains(p) && !soapParts.contains(p)) continue;
                    name2 = new QName(inputNamespace, p.getName());
                    type = this.getPartType(p);
                    call.addParameter(name2, type, ParameterMode.IN);
                }
            }
        }
        soapParts = "wrapped".equals(this.operationStyle) ? this.outputUnwrappedSOAPParts : this.outputSOAPParts;
        Part returnPart = null;
        if (soapParts.size() > 0) {
            returnPart = (Part)soapParts.get(0);
        } else if (this.outputMIMEParts.size() > 0) {
            returnPart = (Part)this.outputMIMEParts.get(0);
        }
        if (!this.isOneWayOperation() && !this.isAsyncOperation() || asyncResponse) {
            if (returnPart == null) {
                call.setReturnType(Constants.WEBSERVICES_VOID);
            } else {
                QName type2 = this.getPartType(returnPart);
                call.setReturnType(type2);
            }
        }
        for (int i = 1; i < soapParts.size(); ++i) {
            p = (Part)soapParts.get(i);
            name2 = new QName(outputNamespace, p.getName());
            type = this.getPartType(p);
            call.addParameter(name2, type, ParameterMode.OUT);
        }
        for (int i = startMIMEIndex = soapParts.size() > 0 ? 0 : 1; i < this.outputMIMEParts.size(); ++i) {
            Part p3 = (Part)this.outputMIMEParts.get(i);
            QName name3 = new QName(outputNamespace, p3.getName());
            QName type3 = this.getPartType(p3);
            call.addParameter(name3, type3, ParameterMode.OUT);
        }
        Trc.exit();
    }

    private boolean invokeSOAPDocStyle(Call call, WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        List soapParts;
        Object response;
        boolean respOK = false;
        call.setOperationName(new QName(this.wsifPort.getPortTypeNamespace(), this.portTypeOperation.getName()));
        call.setProperty("send_type_attr", Boolean.FALSE);
        call.setProperty("sendMultiRefs", Boolean.FALSE);
        call.setOperationStyle(this.operationStyle);
        call.setOperationUse(this.getInputUse());
        this.setCallParameterNames(call, false);
        Object[] inputValues = this.getInputMessageValues(inMsg, null);
        this.addUnreferencedAttachments(inMsg, call);
        Trc.event(this, "Invoking SOAP call ", call, inputValues);
        try {
            if (this.isOneWayOperation() || this.isAsyncOperation()) {
                Trc.event(this, "invoke One Way");
                call.invokeOneWay(inputValues);
                response = null;
            } else {
                response = call.invoke(inputValues);
            }
            respOK = true;
        }
        catch (RemoteException ex) {
            Trc.exception(ex);
            response = ex;
            respOK = false;
        }
        Trc.event(this, "Returned from SOAP invoke, response: ", response);
        if (!(this.isAsyncOperation() || this.isOneWayOperation() || (soapParts = "wrapped".equals(this.operationStyle) ? this.outputUnwrappedSOAPParts : this.outputSOAPParts).size() <= 0 && this.outputMIMEParts.size() <= 0)) {
            Map callParams = call.getOutputParams();
            if (callParams != null) {
                HashMap outParams = new HashMap();
                Iterator i = callParams.keySet().iterator();
                while (i.hasNext()) {
                    QName qn = (QName)i.next();
                    outParams.put(qn.getLocalPart(), callParams.get(qn));
                }
                this.setResponseMessageParameters(outParams);
            }
            respOK = this.buildResponseMessages(response, outMsg, faultMsg);
        }
        return respOK;
    }

    private void setFaults(Call call, boolean asyncResponse) {
        Trc.entry(this, call, new Boolean(asyncResponse));
        if (!asyncResponse) {
            Operation operation = this.getOperation();
            Map faults = operation.getFaults();
            if (faults.isEmpty()) {
                Trc.exit();
                return;
            }
            this.faultsList = new ArrayList();
            Set faultNamesSet = faults.keySet();
            Iterator it = faultNamesSet.iterator();
            while (it.hasNext()) {
                Object faultKey = it.next();
                Fault fault2 = (Fault)faults.get(faultKey);
                this.faultsList.add(fault2);
            }
        }
        if (this.faultsList == null) {
            Trc.exit();
            return;
        }
        Iterator it = this.faultsList.iterator();
        while (it.hasNext()) {
            Fault fault3 = (Fault)it.next();
            QName[] qNames = this.getQNamesFromFault(fault3);
            if (qNames == null) {
                Trc.event(this, "nothing found in fault, trying next fault");
                continue;
            }
            QName faultCode = qNames[0];
            QName messageQName = qNames[1];
            QName partQName = qNames[2];
            QName partXmlType = qNames[3];
            Class className = this.typeMap.getClassForXmlType(partXmlType);
            if (className == null) {
                Trc.event(this, "classname not found for xml type" + partXmlType + ", trying next fault");
                continue;
            }
            Trc.event(this, "calling addFault with ", faultCode, className, messageQName, partXmlType, partQName);
            call.addFault(faultCode, className, messageQName, partXmlType, partQName);
        }
        Trc.exit(call);
    }

    private QName[] getQNamesFromFault(Fault fault2) {
        Trc.entry((Object)this, fault2);
        javax.wsdl.Message faultMessage = fault2.getMessage();
        if (faultMessage == null) {
            Trc.exit(null);
            return null;
        }
        QName messageQName = faultMessage.getQName();
        Map partsMap = faultMessage.getParts();
        if (partsMap.size() == 0) {
            Trc.exit(null);
            return null;
        }
        if (partsMap.size() > 1) {
            Trc.event(this, "Warning: more than 1 part found in fault message. Only 1st part will be used (see WSDL 1.1)");
        }
        Set faultPartsSet = partsMap.keySet();
        Iterator partsIt = faultPartsSet.iterator();
        Object partKey = partsIt.next();
        Part faultPart = (Part)partsMap.get(partKey);
        boolean hasElement = false;
        QName partElementQName = faultPart.getElementName();
        if (partElementQName != null) {
            hasElement = true;
        }
        QName faultCode = null;
        QName partQName = null;
        QName partXmlType = null;
        QName partName = new QName(faultPart.getName());
        if (!hasElement) {
            partXmlType = faultPart.getTypeName();
            faultCode = messageQName;
            partQName = partXmlType;
        } else {
            partXmlType = partElementQName;
            faultCode = partElementQName;
            partQName = partElementQName;
        }
        QName[] returnArray = new QName[]{faultCode, messageQName, partQName, partXmlType, partName};
        if (Trc.isTraceEnabled()) {
            Trc.exit(faultCode + "," + messageQName + "," + partQName + "," + partXmlType + "," + partName);
        }
        return returnArray;
    }

    private boolean invokeSOAPMessaging(Call call, WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        Object soapResponse;
        boolean workedOK;
        block17: {
            workedOK = false;
            List attachments = this.addReferencedAttachments(inMsg, call);
            this.addUnreferencedAttachments(inMsg, call);
            ArrayList<SOAPBodyElement> soapBodies = new ArrayList<SOAPBodyElement>();
            try {
                SOAPFactory f = (SOAPFactory)SOAPFactory.newInstance();
                Object[] inputValues = this.getInputMessageValues(inMsg, null);
                for (int i = 0; i < inputValues.length; ++i) {
                    Element el;
                    if (inputValues[i] instanceof Element) {
                        el = (Element)inputValues[i];
                        if (attachments.size() > 0 && i == 0) {
                            this.fixAttachmentPartsCID(el, attachments);
                        }
                    } else {
                        throw new WSIFException("unexpected input type: " + inputValues[i]);
                    }
                    SOAPBodyElement sbe = f.createSOAPBodyElement("", "");
                    sbe.setAlternateContent(el);
                    soapBodies.add(sbe);
                }
            }
            catch (SOAPException e2) {
                // empty catch block
            }
            call.setOperationStyle(this.operationStyle);
            call.setOperationName(new QName(this.wsifPort.getPortTypeNamespace(), this.portTypeOperation.getName()));
            SOAPBodyElement[] soapInputs = soapBodies.toArray(new SOAPBodyElement[0]);
            MessageContext msgContext = call.getMessageContext();
            if (msgContext != null) {
                msgContext.setHighFidelity(true);
            } else {
                Trc.event(this, "Call message context is null");
            }
            Trc.event(this, "Invoking SOAP call ", call, soapInputs);
            try {
                Call iCall;
                if (this.isOneWayOperation()) {
                    call.setReturnType(null);
                    Trc.event(this, "invoke One Way");
                    try {
                        iCall = call;
                        iCall.invokeOneWay(soapInputs);
                    }
                    catch (JAXRPCException exc) {
                        Trc.ignoredException(exc);
                    }
                    soapResponse = null;
                    break block17;
                }
                iCall = call;
                soapResponse = iCall.invoke(soapInputs);
            }
            catch (RemoteException ex) {
                Trc.exception(ex);
                soapResponse = ex;
                try {
                    if (ex instanceof WebServicesFault) {
                        WebServicesFault f = (WebServicesFault)ex;
                        faultMsg.setName("org.apache.wsif.soap.fault");
                        faultMsg.setObjectPart("org.apache.wsif.soap.fault.object", f);
                    }
                    return false;
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        Trc.event(this, "Returned from SOAP invoke, response: ", soapResponse);
        if (!this.isOneWayOperation()) {
            this.setOutputMessageValues(soapResponse, outMsg);
        }
        workedOK = true;
        return workedOK;
    }

    private void fixAttachmentPartsCID(Element body, List attachments) throws WSIFException {
        ArrayList al = new ArrayList();
        WSIFOperation_SOAP.getAttachmentElements(al, body);
        if (al.size() != attachments.size()) {
            throw new WSIFException("unexpected number of attachments," + attachments.size() + " AttachmentParts, " + al.size() + " attachment href elements");
        }
        for (int i = 0; i < attachments.size(); ++i) {
            AttachmentPart attachment = (AttachmentPart)attachments.get(i);
            Element attachmentElement = (Element)al.get(i);
            attachmentElement.setAttribute("href", "cid:" + attachment.getContentId());
        }
    }

    private static void getAttachmentElements(ArrayList al, Element el) {
        NodeList childNodes = el.getChildNodes();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node n = childNodes.item(j);
            if (!(n instanceof Element)) continue;
            Element childElement = (Element)n;
            String s = childElement.getAttribute("href");
            if (s != null && s.toLowerCase().startsWith("cid:")) {
                al.add(childElement);
                continue;
            }
            WSIFOperation_SOAP.getAttachmentElements(al, childElement);
        }
    }

    private void prepare(Call call, boolean asyncResponse) throws WSIFException {
        Trc.entry(this, call, new Boolean(asyncResponse));
        if (!asyncResponse) {
            this.inputSOAPParts = new ArrayList();
            this.inputMIMEParts = new ArrayList();
            this.outputSOAPParts = new ArrayList();
            this.outputMIMEParts = new ArrayList();
            this.parseSoapOperation();
            this.parseBindingInput();
            this.parseBindingOutput();
            this.unwrapSOAPParts();
            this.addInputJmsPropertyValues(this.wsifPort.getJmsAddressPropVals());
        }
        if (!"rpc".equals(this.operationStyle)) {
            call.setEncodingStyle(null);
            this.inputEncodingStyle = "";
            this.outputEncodingStyle = "";
        }
        if (!(asyncResponse || this.inputNamespace != null && this.inputNamespace.length() >= 1)) {
            this.inputNamespace = this.getTargetNamespaceURI();
        }
        Service s = call.getService();
        TypeMapping tm = WSIFOperation_SOAP.getTypeMapping(s, "http://schemas.xmlsoap.org/soap/encoding/");
        WSIFMessage context = this.getContext();
        WSIFOperation_SOAP.registerDefaultTypeMappings(tm, context);
        WSIFOperation_SOAP.registerDynamicTypes(tm, this.typeMap, context, this.usingJROM);
        if (!asyncResponse) {
            this.registerMIMETypes(this.inputMIMEParts, call);
        }
        this.registerMIMETypes(this.outputMIMEParts, call);
        this.setFaults(call, asyncResponse);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    static TypeMapping getTypeMapping(Service service, String encoding) {
        TypeMappingRegistry tmr = service.getEngine().getTypeMappingRegistry();
        TypeMapping tm = (TypeMapping)tmr.getTypeMapping(encoding);
        TypeMapping defaultTM = (TypeMapping)tmr.getDefaultTypeMapping();
        if (tm == null || tm == defaultTM) {
            tm = (TypeMapping)tmr.createTypeMapping();
            tm.setSupportedEncodings(new String[]{encoding, ""});
            tmr.register(encoding, tm);
            tmr.register("", tm);
        }
        return tm;
    }

    static void registerDefaultTypeMappings(javax.xml.rpc.encoding.TypeMapping callTypeMappings, WSIFMessage context) throws WSIFException {
        Object value2 = null;
        try {
            value2 = context.getObjectPart("org.apache.wsif.soap.default.type.serializers");
        }
        catch (WSIFException e2) {
            Trc.ignoredException(e2);
        }
        if (value2 == null) {
            return;
        }
        if (!(value2 instanceof List)) {
            throw new WSIFException("context part 'org.apache.wsif.soap.default.type.serializers' value is not an instance of java.util.List: " + value2);
        }
        List defaultMappings = (List)value2;
        Iterator i = defaultMappings.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof TypeSerializerInfo)) {
                throw new WSIFException("context part 'org.apache.wsif.soap.default.type.serializers' value List contains an entry that is not an instance of org.apache.wsif.util.TypeSerializer: " + value2);
            }
            TypeSerializerInfo ts = (TypeSerializerInfo)o;
            Class javaType = ts.getJavaType();
            QName elementType = ts.getElementType();
            Object tmp = ts.getSerializer();
            SerializerFactory sf = null;
            if (tmp instanceof SerializerFactory) {
                sf = (SerializerFactory)tmp;
            } else if (tmp instanceof Class) {
                sf = (SerializerFactory)WSIFOperation_SOAP.instantiateDSF((Class)tmp, javaType, elementType);
            }
            tmp = ts.getDeserializer();
            DeserializerFactory df = null;
            if (tmp instanceof DeserializerFactory) {
                df = (DeserializerFactory)tmp;
            } else if (tmp instanceof Class) {
                df = (DeserializerFactory)WSIFOperation_SOAP.instantiateDSF((Class)tmp, javaType, elementType);
            }
            if (javaType != null && elementType != null && (sf != null || df != null)) {
                callTypeMappings.register(javaType, elementType, (javax.xml.rpc.encoding.SerializerFactory)sf, (javax.xml.rpc.encoding.DeserializerFactory)df);
                continue;
            }
            Trc.event(null, "ignoring default TypeSerializer invalid for SOAP:" + ts);
        }
    }

    static Object instantiateDSF(Class factoryClass, Class javaType, QName elementType) {
        final Class factoryClassFin = factoryClass;
        Method createMethod = null;
        try {
            createMethod = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    return factoryClassFin.getMethod("create", class$java$lang$Class == null ? (class$java$lang$Class = WSIFOperation_SOAP.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = WSIFOperation_SOAP.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                }
            });
            Object result = createMethod.invoke(null, javaType, elementType);
            return result;
        }
        catch (Exception ignored) {
            Trc.ignoredException(ignored);
            Constructor ctor = null;
            try {
                ctor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        return factoryClassFin.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = WSIFOperation_SOAP.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = WSIFOperation_SOAP.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                    }
                });
                Object result = ctor.newInstance(javaType, elementType);
                return result;
            }
            catch (Exception ignored2) {
                Trc.ignoredException(ignored2);
                try {
                    Object result = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IllegalAccessException, InstantiationException {
                            return factoryClassFin.newInstance();
                        }
                    });
                    return result;
                }
                catch (Exception ignored3) {
                    Trc.ignoredException(ignored3);
                    return null;
                }
            }
        }
    }

    static void registerDynamicTypes(javax.xml.rpc.encoding.TypeMapping tm, WSIFDynamicTypeMap typeMap, WSIFMessage context, boolean usingJROM) throws WSIFException {
        ArrayList<Configurable> beanDescLiteSuppliers = new ArrayList<Configurable>();
        Iterator iterator = typeMap.iterator();
        while (iterator.hasNext()) {
            WSIFDynamicTypeMapping wsifdynamictypemapping = (WSIFDynamicTypeMapping)iterator.next();
            Class objClass = wsifdynamictypemapping.getJavaType();
            QName xmlType = wsifdynamictypemapping.getXmlType();
            String namespaceURI = wsifdynamictypemapping.getXmlType().getNamespaceURI();
            if (WSIFOperation_SOAP.isDefaultSOAPNamespace(namespaceURI) && !usingJROM) continue;
            SerializerFactory sf = null;
            DeserializerFactory df = null;
            TypeSerializerInfo contextTypeSerializer = WSIFOperation_SOAP.findContextTypeSerialzer(context, objClass, xmlType);
            if (contextTypeSerializer != null) {
                objClass = contextTypeSerializer.getJavaType();
                xmlType = contextTypeSerializer.getElementType();
                sf = (SerializerFactory)contextTypeSerializer.getSerializer();
                df = (DeserializerFactory)contextTypeSerializer.getDeserializer();
            } else if (usingJROM) {
                JROMUtils.registerJROMComplexType((TypeMapping)tm, xmlType, objClass);
            } else {
                if (sf == null) {
                    sf = (SerializerFactory)tm.getSerializer(objClass, xmlType);
                }
                if (sf == null) {
                    sf = objClass.isArray() ? new ArraySerializerFactory(objClass, xmlType) : ((class$com$ibm$ws$webservices$engine$encoding$SimpleType == null ? WSIFOperation_SOAP.class$("com.ibm.ws.webservices.engine.encoding.SimpleType") : class$com$ibm$ws$webservices$engine$encoding$SimpleType).isAssignableFrom(objClass) ? new SimpleSerializerFactory(objClass, xmlType) : new BeanSerializerFactory(objClass, xmlType));
                }
                if (df == null) {
                    df = (DeserializerFactory)tm.getDeserializer(objClass, xmlType);
                }
                if (df == null) {
                    df = objClass.isArray() ? new ArrayDeserializerFactory(objClass, xmlType) : ((class$com$ibm$ws$webservices$engine$encoding$SimpleType == null ? WSIFOperation_SOAP.class$("com.ibm.ws.webservices.engine.encoding.SimpleType") : class$com$ibm$ws$webservices$engine$encoding$SimpleType).isAssignableFrom(objClass) ? new SimpleDeserializerFactory(objClass, xmlType) : new BeanDeserializerFactory(objClass, xmlType));
                }
            }
            String localPart = wsifdynamictypemapping.getXmlType().getLocalPart();
            QName qn = new QName(namespaceURI, localPart);
            if (sf == null && df == null) continue;
            tm.register(objClass, qn, (javax.xml.rpc.encoding.SerializerFactory)sf, (javax.xml.rpc.encoding.DeserializerFactory)df);
            if (df != null && df instanceof BeanDescLiteSupplier) {
                beanDescLiteSuppliers.add(df);
            }
            if (sf == null || !(sf instanceof BeanDescLiteSupplier)) continue;
            beanDescLiteSuppliers.add(sf);
        }
        for (int i = 0; i < beanDescLiteSuppliers.size(); ++i) {
            BeanDescLiteSupplier bdls = (BeanDescLiteSupplier)beanDescLiteSuppliers.get(i);
            BeanDescLite bdl = bdls.getBeanDescLite();
            if (bdl == null) continue;
            bdl.processFieldXMLTypes((TypeMapping)tm);
        }
    }

    private static TypeSerializerInfo findContextTypeSerialzer(WSIFMessage context, Class clazz, QName xmlType) throws WSIFException {
        Object value2 = null;
        try {
            value2 = context.getObjectPart("org.apache.wsif.soap.type.serializers");
        }
        catch (WSIFException e2) {
            Trc.ignoredException(e2);
        }
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof List)) {
            throw new WSIFException("context part 'org.apache.wsif.soap.type.serializers' value is not an instance of java.util.List: " + value2);
        }
        List typeSerializers = (List)value2;
        Iterator i = typeSerializers.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof TypeSerializerInfo)) {
                throw new WSIFException("context part 'org.apache.wsif.soap.type.serializers' value List contains an entry that is not an instance of org.apache.wsif.util.TypeSerializer: " + value2);
            }
            TypeSerializerInfo tm = (TypeSerializerInfo)o;
            Class javaType = tm.getJavaType();
            QName elementType = tm.getElementType();
            Object serializer = tm.getSerializer();
            Object deserializer = tm.getDeserializer();
            if (javaType == null && (!javaType.isAssignableFrom(clazz) || elementType == null && !elementType.equals(xmlType)) || !(serializer == null || serializer instanceof SerializerFactory && deserializer == null || deserializer instanceof DeserializerFactory && serializer != null) && deserializer == null) continue;
            return tm;
        }
        return null;
    }

    private static boolean isDefaultSOAPNamespace(String ns) {
        boolean soapNamespace = false;
        if ("http://www.w3.org/1999/XMLSchema".equals(ns) || "http://www.w3.org/2000/10/XMLSchema".equals(ns) || "http://www.w3.org/2001/XMLSchema".equals(ns) || "http://schemas.xmlsoap.org/soap/encoding/".equals(ns) || "http://www.w3.org/2002/06/soap-encoding".equals(ns)) {
            soapNamespace = true;
        }
        return soapNamespace;
    }

    private Object[] getInputMessageValues(WSIFMessage inMsg, WSIFJMSDestination dest) throws WSIFException {
        ArrayList<Object> soapInputs = new ArrayList<Object>();
        List soapParts = "wrapped".equals(this.operationStyle) ? this.inputUnwrappedSOAPParts : this.inputSOAPParts;
        if ("message".equals(this.operationStyle)) {
            try {
                String partName = (String)this.getContext().getObjectPart("wsif.operationStyle.message.element_part_name");
                Object part = inMsg.getObjectPart(partName);
                if (part != null) {
                    soapInputs.add(part);
                    return soapInputs.toArray();
                }
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
        }
        if (this.inputMIMEParts.isEmpty()) {
            for (int i = 0; i < soapParts.size(); ++i) {
                Object value2;
                Part p = (Part)soapParts.get(i);
                String partName = p.getName();
                try {
                    value2 = inMsg.getObjectPart(partName);
                }
                catch (WSIFException e2) {
                    Trc.ignoredException(e2);
                    value2 = null;
                }
                if (this.inJmsProps.containsKey(partName) && dest != null) {
                    String name2 = (String)this.inJmsProps.get(partName);
                    if (this.timeoutProperty(dest, name2, value2)) continue;
                    dest.setProperty(name2, value2);
                    continue;
                }
                soapInputs.add(value2);
            }
        } else {
            List order = this.portTypeOperation.getInput().getMessage().getOrderedParts(null);
            Iterator it = order.iterator();
            while (it.hasNext()) {
                Object value3;
                Part p = (Part)it.next();
                String partName = p.getName();
                if (!soapParts.contains(p) && (!this.inputMIMEParts.contains(p) || "message".equals(this.operationStyle))) continue;
                try {
                    value3 = inMsg.getObjectPart(partName);
                }
                catch (WSIFException e3) {
                    Trc.ignoredException(e3);
                    value3 = null;
                }
                if (this.inJmsProps.containsKey(partName) && dest != null) {
                    String name3 = (String)this.inJmsProps.get(partName);
                    if (this.timeoutProperty(dest, name3, value3)) continue;
                    dest.setProperty(name3, value3);
                    continue;
                }
                if (value3 instanceof WSIFAttachmentPart) {
                    WSIFAttachmentPart ap = (WSIFAttachmentPart)value3;
                    soapInputs.add(ap.getDataHandler());
                    continue;
                }
                soapInputs.add(value3);
            }
        }
        return soapInputs.toArray();
    }

    private List addReferencedAttachments(WSIFMessage inMsg, Call call) throws WSIFException {
        Trc.entry(this, inMsg, call);
        ArrayList<AttachmentPart> attachments = new ArrayList<AttachmentPart>();
        for (int i = 0; i < this.inputMIMEParts.size(); ++i) {
            Part p = (Part)this.inputMIMEParts.get(i);
            try {
                String partName = p.getName();
                Object value2 = inMsg.getObjectPart(partName);
                AttachmentPart ap = MIMEHelper.getAttachementPart(value2);
                call.addAttachmentPart(ap);
                attachments.add(ap);
                continue;
            }
            catch (WSIFException e2) {
                throw new WSIFException("attachment part '" + p.getName() + "' not in input WSIFMessage");
            }
        }
        Trc.exit(attachments);
        return attachments;
    }

    private void addUnreferencedAttachments(WSIFMessage inMsg, Call call) throws WSIFException {
        Trc.entry(this, inMsg, call);
        if (WSIFProperties.areUnreferencedAttachmentsSupported()) {
            List l = null;
            try {
                WSIFMessage context = this.getContext();
                if (context != null) {
                    l = (List)context.getObjectPart("org.apache.wsif.attachments.request.unreferenced_attachment_parts");
                }
            }
            catch (Exception e2) {
                Trc.ignoredException(e2);
            }
            if (l != null && !l.isEmpty()) {
                ListIterator it = l.listIterator();
                while (it.hasNext()) {
                    Object next = it.next();
                    AttachmentPart ap = MIMEHelper.getAttachementPart(next);
                    call.addAttachmentPart(ap);
                }
            }
        }
        Trc.exit();
    }

    private void setOutputMessageValues(Object soapResponse, WSIFMessage outMsg) throws WSIFException {
        Trc.entry(this, soapResponse, outMsg);
        if (!(soapResponse instanceof List)) {
            throw new WSIFException("expect response type of java.util.List of SOAPBodyElement, found: " + soapResponse);
        }
        List al = (List)soapResponse;
        Iterator i = al.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof SOAPBodyElement) {
                Element e2;
                SOAPBodyElement sbe = (SOAPBodyElement)o;
                try {
                    e2 = sbe.getAsDOM();
                }
                catch (Exception ex) {
                    throw new WSIFException("excpetion extracting DOM Element from response" + ex.getLocalizedMessage(), ex);
                }
                outMsg.setName(e2.getLocalName());
                QName qn = new QName(e2.getNamespaceURI(), e2.getLocalName());
                Part p = this.findPart(this.outputSOAPParts, qn);
                if (p != null) {
                    outMsg.setObjectPart(p.getName(), e2);
                    continue;
                }
                if (!this.wsifPort.getBindingStyle().equals("rpc")) continue;
                this.context.setObjectPart("org.apache.wsif.soap.top.level.element.qname", qn);
                Iterator it = sbe.getChildElements();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof SOAPElement)) continue;
                    SOAPElement se = (SOAPElement)obj;
                    try {
                        e2 = se.getAsDOM();
                    }
                    catch (Exception ex) {
                        throw new WSIFException("exception extracting DOM Element from response child" + ex.getLocalizedMessage(), ex);
                    }
                    qn = new QName(e2.getNamespaceURI(), e2.getLocalName());
                    p = this.findPart(this.outputSOAPParts, qn);
                    if (p == null) continue;
                    outMsg.setObjectPart(p.getName(), e2);
                }
                continue;
            }
            throw new WSIFException("expecting response type of SOAPBodyElement, found: " + o);
        }
        Trc.exit(outMsg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setAttachmentPart(WSIFMessage outMsg, RequestResponse rr) throws WSIFException {
        Vector params;
        try {
            params = rr.getParams();
        }
        catch (SAXException e2) {
            throw new WSIFException("SAXException getting response MIME part: " + e2.getLocalizedMessage(), e2);
        }
        if (params == null || params.size() < 1) {
            throw new WSIFException("no attachments found in response element: " + rr);
        }
        ParamValue rpcParam = (ParamValue)params.get(0);
        QName qn = rpcParam.getQName();
        Part p = this.findPart(this.outputMIMEParts, qn);
        if (p == null) throw new WSIFException("cannot find a WSDL output MIME part for response element: " + rr);
        Object responseValue = rpcParam.getValue();
        if (!(responseValue instanceof AttachmentPart)) throw new WSIFException("expecting response AttachmentPart but found: " + responseValue);
        try {
            DataHandler attachment = ((AttachmentPart)responseValue).getDataHandler();
            String partName = p.getName();
            outMsg.setObjectPart(partName, attachment);
            return;
        }
        catch (SOAPException e3) {
            throw new WSIFException("SOAPException getting DataHandler from AttachmentPart: " + e3.getLocalizedMessage(), e3);
        }
    }

    private Part findPart(List partsList, QName partName) {
        Trc.entry(this, partsList, partName);
        Part part = null;
        Iterator i = partsList.iterator();
        while (i.hasNext() && part == null) {
            Part p = (Part)i.next();
            if (partName.equals(p.getElementName())) {
                part = p;
                continue;
            }
            if (partName.getLocalPart().equals(p.getName())) {
                part = p;
                continue;
            }
            if (p.getElementName() == null || !partName.getLocalPart().equals(p.getElementName().getLocalPart()) || !"message".equals(this.operationStyle) || partsList.size() != 1) continue;
            part = p;
        }
        Trc.exit(part);
        return part;
    }

    private void registerMIMETypes(List mimeParts, Call call) {
        if (mimeParts != null && !mimeParts.isEmpty()) {
            Iterator i = mimeParts.iterator();
            while (i.hasNext()) {
                Part p = (Part)i.next();
                QName type = this.getPartType(p);
                MIMEHelper.registerAttachmentType(call, type);
            }
        }
    }

    private void setResponseHandler(WSIFResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    WSIFResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public void setDefinition(Definition definition1) {
        Trc.entry((Object)this, definition1);
        throw new RuntimeException("method nolonger supported");
    }

    public void setDynamicWSIFPort(WSIFPort_SOAP wsifport_soap) {
        Trc.entry((Object)this, wsifport_soap);
        this.wsifPort = wsifport_soap;
        Trc.exit();
    }

    public void setInputEncodingStyle(String s) {
        Trc.entry((Object)this, s);
        this.inputEncodingStyle = s;
        Trc.exit();
    }

    public void setInputNamespace(String s) {
        Trc.entry((Object)this, s);
        this.inputNamespace = s;
        Trc.exit();
    }

    public void setOperation(Operation operation1) {
        Trc.entry((Object)this, operation1);
        this.portTypeOperation = operation1;
        Trc.exit();
    }

    public void setOutputEncodingStyle(String s) {
        Trc.entry((Object)this, s);
        this.outputEncodingStyle = s;
        Trc.exit();
    }

    public void setSoapActionURI(String s) {
        Trc.entry((Object)this, s);
        this.soapActionURI = s;
        Trc.exit();
    }

    private void setResponseMessageParameters(HashMap hm) {
        this.responseMessageParameters = hm;
    }

    private void setAsyncOperation(boolean b) {
        this.asyncOperation = b;
    }

    private void setOneWayOperation(boolean b) {
        this.oneWayOperation = b;
    }

    private boolean isOneWayOperation() {
        return this.oneWayOperation;
    }

    public String getTargetNamespaceURI() {
        Trc.entry(this);
        Definition d = this.getDefinition();
        String s = d == null ? "" : d.getTargetNamespace();
        Trc.exit(s);
        return s;
    }

    private void setJMSOutPropsInContext(WSIFJMSDestination dest) throws WSIFException {
        if (dest == null) {
            return;
        }
        HashMap props = dest.getProperties();
        if (props != null) {
            this.getContext().setParts(props);
        }
    }

    private void setDestinationContext(WSIFJMSDestination dest) throws WSIFException {
        if (dest == null) {
            return;
        }
        WSIFMessage context = this.getContext();
        HashMap<String, Object> jmsProps = new HashMap<String, Object>();
        Iterator i = context.getPartNames();
        while (i.hasNext()) {
            String partName = (String)i.next();
            try {
                Object value2 = context.getObjectPart(partName);
                if (this.timeoutProperty(dest, partName, value2) || !partName.startsWith("JMSProperty.")) continue;
                String propertyName = partName.substring("JMSProperty.".length());
                jmsProps.put(propertyName, value2);
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
        }
        if (jmsProps.size() > 0) {
            dest.setProperties(jmsProps);
        }
    }

    private void setCallContext(Call call, boolean asyncResponse) throws WSIFException {
        WSIFMessage context = this.getContext();
        if (!asyncResponse) {
            Object o;
            String name2 = "org.apache.wsif.http.UserName";
            try {
                o = context.getObjectPart(name2);
                if (o instanceof String) {
                    this.addHTTPHeader(call, name2, (String)o);
                }
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
            name2 = "org.apache.wsif.http.Password";
            try {
                o = context.getObjectPart(name2);
                if (o instanceof String) {
                    this.addHTTPHeader(call, name2, (String)o);
                }
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
            try {
                name2 = "org.apache.wsif.soap.RequestHeaders";
                o = context.getObjectPart(name2);
                if (o instanceof List) {
                    this.addSOAPHeader(call, (List)o);
                }
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
            o = null;
            try {
                name2 = "org.apache.wsif.http.RequestHeaders";
                o = context.getObjectPart(name2);
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
            if (o != null) {
                if (o != null && o instanceof Hashtable) {
                    call.setProperty("HTTP-Request-Headers", (Hashtable)o);
                } else {
                    throw new WSIFException("value type must be java.util.Hashtable for context part 'org.apache.wsif.http.RequestHeaders'");
                }
            }
            this.setProxyUserFromContext(context);
        }
        Iterator i = context.getPartNames();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value2 = context.getObjectPart(key);
            call.setProperty(key, value2);
        }
    }

    private void setProxyUserFromContext(WSIFMessage ctx) throws WSIFException {
        String pswd;
        String uid;
        block7: {
            uid = null;
            pswd = null;
            try {
                Object o = ctx.getObjectPart("org.apache.wsif.http.proxy.UserName");
                if (o != null) {
                    if (o instanceof String) {
                        uid = (String)o;
                    } else {
                        throw new WSIFException("invalid value type for context part 'org.apache.wsif.http.proxy.UserName', found value: " + o);
                    }
                }
                if ((o = ctx.getObjectPart("org.apache.wsif.http.proxy.Password")) == null) break block7;
                if (o instanceof String) {
                    pswd = (String)o;
                    break block7;
                }
                throw new WSIFException("invalid value type for context part 'org.apache.wsif.http.proxy.Password', found value: " + o);
            }
            catch (WSIFException e2) {
                Trc.ignoredException(e2);
            }
        }
        if (uid != null) {
            WebServicesProperties.setProperty("http.proxyUser", uid);
            WebServicesProperties.setProperty("http.proxyPassword", pswd);
        }
    }

    private void setResponseContext(Call call) throws WSIFException {
        Message m = call.getResponseMessage();
        if (m != null) {
            SOAPEnvelope env;
            try {
                env = m.getSOAPEnvelope();
            }
            catch (WebServicesFault e2) {
                throw new WSIFException("WebServicesFault getting response SOAP envelope", e2);
            }
            if (env != null) {
                SOAPHeader soapHeader;
                try {
                    soapHeader = env.getHeader();
                }
                catch (SOAPException e3) {
                    throw new WSIFException("SOAPException getting response headers from SOAP envelope", e3);
                }
                this.addContextResponseSOAPHeaders(soapHeader);
            }
        }
        Hashtable<String, Object> responseContextProperties = new Hashtable<String, Object>();
        MessageContext msgContext = call.getMessageContext();
        Iterator i = msgContext.getPropertyNames();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value2 = msgContext.getProperty(key);
            if (value2 == null || !(value2 instanceof Serializable) && !(value2 instanceof Cloneable)) continue;
            responseContextProperties.put(key, value2);
        }
        if (this.context != null) {
            this.context.setObjectPart("ResponseContextProperties", responseContextProperties);
        }
    }

    private void addSOAPHeader(Call call, List soapHeaders) throws WSIFException {
        SOAPFactory f;
        try {
            f = (SOAPFactory)SOAPFactory.newInstance();
        }
        catch (SOAPException e2) {
            throw new WSIFException("SOAPException getting SOAPFactory", e2);
        }
        Iterator i = soapHeaders.iterator();
        while (i.hasNext()) {
            SOAPHeaderElement she;
            Object o = i.next();
            if (!(o instanceof Element)) continue;
            try {
                she = f.createSOAPHeaderElement("", "");
                she.setAlternateContent((Element)o);
            }
            catch (SOAPException e3) {
                throw new WSIFException("SOAPException creating SOAPHeader", e3);
            }
            call.addHeader(she);
        }
    }

    private void addContextResponseSOAPHeaders(SOAPHeader soapHeader) throws WSIFException {
        if (soapHeader != null) {
            ArrayList<Element> headers = new ArrayList<Element>();
            Iterator i = soapHeader.getChildElements();
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof SOAPHeaderElement) {
                    SOAPHeaderElement she = (SOAPHeaderElement)o;
                    try {
                        headers.add(she.getAsDOM());
                        continue;
                    }
                    catch (Exception e2) {
                        throw new WSIFException("exception getting response SOAP header", e2);
                    }
                }
                Trc.event("unexpected response SOAP header type: ", o);
            }
            if (headers.size() > 0) {
                WSIFMessage context = this.getContext();
                context.setObjectPart("org.apache.wsif.soap.ResponseHeaders", headers);
                this.setContext(context);
            }
        }
    }

    private void addHTTPHeader(Call call, String name2, String value2) {
        if (name2.equals("org.apache.wsif.http.UserName")) {
            call.setProperty("javax.xml.rpc.security.auth.username", value2);
        } else if (name2.equals("org.apache.wsif.http.Password")) {
            call.setProperty("javax.xml.rpc.security.auth.password", value2);
        }
    }

    private void checkForTimeoutProperties(HashMap inJmsPropVals, WSIFJMSDestination dest) throws WSIFException {
        Iterator i = inJmsPropVals.keySet().iterator();
        while (i.hasNext()) {
            Object value2;
            String name2 = (String)i.next();
            if (!this.timeoutProperty(dest, name2, value2 = inJmsPropVals.get(name2))) continue;
            i.remove();
        }
    }

    private boolean timeoutProperty(WSIFJMSDestination dest, String propertyName, Object value2) throws WSIFException {
        boolean isTimeoutProperty = false;
        try {
            if ("wsif.syncrequest.timeout".equals(propertyName)) {
                isTimeoutProperty = true;
                Long syncTimeout = new Long(value2.toString());
                WSIFJmsTransport transport2 = (WSIFJmsTransport)this.getTransport();
                transport2.setSyncTimeout(syncTimeout);
                Trc.event(this, "overridding syncTimeout to " + syncTimeout);
            } else if ("wsif.asyncrequest.timeout".equals(propertyName)) {
                isTimeoutProperty = true;
                Long asyncTimeout = new Long(value2.toString());
                WSIFJmsTransport transport3 = (WSIFJmsTransport)this.getTransport();
                transport3.setAsyncTimeout(asyncTimeout);
                Trc.event(this, "overridding asyncTimeout to " + asyncTimeout);
            }
        }
        catch (NumberFormatException ex) {
            Trc.ignoredException(ex);
        }
        return isTimeoutProperty;
    }

    private static boolean isPrimitiveOf(Class clazz, Class primitive) {
        return primitive.equals(Boolean.TYPE) && Boolean.class.isAssignableFrom(clazz) || primitive.equals(Character.TYPE) && Character.class.isAssignableFrom(clazz) || primitive.equals(Byte.TYPE) && Byte.class.isAssignableFrom(clazz) || primitive.equals(Short.TYPE) && Short.class.isAssignableFrom(clazz) || primitive.equals(Integer.TYPE) && Integer.class.isAssignableFrom(clazz) || primitive.equals(Long.TYPE) && Long.class.isAssignableFrom(clazz) || primitive.equals(Float.TYPE) && Float.class.isAssignableFrom(clazz) || primitive.equals(Double.TYPE) && Double.class.isAssignableFrom(clazz);
    }

    void setAsyncRequestID(WSIFCorrelationId asyncRequestID) {
        Trc.entry((Object)this, asyncRequestID);
        this.asyncRequestID = asyncRequestID;
        Trc.exit();
    }

    public String getStyle() {
        return this.operationStyle;
    }

    public String getInputUse() {
        return this.inputUse;
    }

    protected void setInputUse(String inputUse) {
        this.inputUse = inputUse;
    }

    public String getOperationStyle() {
        return this.operationStyle;
    }

    public void setStyle(String style) {
        this.operationStyle = style;
    }

    public void setOperationStyle(String style) {
        this.operationStyle = style;
    }

    public String deep() {
        StringBuffer buff = new StringBuffer();
        try {
            buff.append(super.toString()).append(":\n");
            buff.append("wsifPort:").append(this.wsifPort);
            buff.append(" portTypeOperation:").append(Trc.brief(this.portTypeOperation));
            buff.append(" bindingOperation:").append(this.bindingOperation);
            buff.append(" soapOperation:").append(this.soapOperation);
            buff.append(" operationStyle:").append(this.operationStyle);
            buff.append(" inputSOAPParts:").append(this.inputSOAPParts);
            buff.append(" inputUnwrappedSOAPParts:").append(this.inputUnwrappedSOAPParts);
            buff.append(" inputMIMEParts:").append(this.inputMIMEParts);
            buff.append(" inputSOAPHeader:").append(this.inputSOAPHeader);
            buff.append(" inputSOAPHeaderFault:").append(this.inputSOAPHeaderFault);
            buff.append(" outputSOAPParts:").append(this.outputSOAPParts);
            buff.append(" outputUnwrappedSOAPParts:").append(this.outputUnwrappedSOAPParts);
            buff.append(" outputMIMEParts:").append(this.outputMIMEParts);
            buff.append(" outputSOAPHeader:").append(this.outputSOAPHeader);
            buff.append(" outputSOAPHeaderFault:").append(this.outputSOAPHeaderFault);
            buff.append(" inputEncodingStyle:").append(this.inputEncodingStyle);
            buff.append(" inputNamespace:").append(this.inputNamespace);
            buff.append(" actionUri:").append(this.soapActionURI);
            buff.append(" inJmsProps:").append(this.inJmsProps);
            buff.append(" outJmsProps:").append(this.outJmsProps);
            buff.append(" inJmsPropVals:").append(this.inJmsPropVals);
            buff.append(" context:").append(this.context);
            buff.append(" asyncOperation:").append(this.asyncOperation);
            buff.append(" asyncRequestID:").append(this.asyncRequestID);
            buff.append(" oneWayOperation:").append(this.oneWayOperation);
            buff.append(" responseHandler:").append(this.responseHandler);
            buff.append(" responseMessageParameters:").append(this.responseMessageParameters);
            buff.append(" outputEncodingStyle:").append(this.outputEncodingStyle);
            buff.append(" typeMap:").append(this.typeMap);
            buff.append(" faultsList:").append(this.faultsList);
        }
        catch (Exception e2) {
            Trc.exceptionInTrace(e2);
        }
        return buff.toString();
    }
}

