/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.providers.soap;

import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import java.util.Iterator;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPException;
import org.apache.wsif.WSIFException;
import org.apache.wsif.attachments.WSIFAttachmentPart;
import org.apache.wsif.logging.Trc;

public class WSIFSOAPUtils {
    public static AttachmentPart wsifToSoapAttachmentPart(WSIFAttachmentPart wsifAp) throws WSIFException {
        Trc.entry(null, wsifAp);
        AttachmentPart soapAp = new AttachmentPart(wsifAp.getDataHandler());
        Iterator it = wsifAp.getPropertyIterator();
        while (it.hasNext()) {
            String name2 = (String)it.next();
            soapAp.addMimeHeader(name2, wsifAp.getProperty(name2));
        }
        Trc.exit(soapAp);
        return soapAp;
    }

    public static WSIFAttachmentPart soapToWsifAttachmentPart(AttachmentPart soapAp) throws WSIFException {
        Trc.entry(null, soapAp);
        WSIFAttachmentPart wsifAp = null;
        try {
            wsifAp = new WSIFAttachmentPart(soapAp.getDataHandler());
        }
        catch (SOAPException se) {
            Trc.exception(se);
            throw new WSIFException("Could not convert WSIFAttachmentPart to Soap AttachmentPart. " + (Object)((Object)se));
        }
        Iterator it = soapAp.getAllMimeHeaders();
        while (it.hasNext()) {
            MimeHeader mh = (MimeHeader)it.next();
            wsifAp.setProperty(mh.getName(), mh.getValue());
        }
        Trc.exit(wsifAp);
        return wsifAp;
    }
}

