/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.providers.soap.jrom;

import com.ibm.jrom.JROMComplexValue;
import com.ibm.jrom.JROMException;
import com.ibm.jrom.JROMType;
import com.ibm.jrom.JROMValue;
import com.ibm.jrom.convertors.JROM2XML;
import com.ibm.jrom.factory.JROMFactory;
import com.ibm.jrom.util.ConvertorUtils;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingBase;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.wsif.logging.Trc;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class JROMSerializer
implements Serializer,
Serializable {
    protected static Log log = Trc.getLog(JROMSerializer.class.getName());
    protected JROMFactory jromFactory;
    protected SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd");
    protected JROMType jType;
    protected TypeMapping simpleTypeSMR;
    protected JROMComplexValue parent = null;
    protected QName xmlType;
    protected Class javaType;
    private static final Boolean SEND_TYPE = new Boolean(true);
    private Map jrom2SchemaMap = JROM2XML.createDefaultTypeMap();

    public JROMSerializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        try {
            this.jromFactory = (JROMFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws JROMException {
                    return JROMFactory.newInstance();
                }
            });
        }
        catch (PrivilegedActionException ex) {
            JROMException e2 = (JROMException)ex.getException();
            throw new RuntimeException(e2.getLocalizedMessage());
        }
    }

    public void serialize(QName name2, Attributes attributes2, Object value2, SerializationContext context) throws IOException {
        JROMValue jromEl = (JROMValue)value2;
        if (jromEl.getJROMType() != JROMType.JROM_COMPLEX_VALUE) {
            Object jromVal = ConvertorUtils.getSimpleJROMObject(jromEl);
            if (jromVal == null) {
                QName typeQName = (QName)this.jrom2SchemaMap.get(jromEl.getJROMType());
                context.serialize(name2, null, null, typeQName, true, SEND_TYPE);
                return;
            }
            if (jromEl.getJROMType() == JROMType.JROM_DURATION_VALUE) {
                attributes2 = this.setTypeAttr(attributes2, "xsd:duration");
                context.getSerializationWriter().simpleElement(name2, attributes2, ConvertorUtils.durationToString((int[])jromVal));
                return;
            }
            if (jromEl.getJROMType() == JROMType.JROM_DATE_VALUE) {
                attributes2 = this.setTypeAttr(attributes2, "xsd:date");
                jromVal = ((GregorianCalendar)jromVal).getTime();
                context.getSerializationWriter().simpleElement(name2, attributes2, this.zulu.format((Date)jromVal));
                return;
            }
            if (this.simpleTypeSMR == null) {
                this.simpleTypeSMR = ((TypeMappingBase)context.getTypeMapping()).getDelegate();
            }
            SerializerFactory serFac = (SerializerFactory)this.simpleTypeSMR.getSerializer(jromVal.getClass());
            Serializer ser = (Serializer)serFac.getSerializerAs("WebServices SAX Mechanism");
            ser.serialize(name2, attributes2, jromVal, context);
        } else {
            Iterator elements;
            JROMComplexValue jromComplex = (JROMComplexValue)jromEl;
            QName elementType = new QName(jromComplex.getTypeNamespace(), jromComplex.getTypeLocalPart());
            boolean isArrayName = elementType.getLocalPart().startsWith("ArrayOf");
            if (elementType.equals(Constants.SOAP_ARRAY) || isArrayName) {
                Object obj;
                attributes2 = this.setTypeAttr(attributes2, context.getSerializationWriter().qName2String(elementType));
                elements = jromComplex.getElementValues();
                if (!elements.hasNext()) {
                    throw new IllegalArgumentException("Currently, JROM does not support empty arrays");
                }
                QName arrayElType = null;
                JROMValue childElement = (JROMValue)elements.next();
                arrayElType = childElement.getJROMType() != JROMType.JROM_COMPLEX_VALUE ? (childElement.getJROMType() == JROMType.JROM_DURATION_VALUE ? new QName("http://www.w3.org/2001/XMLSchema", "duration") : ((obj = ConvertorUtils.getSimpleJROMObject(childElement)) != null ? context.getTypeMapping().getTypeQName(obj.getClass()) : (QName)this.jrom2SchemaMap.get(childElement.getJROMType()))) : new QName(((JROMComplexValue)childElement).getTypeNamespace(), ((JROMComplexValue)childElement).getTypeLocalPart());
                int numChildren = jromComplex.getNumElements();
                String prefix = context.getSerializationWriter().getOrCreatePrefix(arrayElType.getNamespaceURI(), null, true);
                String arrayType = prefix + ":" + arrayElType.getLocalPart();
                arrayType = arrayType + "[" + numChildren + "]";
                if (attributes2 != null && attributes2.getIndex(Constants.URI_DEFAULT_SOAP_ENC, "arrayType") == -1) {
                    String encprefix = context.getSerializationWriter().getOrCreatePrefix(Constants.URI_DEFAULT_SOAP_ENC, null, true);
                    AttributesImpl attrImpl = new AttributesImpl(attributes2);
                    attrImpl.addAttribute(Constants.URI_DEFAULT_SOAP_ENC, "arrayType", encprefix + ":" + "arrayType", "CDATA", arrayType);
                    attributes2 = attrImpl;
                }
            } else {
                attributes2 = this.setTypeAttr(attributes2, context.getSerializationWriter().qName2String(elementType));
            }
            context.startElement(name2, attributes2);
            elements = jromComplex.getElementValues();
            while (elements.hasNext()) {
                JROMValue el = (JROMValue)elements.next();
                QName elName = new QName(el.getNameNamespace(), el.getNameLocalPart());
                boolean nil = false;
                if (el.getJROMType() != JROMType.JROM_COMPLEX_VALUE) {
                    boolean bl = nil = ConvertorUtils.getSimpleJROMObject(el) == null;
                }
                if (nil) {
                    QName typeQName = (QName)this.jrom2SchemaMap.get(el.getJROMType());
                    context.serialize(elName, null, null, typeQName, true, SEND_TYPE);
                    continue;
                }
                context.serialize(elName, null, el);
            }
            context.endElement();
        }
    }

    private Attributes setTypeAttr(Attributes attributes2, String name2) {
        int typeAttrIdx;
        if (attributes2 == null) {
            attributes2 = new AttributesImpl();
        }
        if ((typeAttrIdx = attributes2.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type")) != -1) {
            ((AttributesImpl)attributes2).setAttribute(typeAttrIdx, "http://www.w3.org/2001/XMLSchema-instance", "type", "xsi:type", "CDATA", name2);
        } else {
            ((AttributesImpl)attributes2).addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi:type", "CDATA", name2);
        }
        return attributes2;
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }
}

