/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.providers.soap.ser;

import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.EnumDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.EnumSerializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsif.providers.soap.ser.BeanDescLite;
import com.ibm.ws.webservices.wsif.providers.soap.ser.BeanDescLiteSupplier;
import com.ibm.ws.webservices.wsif.providers.soap.ser.BeanSerializerFactory;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;

public class BeanDeserializerFactory
extends BaseDeserializerFactory
implements BeanDescLiteSupplier {
    protected BeanDesc beanDesc = null;
    protected TypeDesc typeDesc = null;
    protected Map propertyMap = null;

    public BeanDeserializerFactory(Class javaType, QName xmlType) {
        super(BeanDeserializer.class, xmlType, javaType);
        if (JavaUtils.isEnumClass(javaType)) {
            this.deserClass = EnumDeserializer.class;
        }
        Trc.event(this, "WSIF will check for WSADIE-gen Bean first");
        Object[] ret = BeanSerializerFactory.getPdFromWSADIEBean(javaType);
        if (ret != null) {
            if (Trc.ON) {
                Trc.event(this, "WSIF will use the TypeDesc class obtained from the Web Services engine");
            }
            this.typeDesc = (TypeDesc)ret[1];
            BeanPropertyDescriptor[] pd = (BeanPropertyDescriptor[])ret[0];
            this.beanDesc = BeanDescLite.getBeanDescForTypeDesc(this.typeDesc, pd, javaType);
            this.propertyMap = BeanDeserializerFactory.getProperties(javaType, this.beanDesc);
        } else {
            if (Trc.ON) {
                Trc.event(this, "WSIF will use the BeanDesc class obtained from the Web Services engine");
            }
            this.beanDesc = BeanDescLite.getBeanDescForClass(javaType);
            this.propertyMap = BeanDeserializerFactory.getProperties(javaType, this.beanDesc);
        }
    }

    public static Map getProperties(Class javaType, BeanDesc beanDesc) {
        if (Trc.ON) {
            Trc.event(BeanDeserializerFactory.class, "WSIF will create a new propertyMap");
        }
        HashMap<String, BeanPropertyDescriptor> propertyMap = null;
        if (beanDesc != null) {
            propertyMap = beanDesc.getPropertyDescriptorMap();
        } else {
            BeanPropertyDescriptor[] pd = BeanUtils.getPd(javaType, null);
            propertyMap = new HashMap<String, BeanPropertyDescriptor>();
            for (int i = 0; i < pd.length; ++i) {
                BeanPropertyDescriptor descriptor = pd[i];
                propertyMap.put(descriptor.getName(), descriptor);
            }
        }
        return propertyMap;
    }

    protected Deserializer getGeneralPurpose(String mechanismType) {
        if (this.javaType == null || this.xmlType == null) {
            return super.getGeneralPurpose(mechanismType);
        }
        if (this.deserClass == EnumSerializer.class) {
            return super.getGeneralPurpose(mechanismType);
        }
        if (this.beanDesc != null) {
            if (Trc.ON) {
                Trc.event(this, "WSIF will use the BeanDesc class for the Deserializer");
            }
            return new BeanDeserializer(this.javaType, this.xmlType, this.beanDesc);
        }
        if (Trc.ON) {
            Trc.event(this, "WSIF will use the propertyMap for the Deserializer");
        }
        return new BeanDeserializer(this.javaType, this.xmlType, null, this.propertyMap);
    }

    public BeanDescLite getBeanDescLite() {
        if (this.beanDesc != null && this.beanDesc instanceof BeanDescLite) {
            return (BeanDescLite)this.beanDesc;
        }
        return null;
    }
}

