/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.providers.soap.ser;

import com.ibm.ws.webservices.engine.description.ElementDesc;
import com.ibm.ws.webservices.engine.description.FieldDesc;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BeanSerializer;
import com.ibm.ws.webservices.engine.encoding.ser.EnumSerializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsif.providers.soap.ser.BeanDescLite;
import com.ibm.ws.webservices.wsif.providers.soap.ser.BeanDescLiteSupplier;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.apache.wsif.logging.Trc;

public class BeanSerializerFactory
extends BaseSerializerFactory
implements BeanDescLiteSupplier {
    protected TypeDesc typeDesc = null;
    protected BeanDesc beanDesc = null;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;

    public BeanSerializerFactory(Class javaType, QName xmlType) {
        super(BeanSerializer.class, xmlType, javaType);
        Object[] ret;
        if (JavaUtils.isEnumClass(javaType)) {
            Class clazz = this.serClass = EnumSerializer.class;
        }
        if (Trc.ON) {
            Trc.event(this, "WSIF will check for WSADIE-gen Bean first");
        }
        if ((ret = BeanSerializerFactory.getPdFromWSADIEBean(javaType)) != null) {
            if (Trc.ON) {
                Trc.event(this, "WSIF will use the TypeDesc class obtained from the Web Services engine");
            }
            this.propertyDescriptor = (BeanPropertyDescriptor[])ret[0];
            this.typeDesc = (TypeDesc)ret[1];
        } else {
            this.beanDesc = BeanDescLite.getBeanDescForClass(javaType);
            Trc.event(this, "WSIF obtained Bean Descriptor : " + this.beanDesc);
            if (this.beanDesc != null) {
                this.propertyDescriptor = this.beanDesc.getPropertyDescriptors();
                if (Trc.ON) {
                    Trc.event(this, "WSIF will use the BeanDesc class obtained from the Web Services engine");
                }
            } else {
                if (Trc.ON) {
                    Trc.event(this, "WSIF could not obtain the BeanDesc class from the Web Services engine. Processing continues, but there may be problems with the element names");
                }
                this.propertyDescriptor = BeanUtils.getPd(javaType, null);
            }
        }
    }

    public javax.xml.rpc.encoding.Serializer getSerializerAs(String mechanismType) throws JAXRPCException {
        return (Serializer)super.getSerializerAs(mechanismType);
    }

    protected Serializer getGeneralPurpose(String mechanismType) {
        if (this.javaType == null || this.xmlType == null) {
            return super.getGeneralPurpose(mechanismType);
        }
        if (this.serClass == EnumSerializer.class) {
            return super.getGeneralPurpose(mechanismType);
        }
        if (this.beanDesc != null) {
            return new BeanSerializer(this.javaType, this.xmlType, this.beanDesc);
        }
        return new BeanSerializer(this.javaType, this.xmlType, null, this.propertyDescriptor);
    }

    public BeanDescLite getBeanDescLite() {
        if (this.beanDesc != null && this.beanDesc instanceof BeanDescLite) {
            return (BeanDescLite)this.beanDesc;
        }
        return null;
    }

    static Object[] getPdFromWSADIEBean(Class javaTyp) {
        Trc.entry(null, javaTyp);
        final Class javaType = javaTyp;
        if (!BeanSerializerFactory.isIEBean(javaType.getSuperclass())) {
            Trc.exit();
            return null;
        }
        BeanPropertyDescriptor[] beanProps = null;
        TypeDesc newTypeDesc = new TypeDesc(javaType);
        FieldDesc[] fieldDescs = null;
        try {
            List props = (List)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Method getInfo = javaType.getMethod("properties", new Class[0]);
                    Object o = javaType.newInstance();
                    return getInfo.invoke(o, new Object[0]);
                }
            });
            ArrayList<BeanPropertyDescriptor> list = new ArrayList<BeanPropertyDescriptor>();
            ArrayList<ElementDesc> fieldDescList = new ArrayList<ElementDesc>();
            Iterator i = props.iterator();
            while (i.hasNext()) {
                String name2 = (String)i.next();
                String nameSpace = "";
                int index = name2.lastIndexOf("#");
                if (index != -1) {
                    nameSpace = name2.substring(0, name2.lastIndexOf("#"));
                    name2 = name2.substring(name2.lastIndexOf("#") + 1);
                }
                ElementDesc fieldDesc = new ElementDesc();
                fieldDesc.setXmlName(new QName(nameSpace, name2));
                fieldDesc.setXmlType(null);
                Trc.event(null, "WSIF will set the element name :" + name2);
                fieldDesc.setFieldName(name2);
                list.add(new BeanPropertyDescriptor(new PropertyDescriptor(name2, javaType)));
                fieldDescList.add(fieldDesc);
            }
            beanProps = list.toArray(new BeanPropertyDescriptor[0]);
            fieldDescs = fieldDescList.toArray(new FieldDesc[0]);
        }
        catch (Exception ex) {
            Trc.ignoredException(ex);
            Trc.exit(ex);
            return null;
        }
        if (beanProps == null) {
            Trc.exit(null);
            return null;
        }
        for (int i = 0; i < fieldDescs.length; ++i) {
            newTypeDesc.addFieldDesc(fieldDescs[i]);
        }
        Object[] ret = new Object[]{beanProps, newTypeDesc};
        Trc.exit(ret);
        return ret;
    }

    private static boolean isIEBean(Class c) {
        if (c == null) {
            return false;
        }
        if (c.getName().equals("com.ibm.wsif.format.jca.WSIFFormatPartImpl") || c.getName().equals("com.ibm.wsif.format.jca.WSIFFaultImpl")) {
            return true;
        }
        return BeanSerializerFactory.isIEBean(c.getSuperclass());
    }
}

