/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.schema;

import com.ibm.wsdl.util.xml.QNameUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.schema.ParserDelegate;
import org.apache.wsif.wsdl.WSIFWSDLLocatorImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ParserDelegateImpl
implements ParserDelegate,
Serializable {
    private static final QName schema1999 = new QName("http://www.w3.org/1999/XMLSchema", "schema");
    private static final QName schema2000 = new QName("http://www.w3.org/2000/10/XMLSchema", "schema");
    private static final QName schema2001 = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    private static final String SCHEMAS_LIST_PROPERTY = "org.apache.wsif.schema.parser.types";

    public void getTypesSchemas(Definition def, List schemas, WSDLLocator loc) throws WSIFException {
        if (loc == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            loc = new WSIFWSDLLocatorImpl((String)null, (String)null, cl);
        }
        this.getTypesSchemas(def, schemas, loc, new ArrayList(), new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTypesSchemas(Definition def, List schemas, WSDLLocator loc, List parsedXSDs, List parsedDefs) throws WSIFException {
        if (parsedDefs.contains(def)) {
            return;
        }
        Definition definition = def;
        synchronized (definition) {
            Types types = def.getTypes();
            if (types != null) {
                Iterator extEleIt = types.getExtensibilityElements().iterator();
                while (extEleIt.hasNext()) {
                    UnknownExtensibilityElement typesElement;
                    Element schemaEl;
                    Object tempElement = extEleIt.next();
                    if (tempElement instanceof Schema) {
                        Schema lightWeightSchema = (Schema)tempElement;
                        this.addSchema(lightWeightSchema, schemas, parsedXSDs);
                        continue;
                    }
                    if (!(tempElement instanceof UnknownExtensibilityElement) || !QNameUtils.matches(schema2001, schemaEl = (typesElement = (UnknownExtensibilityElement)tempElement).getElement()) && !QNameUtils.matches(schema2000, schemaEl) && !QNameUtils.matches(schema1999, schemaEl)) continue;
                    org.apache.wsif.schema.Schema sc = new org.apache.wsif.schema.Schema(schemaEl);
                    schemas.add(sc);
                    String docBase = def.getDocumentBaseURI();
                    if (docBase == null || loc == null) continue;
                    String[] imports = sc.getImports();
                    for (int i = 0; i < imports.length; ++i) {
                        String sl = imports[i];
                        this.getImportedSchemas(docBase, sl, loc, schemas, parsedXSDs, null);
                    }
                    String[] includes = sc.getIncludes();
                    String parentNamespace = sc.getTargetNamespace();
                    for (int i = 0; i < includes.length; ++i) {
                        String sl = includes[i];
                        this.getImportedSchemas(docBase, sl, loc, schemas, parsedXSDs, parentNamespace);
                    }
                }
            }
            parsedDefs.add(def);
            Map imports = def.getImports();
            if (imports != null) {
                Iterator valueIterator = imports.values().iterator();
                while (valueIterator.hasNext()) {
                    List importList = (List)valueIterator.next();
                    if (importList == null) continue;
                    Iterator importIterator = importList.iterator();
                    while (importIterator.hasNext()) {
                        Import tempImport = (Import)importIterator.next();
                        if (tempImport == null) continue;
                        Definition importedDef = tempImport.getDefinition();
                        if (importedDef != null) {
                            this.getTypesSchemas(importedDef, schemas, loc, parsedXSDs, parsedDefs);
                            continue;
                        }
                        String baseLoc = def.getDocumentBaseURI();
                        String importLoc = tempImport.getLocationURI();
                        if (baseLoc == null || importLoc == null || loc == null) continue;
                        this.getImportedSchemas(baseLoc, importLoc, loc, schemas, parsedXSDs, null);
                    }
                }
            }
        }
    }

    private void addSchema(Schema sch, List schemaList, List parsedXSDs) throws WSIFException {
        if (sch == null || this.alreadyParsed(sch, parsedXSDs)) {
            return;
        }
        Element schemaEl = sch.getElement();
        if (QNameUtils.matches(schema2001, schemaEl) || QNameUtils.matches(schema2000, schemaEl) || QNameUtils.matches(schema1999, schemaEl)) {
            List redefines;
            List includes;
            SchemaReference schRef;
            org.apache.wsif.schema.Schema sc = new org.apache.wsif.schema.Schema(schemaEl);
            schemaList.add(sc);
            parsedXSDs.add(sch);
            Map xsdImports = sch.getImports();
            if (xsdImports != null) {
                Iterator importsIt = xsdImports.values().iterator();
                while (importsIt.hasNext()) {
                    List xsdList = (List)importsIt.next();
                    if (xsdList.size() <= 0) continue;
                    for (int i = 0; i < xsdList.size(); ++i) {
                        schRef = (SchemaReference)xsdList.get(i);
                        if (schRef == null) continue;
                        Schema importedSch = schRef.getReferencedSchema();
                        this.addSchema(importedSch, schemaList, parsedXSDs);
                    }
                }
            }
            if ((includes = sch.getIncludes()) != null) {
                Iterator includesIt = includes.iterator();
                while (includesIt.hasNext()) {
                    SchemaReference schRef2 = (SchemaReference)includesIt.next();
                    if (schRef2 == null) continue;
                    Schema includedSch = schRef2.getReferencedSchema();
                    this.addSchema(includedSch, schemaList, parsedXSDs);
                }
            }
            if ((redefines = sch.getRedefines()) != null) {
                Iterator redefinesIt = includes.iterator();
                while (redefinesIt.hasNext()) {
                    schRef = (SchemaReference)redefinesIt.next();
                    if (schRef == null) continue;
                    Schema redefinedSch = schRef.getReferencedSchema();
                    this.addSchema(redefinedSch, schemaList, parsedXSDs);
                }
            }
        }
    }

    private boolean alreadyParsed(Schema sch, List list) {
        boolean seen = false;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj != sch) continue;
            seen = true;
            break;
        }
        return seen;
    }

    private void getImportedSchemas(String base, String rel, WSDLLocator loc, List schemaList, List parsedXSDs, String parentNamespace) throws WSIFException {
        try {
            if (rel.startsWith("http://schemas.xmlsoap.org")) {
                return;
            }
            InputSource inputSource = loc.getImportInputSource(base, rel);
            if (inputSource == null) {
                if (Trc.isDebugEnabled()) {
                    Trc.event(this, "ParserDelegateImpl was unable to locate schema file " + rel + " relative to " + base);
                }
                throw new WSIFException("Unable to locate schema file " + rel + " relative to " + base);
            }
            String lastURI = loc.getLatestImportURI();
            if (parsedXSDs.contains(lastURI)) {
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inputSource);
            if (inputSource.getCharacterStream() != null) {
                inputSource.getCharacterStream().close();
            } else if (inputSource.getByteStream() != null) {
                inputSource.getByteStream().close();
            }
            Element el = doc.getDocumentElement();
            if (el != null && (QNameUtils.matches(schema2001, el) || QNameUtils.matches(schema2000, el) || QNameUtils.matches(schema1999, el))) {
                org.apache.wsif.schema.Schema sc = new org.apache.wsif.schema.Schema(el, parentNamespace);
                schemaList.add(sc);
                parsedXSDs.add(lastURI);
                String[] imports = sc.getImports();
                for (int i = 0; i < imports.length; ++i) {
                    String sl = imports[i];
                    this.getImportedSchemas(lastURI, sl, loc, schemaList, parsedXSDs, null);
                }
                String[] includes = sc.getIncludes();
                String newParentNamespace = sc.getTargetNamespace();
                for (int i = 0; i < includes.length; ++i) {
                    String sl = includes[i];
                    this.getImportedSchemas(lastURI, sl, loc, schemaList, parsedXSDs, newParentNamespace);
                }
            }
        }
        catch (Exception e2) {
            Trc.exception(e2);
            if (e2 instanceof WSIFException) {
                throw (WSIFException)e2;
            }
            throw new WSIFException("Error when getting imported schemas", e2);
        }
    }
}

