/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.confimpl;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSAlgorithmFactory;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.CollectionCertStore;
import com.ibm.ws.webservices.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class PrivateGeneratorConfig
extends PrivateCommonConfig
implements WSSGeneratorConfig {
    private static final TraceComponent tc = Tr.register(PrivateGeneratorConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PrivateGeneratorConfig.class.getName();
    protected String _myActor = null;
    protected String _targetActor = null;
    protected boolean _indentation = false;
    protected final Set _allowedTransforms = new HashSet();
    protected final Set _allowedCanonicalizationMethods = new HashSet();
    protected final Set _allowedSignatureMethods = new HashSet();
    protected final Set _allowedDigestMethods = new HashSet();
    protected final Set _allowedDataEncryptionMethods = new HashSet();
    protected final Set _allowedKeyEncryptionMethods = new HashSet();
    protected final WSSAlgorithmFactory _algorithmFactory = (WSSAlgorithmFactory)WSSAlgorithmFactory.getInstance();
    protected final Set _defaultKeyInfoContentGenerators = new HashSet();
    protected final Set _defaultTokenGenerators = new HashSet();
    protected final Set _defaultCallbackHandlers = new HashSet();
    protected final Set _defaultKeyLocators = new HashSet();
    protected boolean _userDefinedComponentsUsed = false;
    protected boolean _signatureEnabled = false;
    protected boolean _encryptionEnabled = false;
    protected boolean _tokenEnabled = false;
    protected boolean _timestampEnabled = false;
    protected final List _integralParts = new ArrayList();
    protected final List _confidentialParts = new ArrayList();
    protected final List _securityTokens = new ArrayList();
    protected final List _operationGenerators = new ArrayList();
    protected final Set _tokenGenerators = new HashSet();
    protected NonceManager _nonceManager = null;
    protected Map _properties = null;
    protected TimestampGeneratorConfImpl _timestampGenerator = null;
    protected boolean _clientSetMustUnderstand = true;
    protected boolean _serviceGetMustUnderstand = true;
    protected boolean _checkCacheUnt = false;

    protected void processPrivateConfig(Document document) throws SoapSecurityException {
        String string;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processPrivateConfig(Document pconfig[" + document + "])");
        }
        boolean bl = false;
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is true; getting FIPS algorithms");
            }
            bl = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is false; getting non-FIPS algorithms");
            }
            bl = false;
        }
        NodeList nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "Transform");
        int n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)nodeList.item(n), "algorithm");
            this._allowedTransforms.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed Transforms:", new Object[]{this._allowedTransforms});
        }
        if (this._allowedTransforms.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s11");
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "canonicalizationMethod");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)nodeList.item(n), "algorithm");
            this._allowedCanonicalizationMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed canonicalizationMethods:", new Object[]{this._allowedCanonicalizationMethods});
        }
        if (this._allowedCanonicalizationMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s12");
        }
        nodeList = bl ? document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsSignatureMethod") : document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "signatureMethod");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)nodeList.item(n), "algorithm");
            this._allowedSignatureMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed signatureMethods:", new Object[]{this._allowedSignatureMethods});
        }
        if (this._allowedSignatureMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s13");
        }
        nodeList = bl ? document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsDigestMethod") : document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "digestMethod");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)nodeList.item(n), "algorithm");
            this._allowedDigestMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed digestMethods:", new Object[]{this._allowedDigestMethods});
        }
        if (this._allowedDigestMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s14");
        }
        nodeList = bl ? document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsEncryptionMethod") : document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "encryptionMethod");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)nodeList.item(n), "algorithm");
            this._allowedDataEncryptionMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed encryptionMethods:", new Object[]{this._allowedDataEncryptionMethods});
        }
        if (this._allowedDataEncryptionMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s15");
        }
        nodeList = bl ? document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsKeyEncryptionMethod") : document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "keyEncryptionMethod");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)nodeList.item(n), "algorithm");
            if (!ConfigValidation.isAlgoSupportedByRuntime(string)) continue;
            this._allowedKeyEncryptionMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed keyEncryptionMethods:", new Object[]{this._allowedKeyEncryptionMethods});
        }
        if (this._allowedKeyEncryptionMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s16");
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "KeyInfoContentGenerator");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)nodeList.item(n), "class");
            this._defaultKeyInfoContentGenerators.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default KeyInfoContentGenerator:", new Object[]{this._defaultKeyInfoContentGenerators});
        }
        if (this._defaultKeyInfoContentGenerators.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6715W");
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "TokenGenerator");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)nodeList.item(n), "class");
            this._defaultTokenGenerators.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default TokenGenerator:", new Object[]{this._defaultTokenGenerators});
        }
        if (this._defaultTokenGenerators.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6716W");
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "CallbackHandler");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)nodeList.item(n), "class");
            this._defaultCallbackHandlers.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default CallbackHandler:", new Object[]{this._defaultCallbackHandlers});
        }
        if (this._defaultCallbackHandlers.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6717W");
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "KeyLocator");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)nodeList.item(n), "class");
            this._defaultKeyLocators.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default KeyLocator:", new Object[]{this._defaultKeyLocators});
        }
        if (this._defaultKeyLocators.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6714W");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processPrivateConfig(Document pconfig)");
        }
    }

    public void validate() throws SoapSecurityException {
        this.validate(false);
    }

    public void validate(boolean bl) throws SoapSecurityException {
        block72: {
            block73: {
                TokenGeneratorConfImpl tokenGeneratorConfImpl;
                int n;
                String string;
                String string2;
                PrivateCommonConfig.PartConfImpl partConfImpl;
                Iterator iterator;
                PrivateCommonConfig.ReferencePartConfImpl referencePartConfImpl;
                int n2;
                int n3;
                int n4;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "validate(boolean defaultConfig[" + bl + "])");
                }
                HashSet<PrivateCommonConfig.ReferencePartConfImpl> hashSet = new HashSet<PrivateCommonConfig.ReferencePartConfImpl>();
                HashSet<PrivateCommonConfig.ReferencePartConfImpl> hashSet2 = new HashSet<PrivateCommonConfig.ReferencePartConfImpl>();
                Iterator iterator2 = this._integralParts.iterator();
                while (iterator2.hasNext()) {
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                    referencePartConfImpl = (PrivateCommonConfig.ReferencePartConfImpl)iterator2.next();
                    referencePartConfImpl.validate();
                    iterator = referencePartConfImpl._parts.iterator();
                    while (iterator.hasNext()) {
                        partConfImpl = (PrivateCommonConfig.PartConfImpl)iterator.next();
                        partConfImpl.validate();
                        if (partConfImpl.isNonce()) {
                            ++n3;
                        } else if (partConfImpl.isTimestamp()) {
                            ++n2;
                        } else {
                            ++n4;
                        }
                        string2 = partConfImpl._dialect;
                        string = partConfImpl._keyword;
                        if (Constants.DIALECT_WAS.equals(string2)) {
                            n = ConfigUtil.isIntegralWASDialect(string);
                            if (n == 1) {
                                if (partConfImpl.isTimestamp()) {
                                    throw SoapSecurityException.format("security.wssecurity.TimestampGenerator.s02");
                                }
                                if (this._timestampGenerator == null) continue;
                                TimestampGeneratorConfImpl timestampGeneratorConfImpl = this._timestampGenerator;
                                timestampGeneratorConfImpl._signed = true;
                                continue;
                            }
                            if (n == 3) {
                                hashSet.add(referencePartConfImpl);
                                continue;
                            }
                            if (n == 4) {
                                hashSet2.add(referencePartConfImpl);
                                continue;
                            }
                            if (n >= 0) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", string, partConfImpl.toString());
                        }
                        if (Constants.DIALECT_FUNCTION.equals(string2)) {
                            if (string != null) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", string2, partConfImpl.toString());
                        }
                        if (Constants.DIALECT_XPATH.equals(string2)) {
                            if (string != null) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", string2, partConfImpl.toString());
                        }
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", string2, partConfImpl.toString());
                    }
                    if (n3 <= 0 && n2 <= 0 || n4 > 0) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s36");
                }
                iterator2 = this._confidentialParts.iterator();
                while (iterator2.hasNext()) {
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                    referencePartConfImpl = (PrivateCommonConfig.ReferencePartConfImpl)iterator2.next();
                    referencePartConfImpl.validate();
                    iterator = referencePartConfImpl._parts.iterator();
                    while (iterator.hasNext()) {
                        partConfImpl = (PrivateCommonConfig.PartConfImpl)iterator.next();
                        partConfImpl.validate();
                        if (partConfImpl.isNonce()) {
                            ++n3;
                        } else if (partConfImpl.isTimestamp()) {
                            ++n2;
                        } else {
                            ++n4;
                        }
                        string2 = partConfImpl._dialect;
                        string = partConfImpl._keyword;
                        if (Constants.DIALECT_WAS.equals(string2)) {
                            if (ConfigUtil.isConfidentialWASDialect(string) >= 0) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", string, partConfImpl.toString());
                        }
                        if (Constants.DIALECT_FUNCTION.equals(string2)) {
                            if (string != null) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", string2, partConfImpl.toString());
                        }
                        if (Constants.DIALECT_XPATH.equals(string2)) {
                            if (string != null) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", string2, partConfImpl.toString());
                        }
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", string2, partConfImpl.toString());
                    }
                    if (n3 <= 0 && n2 <= 0 || n4 > 0) continue;
                    String string3 = " If there is one or more Nonce or timestamp that need to be encrypted, also specify a MessagePart that needs to be encrypted ";
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s36");
                }
                if (bl) {
                    HashMap<QName, TokenGeneratorConfImpl> hashMap = new HashMap<QName, TokenGeneratorConfImpl>();
                    iterator2 = this._tokenGenerators.iterator();
                    while (iterator2.hasNext()) {
                        tokenGeneratorConfImpl = (TokenGeneratorConfImpl)iterator2.next();
                        hashMap.put(tokenGeneratorConfImpl.getType(), tokenGeneratorConfImpl);
                    }
                    iterator2 = this._securityTokens.iterator();
                    while (iterator2.hasNext()) {
                        tokenGeneratorConfImpl = (TokenGeneratorConfImpl)iterator2.next();
                        QName qName = tokenGeneratorConfImpl.getType();
                        TokenGeneratorConfImpl tokenGeneratorConfImpl2 = (TokenGeneratorConfImpl)hashMap.get(qName);
                        if (tokenGeneratorConfImpl2 == null) {
                            String string4 = "There is a security token that does not have a matching token generator. Its name is [" + tokenGeneratorConfImpl._name + "] and its type is [" + qName + "]";
                            throw new SoapSecurityException(string4);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Found token generator of type [" + qName + "].");
                    }
                } else {
                    iterator2 = this._securityTokens.iterator();
                    while (iterator2.hasNext()) {
                        tokenGeneratorConfImpl = (TokenGeneratorConfImpl)iterator2.next();
                        if (!this._tokenGenerators.contains(tokenGeneratorConfImpl)) {
                            String string5 = "There is the security token that no token generator references. Its name is [" + tokenGeneratorConfImpl._name + "].";
                            throw new SoapSecurityException(string5);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Found token generator in _tokenGenerators: " + tokenGeneratorConfImpl);
                    }
                }
                ArrayList<EncryptionGeneratorConfImpl> arrayList = new ArrayList<EncryptionGeneratorConfImpl>();
                iterator2 = this._operationGenerators.iterator();
                while (iterator2.hasNext()) {
                    EncryptionGeneratorConfImpl encryptionGeneratorConfImpl;
                    KeyInfoContentGeneratorConfImpl keyInfoContentGeneratorConfImpl;
                    KeyInfoGeneratorConfImpl keyInfoGeneratorConfImpl;
                    PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl;
                    Object e2 = iterator2.next();
                    if (e2 instanceof SignatureGeneratorConfig) {
                        Iterator iterator3;
                        SignatureGeneratorConfImpl signatureGeneratorConfImpl = (SignatureGeneratorConfImpl)e2;
                        signatureGeneratorConfImpl.validate(bl);
                        algorithmConfImpl = signatureGeneratorConfImpl._canonicalizationMethod;
                        if (algorithmConfImpl != null) {
                            algorithmConfImpl.validate();
                            if (!this._allowedCanonicalizationMethods.contains(algorithmConfImpl._algorithm)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s08", algorithmConfImpl._algorithm);
                            }
                        }
                        algorithmConfImpl = signatureGeneratorConfImpl._signatureMethod;
                        boolean bl2 = false;
                        String string6 = null;
                        if (algorithmConfImpl != null) {
                            algorithmConfImpl.validate();
                            if (!this._allowedSignatureMethods.contains(algorithmConfImpl._algorithm)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s09", algorithmConfImpl._algorithm);
                            }
                            string6 = algorithmConfImpl._algorithm;
                            bl2 = ConfigUtil.isSecretKeyAlgorithm(string6);
                        }
                        if ((algorithmConfImpl = signatureGeneratorConfImpl._keyInfoSignature) != null) {
                            algorithmConfImpl.validate();
                            if (ConfigUtil.isKeyInfoSignature(algorithmConfImpl._algorithm) < 0) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s10", algorithmConfImpl._algorithm);
                            }
                        }
                        PrivateCommonConfig.ReferencePartConfImpl referencePartConfImpl2 = null;
                        iterator = signatureGeneratorConfImpl._references.iterator();
                        while (iterator.hasNext()) {
                            PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl = (PrivateCommonConfig.SigningReferenceConfImpl)iterator.next();
                            signingReferenceConfImpl.validate(bl);
                            algorithmConfImpl = signingReferenceConfImpl._digestMethod;
                            if (algorithmConfImpl != null) {
                                algorithmConfImpl.validate();
                                if (!this._allowedDigestMethods.contains(algorithmConfImpl._algorithm)) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s11", algorithmConfImpl._algorithm);
                                }
                            }
                            boolean bl3 = false;
                            iterator3 = signingReferenceConfImpl._transforms.iterator();
                            while (iterator3.hasNext()) {
                                algorithmConfImpl = (PrivateCommonConfig.AlgorithmConfImpl)iterator3.next();
                                algorithmConfImpl.validate();
                                if (!this._allowedTransforms.contains(algorithmConfImpl._algorithm)) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s12", algorithmConfImpl._algorithm);
                                }
                                if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(algorithmConfImpl._algorithm)) {
                                    bl3 = true;
                                    continue;
                                }
                                if (!"http://www.w3.org/TR/1999/REC-xpath-19991116".equals(algorithmConfImpl._algorithm) || (string = ConfigUtil.trim((String)algorithmConfImpl._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_XPATH_EXPRESSION))) != null && string.length() != 0) continue;
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s27");
                            }
                            if (!bl3 || referencePartConfImpl2 != null) continue;
                            if (hashSet.contains(signingReferenceConfImpl._reference)) {
                                referencePartConfImpl2 = signingReferenceConfImpl._reference;
                                continue;
                            }
                            if (!hashSet2.contains(signingReferenceConfImpl._reference)) continue;
                            referencePartConfImpl2 = signingReferenceConfImpl._reference;
                        }
                        keyInfoGeneratorConfImpl = signatureGeneratorConfImpl._signingKeyInfo;
                        keyInfoGeneratorConfImpl.validate();
                        keyInfoContentGeneratorConfImpl = keyInfoGeneratorConfImpl._contentGenerator;
                        keyInfoContentGeneratorConfImpl.validate();
                        if (ConfigUtil.isKeyInfoType(keyInfoContentGeneratorConfImpl._keyInfoType) < 0) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s13", keyInfoContentGeneratorConfImpl.toString());
                        }
                        if (bl2) {
                            if (ConfigUtil.isKeyInfoEmb(keyInfoContentGeneratorConfImpl._keyInfoType)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", string6, keyInfoContentGeneratorConfImpl._keyInfoType);
                            }
                            if (ConfigUtil.isKeyInfoX509issuer(keyInfoContentGeneratorConfImpl._keyInfoType)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", string6, keyInfoContentGeneratorConfImpl._keyInfoType);
                            }
                        } else if (referencePartConfImpl2 != null && keyInfoContentGeneratorConfImpl._tokenGenerator == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s35");
                        }
                        iterator3 = arrayList.iterator();
                        while (iterator3.hasNext()) {
                            encryptionGeneratorConfImpl = (EncryptionGeneratorConfImpl)iterator3.next();
                            encryptionGeneratorConfImpl._sigAfterEnc = true;
                        }
                        continue;
                    }
                    if (e2 instanceof EncryptionGeneratorConfig) {
                        encryptionGeneratorConfImpl = (EncryptionGeneratorConfImpl)e2;
                        encryptionGeneratorConfImpl.validate(bl);
                        algorithmConfImpl = encryptionGeneratorConfImpl._dataEncryptionMethod;
                        algorithmConfImpl.validate();
                        if (!this._allowedDataEncryptionMethods.contains(algorithmConfImpl._algorithm)) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s14", algorithmConfImpl._algorithm);
                        }
                        String string7 = algorithmConfImpl._algorithm;
                        boolean bl4 = ConfigUtil.isSecretKeyAlgorithm(string7);
                        algorithmConfImpl = encryptionGeneratorConfImpl._keyEncryptionMethod;
                        if (algorithmConfImpl != null) {
                            algorithmConfImpl.validate();
                            if (!this._allowedKeyEncryptionMethods.contains(algorithmConfImpl._algorithm)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s15", algorithmConfImpl._algorithm);
                            }
                            string7 = algorithmConfImpl._algorithm;
                            bl4 = ConfigUtil.isSecretKeyAlgorithm(string7);
                        }
                        keyInfoGeneratorConfImpl = encryptionGeneratorConfImpl._encryptionKeyInfo;
                        keyInfoGeneratorConfImpl.validate();
                        keyInfoContentGeneratorConfImpl = keyInfoGeneratorConfImpl._contentGenerator;
                        keyInfoContentGeneratorConfImpl.validate();
                        if (ConfigUtil.isKeyInfoType(keyInfoContentGeneratorConfImpl._keyInfoType) < 0) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s13", keyInfoContentGeneratorConfImpl.toString());
                        }
                        if (bl4) {
                            if (ConfigUtil.isKeyInfoEmb(keyInfoContentGeneratorConfImpl._keyInfoType)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", string7, keyInfoContentGeneratorConfImpl._keyInfoType);
                            }
                            if (ConfigUtil.isKeyInfoX509issuer(keyInfoContentGeneratorConfImpl._keyInfoType)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", string7, keyInfoContentGeneratorConfImpl._keyInfoType);
                            }
                        }
                        arrayList.add(encryptionGeneratorConfImpl);
                        continue;
                    }
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s01", this.toString());
                }
                iterator2 = this._tokenGenerators.iterator();
                while (iterator2.hasNext()) {
                    tokenGeneratorConfImpl = (TokenGeneratorConfImpl)iterator2.next();
                    tokenGeneratorConfImpl.validate();
                    CallbackHandlerConfImpl callbackHandlerConfImpl = tokenGeneratorConfImpl._callbackHandler;
                    if (callbackHandlerConfImpl != null) {
                        callbackHandlerConfImpl.validate();
                        PrivateCommonConfig.KeyStoreConfImpl keyStoreConfImpl = callbackHandlerConfImpl._keyStoreConfig;
                        if (keyStoreConfImpl != null) {
                            keyStoreConfImpl.validate();
                        }
                        iterator2 = callbackHandlerConfImpl._keyInformationList.iterator();
                        while (iterator2.hasNext()) {
                            PrivateCommonConfig.KeyInformationConfImpl keyInformationConfImpl = (PrivateCommonConfig.KeyInformationConfImpl)iterator2.next();
                            keyInformationConfImpl.validate();
                        }
                    }
                    if (!tokenGeneratorConfImpl._standAlone) continue;
                    if (tokenGeneratorConfImpl._usedForSignature) {
                        tokenGeneratorConfImpl._standAlone = false;
                        String string8 = "The token generator [" + tokenGeneratorConfImpl._name + "] that refers to the security token in DD is used for signature." + " The security token should be used for \"stand-alone\" tokens.  Please check the configuration.";
                        throw new SoapSecurityException(string8);
                    }
                    if (!tokenGeneratorConfImpl._usedForEncryption) continue;
                    tokenGeneratorConfImpl._standAlone = false;
                    if (!tc.isDebugEnabled()) continue;
                    String string9 = "The token generator [" + tokenGeneratorConfImpl._name + "] that refers to the security token in DD is used for encryption." + " The security token should be used for \"stand-alone\" tokens.  Please check the configuration.";
                    throw new SoapSecurityException(string9);
                }
                if (this._timestampGenerator == null) break block72;
                this._timestampGenerator.validate();
                String string10 = (String)this._timestampGenerator._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_SOAPHEADER);
                if (string10 != null) {
                    this._timestampGenerator._headerAttribute = ConfigUtil.isTrue(string10);
                    this._timestampGenerator._soapHeader = true;
                }
                if ((string10 = (String)this._timestampGenerator._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_DIALECT)) == null) break block72;
                if (!Constants.DIALECT_WAS.equals(string10)) break block73;
                string10 = (String)this._timestampGenerator._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_KEYWORD);
                if (string10 == null) break block72;
                n = ConfigUtil.isTimestampWASDialect(string10);
                switch (n) {
                    case 1: {
                        break block72;
                    }
                    case 2: 
                    case 3: {
                        this._timestampGenerator._soapHeader = true;
                    }
                    case 0: {
                        this._timestampGenerator._default = false;
                        break block72;
                    }
                    default: {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", string10, this._timestampGenerator.toString());
                    }
                }
            }
            this._timestampGenerator._default = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate(boolean)");
        }
    }

    public boolean getServiceGetMustUnderstand() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceGetMustUnderstand");
            Tr.exit(tc, "getServiceGetMustUnderstand=" + this._serviceGetMustUnderstand);
        }
        return this._serviceGetMustUnderstand;
    }

    public boolean getClientSetMustUnderstand() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientSetMustUnderstand");
            Tr.exit(tc, "getClientSetMustUnderstand=" + this._clientSetMustUnderstand);
        }
        return this._clientSetMustUnderstand;
    }

    public boolean getCheckCacheUnt() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCheckCacheUnt");
            Tr.exit(tc, "getCheckCacheUnt=" + this._checkCacheUnt);
        }
        return this._checkCacheUnt;
    }

    public String getMyActor() {
        return this._myActor;
    }

    public String getTargetActor() {
        return this._targetActor;
    }

    public boolean doIndentation() {
        return this._indentation;
    }

    public void setIndentation(boolean bl) {
        this._indentation = bl;
    }

    public Set getAllowedTransforms() {
        return this._allowedTransforms;
    }

    public Set getAllowedCanonicalizationMethods() {
        return this._allowedCanonicalizationMethods;
    }

    public Set getAllowedSignatureMethods() {
        return this._allowedSignatureMethods;
    }

    public Set getAllowedDigestMethods() {
        return this._allowedDigestMethods;
    }

    public Set getAllowedDataEncryptionMethods() {
        return this._allowedDataEncryptionMethods;
    }

    public Set getAllowedKeyEncryptionMethods() {
        return this._allowedKeyEncryptionMethods;
    }

    public WSSAlgorithmFactory getAlgorithmFactory() {
        return this._algorithmFactory;
    }

    public boolean isSignatureEnabled() {
        return this._signatureEnabled;
    }

    public boolean isEncryptionEnabled() {
        return this._encryptionEnabled;
    }

    public boolean isTokenEnabled() {
        return this._tokenEnabled;
    }

    public boolean isTimestampEnabled() {
        return this._timestampEnabled;
    }

    public List getIntegralParts() {
        return this._integralParts;
    }

    public List getConfidentialParts() {
        return this._confidentialParts;
    }

    public List getOperationGenerators() {
        return this._operationGenerators;
    }

    public Set getTokenGenerators() {
        return this._tokenGenerators;
    }

    public TimestampGeneratorConfig getTimestampGenerator() {
        return this._timestampGenerator;
    }

    public NonceManager getNonceManager() {
        return this._nonceManager;
    }

    public boolean isUserDefinedComponentsUsed() {
        return this._userDefinedComponentsUsed;
    }

    public Map getProperties() {
        return this._properties;
    }

    public Object getProperty(Object object) {
        if (this._properties != null) {
            return this._properties.get(object);
        }
        return null;
    }

    protected String getLogProperties(Map map, Map map2, Map map3, String string) {
        String string2 = null;
        if (tc.isDebugEnabled()) {
            string2 = super.getLogProperties(map, map2, map3, this._properties, string, "generator");
        }
        return string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
        stringBuffer.append("myActor=[").append(this._myActor).append("], ");
        stringBuffer.append("targetActor=[").append(this._targetActor).append("], ");
        stringBuffer.append("indentation=[").append(this._indentation).append("], ");
        stringBuffer.append("allowedTransforms=[").append(this._allowedTransforms).append("], ");
        stringBuffer.append("allowedCanonicalizations=[").append(this._allowedCanonicalizationMethods).append("], ");
        stringBuffer.append("allowedSignatures=[").append(this._allowedSignatureMethods).append("], ");
        stringBuffer.append("allowedDigests=[").append(this._allowedDigestMethods).append("], ");
        stringBuffer.append("allowedDataEncryptions=[").append(this._allowedDataEncryptionMethods).append("], ");
        stringBuffer.append("allowedKeyEncryptions=[").append(this._allowedKeyEncryptionMethods).append("], ");
        stringBuffer.append("algorithmFactory=[").append(this._algorithmFactory).append("], ");
        stringBuffer.append("signatureEnabled=[").append(this._signatureEnabled).append("], ");
        stringBuffer.append("encryptionEnabled=[").append(this._encryptionEnabled).append("], ");
        stringBuffer.append("tokenEnabled=[").append(this._tokenEnabled).append("], ");
        stringBuffer.append("timestampEnabled=[").append(this._timestampEnabled).append("], ");
        stringBuffer.append("integralParts=[").append(this._integralParts).append("], ");
        stringBuffer.append("confidentialParts=[").append(this._confidentialParts).append("], ");
        stringBuffer.append("operationGenerators=[").append(this._operationGenerators).append("], ");
        stringBuffer.append("tokenGenerators=[").append(this._tokenGenerators).append("], ");
        stringBuffer.append("timestampGenerator=[").append(this._timestampGenerator).append("], ");
        stringBuffer.append("nonceManager=[").append(this._nonceManager).append("], ");
        stringBuffer.append("userDefinedComponentsUsed=[").append(this._userDefinedComponentsUsed).append("], ");
        if (!(this instanceof WSSecurityDefaultGeneratorConfig)) {
            stringBuffer.append("*clientSetMustUnderstand=[").append(this._clientSetMustUnderstand).append("], ");
            stringBuffer.append("*serviceGetMustUnderstand=[").append(this._serviceGetMustUnderstand).append("], ");
        }
        stringBuffer.append("properties=[").append(this._properties).append("]");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static class KeyInfoContentGeneratorConfImpl
    implements KeyInfoContentGeneratorConfig {
        public String _className = null;
        public KeyInfoContentGeneratorComponent _instance = null;
        public String _keyInfoType = null;
        public KeyLocator _keyLocator = null;
        public String _keyName = null;
        public TokenGeneratorConfImpl _tokenGenerator = null;
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s25", this.toString());
            }
            if (this._keyInfoType == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s26", this.toString());
            }
        }

        public KeyInfoContentGeneratorComponent getInstance() {
            return this._instance;
        }

        public String getKeyInfoType() {
            return this._keyInfoType;
        }

        public KeyLocator getKeyLocator() {
            return this._keyLocator;
        }

        public String getKeyName() {
            return this._keyName;
        }

        public TokenGeneratorConfig getTokenGenerator() {
            return this._tokenGenerator;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("className=[").append(this._className).append("], ");
            stringBuffer.append("keyInfoType=[").append(this._keyInfoType).append("], ");
            stringBuffer.append("keyLocator=[").append(this._keyLocator).append("], ");
            stringBuffer.append("keyName=[").append(this._keyName).append("], ");
            stringBuffer.append("tokenGenerator=[").append(this._tokenGenerator).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class KeyInfoGeneratorConfImpl
    implements KeyInfoGeneratorConfig {
        public KeyInfoContentGeneratorConfImpl _contentGenerator = null;

        public void validate() throws SoapSecurityException {
            if (this._contentGenerator == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s07", this.toString());
            }
        }

        public KeyInfoContentGeneratorConfig getContentGenerator() {
            return this._contentGenerator;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("contentGenerator=[").append(this._contentGenerator).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class TimestampGeneratorConfImpl
    implements TimestampGeneratorConfig {
        public String _myActor = null;
        public String _targetActor = null;
        public Duration _duration = null;
        private boolean _signed = false;
        private boolean _headerAttribute = false;
        private boolean _default = true;
        private boolean _soapHeader = false;
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
        }

        public String getMyActor() {
            return this._myActor;
        }

        public String getTargetActor() {
            return this._targetActor;
        }

        public Duration getDuration() {
            return this._duration;
        }

        public boolean toBeSigned() {
            return this._signed;
        }

        public void setToBeSigned(boolean bl) {
            this._signed = bl;
        }

        public boolean getSOAPHeaderAttribute() {
            return this._headerAttribute;
        }

        public boolean isSOAPHeaderElement() {
            return this._soapHeader;
        }

        public boolean isDefault() {
            return this._default;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("myActor=[").append(this._myActor).append("], ");
            stringBuffer.append("targetActor=[").append(this._targetActor).append("], ");
            stringBuffer.append("duration=[").append(this._duration).append("], ");
            stringBuffer.append("signed=[").append(this._signed).append("], ");
            stringBuffer.append("headerAttribute=[").append(this._headerAttribute).append("], ");
            stringBuffer.append("soapHeader=[").append(this._soapHeader).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class CallbackHandlerConfImpl
    implements CallbackHandlerConfig {
        public String _className = null;
        public PrivateCommonConfig.KeyStoreConfImpl _keyStoreConfig = null;
        public final Set _keyInformationList = new HashSet();
        public String _userId = null;
        public char[] _userPassword = null;
        public final Map _properties = new HashMap();
        private static final int ITSHA1_OCTETS = 20;
        private static final int IT60SHA1_OCTETS = 8;
        private static final String OID_KEYIDENTIFIER = "2.5.29.14";
        private static final byte BER_SEQUENCE = 48;
        private static final byte BER_BITSTRING = 3;
        private static final int STATUS_OK = 0;
        private static final int STATUS_CERT_ERROR = 1;
        private static final int STATUS_KEYID_ERROR = 2;
        private static final int STATUS_KEY_ERROR = 4;
        private volatile boolean _initialized = false;
        private CallbackHandler _instance = null;
        private KeyStore _keystore = null;
        private final Map _certlist = new HashMap();

        public void validate() throws SoapSecurityException {
            if (this._className == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s05", this.toString());
            }
            if (this._userId == null && this._userPassword != null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s06", this.toString());
            }
        }

        public String getClassName() {
            return this._className;
        }

        public CallbackHandler getInstance() {
            return this._instance;
        }

        public void setInstance(CallbackHandler callbackHandler) {
            this._instance = callbackHandler;
        }

        public Set getKeyInformationList() {
            return this._keyInformationList;
        }

        public KeyStore getKeyStore() throws SoapSecurityException {
            if (!this._initialized) {
                this.doInit();
            }
            return this._keystore;
        }

        public String getKeyStorePath() {
            return this._keyStoreConfig == null ? null : this._keyStoreConfig._path;
        }

        public Certificate getCertificate(String string) throws SoapSecurityException {
            CertInformation certInformation;
            Certificate certificate = null;
            if (!this._initialized) {
                this.doInit();
            }
            if ((certInformation = (CertInformation)this._certlist.get(string)) != null) {
                certificate = certInformation.getCertificate();
            }
            return certificate;
        }

        public String getUserId() {
            return this._userId;
        }

        public char[] getUserPassword() {
            return this._userPassword;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("className=[").append(this._className).append("], ");
            stringBuffer.append("keyInformationList=[").append(this._keyInformationList).append("], ");
            stringBuffer.append("certInfomationList=[").append(this._certlist).append("], ");
            stringBuffer.append("userId=[").append(this._userId).append("], ");
            stringBuffer.append("userPassword=[XXXXXXXX], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        protected synchronized void doInit() throws SoapSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "doInit()");
            }
            if (this._initialized && tc.isEntryEnabled()) {
                Tr.exit(tc, "doInit()");
            }
            PrivateCommonConfig.KeyStoreConfImpl keyStoreConfImpl = this._keyStoreConfig;
            Set set = this._keyInformationList;
            if (keyStoreConfImpl != null && set != null) {
                if (keyStoreConfImpl._ksRef != null) {
                    this._keystore = ConfigUtil.getKeyStore(keyStoreConfImpl._ksRef);
                } else if (keyStoreConfImpl._type != null && keyStoreConfImpl._path != null && keyStoreConfImpl._password != null && keyStoreConfImpl._path != null) {
                    this._keystore = ConfigUtil.getKeyStore(keyStoreConfImpl._type, keyStoreConfImpl._path, keyStoreConfImpl._password.toCharArray());
                }
                if (this._keystore == null) {
                    throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.loadKeyStore01");
                }
                Iterator iterator = set.iterator();
                try {
                    while (iterator.hasNext()) {
                        PrivateCommonConfig.KeyInformationConfImpl keyInformationConfImpl = (PrivateCommonConfig.KeyInformationConfImpl)iterator.next();
                        String string = KeyInfo.X509Data.encodeDName(keyInformationConfImpl._name);
                        if (string == null || string.length() == 0) {
                            string = keyInformationConfImpl._name;
                        }
                        Certificate certificate = this._keystore.getCertificate(keyInformationConfImpl._alias);
                        String string2 = null;
                        String string3 = null;
                        int n = 0;
                        long l = -1L;
                        String string4 = null;
                        if (certificate == null || !(certificate instanceof X509Certificate)) continue;
                        X509Certificate x509Certificate = (X509Certificate)certificate;
                        string2 = x509Certificate.getSubjectDN().getName();
                        string3 = KeyInfo.X509Data.encodeDName(string2);
                        l = x509Certificate.getNotAfter().getTime();
                        try {
                            x509Certificate.checkValidity();
                        }
                        catch (CertificateExpiredException certificateExpiredException) {
                            n += 2;
                            Tr.processException((Throwable)certificateExpiredException, clsName + ".doInit", "1397", this);
                            Tr.error(tc, "security.wssecurity.WSEC5181E", new Object[]{string2, keyInformationConfImpl.getAlias(), keyStoreConfImpl.getPath(), certificateExpiredException});
                            string4 = ConfigUtil.getMessage("security.wssecurity.WSEC5181E", new String[]{string2, keyInformationConfImpl.getAlias(), keyStoreConfImpl.getPath(), certificateExpiredException.getClass().getName() + ": " + certificateExpiredException.getMessage()});
                        }
                        catch (CertificateException certificateException) {
                            ++n;
                            Tr.processException((Throwable)certificateException, clsName + ".doInit", "1404", this);
                            Tr.error(tc, "security.wssecurity.WSEC5182E", new Object[]{string2, keyInformationConfImpl.getAlias(), keyStoreConfImpl.getPath(), certificateException});
                            string4 = ConfigUtil.getMessage("security.wssecurity.WSEC5182E", new String[]{string2, keyInformationConfImpl.getAlias(), keyStoreConfImpl.getPath(), certificateException.getClass().getName() + ": " + certificateException.getMessage()});
                        }
                        this._certlist.put(keyInformationConfImpl._alias, new CertInformation(keyStoreConfImpl._path, keyInformationConfImpl._alias, string, certificate, string2, string3, l, n, string4));
                    }
                }
                catch (KeyStoreException keyStoreException) {
                    Tr.processException((Throwable)keyStoreException, clsName + ".doInit", "1424", this);
                    Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.exception", new Object[]{keyStoreConfImpl.getPath(), keyStoreException});
                    throw new SoapSecurityException(keyStoreException);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyLocatorConfig [" + this._keyStoreConfig + "], " + "CertInformationList [" + this._certlist + "].");
            }
            this._initialized = true;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doInit()");
            }
        }

        private class CertInformation {
            private String _kspath;
            private String _alias;
            private String _name;
            private Certificate _certificate;
            private String _subjectDN;
            private String _encSubjectDN;
            private int _status;
            private long _expiration;
            private String _errorMes;

            private CertInformation(String string, String string2, String string3, Certificate certificate, String string4, String string5, long l, int n, String string6) {
                this._kspath = string;
                this._alias = string2;
                this._name = string3;
                this._certificate = certificate;
                this._subjectDN = string4;
                this._encSubjectDN = string5;
                this._expiration = l;
                this._status = n;
                this._errorMes = string6;
            }

            private Certificate getCertificate() throws SoapSecurityException {
                if ((this._status & 1) == 1) {
                    throw new SoapSecurityException(this._errorMes);
                }
                this.checkExpiration();
                return this._certificate;
            }

            private void checkExpiration() throws SoapSecurityException {
                long l;
                if (this._expiration >= 0L && (l = this._expiration - System.currentTimeMillis()) < 0L) {
                    ++this._status;
                    this._errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC5181E", new String[]{this._subjectDN, this._alias, this._kspath, "expiration time - current system time = " + l + " ms."});
                    throw new SoapSecurityException(this._errorMes);
                }
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
                stringBuffer.append("keystorePath=[").append(this._kspath).append("], ");
                stringBuffer.append("alias=[").append(this._alias).append("], ");
                stringBuffer.append("name=[").append(this._name).append("], ");
                stringBuffer.append("status=[").append(this._status).append("], ");
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
        }
    }

    public static class TokenGeneratorConfImpl
    implements TokenGeneratorConfig {
        public String _name = null;
        public String _className = null;
        public TokenGeneratorComponent _instance = null;
        public String _usage = null;
        public QName _type = null;
        public boolean _standAlone = false;
        public Provider _provider = null;
        public List _certStores = null;
        public CallbackHandlerConfImpl _callbackHandler = null;
        public boolean _usedForSignature = false;
        public boolean _usedForEncryption = false;
        public final Map _properties = new HashMap();
        private volatile boolean _initialized = false;

        public TokenGeneratorConfImpl() {
        }

        public TokenGeneratorConfImpl(TokenGeneratorConfImpl tokenGeneratorConfImpl) {
            this._name = tokenGeneratorConfImpl._name;
            this._className = tokenGeneratorConfImpl._className;
            this._instance = tokenGeneratorConfImpl._instance;
            this._usage = tokenGeneratorConfImpl._usage;
            this._type = tokenGeneratorConfImpl._type;
            this._standAlone = tokenGeneratorConfImpl._standAlone;
            this._provider = tokenGeneratorConfImpl._provider;
            this._certStores = tokenGeneratorConfImpl._certStores;
            this._callbackHandler = tokenGeneratorConfImpl._callbackHandler;
            this._usedForSignature = tokenGeneratorConfImpl._usedForSignature;
            this._usedForEncryption = tokenGeneratorConfImpl._usedForEncryption;
            this._properties.putAll(tokenGeneratorConfImpl._properties);
            this._initialized = tokenGeneratorConfImpl._initialized;
        }

        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s03", this.toString());
            }
            if (this._type == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s04", this.toString());
            }
        }

        protected synchronized void initCerts() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initCerts()");
            }
            if (this._initialized) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initCerts()");
                }
                return;
            }
            if (this._certStores != null) {
                Iterator iterator;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_certStores is non-null");
                }
                if (!(iterator = this._certStores.iterator()).hasNext() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "_certStores is empty");
                }
                ArrayList<CertStore> arrayList = new ArrayList<CertStore>();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (e2 instanceof CollectionCertStore) {
                        CollectionCertStore collectionCertStore;
                        CertStore certStore;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Instance is a CollectionCertStore, creating CertStore instance.");
                        }
                        if ((certStore = (collectionCertStore = (CollectionCertStore)e2).getInstance()) != null) {
                            this._provider = certStore.getProvider();
                            arrayList.add(certStore);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "CollectionCertStore.getInstance() returned null.");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Instance not a CollectionCertStore, nothing to do.");
                    }
                    arrayList.add((CertStore)e2);
                }
                this._certStores = arrayList;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_certStores is null");
            }
            this._initialized = true;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initCerts()");
            }
        }

        public TokenGeneratorComponent getInstance() {
            return this._instance;
        }

        public String getUsage() {
            return this._usage;
        }

        public QName getType() {
            return this._type;
        }

        public boolean isStandAlone() {
            return this._standAlone;
        }

        public Provider getProvider() {
            this.initCerts();
            return this._provider;
        }

        public List getCertStores() {
            this.initCerts();
            return this._certStores;
        }

        public CallbackHandlerConfig getCallbackHandler() {
            return this._callbackHandler;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("className=[").append(this._className).append("], ");
            stringBuffer.append("usage=[").append(this._usage).append("], ");
            stringBuffer.append("type=[").append(this._type).append("], ");
            stringBuffer.append("standAlone=[").append(this._standAlone).append("], ");
            stringBuffer.append("provider=[").append(this._provider).append("], ");
            stringBuffer.append("certStores=[").append(this._certStores).append("], ");
            stringBuffer.append("callbackHandler=[").append(this._callbackHandler).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class EncryptionGeneratorConfImpl
    implements EncryptionGeneratorConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _dataEncryptionMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyEncryptionMethod = null;
        public KeyInfoGeneratorConfImpl _encryptionKeyInfo = null;
        public PrivateCommonConfig.ReferencePartConfImpl _reference = null;
        public final Map _properties = new HashMap();
        public boolean _sigAfterEnc = false;

        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean bl) throws SoapSecurityException {
            if (this._dataEncryptionMethod == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s19", this.toString());
            }
            if (this._encryptionKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s02", this.toString());
            }
            if (this._reference == null && !bl) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s21", this.toString());
            }
        }

        public AlgorithmConfig getDataEncryptionMethod() {
            return this._dataEncryptionMethod;
        }

        public AlgorithmConfig getKeyEncryptionMethod() {
            return this._keyEncryptionMethod;
        }

        public KeyInfoGeneratorConfig getEncryptionKeyInfo() {
            return this._encryptionKeyInfo;
        }

        public ReferencePartConfig getReference() {
            return this._reference;
        }

        public Map getProperties() {
            return this._properties;
        }

        public boolean remainSignatureAfterEncryption() {
            return this._sigAfterEnc;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("dataEncryptionMethod=[").append(this._dataEncryptionMethod).append("], ");
            stringBuffer.append("keyEncryptionMethod=[").append(this._keyEncryptionMethod).append("], ");
            stringBuffer.append("encryptionKeyInfo=[").append(this._encryptionKeyInfo).append("], ");
            stringBuffer.append("reference=[").append(this._reference).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("], ");
            stringBuffer.append("signatureAfterEncryption=[").append(this._sigAfterEnc).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class SignatureGeneratorConfImpl
    implements SignatureGeneratorConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _canonicalizationMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _signatureMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyInfoSignature = null;
        public KeyInfoGeneratorConfImpl _signingKeyInfo = null;
        public final List _references = new ArrayList();
        public boolean _inclusiveNamespaces = true;
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean bl) throws SoapSecurityException {
            this.checkInclusiveNsProperty();
            if (this._signingKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s01", this.toString());
            }
            if (this._references.isEmpty() && !bl) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s18", this.toString());
            }
        }

        public void putInclusiveNsProperty(Map map) {
            String string = (String)map.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_INCLUSIVE_NAMESPACES);
            if (ConfigUtil.hasValue(string)) {
                this._properties.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_INCLUSIVE_NAMESPACES, string);
            }
        }

        private void checkInclusiveNsProperty() {
            if (this._properties.containsKey(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_INCLUSIVE_NAMESPACES)) {
                this._inclusiveNamespaces = ConfigUtil.isTrue((String)this._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_INCLUSIVE_NAMESPACES));
            }
        }

        public AlgorithmConfig getCanonicalizationMethod() {
            return this._canonicalizationMethod;
        }

        public AlgorithmConfig getSignatureMethod() {
            return this._signatureMethod;
        }

        public AlgorithmConfig getKeyInfoSignature() {
            return this._keyInfoSignature;
        }

        public KeyInfoGeneratorConfig getSigningKeyInfo() {
            return this._signingKeyInfo;
        }

        public List getReferences() {
            return this._references;
        }

        public boolean addInclusiveNamespaces() {
            return this._inclusiveNamespaces;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("canonicalizationMethod=[").append(this._canonicalizationMethod).append("], ");
            stringBuffer.append("signatureMethod=[").append(this._signatureMethod).append("], ");
            stringBuffer.append("keyInfoSignature=[").append(this._keyInfoSignature).append("], ");
            stringBuffer.append("signingKeyInfo=[").append(this._signingKeyInfo).append("], ");
            stringBuffer.append("refereces=[").append(this._references).append("], ");
            stringBuffer.append("addInclusiveNamespaces=[").append(this._inclusiveNamespaces).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

