/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.websphere.cache.DistributedMap;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.wssecurity.util.DistributedMapFactory;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Properties;

class ConfigCache {
    private static final TraceComponent tc = Tr.register(ConfigCache.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = ConfigCache.class.getName();
    private static final String comp = "security.wssecurity";
    private String _cacheName;
    private DistributedMap _dm;
    private boolean _dmInitialized;
    private int _timeToLive;

    public ConfigCache(String string, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CertCache(String cacheName[" + string + "]," + "int size[" + n + "]," + "int timeToLive[" + n2 + "]");
        }
        this._dm = null;
        this._timeToLive = n2;
        if (string == null || string.length() == 0) {
            string = "WSSReqGeneratorConfigMap";
        }
        Properties properties = new Properties();
        properties.put("com.ibm.ws.cache.CacheConfig.cacheSize", Integer.toString(n));
        properties.put("com.ibm.ws.cache.CacheConfig.enableDiskOffload", "false");
        properties.put("com.ibm.ws.cache.CacheConfig.diskOffloadLocation", "");
        this._dm = DistributedMapFactory.getMap(string, properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigCache(String cacheName, int size, int timeout");
        }
    }

    public Object get(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get(Object key[" + object + "]");
            Tr.debug(tc, "key class is " + object.getClass().getName());
        }
        try {
            Object var2_2 = null;
            if (this._dm != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "get(Object key) returns valid Object");
                }
                return this._dm.get(object);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "get(Object key) returns null");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "security.wssecurity.ConfigCache.s01", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "clsName.get", "92", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "get(Object key) returns null");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "put(Object key[" + object + "], Object value[" + object2 + "]");
            Tr.debug(tc, "key class is " + object.getClass().getName());
        }
        try {
            ConfigCache configCache = this;
            synchronized (configCache) {
                if (this._dm != null) {
                    Object object3 = this._dm.put(object, object2, 1, this._timeToLive, 1, null);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "put(Object key, Object value)" + (object3 != null ? "(not null)" : "(null)"));
                    }
                    return object3;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "put(Object key, Object value) returns null");
                }
                return null;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "security.wssecurity.ConfigCache.s02", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "clsName.put", "122", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "put(Object key, Object value) returns null");
            }
            return null;
        }
    }
}

