/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.core.DistributedConfigCache;
import com.ibm.ws.webservices.wssecurity.core.DistributedConfigCacheImpl;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Permission;

public class DistributedConfigCacheFactory {
    private static final TraceComponent tc = Tr.register(DistributedConfigCacheFactory.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = DistributedConfigCacheFactory.class.getName();
    private static final String comp = "security.wssecurity";
    private static final Permission INIT_PERMISSION = new WebSphereRuntimePermission("wssecurity.DistributedConfigCacheFactory.init");
    private static final Permission GET_INSTANCE_PERMISSION = new WebSphereRuntimePermission("wssecurity.DistributedConfigCacheFactory.getInstance");
    private static DistributedConfigCache _instance;
    private static boolean _initialized;
    private static boolean _useCache;
    private static String _cacheName;
    private static int _cacheSize;
    private static int _cacheTimeToLive;

    private DistributedConfigCacheFactory() {
    }

    public static DistributedConfigCache getInstance() throws SoapSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GET_INSTANCE_PERMISSION);
        }
        DistributedConfigCache distributedConfigCache = null;
        if (!_initialized) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "security.wssecurity.DistributedConfigCacheFactory.s01");
            }
        } else {
            distributedConfigCache = _instance;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance() returns config cache[" + distributedConfigCache + "]");
        }
        return distributedConfigCache;
    }

    protected static void init_boot(boolean bl, String string, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init_boot(boolean useCache[" + bl + "]," + "String cacheName[" + string + "]," + "int cacheSize[" + n + "]," + "int cacheTimeToLive[" + n2 + "])");
        }
        _useCache = bl;
        _cacheName = string;
        _cacheSize = n;
        _cacheTimeToLive = n2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init_boot(boolean useCache, String cacheName, int cacheSize, int cacheTimeToLive)");
        }
    }

    public static synchronized void init() {
        Tr.entry(tc, "init()");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(INIT_PERMISSION);
        }
        if (!_initialized) {
            _instance = _useCache ? new DistributedConfigCacheImpl(_cacheName, _cacheSize, _cacheTimeToLive) : null;
            _initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public String toString() {
        return clsName;
    }

    static {
        _initialized = false;
    }
}

