/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.handler.token.WSNonceManagerImpl;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Permission;

public class NonceManagerFactory {
    private static final TraceComponent tc = Tr.register(NonceManagerFactory.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = NonceManagerFactory.class.getName();
    private static final String comp = "security.wssecurity";
    private static final Permission INIT_PERMISSION = new WebSphereRuntimePermission("wssecurity.NonceManagerFactory.init");
    private static final Permission GET_INSTANCE_PERMISSION = new WebSphereRuntimePermission("wssecurity.NonceManagerFactory.getInstance");
    private static boolean _useCache = false;
    private static String _cacheName = null;
    private static int _cacheSize = -1;
    private static int _cacheTimeout = -1;
    private static int _nonceLength = -1;
    private static boolean _cacheDistributed = false;

    private NonceManagerFactory() {
    }

    public static NonceManager getInstance() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GET_INSTANCE_PERMISSION);
        }
        NonceManager nonceManager = NonceInstance._instance;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance() returns NonceManager[" + nonceManager + "]");
        }
        return nonceManager;
    }

    static void init(boolean bl, String string, int n, int n2, int n3, boolean bl2) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(boolean useCache[" + bl + "]," + "String cacheName[" + string + "]," + "int cacheSize[" + n + "]," + "int cacheTimeout[" + n2 + "]," + "int nonceLength[" + n3 + "]," + "boolean cacheDistributed[" + bl2 + "])");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(INIT_PERMISSION);
        }
        _useCache = bl;
        _cacheName = string;
        _cacheSize = n;
        _cacheTimeout = n2;
        _nonceLength = n3;
        _cacheDistributed = bl2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(String cacheName, int cacheSize, int cacheTimeout, int nonceLength, boolean cacheDistributed)");
        }
    }

    public String toString() {
        return clsName;
    }

    private static class NonceInstance {
        private static NonceManager _instance = null;

        private NonceInstance() {
        }

        static {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing WSNonceManagerImpl instance with boolean useCache[" + _useCache + "]," + "String cacheName[" + _cacheName + "]," + "int cacheSize[" + _cacheSize + "]," + "int cacheTimeout[" + _cacheTimeout + "]," + "int nonceLength[" + _nonceLength + "]," + "boolean cacheDistributed[" + _cacheDistributed + "]");
            }
            _instance = _useCache ? new WSNonceManagerImpl(_cacheName, _cacheSize, _cacheTimeout, _nonceLength, _cacheDistributed) : null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSNonceManagerImpl instance initialized [" + _instance + "]");
            }
        }
    }
}

