/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.handler.token.TokenCacheManagerImpl;
import com.ibm.ws.webservices.wssecurity.token.TokenCacheManager;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Permission;

public class TokenCacheManagerFactory {
    private static final TraceComponent tc = Tr.register(TokenCacheManagerFactory.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = TokenCacheManagerFactory.class.getName();
    private static final String comp = "security.wssecurity";
    private static final Permission INIT_PERMISSION = new WebSphereRuntimePermission("wssecurity.TokenCacheManagerFactory.init");
    private static final Permission GET_INSTANCE_PERMISSION = new WebSphereRuntimePermission("wssecurity.TokenCacheManagerFactory.getInstance");
    private static TokenCacheManager _instance;
    private static boolean _initialized;

    private TokenCacheManagerFactory() {
    }

    public static TokenCacheManager getInstance() throws SoapSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GET_INSTANCE_PERMISSION);
        }
        TokenCacheManager tokenCacheManager = null;
        if (!_initialized) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: The token manager is not initialized.");
            }
        } else {
            tokenCacheManager = _instance;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance() returns TokenCacheManager[" + tokenCacheManager + "]");
        }
        return tokenCacheManager;
    }

    protected static synchronized void init(boolean bl, String string, int n, int n2, long l) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(boolean useCache[" + bl + "]," + "String cacheName[" + string + "]," + "int cacheSize[" + n + "]," + "int cacheTimeout[" + n2 + "]" + "long cushion[" + l + "])");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(INIT_PERMISSION);
        }
        if (!_initialized) {
            _instance = bl ? new TokenCacheManagerImpl(string, n, n2, l) : null;
            _initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(boolean useCache, String cacheName, int cacheSize, int cacheTimeout)");
        }
    }

    public String toString() {
        return clsName;
    }

    static {
        _initialized = false;
    }
}

