/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.config.Configuration;
import com.ibm.ws.webservices.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.RequestMessagePool;
import com.ibm.ws.webservices.wssecurity.core.WSSFactory;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.webservices.wssecurity.enc.EncryptionGenerator;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoGenerator;
import com.ibm.ws.webservices.wssecurity.time.TimestampGenerator;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.webservices.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.webservices.wssecurity.util.XPathElementSelector;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.SetupJCEProviders;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class WSSGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(WSSGenerator.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSGenerator.class.getName();
    private Map _handlerOption = new HashMap();
    private ThreadLocal _messageConfig = new ThreadLocal();
    private Map _properties = new HashMap();
    private boolean _initialized = false;

    public void setHandlerOption(String string, Object object) {
        this._handlerOption.put(string, object);
    }

    public Object getHandlerOption(String string) {
        return this._handlerOption.get(string);
    }

    private final void clear() {
        this._messageConfig.set(null);
    }

    private Map getMessageConfig() {
        HashMap hashMap = (HashMap)this._messageConfig.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            this._messageConfig.set(hashMap);
        }
        return hashMap;
    }

    public void setMessageOption(String string, Object object) {
        this.getMessageConfig().put(string, object);
    }

    public Object getMessageOption(String string) {
        return this.getMessageConfig().get(string);
    }

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this.setInitialProperties();
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element parent[" + DOMUtil.getDisplayName(element) + "]," + "Map context)");
        }
        this.clear();
        try {
            int n;
            boolean bl;
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
            if (sOAPMessageContext == null) {
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
            }
            RequestPool.initialize(map);
            boolean bl2 = WSSGenerator.adjustContext(sOAPMessageContext, map);
            TokenManager.initializeSubject(map);
            RequestMessagePool.initialize(map);
            Object object = sOAPMessageContext.getProperty("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
            int n2 = 0;
            if (object != null && object instanceof Integer) {
                n2 = (Integer)object;
                map.put("com.ibm.ws.webservices.wssecurity.constants.wssVersion", object);
            }
            WSSGeneratorConfig wSSGeneratorConfig = (WSSGeneratorConfig)map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSGeneratorConfig [" + wSSGeneratorConfig + "].");
            }
            TimestampGeneratorConfig timestampGeneratorConfig = wSSGeneratorConfig.getTimestampGenerator();
            HashMap hashMap = new HashMap(this._properties);
            map.put(NonceManager.class, wSSGeneratorConfig.getNonceManager());
            boolean bl3 = wSSGeneratorConfig.isTimestampEnabled();
            boolean bl4 = bl = wSSGeneratorConfig.isTokenEnabled() || wSSGeneratorConfig.isSignatureEnabled() || wSSGeneratorConfig.isEncryptionEnabled() || bl3 && !timestampGeneratorConfig.isSOAPHeaderElement() || bl2;
            if (!bl3 && !bl) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invoke(Document doc,Element parent,Map context)");
                }
                return;
            }
            this.setMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress", sOAPMessageContext.getProperty("javax.xml.rpc.service.endpoint.address"));
            SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = null;
            try {
                sOAPEnvelope = sOAPPart.getEnvelope();
            }
            catch (SOAPException sOAPException) {
                Tr.processException((Throwable)sOAPException, clsName + ".invoke", "266", this);
                Tr.error(tc, "security.wssecurity.WSSConsumer.s01", new Object[]{sOAPException});
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s01", sOAPException);
            }
            if (document == null) {
                document = sOAPEnvelope.getOwnerDocument();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The original message to be processed by WSSGenerator: " + DOMUtil.toString(document));
            }
            if (element == null) {
                element = WSSGenerator.getHeader(document, true);
            } else {
                n = NamespaceUtil.checkSoapVersion(element, -1, "Header");
                if (n < 0) {
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", DOMUtil.getQualifiedName(element));
                }
            }
            n = NamespaceUtil.isSoap(element.getNamespaceURI());
            map.put("com.ibm.ws.webservices.wssecurity.constants.soapVersion", new Integer(n));
            boolean bl5 = true;
            if (!bl) {
                if (bl3) {
                    bl5 = this.checkMustUnderstand(wSSGeneratorConfig, sOAPMessageContext);
                    WSSGenerator.callTimestampGenerator(timestampGeneratorConfig, hashMap, document, element, map);
                }
            } else {
                Collection<Element> collection;
                Configuration configuration;
                Set set;
                bl5 = this.checkMustUnderstand(wSSGeneratorConfig, sOAPMessageContext);
                Element element2 = WSSGenerator.addSecurityHeader(document, element, n, n2, wSSGeneratorConfig.getTargetActor(), bl5);
                if (bl3) {
                    WSSGenerator.callTimestampGenerator(timestampGeneratorConfig, hashMap, document, element2, map);
                }
                if ((set = wSSGeneratorConfig.getTokenGenerators()).size() > 0) {
                    this.retrieveCachedInformation(sOAPMessageContext);
                }
                Iterator iterator = set.iterator();
                if (wSSGeneratorConfig.getCheckCacheUnt()) {
                    map.put("com.ibm.wsspi.wssecurity.token.checkCacheUnt", "true");
                }
                while (iterator.hasNext()) {
                    configuration = (Configuration)iterator.next();
                    if (configuration instanceof TokenGeneratorConfig) {
                        WSSGenerator.callTokenGenerator((TokenGeneratorConfig)configuration, document, element2, map);
                        continue;
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s04", configuration.getClass().getName());
                }
                map.remove("com.ibm.wsspi.wssecurity.token.checkCacheUnt");
                Set set2 = TokenManager.getTokens(map);
                if (set2 != null && set2.size() > 0) {
                    collection = new HashSet();
                    iterator = set2.iterator();
                    while (iterator.hasNext()) {
                        Token token = (Token)iterator.next();
                        if (token.getElement() == null) continue;
                        collection.add(token.getElement());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Added the element of stand-alone token [" + token + "].");
                    }
                    map.put("com.ibm.ws.webservices.wssecurity.constants.standAloneElements", collection);
                }
                collection = wSSGeneratorConfig.getOperationGenerators();
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    configuration = (Configuration)iterator.next();
                    if (configuration instanceof SignatureGeneratorConfig) {
                        WSSGenerator.callSignatureGenerator((SignatureGeneratorConfig)configuration, hashMap, document, element2, map);
                        continue;
                    }
                    if (configuration instanceof EncryptionGeneratorConfig) {
                        WSSGenerator.callEncryptionGenerator((EncryptionGeneratorConfig)configuration, hashMap, document, element2, map);
                        continue;
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s04", configuration.getClass().getName());
                }
            }
            if (bl3) {
                TimestampGenerator.moveTimestamp(document, wSSGeneratorConfig.getTimestampGenerator(), hashMap, map);
            }
            if (wSSGeneratorConfig.isUserDefinedComponentsUsed()) {
                IdUtil.getInstance().checkIdUniqueness(document);
            }
            RequestPool.finalize(map);
            RequestMessagePool.finalize(map);
        }
        finally {
            this.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc,Element parent,Map context)");
        }
    }

    public void onFault(SOAPMessageContext sOAPMessageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onFault(SOAPMessageContext context)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onFault(SOAPMessageContext context)");
        }
    }

    private void setInitialProperties() throws SoapSecurityException {
        this._properties.put(ConfidentialDialectElementSelector.class, new ConfidentialDialectElementSelector());
        this._properties.put(IntegralDialectElementSelector.class, new IntegralDialectElementSelector());
        this._properties.put(TimestampDialectElementSelector.class, new TimestampDialectElementSelector());
        this._properties.put(WSPFunctionElementSelector.class, new WSPFunctionElementSelector());
        this._properties.put(XPathElementSelector.class, new XPathElementSelector());
        this._properties.put("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver", IdUtil.getInstance());
        WSSFactory wSSFactory = WSSFactory.getInstance("soap");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.timestamp");
        this._properties.put(TimestampGenerator.class, wSSFactory.createGenerator(hashMap, this._properties));
        hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.signature");
        this._properties.put(SignatureGenerator.class, wSSFactory.createGenerator(hashMap, this._properties));
        hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.encryption");
        this._properties.put(EncryptionGenerator.class, wSSFactory.createGenerator(hashMap, this._properties));
        hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.keyinfo");
        this._properties.put(KeyInfoGenerator.class, wSSFactory.createGenerator(hashMap, this._properties));
    }

    private static boolean adjustContext(SOAPMessageContext sOAPMessageContext, Map map) throws SoapSecurityException {
        return false;
    }

    public abstract void retrieveCachedInformation(SOAPMessageContext var1) throws SoapSecurityException;

    public static Element getHeader(Document document, boolean bl) throws SoapSecurityException {
        String string;
        Element element;
        Element element2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHeader(Document doc[" + DOMUtil.getDisplayName(document) + "])");
        }
        if ((element2 = DOMUtil.getFirstElement(element = document.getDocumentElement(), string = element.getNamespaceURI(), "Header")) == null && bl) {
            String string2 = element.getPrefix();
            if (string2 == null) {
                string2 = "";
            } else if (string2.length() > 0) {
                string2 = string2 + ":";
            }
            element2 = document.createElementNS(string, string2 + "Header");
            element2 = (Element)element.insertBefore(element2, element.getFirstChild());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getheader(Document doc) returns Element[", DOMUtil.getDisplayName(element2) + "]");
        }
        return element2;
    }

    private static Element addSecurityHeader(Document document, Element element, int n, int n2, String string, boolean bl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSecurityHeader(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element header[" + DOMUtil.getDisplayName(element) + "]," + "int soapVersion[" + n + "]," + "int wssVersion[" + n2 + "]," + "String actor[" + string + "]," + "boolean mustUnderstand[" + bl + "])");
        }
        Element element2 = null;
        element2 = WSSGenerator.getSecurityHeader(element, n, n2, string, bl);
        if (element2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addSecurityHeader Uses existing wsse:Security element");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addSecurityHeader(Document doc,Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns Element[" + DOMUtil.getDisplayName(element2) + "]");
            }
            return element2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addSecurityHeader Creates new wsse:Security element");
        }
        element2 = document.createElementNS(Constants.NS_WSSE, "wsse:Security");
        element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", Constants.NS_WSSE);
        String string2 = element.getPrefix();
        if (string != null) {
            String string3 = n == 0 ? "actor" : "role";
            if (string2 == null || string2.length() <= 0) {
                string2 = "env";
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, Constants.NS_SOAP);
            }
            element2.setAttributeNS(Constants.NS_SOAP, string2 + ":" + string3, string);
        }
        if (bl) {
            if (string2 == null || string2.length() <= 0) {
                string2 = "env";
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, Constants.NS_SOAP);
            }
            element2.setAttributeNS(Constants.NS_SOAP, string2 + ":mustUnderstand", "1");
        }
        element2 = (Element)element.insertBefore(element2, element.getFirstChild());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSecurityHeader(Document doc,Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns Element[" + DOMUtil.getDisplayName(element2) + "]");
        }
        return element2;
    }

    public static Element getSecurityHeader(Element element, int n, int n2, String string, boolean bl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchForSecurityHeader(Element header[" + DOMUtil.getDisplayName(element) + "]," + "int soapVersion[" + n + "]," + "int wssVersion[" + n2 + "]," + "String actor[" + string + "]," + "boolean mustUnderstand[" + bl + "])");
        }
        Element element2 = DOMUtil.getFirstElement(element);
        while (element2 != null) {
            String string2 = element2.getNamespaceURI();
            String string3 = element2.getLocalName();
            if ((n2 < 0 || NamespaceUtil.isWsse(string2) == n2) && "Security".equals(string3)) {
                String string4;
                String string5;
                if (n == 1) {
                    string5 = element2.getAttributeNS(Constants.NS_SOAP12, "role");
                    string4 = element2.getAttributeNS(Constants.NS_SOAP12, "mustUnderstand");
                } else if (n == 0) {
                    string5 = element2.getAttributeNS(Constants.NS_SOAP, "actor");
                    string4 = element2.getAttributeNS(Constants.NS_SOAP, "mustUnderstand");
                } else {
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s11", Integer.toString(n));
                }
                if (!(string != null && string.length() != 0 ? !string.equals(string5) : string5 != null && string5.trim().length() != 0)) {
                    if (bl && !"1".equals(string4)) {
                        throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s12", string4, Boolean.toString(bl));
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "searchForSecurityHeader(Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns Element[" + element2 + "]");
                    }
                    return element2;
                }
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchForSecurityHeader(Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns null");
        }
        return null;
    }

    private static void callTimestampGenerator(TimestampGeneratorConfig timestampGeneratorConfig, Map map, Document document, Element element, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callTimestampGenerator(TimestampGeneratorConfig config,Map selectors,Document document[" + DOMUtil.getDisplayName(document) + "]," + "Element parent[" + DOMUtil.getDisplayName(element) + "]," + "Map context)");
        }
        TimestampGenerator timestampGenerator = (TimestampGenerator)map.get(TimestampGenerator.class);
        map2.put("com.ibm.wsspi.wssecurity.config.timestampGenerator.configKey", timestampGeneratorConfig);
        timestampGenerator.invoke(document, element, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callTimestampGenerator(TimestampGeneratorConfig config,Map selectors,Document document,Element parent,Map context)");
        }
    }

    private static void callTokenGenerator(TokenGeneratorConfig tokenGeneratorConfig, Document document, Element element, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callTokenGenerator(TokenGeneratorConfig[" + tokenGeneratorConfig + "]" + "Document document[" + DOMUtil.getDisplayName(document) + "]," + "Element parent[" + DOMUtil.getDisplayName(element) + "]," + "Map context)");
        }
        if (tokenGeneratorConfig.isStandAlone()) {
            TokenGeneratorComponent tokenGeneratorComponent;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Generating security token");
            }
            if ((tokenGeneratorComponent = tokenGeneratorConfig.getInstance()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get the TokenGenerator object: [" + tokenGeneratorConfig + "].");
                }
            } else {
                map.put("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey", tokenGeneratorConfig);
                tokenGeneratorComponent.invoke(document, element, map);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security token will not be generated");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callTokenGenerator(TokenGeneratorConfig config,Document document,Element parent,Map context)");
        }
    }

    private static void callSignatureGenerator(SignatureGeneratorConfig signatureGeneratorConfig, Map map, Document document, Element element, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callSignatureGenerator(SignatureGeneratorConfig config,Map selectors,Document document[" + DOMUtil.getDisplayName(document) + "]," + "Element parent[" + DOMUtil.getDisplayName(element) + "]," + "Map context)");
        }
        SignatureGenerator signatureGenerator = (SignatureGenerator)map.get(SignatureGenerator.class);
        map2.put("com.ibm.wsspi.wssecurity.config.signatureGenerator.configKey", signatureGeneratorConfig);
        signatureGenerator.invoke(document, element, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callSignatureGenerator(WSSFactory factory,SignatureGeneratorConfig config,Map type,Map selectors,Document document,Element parent,Map context)");
        }
    }

    private static void callEncryptionGenerator(EncryptionGeneratorConfig encryptionGeneratorConfig, Map map, Document document, Element element, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callEncryptionGenerator(EncryptionGeneratorConfig config,Map selectors,Document document[" + DOMUtil.getDisplayName(document) + "]," + "Element parent[" + DOMUtil.getDisplayName(element) + "]," + "Map context)");
        }
        EncryptionGenerator encryptionGenerator = (EncryptionGenerator)map.get(EncryptionGenerator.class);
        map2.put("com.ibm.wsspi.wssecurity.config.encryptionGenerator.configKey", encryptionGeneratorConfig);
        encryptionGenerator.invoke(document, element, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callEncryptionGenerator(EncryptionGeneratorConfig config,Map selectors,Document document,Element parent,Map context)");
        }
    }

    private static void replaceEnvelope(SOAPEnvelope sOAPEnvelope, Element element, String string) throws SOAPException, SoapSecurityException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceEnvelope(SOAPEnvelope envelope[" + DOMUtil.getDisplayName((Node)sOAPEnvelope) + "]," + "Element source[" + DOMUtil.getDisplayName(element) + "]," + "String nsSoap[" + string + "])");
        }
        NamedNodeMap namedNodeMap = sOAPEnvelope.getAttributes();
        for (n = namedNodeMap.getLength() - 1; n >= 0; --n) {
            sOAPEnvelope.removeAttributeNode((Attr)namedNodeMap.item(n));
        }
        namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        Attr[] attrArray = new Attr[n2];
        for (n = n2 - 1; n >= 0; --n) {
            Attr attr;
            attrArray[n] = attr = element.removeAttributeNode((Attr)namedNodeMap.item(n));
        }
        int n3 = n2;
        for (n = 0; n < n3; ++n) {
            sOAPEnvelope.setAttributeNodeNS(attrArray[n]);
        }
        sOAPEnvelope.removeContents();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            sOAPEnvelope.appendChild(node);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceEnvelope(SOAPEnvelope envelope,Element source,String nsSoap)");
        }
    }

    private boolean checkMustUnderstand(WSSGeneratorConfig wSSGeneratorConfig, SOAPMessageContext sOAPMessageContext) {
        boolean bl = true;
        if (sOAPMessageContext.isServer()) {
            boolean bl2 = wSSGeneratorConfig.getServiceGetMustUnderstand();
            if (bl2) {
                bl = ConfigUtil.getMustUnderstand(sOAPMessageContext);
            }
        } else {
            bl = wSSGeneratorConfig.getClientSetMustUnderstand();
        }
        ConfigUtil.setMustUnderstand(sOAPMessageContext, bl);
        return bl;
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("setup-jce");
            }
        });
        if (string != null) {
            SetupJCEProviders.setup();
        }
    }
}

