/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscommonbnd.AlgorithmMapping;
import com.ibm.etools.webservice.wscommonbnd.CRL;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.NonceCaching;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wssecurity.Consumer;
import com.ibm.etools.webservice.wssecurity.Generator;
import com.ibm.etools.webservice.wssecurity.WSSecurity;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webservices.wssecurity.config.CollectionCertStore;
import com.ibm.ws.webservices.wssecurity.config.KeyStore;
import com.ibm.ws.webservices.wssecurity.core.CertManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.DistributedConfigCacheFactory;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.TokenCacheManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityClientComponentImpl;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.core.WebServicesSecurityAdmin;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.WebServicesSecurityAlgorithmHelper;
import com.ibm.ws.wssecurity.xss4j.dsig.util.HWKeyCache;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.security.Permission;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;

public class WSSecurityComponentImpl
extends ComponentImpl
implements WSSecurityService {
    private boolean ndEnvironment = false;
    private WSSecurityDefaultConfiguration config = new WSSecurityDefaultConfiguration();
    private WebServicesSecurityAdmin wssecAdmin = null;
    private Object lock = new Object();
    private boolean initialized = false;
    private static final TraceComponent tc = Tr.register(WSSecurityComponentImpl.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = WSSecurityComponentImpl.class.getName();
    private ClassLoader appClassLoader = null;
    private static final String comp = "security.wssecurity";
    private static final Permission REFRESH_PERM = new WebSphereRuntimePermission("wssecurity.refreshConfig");

    public void start() throws RuntimeWarning, RuntimeError {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Registering WebServicesSecurityAdmin MBean");
            }
            this.wssecAdmin = new WebServicesSecurityAdmin();
            object2 = AdminServiceFactory.getMBeanFactory();
            object = new DefaultRuntimeCollaborator(this.wssecAdmin, "WebServicesSecurityAdmin");
            object2.activateMBean("WebServicesSecurityAdmin", (RuntimeCollaborator)object, object2.getConfigId("WebServicesSecurityAdmin"), "com/ibm/ws/management/descriptor/xml/WebServicesSecurityAdmin.xml");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebServicesSecurityAdmin MBean registered");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, clsName + ".initialize", "118", this);
            Tr.error(tc, "security.wssecurity.init.startfail", new Object[]{exception});
            throw new RuntimeError(ConfigConstants.getMessage("security.wssecurity.start.activate.failed"), exception);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Registering WebServicesSecurityAlgorithmHelper MBean");
            }
            object2 = new WebServicesSecurityAlgorithmHelper();
            object = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(object2, "WebServicesSecurityAlgorithmHelper");
            object.activateMBean("WebServicesSecurityAlgorithmHelper", defaultRuntimeCollaborator, object.getConfigId("WebServicesSecurityAlgorithmHelper"), "com/ibm/ws/management/descriptor/xml/WebServicesSecurityAlgorithmHelper.xml");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebServicesSecurityAlgorithmHelper MBean registered");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, clsName + ".initialize", "136", this);
            Tr.error(tc, "security.wssecurity.init.startfail", new Object[]{exception});
            throw new RuntimeError(ConfigConstants.getMessage("security.wssecurity.WSEC0145E"), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        HWKeyCache.removeAllEntries();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        try {
            Object object2;
            WSSecurity wSSecurity;
            WSSecurity wSSecurity2;
            Repository repository2;
            block23: {
                WSSecurityPlatformContextFactory.setServer();
                AdminService adminService = AdminServiceFactory.getAdminService();
                String string = adminService.getProcessType();
                if (string == null || string.length() == 0) {
                    Tr.error(tc, "security.wssecurity.init.nullprocesstype");
                    throw new ConfigurationError(ConfigConstants.getMessage("security.wssecurity.init.nullprocesstype"));
                }
                if (string.equals("ManagedProcess") || string.equals("DeploymentManager") || string.equals("NodeAgent")) {
                    this.ndEnvironment = true;
                }
                repository2 = null;
                ConfigRoot configRoot = null;
                wSSecurity2 = null;
                wSSecurity = null;
                try {
                    block22: {
                        repository2 = (Repository)this.getService(Repository.class);
                        configRoot = repository2.getConfigRoot();
                        if (this.ndEnvironment) {
                            object2 = null;
                            try {
                                object2 = configRoot.getResource(0, "ws-security.xml");
                            }
                            catch (Exception exception) {
                                String string2 = configRoot.getAbsolutePath(0, "ws-security.xml");
                                FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".initialize", "200", this);
                                Tr.warning(tc, "security.wssecurity.load.cell.wssecurity.xml", new Object[]{string2});
                                throw new ConfigurationWarning(MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.load.cell.wssecurity.xml"), string2), exception);
                            }
                            if (object2 != null && (wSSecurity2 = (WSSecurity)object2.getContents().get(0)) != null && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found document: " + configRoot.getAbsolutePath(0, "ws-security.xml"));
                            }
                        }
                        object2 = null;
                        try {
                            object2 = configRoot.getResource(4, "ws-security.xml");
                        }
                        catch (Exception exception) {
                            if (this.ndEnvironment) break block22;
                            String string3 = configRoot.getAbsolutePath(4, "ws-security.xml");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Can not load server level configuration file: " + string3, new Object[]{exception});
                            }
                            Tr.warning(tc, "security.wssecurity.load.server.wssecurity.xml", new Object[]{string3});
                        }
                    }
                    if (object2 != null && (wSSecurity = (WSSecurity)object2.getContents().get(0)) != null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found document: " + configRoot.getAbsolutePath(4, "ws-security.xml"));
                    }
                    if (configRoot == null) break block23;
                }
                catch (Throwable throwable) {
                    if (configRoot != null) {
                        this.releaseService(configRoot);
                    }
                    if (repository2 != null) {
                        this.releaseService(repository2);
                    }
                    throw throwable;
                }
                this.releaseService(configRoot);
            }
            if (repository2 != null) {
                this.releaseService(repository2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cell WSSecurity: ", new Object[]{wSSecurity2});
                Tr.debug(tc, "Server WSSecurity: ", new Object[]{wSSecurity});
            }
            if ((object2 = (SecurityService)this.getService(SecurityService.class)) == null) {
                throw new ConfigurationError(ConfigConstants.getMessage("security.wssecurity.secrutiyservice.isnull"));
            }
            object2.addListener(new WSSecurityListener(wSSecurity2, wSSecurity));
            this.addService(WSSecurityService.class);
        }
        catch (ConfigurationError configurationError) {
            FFDCFilter.processException((Throwable)configurationError, this.getClass().getName() + ".initialize", "257", this);
            Tr.error(tc, "security.wssecurity.init.startfail", new Object[]{configurationError});
            throw configurationError;
        }
        catch (SoapSecurityException soapSecurityException) {
            FFDCFilter.processException((Throwable)soapSecurityException, this.getClass().getName() + ".initialize", "261", this);
            Tr.error(tc, "security.wssecurity.init.startfail", new Object[]{soapSecurityException});
            throw new ConfigurationError(ConfigConstants.getMessage("security.wssecurity.init.startfail"), soapSecurityException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
            Tr.exit(tc, "destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfig");
            Tr.exit(tc, "getConfig", this.config);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig(WSSecurity wSSecurity, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfig", new Object[]{wSSecurity, wSSecurityDefaultConfiguration});
        }
        VariableMap variableMap = null;
        try {
            NonceCaching nonceCaching;
            CertStoreList certStoreList;
            EList eList;
            Object object;
            EList eList2;
            Object object2;
            String string;
            String string2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            String string3;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Object object12;
            Object object13;
            variableMap = (VariableMap)this.getService(VariableMap.class);
            boolean bl = wSSecurity.isUseHardwareAcceleration();
            if (bl) {
                if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    Tr.info(tc, "security.wssecurity.WSEC0158I", new Object[]{new Boolean(bl)});
                    bl = false;
                } else if (PlatformHelperFactory.getPlatformHelper().isOS400()) {
                    Tr.error(tc, "security.wssecurityHardware Crypto is not supported on this platform, continues to use software crypto provider");
                }
            }
            if (bl) {
                wSSecurityDefaultConfiguration.useHardwareAcceleration = bl;
                Tr.info(tc, "security.wssecurity.WSEC0158I", new Object[]{new Boolean(bl)});
                object13 = wSSecurity.getHardwareConfigRef();
                if (object13 != null && ((String)object13).length() != 0) {
                    wSSecurityDefaultConfiguration.hardwareConfigName = object13;
                    Tr.info(tc, "security.wssecurity.WSEC0158I", new Object[]{object13});
                }
            }
            if ((object13 = wSSecurity.getProperties()) != null) {
                object12 = ConfigConstants.getProperties((EList)object13, variableMap);
                if (!this.initialized) {
                    String string4;
                    block151: {
                        int n;
                        wSSecurityDefaultConfiguration.addProperties((Map)object12);
                        string4 = (String)object12.get("com.ibm.ws.wssecurity.handler.useConfigCache");
                        wSSecurityDefaultConfiguration.useConfigCache = string4 != null ? ConfigUtil.isTrue(string4) : true;
                        object11 = (String)object12.get("com.ibm.ws.wssecurity.config.hwKeyStoreName");
                        if (object11 != null && ((String)object11).length() != 0) {
                            wSSecurityDefaultConfiguration.hardwareKeyStoreName = object11;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Hardware keystore name property is specified, value = " + (String)object11);
                            }
                        }
                        if ((object10 = (String)object12.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheTimeout")) != null && ((String)(object10 = ((String)object10).trim())).length() != 0) {
                            try {
                                n = Integer.parseInt((String)object10);
                                wSSecurityDefaultConfiguration.nonceCacheTimeout = ConfigConstants.validNonceCacheTimeout(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                wSSecurityDefaultConfiguration.nonceCacheTimeout = 600;
                                FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".loadConfig", "314", this);
                                Tr.warning(tc, "security.wssecurity.WSEC0115W", new Object[]{object10, new Integer(600)});
                            }
                        }
                        if ((object10 = (String)object12.get("com.ibm.ws.wssecurity.config.token.certificate.cacheTimeout")) != null && ((String)(object10 = ((String)object10).trim())).length() != 0) {
                            try {
                                n = Integer.parseInt((String)object10);
                                wSSecurityDefaultConfiguration.certCacheTimeOut = ConfigConstants.validCertCacheTimeout(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                wSSecurityDefaultConfiguration.certCacheTimeOut = 900;
                                FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".loadConfig", "330", this);
                                if (!tc.isDebugEnabled()) break block151;
                                Tr.debug(tc, "WARNING: Exception occurred during parsing the certificate cache timeout " + (String)object10 + "seconds, default " + 900 + " seconds is used instead.");
                            }
                        }
                    }
                    if ((object10 = (String)object12.get("com.ibm.ws.wssecurity.handler.configCacheTimeToLive")) != null) {
                        if (((String)(object10 = ((String)object10).trim())).length() != 0) {
                            try {
                                int n;
                                wSSecurityDefaultConfiguration.configCacheTimeToLive = n = Integer.parseInt((String)object10);
                            }
                            catch (NumberFormatException numberFormatException) {
                                wSSecurityDefaultConfiguration.configCacheTimeToLive = 900;
                                FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".loadConfig", "349", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WARNING: Exception occurred during parsing the config cache timeToLive " + (String)object10 + "seconds, default " + 900 + " seconds is used instead.");
                                }
                            }
                        }
                    } else {
                        wSSecurityDefaultConfiguration.configCacheTimeToLive = 900;
                    }
                    if ((object10 = (String)object12.get("com.ibm.ws.wssecurity.handler.token.cacheTimeout")) != null) {
                        if (((String)(object10 = ((String)object10).trim())).length() != 0) {
                            try {
                                int n = Integer.parseInt((String)object10);
                                wSSecurityDefaultConfiguration.tokenCacheTimeOut = ConfigConstants.validTokenCacheTimeout(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                wSSecurityDefaultConfiguration.tokenCacheTimeOut = 900;
                                FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".loadConfig", "391", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WARNING: Exception occurred during parsing the token cache timeout " + (String)object10 + "seconds, default " + 900 + " seconds is used instead.");
                                }
                            }
                        }
                    } else {
                        wSSecurityDefaultConfiguration.tokenCacheTimeOut = 900;
                    }
                    if ((object10 = (String)object12.get("com.ibm.ws.wssecurity.handler.token.cushion")) != null) {
                        if (((String)(object10 = ((String)object10).trim())).length() != 0) {
                            try {
                                int n = Integer.parseInt((String)object10);
                                wSSecurityDefaultConfiguration.tokenCacheCushion = ConfigConstants.validTokenCushion(n * 1000);
                            }
                            catch (NumberFormatException numberFormatException) {
                                wSSecurityDefaultConfiguration.tokenCacheCushion = 600000L;
                                FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".loadConfig", "412", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WARNING: Exception occurred during parsing the token cushion " + (String)object10 + "seconds, default " + 600 + " seconds is used instead.");
                                }
                            }
                        }
                    } else {
                        wSSecurityDefaultConfiguration.tokenCacheCushion = 600000L;
                    }
                    if ((object9 = (String)object12.get("com.ibm.ws.wssecurity.handler.OffloadAllCryptography")) != null) {
                        wSSecurityDefaultConfiguration.useOffloadAllCrypto = object9;
                    }
                    wSSecurityDefaultConfiguration.offloadRSAPublicKeyCrypto = (object8 = (String)object12.get("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography")) != null ? ConfigUtil.isTrue((String)object8) : true;
                    object7 = (String)object12.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                    wSSecurityDefaultConfiguration.hardwareCacheSize = object7 != null ? ConfigConstants.processHardwareCacheSize((String)object7) : 1000;
                    string3 = (String)object12.get("com.ibm.ws.wssecurity.handler.hardwareCacheEntryRefreshHours");
                    long l = 8L;
                    if (string3 != null) {
                        l = ConfigConstants.processHardwareCacheEntryRefresh(string3);
                    }
                    object6 = HWKeyCache.getInstance();
                    ((HWKeyCache)object6).setScanParameters(l);
                    string4 = (String)object12.get("com.ibm.ws.wssecurity.config.token.certificate.useCache");
                    if (string4 != null) {
                        wSSecurityDefaultConfiguration.useCertCache = ConfigUtil.isTrue(string4);
                    }
                    wSSecurityDefaultConfiguration.useConfigCache = (string4 = (String)object12.get("com.ibm.ws.wssecurity.handler.useConfigCache")) != null ? ConfigUtil.isTrue(string4) : true;
                    string4 = (String)object12.get("com.ibm.ws.wssecurity.handler.token.useCache");
                    wSSecurityDefaultConfiguration.useTokenCache = string4 != null ? ConfigUtil.isTrue(string4) : true;
                    object5 = (String)object12.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheName");
                    if (object5 != null) {
                        wSSecurityDefaultConfiguration.nonceCacheName = object5;
                    }
                    if ((object5 = (String)object12.get("com.ibm.ws.wssecurity.config.token.certificate.cacheName")) != null) {
                        wSSecurityDefaultConfiguration.certCacheName = object5;
                    }
                    wSSecurityDefaultConfiguration.configCacheName = (object5 = (String)object12.get("com.ibm.ws.wssecurity.handler.configCacheName")) != null ? object5 : "WSSReqGeneratorConfigMap";
                    object5 = (String)object12.get("com.ibm.ws.wssecurity.handler.token.cacheName");
                    wSSecurityDefaultConfiguration.tokenCacheName = object5 != null ? object5 : "WSSTokenCache";
                    object4 = (String)object12.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheSize");
                    if (object4 != null) {
                        wSSecurityDefaultConfiguration.nonceCacheSize = ConfigConstants.processNonceCacheSize((String)object4);
                    }
                    if ((object4 = (String)object12.get("com.ibm.ws.wssecurity.config.token.certificate.cacheSize")) != null) {
                        wSSecurityDefaultConfiguration.certCacheSize = ConfigConstants.processCertCacheSize((String)object4);
                    }
                    if ((object3 = (String)object12.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.length")) != null) {
                        wSSecurityDefaultConfiguration.nonceCacheSize = ConfigConstants.processNonceLength((String)object3);
                    }
                    if ((object4 = (String)object12.get("com.ibm.ws.wssecurity.handler.configCacheSize")) != null) {
                        try {
                            int n;
                            wSSecurityDefaultConfiguration.configCacheSize = n = Integer.parseInt((String)object4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            wSSecurityDefaultConfiguration.configCacheSize = 128;
                            FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".loadConfig", "420", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "WARNING: Exception occurred during parsing the config cache size " + (String)object4 + "default size" + 128 + " is used instead.");
                            }
                        }
                    } else {
                        wSSecurityDefaultConfiguration.configCacheSize = 128;
                    }
                    if ((object4 = (String)object12.get("com.ibm.ws.wssecurity.handler.token.cacheSize")) != null) {
                        wSSecurityDefaultConfiguration.tokenCacheSize = ConfigConstants.processTokenCacheSize((String)object4);
                    }
                    if ((string2 = (String)object12.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge")) != null) {
                        wSSecurityDefaultConfiguration.nonceMaxAge = ConfigConstants.processNonceMaxAge(string2, wSSecurityDefaultConfiguration.nonceCacheTimeout);
                    }
                    if ((string = (String)object12.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew")) != null) {
                        wSSecurityDefaultConfiguration.nonceClockSkew = ConfigConstants.processNonceClockSkew(string, wSSecurityDefaultConfiguration.nonceMaxAge);
                    }
                    wSSecurityDefaultConfiguration.decoupleToken = (object2 = (String)object12.get("com.ibm.websphere.wssecurity.util.decouple.token")) != null ? ConfigUtil.isTrue((String)object2) : true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Nonce cache timeout = " + wSSecurityDefaultConfiguration.nonceCacheTimeout + ", Nonce max age = " + wSSecurityDefaultConfiguration.nonceMaxAge + ", Nonce clock skew = " + wSSecurityDefaultConfiguration.nonceClockSkew);
                }
            }
            if ((object12 = wSSecurity.getLoginMappings()) == null || object12.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No LoginMappings found.");
                }
            } else {
                int n = object12.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, n + " LoginMappings found.");
                }
                for (int i = 0; i < n; ++i) {
                    object10 = (LoginMapping)object12.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing LoginMapping: ", new Object[]{object10});
                    }
                    try {
                        object9 = ConfigConstants.readLoginMapping((LoginMapping)object10, variableMap, this.appClassLoader);
                        wSSecurityDefaultConfiguration.loginMappings.put(((com.ibm.xml.soapsec.token.LoginMapping)object9).getAuthMethod(), object9);
                        this.processNonceBindings(((com.ibm.xml.soapsec.token.LoginMapping)object9).getAuthMethod(), ((com.ibm.xml.soapsec.token.LoginMapping)object9).getProperties(), wSSecurityDefaultConfiguration);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Tr.error(tc, "security.wssecurity.load.loginmapping.failed", new Object[]{object10.getAuthMethod(), throwable});
                    }
                }
            }
            if ((eList2 = wSSecurity.getTrustAnchors()) == null || eList2.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No TrustAnchors found.");
                }
            } else {
                int n = eList2.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, n + " TrustAnchors found.");
                }
                for (int i = 0; i < n; ++i) {
                    object9 = null;
                    object8 = (TrustAnchor)eList2.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing TrustAnchor: ", new Object[]{object8});
                    }
                    object7 = object8.getKeyStore();
                    object9 = object7.getKeyStoreRef();
                    string3 = object7.getPath();
                    KeyStore keyStore = null;
                    if (object9 != null && string3 != null) {
                        Tr.warning(tc, "Cannot refer to both keyStoreRef and keystore path in the configuration, continue to use keyStoreRef and ignore path information");
                    }
                    if (object9 != null && ((String)object9).length() != 0) {
                        keyStore = (KeyStore)wSSecurityDefaultConfiguration.keyStores.get(object9);
                        if (keyStore == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Creating keystore instance with keystore reference: " + (String)object9);
                            }
                            keyStore = new KeyStore((String)object9);
                            wSSecurityDefaultConfiguration.keyStores.put(object9, keyStore);
                        }
                    } else if (string3 != null && string3.length() != 0) {
                        keyStore = (KeyStore)wSSecurityDefaultConfiguration.keyStores.get(string3 = variableMap.expand(string3));
                        if (keyStore == null) {
                            object = object7.getType();
                            object6 = object7.getStorepass().toCharArray();
                            object9 = object7.getKeyStoreRef();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Creating keystore instance " + string3 + " of type " + (String)object);
                            }
                            keyStore = new KeyStore((String)object, string3, (char[])object6);
                            wSSecurityDefaultConfiguration.keyStores.put(string3, keyStore);
                        }
                    } else {
                        Tr.error(tc, "Missing keystore information in the trust anchor: " + object8.getName());
                    }
                    wSSecurityDefaultConfiguration.trustAnchors.put(object8.getName(), keyStore);
                }
            }
            if ((object11 = wSSecurity.getTrustedIDEvaluators()) == null || object11.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No TrustedIDEvaluators found.");
                }
            } else {
                int n = object11.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, n + " TrustedIDEvaluators found.");
                }
                for (int i = 0; i < n; ++i) {
                    object8 = (TrustedIDEvaluator)object11.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing TrustedIDEvaluator: ", new Object[]{object8});
                    }
                    try {
                        wSSecurityDefaultConfiguration.trustedIDEvaluators.put(object8.getName(), ConfigConstants.readTrustedIDEvaluator((TrustedIDEvaluator)object8, variableMap, this.appClassLoader));
                        continue;
                    }
                    catch (Throwable throwable) {
                        Tr.error(tc, "security.wssecurity.load.trustedidevaluator.failed", new Object[]{object8.getName(), throwable});
                    }
                }
            }
            if ((eList = wSSecurity.getKeyLocators()) == null || eList.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No KeyLocators found.");
                }
            } else {
                int n = eList.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, n + " KeyLocators found.");
                }
                for (int i = 0; i < n; ++i) {
                    object7 = (KeyLocator)eList.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing KeyLocator: ", new Object[]{object7});
                    }
                    try {
                        wSSecurityDefaultConfiguration.keyLocators.put(object7.getName(), ConfigConstants.readKeyLocator((KeyLocator)object7, variableMap));
                        continue;
                    }
                    catch (Throwable throwable) {
                        Tr.error(tc, "security.wssecurity.load.keylocator.failed", new Object[]{object7.getName(), throwable});
                    }
                }
            }
            if ((certStoreList = wSSecurity.getCertStoreList()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No CertStoreList found.");
                }
            } else {
                object8 = certStoreList.getLdapCertStores();
                if (object8 == null || object8.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No LDAPCertStores found.");
                    }
                } else {
                    int n = object8.size();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, n + " LDAPCertStores found.");
                    }
                    for (int i = 0; i < n; ++i) {
                        LDAPCertStore lDAPCertStore = (LDAPCertStore)object8.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Processing LDAPCertStore: ", new Object[]{lDAPCertStore});
                        }
                        try {
                            object = null;
                            object = new com.ibm.ws.webservices.wssecurity.config.LDAPCertStore(lDAPCertStore, variableMap);
                            wSSecurityDefaultConfiguration.certStores.put(lDAPCertStore.getName(), object);
                            continue;
                        }
                        catch (Throwable throwable) {
                            Tr.error(tc, "security.wssecurity.load.ldapcertstore.failed", new Object[]{lDAPCertStore.getName(), throwable});
                        }
                    }
                }
                if ((object7 = certStoreList.getCollectionCertStores()) == null || object7.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No CollectionCertStores found.");
                    }
                } else {
                    int n = object7.size();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, n + " collectionCertStores found.");
                    }
                    for (int i = 0; i < n; ++i) {
                        object = (com.ibm.etools.webservice.wscommonbnd.CollectionCertStore)object7.get(i);
                        if (object == null) {
                            Tr.error(tc, "security.wssecurity.collectioncertstore.is.null");
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Process CollectionCertStore: ", new Object[]{object});
                        }
                        object6 = object.getProvider();
                        object5 = new HashSet<String>();
                        object4 = object.getX509Certificates();
                        object3 = object.getCRL();
                        if ((object4 == null || object4.isEmpty()) && (object3 == null || object3.isEmpty())) {
                            Tr.error(tc, "security.wssecurity.x509certificates.is.null");
                            Tr.error(tc, "security.wssecurity.WSEC0134E");
                            continue;
                        }
                        string2 = "Collection";
                        string = null;
                        try {
                            String string5;
                            X509Certificate x509Certificate;
                            int n2;
                            int n3;
                            object2 = ConfigUtil.createCertificateFactory("");
                            if (object4 == null || object4.isEmpty()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "No X509 certificates in CollectionCertStore[" + object + "]");
                                }
                            } else {
                                n3 = object4.size();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, n3 + " certificates found.");
                                }
                                for (n2 = 0; n2 < n3; ++n2) {
                                    x509Certificate = (X509Certificate)object4.get(n2);
                                    string5 = variableMap.expand(x509Certificate.getPath());
                                    if (string5 == null) {
                                        Tr.error(tc, "security.wssecurity.cert.path.null", new Object[]{object.getName()});
                                        continue;
                                    }
                                    if (object5.contains(string5)) {
                                        if (!tc.isDebugEnabled()) continue;
                                        Tr.debug(tc, "href already in HashSet: " + string5);
                                        continue;
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding href to HashSet: " + string5);
                                    }
                                    object5.add(string5);
                                }
                            }
                            if (object3 == null || object3.isEmpty()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "No X509 crls in CollectionCertStore[" + object + "]");
                                }
                            } else {
                                n3 = object3.size();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, n3 + " CRLs found.");
                                }
                                for (n2 = 0; n2 < n3; ++n2) {
                                    x509Certificate = (CRL)object3.get(n2);
                                    string5 = variableMap.expand(x509Certificate.getPath());
                                    if (string5 == null) {
                                        Tr.error(tc, "security.wssecurity.cert.path.null", new Object[]{object.getName()});
                                        continue;
                                    }
                                    if (object5.contains(string5)) {
                                        if (!tc.isDebugEnabled()) continue;
                                        Tr.debug(tc, "href already in HashSet: " + string5);
                                        continue;
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding href to HashSet: " + string5);
                                    }
                                    object5.add(string5);
                                }
                            }
                            CollectionCertStore collectionCertStore = null;
                            collectionCertStore = new CollectionCertStore(string2, (Set)object5, (String)object6, object.getName());
                            wSSecurityDefaultConfiguration.certStores.put(object.getName(), collectionCertStore);
                            continue;
                        }
                        catch (Throwable throwable) {
                            Tr.error(tc, "security.wssecurity.load.collectioncertstore.failed", new Object[]{object.getName(), throwable});
                        }
                    }
                }
            }
            if ((object8 = wSSecurity.getAlgorithmMapping()) == null || object8.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No AlgorithmMappings found.");
                }
            } else {
                int n = object8.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, n + " AlgorithmMappings found.");
                }
                for (int i = 0; i < n; ++i) {
                    AlgorithmMapping algorithmMapping = (AlgorithmMapping)object8.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Process AlgorithmMapping: ", new Object[]{algorithmMapping});
                    }
                    try {
                        wSSecurityDefaultConfiguration.algorithmMappings.add(ConfigConstants.readAlgorithmMapping(algorithmMapping, variableMap));
                        continue;
                    }
                    catch (Throwable throwable) {
                        Tr.error(tc, "security.wssecurity.load.algorithmmapping.failed", new Object[]{algorithmMapping.getFactoryname(), throwable});
                    }
                }
            }
            if ((nonceCaching = wSSecurity.getNonceCaching()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No NonceCaching found.");
                }
            } else {
                wSSecurityDefaultConfiguration.nonceCacheDistributed = nonceCaching.isDistributed();
            }
            if ((string3 = wSSecurity.getDefaultbindings()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No default bindings found.");
                }
            } else {
                Consumer consumer = string3.getConsumer();
                if (consumer != null) {
                    wSSecurityDefaultConfiguration.cconfig = new WSSecurityDefaultConsumerConfig(consumer, variableMap, wSSecurityDefaultConfiguration);
                }
                if ((object = string3.getGenerator()) != null) {
                    wSSecurityDefaultConfiguration.gconfig = null;
                    try {
                        wSSecurityDefaultConfiguration.gconfig = new WSSecurityDefaultGeneratorConfig((Generator)object, variableMap, wSSecurityDefaultConfiguration);
                    }
                    catch (SoapSecurityException soapSecurityException) {
                        Tr.error(tc, "security.wssecurity.WSEC0135E", new Object[]{soapSecurityException.getMessage()});
                    }
                }
            }
        }
        finally {
            if (variableMap != null) {
                this.releaseService(variableMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfig", new Object[]{wSSecurity, wSSecurityDefaultConfiguration});
        }
    }

    private void processNonceBindings(String string, Map map, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processNonceBindings");
        }
        if (bl = "BasicAuth".equals(string)) {
            String string2;
            String string3 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge");
            if (string3 != null) {
                wSSecurityDefaultConfiguration.nonceMaxAge = ConfigConstants.processNonceMaxAge(string3, wSSecurityDefaultConfiguration.nonceCacheTimeout);
            }
            if ((string2 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew")) != null) {
                wSSecurityDefaultConfiguration.nonceClockSkew = ConfigConstants.processNonceClockSkew(string2, wSSecurityDefaultConfiguration.nonceMaxAge);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " Nonce max age = " + wSSecurityDefaultConfiguration.nonceMaxAge + ", Nonce clock skew = " + wSSecurityDefaultConfiguration.nonceClockSkew);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processNonceBindings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void refresh() throws RuntimeWarning {
        block26: {
            if (WSSecurityComponentImpl.tc.isEntryEnabled()) {
                Tr.entry(WSSecurityComponentImpl.tc, "refresh");
            }
            if ((var1_1 = System.getSecurityManager()) != null) {
                var1_1.checkPermission(WSSecurityComponentImpl.REFRESH_PERM);
            }
            var2_2 = null;
            var3_3 = null;
            var4_4 = new WSSecurityDefaultConfiguration();
            try {
                block25: {
                    var2_2 = (Repository)this.getService(Repository.class);
                    var3_3 = var2_2.getConfigRoot();
                    if (this.ndEnvironment) {
                        var5_5 = null;
                        try {
                            var5_5 = var3_3.getResource(0, "ws-security.xml");
                        }
                        catch (Exception var6_7) {
                            var7_10 = var3_3.getAbsolutePath(0, "ws-security.xml");
                            FFDCFilter.processException((Throwable)var6_7, this.getClass().getName() + ".refresh", "814", this);
                            var8_12 = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.load.cell.wssecurity.xml"), new Object[]{var7_10});
                            Tr.warning(WSSecurityComponentImpl.tc, "security.wssecurity.load.cell.wssecurity.xml", new Object[]{var7_10});
                            throw new RuntimeWarning(var8_12, var6_7);
                        }
                        if (var5_5 != null) {
                            var6_8 = (WSSecurity)var5_5.getContents().get(0);
                            if (var6_8 != null && WSSecurityComponentImpl.tc.isDebugEnabled()) {
                                Tr.debug(WSSecurityComponentImpl.tc, "Loading the Cell level configuration: " + var3_3.getAbsolutePath(0, "ws-security.xml"));
                            }
                            this.loadConfig((WSSecurity)var6_8, var4_4);
                        }
                    }
                    var5_5 = null;
                    try {
                        var5_5 = var3_3.getResource(4, "ws-security.xml");
                    }
                    catch (Exception var6_9) {
                        if (this.ndEnvironment) break block25;
                        var7_11 = var3_3.getAbsolutePath(4, "ws-security.xml");
                        if (WSSecurityComponentImpl.tc.isDebugEnabled()) {
                            Tr.debug(WSSecurityComponentImpl.tc, "Can not load server level configuration file: " + var7_11, new Object[]{var6_9});
                        }
                        Tr.warning(WSSecurityComponentImpl.tc, "security.wssecurity.load.server.wssecurity.xml", new Object[]{var7_11});
                    }
                }
                if (var5_5 != null) {
                    var6_8 = (WSSecurity)var5_5.getContents().get(0);
                    if (var6_8 != null && WSSecurityComponentImpl.tc.isDebugEnabled()) {
                        Tr.debug(WSSecurityComponentImpl.tc, "Loading the Server level configuration: " + var3_3.getAbsolutePath(4, "ws-security.xml"));
                    }
                    this.loadConfig((WSSecurity)var6_8, var4_4);
                }
                var6_8 = this.lock;
                synchronized (var6_8) {
                    var4_4.keyStores.clear();
                    var4_4.certs.clear();
                    this.config = var4_4;
                }
                if (WSSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug(WSSecurityComponentImpl.tc, "Configuration: ", new Object[]{this.config});
                }
                if (var3_3 == null) break block26;
            }
            catch (SoapSecurityException var5_6) {
                block27: {
                    try {
                        FFDCFilter.processException((Throwable)var5_6, WSSecurityClientComponentImpl.class.getName() + ".initialize", "865", this);
                        Tr.error(WSSecurityComponentImpl.tc, "security.wssecurity.WSEC0126E", var5_6);
                        if (var3_3 == null) break block27;
                    }
                    catch (Throwable var10_14) {
                        if (var3_3 != null) {
                            this.releaseService(var3_3);
                        }
                        if (var2_2 != null) {
                            this.releaseService(var2_2);
                        }
                        throw var10_14;
                    }
                    this.releaseService(var3_3);
                }
                if (var2_2 != null) {
                    this.releaseService(var2_2);
                } else {
                    ** GOTO lbl76
                }
            }
            this.releaseService(var3_3);
        }
        if (var2_2 != null) {
            this.releaseService(var2_2);
        }
        if (WSSecurityComponentImpl.tc.isEntryEnabled()) {
            Tr.exit(WSSecurityComponentImpl.tc, "refresh");
        }
    }

    private class WSSecurityListener
    implements SecurityServiceListener {
        private WSSecurity cell;
        private WSSecurity server;

        private WSSecurityListener(WSSecurity wSSecurity, WSSecurity wSSecurity2) {
            this.cell = wSSecurity;
            this.server = wSSecurity2;
        }

        public void stateChanged(SecurityServiceEvent securityServiceEvent) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stateChanged");
            }
            if (securityServiceEvent.getState() == 1) {
                WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = new WSSecurityDefaultConfiguration();
                try {
                    if (WSSecurityComponentImpl.this.ndEnvironment && this.cell != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loading the Cell level configuration");
                        }
                        WSSecurityComponentImpl.this.loadConfig(this.cell, wSSecurityDefaultConfiguration);
                    }
                    if (this.server != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loading the Server level configuration");
                        }
                        WSSecurityComponentImpl.this.loadConfig(this.server, wSSecurityDefaultConfiguration);
                    }
                }
                catch (SoapSecurityException soapSecurityException) {
                    FFDCFilter.processException((Throwable)soapSecurityException, (class$com$ibm$ws$webservices$wssecurity$core$WSSecurityClientComponentImpl == null ? (class$com$ibm$ws$webservices$wssecurity$core$WSSecurityClientComponentImpl = WSSecurityComponentImpl.class$("com.ibm.ws.webservices.wssecurity.core.WSSecurityClientComponentImpl")) : class$com$ibm$ws$webservices$wssecurity$core$WSSecurityClientComponentImpl).getName() + ".initialize", "912", this);
                    Tr.error(tc, "security.wssecurity.WSEC0126E", soapSecurityException);
                }
                wSSecurityDefaultConfiguration.keyStores.clear();
                wSSecurityDefaultConfiguration.certs.clear();
                WSSecurityComponentImpl.this.config = wSSecurityDefaultConfiguration;
                if (!WSSecurityComponentImpl.this.initialized) {
                    NonceManagerFactory.init(((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.useNonceCache, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.nonceCacheName, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.nonceCacheSize, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.nonceCacheTimeout, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.nonceLength, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.nonceCacheDistributed);
                    CertManagerFactory.init(((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.useCertCache, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.certCacheName, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.certCacheSize, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.certCacheTimeOut);
                    DistributedConfigCacheFactory.init_boot(((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.useConfigCache, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.configCacheName, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.configCacheSize, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.configCacheTimeToLive);
                    TokenCacheManagerFactory.init(((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.useTokenCache, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.tokenCacheName, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.tokenCacheSize, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.tokenCacheTimeOut, ((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.tokenCacheCushion);
                }
                WSSecurityComponentImpl.this.initialized = true;
                if (WSSecurityComponentImpl.this.wssecAdmin != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "(Start) set WSSecurityService to WebServicesSecurityAdmin MBean");
                    }
                    WSSecurityComponentImpl.this.wssecAdmin.setWSSecurityService(WSSecurityComponentImpl.this);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Configuration: ", new Object[]{WSSecurityComponentImpl.this.config});
                }
            } else if (securityServiceEvent.getState() == 2 && WSSecurityComponentImpl.this.wssecAdmin != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "(Stop) remove WSSecurityService from WebServicesSecurityAdmin MBean");
                }
                WSSecurityComponentImpl.this.wssecAdmin.setWSSecurityService(null);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stateChanged");
            }
        }
    }
}

