/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.TokenConsumer;
import com.ibm.etools.webservice.wscommonbnd.Transform;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluatorRef;
import com.ibm.etools.webservice.wscommonbnd.ValueType;
import com.ibm.etools.webservice.wssecurity.Consumer;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.webservices.wssecurity.config.Configuration;
import com.ibm.ws.webservices.wssecurity.config.KeyStore;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyLocatorProxy;
import com.ibm.ws.webservices.wssecurity.util.ClientVariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.WebServicesSecurityAlgorithmHelper;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public class WSSecurityDefaultConsumerConfig
extends PrivateConsumerConfig {
    private static final TraceComponent tc = Tr.register(WSSecurityDefaultConsumerConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityDefaultConsumerConfig.class.getName();

    public WSSecurityDefaultConsumerConfig(Consumer consumer, VariableMap variableMap, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSecurityDefaultConsumerConfig(Consumer, VariableMap, WSSecurityDefaultConfiguration):", new Object[]{consumer, variableMap, wSSecurityDefaultConfiguration});
        }
        if (variableMap == null) {
            variableMap = ClientVariableMap.getInstance();
        }
        this.init(consumer, variableMap, wSSecurityDefaultConfiguration);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSecurityDefaultConsumerConfig(Consumer, VariableMap, WSSecurityDefaultConfiguration)");
        }
    }

    protected final void init(Consumer consumer, VariableMap variableMap, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) throws SoapSecurityException {
        int n;
        int n2;
        PrivateConsumerConfig.KeyInfoConsumerConfImpl keyInfoConsumerConfImpl;
        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl;
        PrivateConsumerConfig.KeyInfoContentConsumerConfImpl keyInfoContentConsumerConfImpl;
        Transform transform;
        EList eList;
        CertStoreRef certStoreRef;
        Object object;
        TrustedIDEvaluatorRef trustedIDEvaluatorRef;
        EList eList2;
        Object object2;
        String string;
        PartReference partReference;
        QName qName;
        ValueType valueType;
        int n3;
        int n4;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Consumer, VariableMap, WSSecurityDefaultConfiguration):", new Object[]{consumer, variableMap, wSSecurityDefaultConfiguration});
        }
        ClassLoader classLoader = null;
        boolean bl = false;
        WebServicesSecurityAlgorithmHelper webServicesSecurityAlgorithmHelper = null;
        WSSFactory wSSFactory = WSSFactory.getInstance("soap");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Configuration> hashMap2 = new HashMap<String, Configuration>();
        bl = ConfigValidation.isFipsEnabled();
        if (bl) {
            webServicesSecurityAlgorithmHelper = new WebServicesSecurityAlgorithmHelper();
        }
        EList eList3 = null;
        EList eList4 = null;
        EList eList5 = null;
        EList eList6 = null;
        Map map = null;
        this._properties = new HashMap();
        if (wSSecurityDefaultConfiguration != null && (object3 = wSSecurityDefaultConfiguration.getProperties()) != null) {
            this._properties.putAll(object3);
        }
        if (consumer != null) {
            eList3 = consumer.getEncryptionInfo();
            eList4 = consumer.getKeyInfo();
            eList5 = consumer.getSigningInfo();
            eList6 = consumer.getTokenConsumer();
            object3 = consumer.getProperties();
            if (object3 != null) {
                map = ConfigConstants.getProperties((EList)object3, variableMap);
                this._properties.putAll(map);
            }
            if (tc.isDebugEnabled()) {
                if (map != null) {
                    Tr.debug(tc, "Default Consumer Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenConsumers, Property):", new Object[]{eList5, eList3, eList4, eList6, map});
                } else {
                    Tr.debug(tc, "Default Consumer Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenConsumers):", new Object[]{eList5, eList3, eList4, eList6});
                }
            }
        }
        this._bypassSecurityHeader = ConfigUtil.getIsTruePropertyEnv(this._properties, "com.ibm.wsspi.wssecurity.config.disableWSSIfApplicationSecurityDisabled");
        if (eList6 != null) {
            n4 = eList6.size();
            for (n3 = 0; n3 < n4; ++n3) {
                object3 = (TokenConsumer)eList6.get(n3);
                valueType = object3.getValueType();
                if (valueType == null) {
                    throw new SoapSecurityException("The valueType field for the token consumer named " + object3.getName() + " is missing");
                }
                qName = new QName(ConfigUtil.trim(valueType.getUri()), ConfigUtil.trim(valueType.getLocalName()));
                partReference = object3.getPartReference();
                PrivateConsumerConfig.TokenConsumerConfImpl tokenConsumerConfImpl = null;
                if (partReference != null && (string = ConfigUtil.trim(partReference.getPart())) != null && string.length() > 0) {
                    tokenConsumerConfImpl = (PrivateConsumerConfig.TokenConsumerConfImpl)hashMap2.get(string);
                    if (tokenConsumerConfImpl == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                    }
                    if (!tokenConsumerConfImpl.getType().equals(qName)) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s30", new Object[]{tokenConsumerConfImpl.getType().toString(), qName.toString()});
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + string);
                    }
                }
                if (tokenConsumerConfImpl == null) {
                    tokenConsumerConfImpl = new PrivateConsumerConfig.TokenConsumerConfImpl();
                    tokenConsumerConfImpl._type = qName;
                }
                tokenConsumerConfImpl._isDefault = true;
                tokenConsumerConfImpl._name = ConfigUtil.trim(object3.getName());
                ConfigConstants.getProperties(tokenConsumerConfImpl._properties, object3.getProperties(), variableMap);
                tokenConsumerConfImpl._className = ConfigUtil.trim(object3.getClassname());
                object2 = object3.getJAASConfig();
                if (object2 != null) {
                    tokenConsumerConfImpl._jaasConfig = ConfigUtil.trim(object2.getConfigName());
                    ConfigConstants.getProperties(tokenConsumerConfImpl._jaasConfigProperties, object2.getProperties(), variableMap);
                }
                if ((eList2 = object3.getCertPathSettings()) != null) {
                    tokenConsumerConfImpl._certPathSettingsAcquired = true;
                    trustedIDEvaluatorRef = eList2.getTrustAnyCertificate();
                    if (trustedIDEvaluatorRef != null) {
                        tokenConsumerConfImpl._trustAny = true;
                    } else {
                        object = eList2.getTrustAnchorRef();
                        certStoreRef = eList2.getCertStoreRef();
                        if (object != null || certStoreRef != null) {
                            eList = null;
                            if (object != null) {
                                transform = null;
                                Object var41_33 = null;
                                string = ConfigUtil.trim(object.getRef());
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "TrustAnchorRef = " + string);
                                }
                                tokenConsumerConfImpl._trustAnchorRef = string;
                                tokenConsumerConfImpl._trustAnchorKeyStore = (KeyStore)wSSecurityDefaultConfiguration.trustAnchors.get(string);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "_trustAnchorKeyStore = " + tokenConsumerConfImpl._trustAnchorKeyStore);
                                }
                                if (certStoreRef != null) {
                                    Object object4;
                                    string = ConfigUtil.trim(certStoreRef.getRef());
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "CertStoreRef = " + string);
                                    }
                                    if ((object4 = wSSecurityDefaultConfiguration.getWSCertStore(string)) == null) {
                                        String string2 = "security.wssecurity.ConfigValidation.csref.notfound";
                                        Tr.error(tc, string2, new Object[]{string});
                                    } else {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Found CertStore for " + string);
                                        }
                                        tokenConsumerConfImpl._certStores.add(object4);
                                    }
                                }
                                tokenConsumerConfImpl._provider = var41_33;
                                tokenConsumerConfImpl._pkixBuilderParams = transform;
                            }
                        }
                    }
                    if (tokenConsumerConfImpl._trustAnchorRef != null && tokenConsumerConfImpl._provider == null) {
                        tokenConsumerConfImpl._provider = ConfigUtil.setupCertStoreProvider(this._properties, tokenConsumerConfImpl._properties, tokenConsumerConfImpl._name);
                    }
                }
                if ((trustedIDEvaluatorRef = object3.getTrustedIDEvaluatorRef()) != null) {
                    object = ConfigUtil.trim(trustedIDEvaluatorRef.getRef());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding TrustID Evaluator Reference: " + (String)object);
                    }
                    tokenConsumerConfImpl._trustedIDEvaluator = wSSecurityDefaultConfiguration.getTrustedIDEvaluator((String)object);
                }
                hashMap.clear();
                hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", tokenConsumerConfImpl._className);
                object = new HashMap();
                try {
                    tokenConsumerConfImpl._instance = (TokenConsumerComponent)wSSFactory.createConsumer(hashMap, (Map)object);
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{tokenConsumerConfImpl._className});
                }
                this._tokenConsumers.add(tokenConsumerConfImpl);
                string = ConfigUtil.trim(object3.getName());
                if (string == null || string.length() == 0) {
                    Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s26");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding token consumer: " + string);
                }
                hashMap2.put(string, tokenConsumerConfImpl);
            }
        }
        object3 = new ArrayList();
        if (eList4 != null) {
            n4 = eList4.size();
            for (n3 = 0; n3 < n4; ++n3) {
                valueType = (KeyInfo)eList4.get(n3);
                keyInfoContentConsumerConfImpl = new PrivateConsumerConfig.KeyInfoContentConsumerConfImpl();
                keyInfoContentConsumerConfImpl._className = ConfigUtil.trim(valueType.getClassname());
                keyInfoContentConsumerConfImpl._keyInfoType = ConfigUtil.trim(valueType.getType());
                qName = valueType.getKeyLocatorMapping();
                if (qName != null) {
                    string = ConfigUtil.trim(qName.getLocatorRef());
                    if (string != null && string.length() > 0) {
                        KeyLocatorProxy keyLocatorProxy = wSSecurityDefaultConfiguration.getKeyLocator(string);
                        if (keyLocatorProxy == null) {
                            Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                        } else {
                            try {
                                keyInfoContentConsumerConfImpl._keyLocator = keyLocatorProxy.getKeyLocator6(classLoader);
                            }
                            catch (SoapSecurityException soapSecurityException) {
                                Tr.warning(tc, "security.wssecurity.keylocator.is.null", new Object[]{soapSecurityException});
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got the key locator mapping: " + string);
                            }
                        }
                    }
                    keyInfoContentConsumerConfImpl._keyName = ConfigUtil.trim(qName.getKeynameRef());
                }
                if ((partReference = valueType.getTokenReference()) != null && (string = ConfigUtil.trim(partReference.getTokenRef())) != null && string.length() > 0) {
                    keyInfoContentConsumerConfImpl._tokenConsumer = (PrivateConsumerConfig.TokenConsumerConfImpl)hashMap2.get(string);
                    if (keyInfoContentConsumerConfImpl._tokenConsumer == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the token reference: " + string);
                    }
                }
                ConfigConstants.getProperties(keyInfoContentConsumerConfImpl._properties, valueType.getProperties(), variableMap);
                hashMap.clear();
                hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", keyInfoContentConsumerConfImpl._className);
                object2 = new HashMap();
                try {
                    keyInfoContentConsumerConfImpl._instance = (KeyInfoContentConsumerComponent)wSSFactory.createConsumer(hashMap, (Map)object2);
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{keyInfoContentConsumerConfImpl._className});
                }
                object3.add(keyInfoContentConsumerConfImpl);
                string = ConfigUtil.trim(valueType.getName());
                if (string == null || string.length() == 0) {
                    Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s28");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key info: " + string);
                }
                hashMap2.put(string, keyInfoContentConsumerConfImpl);
            }
        }
        if (eList3 != null) {
            n4 = eList3.size();
            for (n3 = 0; n3 < n4; ++n3) {
                valueType = (EncryptionInfo)eList3.get(n3);
                PrivateConsumerConfig.EncryptionConsumerConfImpl encryptionConsumerConfImpl = new PrivateConsumerConfig.EncryptionConsumerConfImpl();
                qName = valueType.getEncryptionMethod();
                algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                algorithmConfImpl._algorithm = ConfigUtil.trim(qName.getAlgorithm());
                if (!bl || webServicesSecurityAlgorithmHelper.getFipsDataEncryptionAlgorithms().contains(algorithmConfImpl._algorithm)) {
                    ConfigConstants.getProperties(algorithmConfImpl._properties, qName.getProperties(), variableMap);
                    encryptionConsumerConfImpl._dataEncryptionMethod = algorithmConfImpl;
                } else {
                    Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"DataEncryptionMethod", algorithmConfImpl._algorithm});
                }
                partReference = valueType.getKeyEncryptionMethod();
                if (partReference != null) {
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = ConfigUtil.trim(partReference.getAlgorithm());
                    if (!bl || webServicesSecurityAlgorithmHelper.getFipsKeyEncryptionAlgorithms().contains(algorithmConfImpl._algorithm)) {
                        ConfigConstants.getProperties(algorithmConfImpl._properties, partReference.getProperties(), variableMap);
                        encryptionConsumerConfImpl._keyEncryptionMethod = algorithmConfImpl;
                    } else {
                        Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"KeyEncryptionMethod", algorithmConfImpl._algorithm});
                    }
                }
                keyInfoConsumerConfImpl = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                object2 = valueType.getEncryptionKeyInfo();
                if (object2 == null || object2.size() == 0) {
                    keyInfoConsumerConfImpl._contentConsumers = object3;
                } else {
                    keyInfoConsumerConfImpl._contentConsumers = new ArrayList();
                    n2 = object2.size();
                    for (n = 0; n < n2; ++n) {
                        eList2 = (EncryptionKeyInfo)object2.get(n);
                        string = ConfigUtil.trim(eList2.getKeyinfoRef());
                        if (string == null || string.length() <= 0) continue;
                        keyInfoContentConsumerConfImpl = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)hashMap2.get(string);
                        if (keyInfoContentConsumerConfImpl == null) {
                            Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                            continue;
                        }
                        keyInfoConsumerConfImpl._contentConsumers.add(keyInfoContentConsumerConfImpl);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Got the key info reference: " + string);
                    }
                }
                encryptionConsumerConfImpl._encryptionKeyInfo = keyInfoConsumerConfImpl;
                eList2 = valueType.getPartReference();
                if (eList2 != null && (string = ConfigUtil.trim(eList2.getPart())) != null && string.length() > 0) {
                    encryptionConsumerConfImpl._reference = (PrivateCommonConfig.ReferencePartConfImpl)hashMap2.get(string);
                    if (encryptionConsumerConfImpl._reference == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + string);
                    }
                }
                ConfigConstants.getProperties(encryptionConsumerConfImpl._properties, valueType.getProperties(), variableMap);
                this._encryptionConsumers.add(encryptionConsumerConfImpl);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding encryption consumer.");
            }
        }
        if (eList5 != null) {
            n4 = eList5.size();
            for (n3 = 0; n3 < n4; ++n3) {
                valueType = (SigningInfo)eList5.get(n3);
                PrivateConsumerConfig.SignatureConsumerConfImpl signatureConsumerConfImpl = new PrivateConsumerConfig.SignatureConsumerConfImpl();
                qName = valueType.getCanonicalizationMethod();
                if (qName == null) {
                    Tr.warning(tc, "security.wssecurity.nocanonicalization.algo");
                } else {
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = ConfigUtil.trim(qName.getAlgorithm());
                    ConfigConstants.getProperties(algorithmConfImpl._properties, qName.getProperties(), variableMap);
                    signatureConsumerConfImpl._canonicalizationMethod = algorithmConfImpl;
                }
                partReference = valueType.getSignatureMethod();
                if (qName == null) {
                    Tr.warning(tc, "security.wssecurity.nosignature.algo");
                } else {
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = ConfigUtil.trim(partReference.getAlgorithm());
                    if (!bl || webServicesSecurityAlgorithmHelper.getFipsSignatureAlgorithms().contains(algorithmConfImpl._algorithm)) {
                        ConfigConstants.getProperties(algorithmConfImpl._properties, partReference.getProperties(), variableMap);
                        signatureConsumerConfImpl._signatureMethod = algorithmConfImpl;
                    } else {
                        Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"SignatureMethod", algorithmConfImpl._algorithm});
                    }
                }
                object2 = valueType.getKeyInfoSignature();
                if (object2 != null) {
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = ConfigUtil.trim(object2.getType());
                    ConfigConstants.getProperties(algorithmConfImpl._properties, object2.getProperties(), variableMap);
                    signatureConsumerConfImpl._keyInfoSignature = algorithmConfImpl;
                }
                keyInfoConsumerConfImpl = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                eList2 = valueType.getSigningKeyInfo();
                if (eList2 == null || eList2.size() == 0) {
                    keyInfoConsumerConfImpl._contentConsumers = object3;
                } else {
                    keyInfoConsumerConfImpl._contentConsumers = new ArrayList();
                    n2 = eList2.size();
                    for (n = 0; n < n2; ++n) {
                        trustedIDEvaluatorRef = (SigningKeyInfo)eList2.get(n);
                        string = ConfigUtil.trim(trustedIDEvaluatorRef.getKeyinfoRef());
                        if (string == null || string.length() <= 0) continue;
                        keyInfoContentConsumerConfImpl = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)hashMap2.get(string);
                        if (keyInfoContentConsumerConfImpl == null) {
                            Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                            continue;
                        }
                        keyInfoConsumerConfImpl._contentConsumers.add(keyInfoContentConsumerConfImpl);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Got the key info reference: " + string);
                    }
                }
                signatureConsumerConfImpl._signingKeyInfo = keyInfoConsumerConfImpl;
                trustedIDEvaluatorRef = valueType.getPartReference();
                if (trustedIDEvaluatorRef != null) {
                    n2 = trustedIDEvaluatorRef.size();
                    for (n = 0; n < n2; ++n) {
                        object = (PartReference)trustedIDEvaluatorRef.get(n);
                        PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl = new PrivateCommonConfig.SigningReferenceConfImpl();
                        string = ConfigUtil.trim(object.getPart());
                        if (string != null && string.length() > 0) {
                            signingReferenceConfImpl._reference = (PrivateCommonConfig.ReferencePartConfImpl)hashMap2.get(string);
                            if (signingReferenceConfImpl._reference == null) {
                                Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got the part reference: " + string);
                            }
                        }
                        if ((certStoreRef = object.getDigestMethod()) == null) {
                            Tr.warning(tc, "security.wssecurity.nodigest.algo");
                        } else {
                            algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                            algorithmConfImpl._algorithm = ConfigUtil.trim(certStoreRef.getAlgorithm());
                            if (!bl || webServicesSecurityAlgorithmHelper.getFipsDigestAlgorithms().contains(algorithmConfImpl._algorithm)) {
                                ConfigConstants.getProperties(algorithmConfImpl._properties, certStoreRef.getProperties(), variableMap);
                                signingReferenceConfImpl._digestMethod = algorithmConfImpl;
                            } else {
                                Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"DigestMethod", algorithmConfImpl._algorithm});
                            }
                        }
                        eList = object.getTransform();
                        if (eList != null) {
                            int n5 = eList.size();
                            for (int i = 0; i < n5; ++i) {
                                transform = (Transform)eList.get(i);
                                if (transform == null) continue;
                                algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                                algorithmConfImpl._algorithm = ConfigUtil.trim(transform.getAlgorithm());
                                ConfigConstants.getProperties(algorithmConfImpl._properties, transform.getProperties(), variableMap);
                                signingReferenceConfImpl._transforms.add(algorithmConfImpl);
                            }
                        }
                        signatureConsumerConfImpl._references.add(signingReferenceConfImpl);
                    }
                }
                ConfigConstants.getProperties(signatureConsumerConfImpl._properties, valueType.getProperties(), variableMap);
                this._signatureConsumers.add(signatureConsumerConfImpl);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding signature consumer.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Consumer, VariableMap, WSSecurityDefaultConfiguration)");
        }
    }
}

