/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.BasicAuth;
import com.ibm.etools.webservice.wscommonbnd.CallbackHandler;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.TokenGenerator;
import com.ibm.etools.webservice.wscommonbnd.Transform;
import com.ibm.etools.webservice.wscommonbnd.ValueType;
import com.ibm.etools.webservice.wssecurity.Generator;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.webservices.wssecurity.config.Configuration;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyLocatorProxy;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.WebServicesSecurityAlgorithmHelper;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public class WSSecurityDefaultGeneratorConfig
extends PrivateGeneratorConfig {
    private static final TraceComponent tc = Tr.register(WSSecurityDefaultGeneratorConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityDefaultGeneratorConfig.class.getName();

    public WSSecurityDefaultGeneratorConfig(Generator generator, VariableMap variableMap, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSecurityDefaultGeneratorConfig(Generator, VariableMap, WSSecurityDefaultConfiguration):", new Object[]{generator, variableMap, wSSecurityDefaultConfiguration});
        }
        this.init(generator, variableMap, wSSecurityDefaultConfiguration);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSecurityDefaultGeneratorConfig(Generator, VariableMap, WSSecurityDefaultConfiguration)");
        }
    }

    protected final void init(Generator generator, VariableMap variableMap, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) throws SoapSecurityException {
        PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfoGeneratorConfImpl;
        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl;
        PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl keyInfoContentGeneratorConfImpl;
        Object object;
        EList eList;
        BasicAuth basicAuth;
        int n;
        int n2;
        Object object2;
        CertPathSettings certPathSettings;
        CallbackHandler callbackHandler;
        String string;
        Object object3;
        QName qName;
        ValueType valueType;
        int n3;
        int n4;
        Map map;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Generator, VariableMap, WSSecurityDefaultConfiguration):", new Object[]{generator, variableMap, wSSecurityDefaultConfiguration});
        }
        ClassLoader classLoader = null;
        boolean bl = false;
        WebServicesSecurityAlgorithmHelper webServicesSecurityAlgorithmHelper = null;
        WSSFactory wSSFactory = WSSFactory.getInstance("soap");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Configuration> hashMap2 = new HashMap<String, Configuration>();
        bl = ConfigValidation.isFipsEnabled();
        if (bl) {
            webServicesSecurityAlgorithmHelper = new WebServicesSecurityAlgorithmHelper();
        }
        EList eList2 = null;
        EList eList3 = null;
        EList eList4 = null;
        EList eList5 = null;
        Map map2 = null;
        this._properties = new HashMap();
        if (wSSecurityDefaultConfiguration != null && (map = wSSecurityDefaultConfiguration.getProperties()) != null) {
            this._properties.putAll(map);
        }
        if (generator != null) {
            eList2 = generator.getSigningInfo();
            eList3 = generator.getEncryptionInfo();
            eList4 = generator.getKeyInfo();
            eList5 = generator.getTokenGenerator();
            map = generator.getProperties();
            if (map != null) {
                map2 = ConfigConstants.getProperties((EList)map, variableMap);
                this._properties.putAll(map2);
            }
            if (tc.isDebugEnabled()) {
                if (map2 != null) {
                    Tr.debug(tc, "Default Generator Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenGenerators, Property):", new Object[]{eList2, eList3, eList4, eList5, map2});
                } else {
                    Tr.debug(tc, "Default Generator Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenGenerators):", new Object[]{eList2, eList3, eList4, eList5});
                }
            }
        }
        if (eList5 != null) {
            n4 = eList5.size();
            for (n3 = 0; n3 < n4; ++n3) {
                map = (TokenGenerator)eList5.get(n3);
                valueType = map.getValueType();
                if (valueType == null) {
                    throw new SoapSecurityException("The valueType field for the token generator named " + map.getName() + " is missing");
                }
                qName = new QName(ConfigUtil.trim(valueType.getUri()), ConfigUtil.trim(valueType.getLocalName()));
                object3 = map.getPartReference();
                PrivateGeneratorConfig.TokenGeneratorConfImpl tokenGeneratorConfImpl = null;
                if (object3 != null && (string = ConfigUtil.trim(object3.getPart())) != null && string.length() > 0) {
                    tokenGeneratorConfImpl = (PrivateGeneratorConfig.TokenGeneratorConfImpl)hashMap2.get(string);
                    if (tokenGeneratorConfImpl == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                    }
                    if (!tokenGeneratorConfImpl.getType().equals(qName)) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s30", new Object[]{tokenGeneratorConfImpl.getType().toString(), qName.toString()});
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + string);
                    }
                }
                if (tokenGeneratorConfImpl == null) {
                    tokenGeneratorConfImpl = new PrivateGeneratorConfig.TokenGeneratorConfImpl();
                    tokenGeneratorConfImpl._type = qName;
                }
                tokenGeneratorConfImpl._className = ConfigUtil.trim(map.getClassname());
                callbackHandler = map.getCallbackHandler();
                if (callbackHandler != null) {
                    PrivateGeneratorConfig.CallbackHandlerConfImpl callbackHandlerConfImpl = new PrivateGeneratorConfig.CallbackHandlerConfImpl();
                    callbackHandlerConfImpl._className = ConfigUtil.trim(callbackHandler.getClassname());
                    certPathSettings = callbackHandler.getKeyStore();
                    if (certPathSettings != null) {
                        PrivateCommonConfig.KeyStoreConfImpl keyStoreConfImpl = new PrivateCommonConfig.KeyStoreConfImpl();
                        keyStoreConfImpl._type = ConfigUtil.trim(certPathSettings.getType());
                        keyStoreConfImpl._path = variableMap.expand(ConfigUtil.trim(certPathSettings.getPath()));
                        keyStoreConfImpl._password = ConfigUtil.trim(certPathSettings.getStorepass());
                        keyStoreConfImpl._ksRef = ConfigUtil.trim(certPathSettings.getKeyStoreRef());
                        keyStoreConfImpl.validate();
                        callbackHandlerConfImpl._keyStoreConfig = keyStoreConfImpl;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "callbackHandler.getKeyStore() returned null");
                    }
                    object2 = callbackHandler.getKey();
                    n2 = object2.size();
                    for (n = 0; n < n2; ++n) {
                        basicAuth = (Key)object2.get(n);
                        PrivateCommonConfig.KeyInformationConfImpl keyInformationConfImpl = new PrivateCommonConfig.KeyInformationConfImpl();
                        keyInformationConfImpl._alias = ConfigUtil.trim(basicAuth.getAlias());
                        keyInformationConfImpl._keypass = ConfigUtil.trim(basicAuth.getKeypass());
                        keyInformationConfImpl._name = ConfigUtil.trim(basicAuth.getName());
                        callbackHandlerConfImpl._keyInformationList.add(keyInformationConfImpl);
                    }
                    basicAuth = callbackHandler.getBasicAuth();
                    if (basicAuth != null) {
                        string = ConfigUtil.trim(basicAuth.getUserid());
                        if (string != null && string.length() > 0) {
                            callbackHandlerConfImpl._userId = string;
                        }
                        if ((string = ConfigUtil.trim(basicAuth.getPassword())) != null && string.length() > 0) {
                            callbackHandlerConfImpl._userPassword = string.toCharArray();
                        }
                    }
                    ConfigConstants.getProperties(callbackHandlerConfImpl._properties, callbackHandler.getProperties(), variableMap);
                    tokenGeneratorConfImpl._callbackHandler = callbackHandlerConfImpl;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the callback handler: " + callbackHandlerConfImpl.getClassName());
                    }
                }
                if ((certPathSettings = map.getCertPathSettings()) != null && (object2 = certPathSettings.getCertStoreRef()) != null) {
                    basicAuth = new ArrayList();
                    eList = null;
                    if (object2 != null) {
                        string = ConfigUtil.trim(object2.getRef());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "CertStoreRef = " + string);
                        }
                        if ((object = wSSecurityDefaultConfiguration.getWSCertStore(string)) == null) {
                            String string2 = "security.wssecurity.ConfigValidation.csref.notfound";
                            Tr.warning(tc, string2, new Object[]{string});
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found CertStore for " + string);
                            }
                            basicAuth.add(object);
                        }
                    }
                    tokenGeneratorConfImpl._provider = eList;
                    tokenGeneratorConfImpl._certStores = basicAuth;
                }
                hashMap.clear();
                hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", tokenGeneratorConfImpl._className);
                object2 = new HashMap();
                try {
                    tokenGeneratorConfImpl._instance = (TokenGeneratorComponent)wSSFactory.createGenerator(hashMap, (Map)object2);
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{tokenGeneratorConfImpl._className});
                }
                ConfigConstants.getProperties(tokenGeneratorConfImpl._properties, map.getProperties(), variableMap);
                this._tokenGenerators.add(tokenGeneratorConfImpl);
                string = ConfigUtil.trim(map.getName());
                if (string == null || string.length() == 0) {
                    Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s26");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding token consumer: " + string);
                }
                hashMap2.put(string, tokenGeneratorConfImpl);
            }
        }
        if (eList4 != null) {
            n4 = eList4.size();
            for (n3 = 0; n3 < n4; ++n3) {
                map = (KeyInfo)eList4.get(n3);
                keyInfoContentGeneratorConfImpl = new PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl();
                keyInfoContentGeneratorConfImpl._className = ConfigUtil.trim(map.getClassname());
                keyInfoContentGeneratorConfImpl._keyInfoType = ConfigUtil.trim(map.getType());
                valueType = map.getKeyLocatorMapping();
                if (valueType != null) {
                    string = ConfigUtil.trim(valueType.getLocatorRef());
                    if (string != null && string.length() > 0) {
                        KeyLocatorProxy keyLocatorProxy = wSSecurityDefaultConfiguration.getKeyLocator(string);
                        if (keyLocatorProxy == null) {
                            Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                        } else {
                            try {
                                keyInfoContentGeneratorConfImpl._keyLocator = keyLocatorProxy.getKeyLocator6(classLoader);
                            }
                            catch (SoapSecurityException soapSecurityException) {
                                Tr.warning(tc, "security.wssecurity.keylocator.is.null", new Object[]{soapSecurityException});
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got the key locator mapping: " + string);
                            }
                        }
                    }
                    keyInfoContentGeneratorConfImpl._keyName = valueType.getKeynameRef();
                }
                if ((qName = map.getTokenReference()) != null && (string = ConfigUtil.trim(qName.getTokenRef())) != null && string.length() > 0) {
                    keyInfoContentGeneratorConfImpl._tokenGenerator = (PrivateGeneratorConfig.TokenGeneratorConfImpl)hashMap2.get(string);
                    if (keyInfoContentGeneratorConfImpl._tokenGenerator == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the token reference: " + string);
                    }
                }
                ConfigConstants.getProperties(keyInfoContentGeneratorConfImpl._properties, map.getProperties(), variableMap);
                hashMap.clear();
                hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                hashMap.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", keyInfoContentGeneratorConfImpl._className);
                object3 = new HashMap();
                try {
                    keyInfoContentGeneratorConfImpl._instance = (KeyInfoContentGeneratorComponent)wSSFactory.createGenerator(hashMap, (Map)object3);
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{keyInfoContentGeneratorConfImpl._className});
                }
                string = ConfigUtil.trim(map.getName());
                if (string == null || string.length() == 0) {
                    Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s28");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key info: " + string);
                }
                hashMap2.put(string, keyInfoContentGeneratorConfImpl);
            }
        }
        if (eList3 != null) {
            n4 = eList3.size();
            for (n3 = 0; n3 < n4; ++n3) {
                map = (EncryptionInfo)eList3.get(n3);
                PrivateGeneratorConfig.EncryptionGeneratorConfImpl encryptionGeneratorConfImpl = new PrivateGeneratorConfig.EncryptionGeneratorConfImpl();
                valueType = map.getEncryptionMethod();
                algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                algorithmConfImpl._algorithm = ConfigUtil.trim(valueType.getAlgorithm());
                if (!bl || webServicesSecurityAlgorithmHelper.getFipsDataEncryptionAlgorithms().contains(algorithmConfImpl._algorithm)) {
                    ConfigConstants.getProperties(algorithmConfImpl._properties, valueType.getProperties(), variableMap);
                    encryptionGeneratorConfImpl._dataEncryptionMethod = algorithmConfImpl;
                } else {
                    Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"DataEncryptionMethod", algorithmConfImpl._algorithm});
                }
                qName = map.getKeyEncryptionMethod();
                if (qName != null) {
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = ConfigUtil.trim(qName.getAlgorithm());
                    if (!bl || webServicesSecurityAlgorithmHelper.getFipsKeyEncryptionAlgorithms().contains(algorithmConfImpl._algorithm)) {
                        ConfigConstants.getProperties(algorithmConfImpl._properties, qName.getProperties(), variableMap);
                        encryptionGeneratorConfImpl._keyEncryptionMethod = algorithmConfImpl;
                    } else {
                        Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"KeyEncryptionMethod", algorithmConfImpl._algorithm});
                    }
                }
                keyInfoGeneratorConfImpl = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
                object3 = map.getEncryptionKeyInfo();
                if (object3 != null && object3.size() == 1 && (string = ConfigUtil.trim((callbackHandler = (EncryptionKeyInfo)object3.get(0)).getKeyinfoRef())) != null && string.length() > 0) {
                    keyInfoContentGeneratorConfImpl = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)hashMap2.get(string);
                    if (keyInfoContentGeneratorConfImpl == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the key info reference: " + string);
                    }
                    keyInfoGeneratorConfImpl._contentGenerator = keyInfoContentGeneratorConfImpl;
                }
                encryptionGeneratorConfImpl._encryptionKeyInfo = keyInfoGeneratorConfImpl;
                callbackHandler = map.getPartReference();
                if (callbackHandler != null && (string = ConfigUtil.trim(callbackHandler.getPart())) != null && string.length() > 0) {
                    encryptionGeneratorConfImpl._reference = (PrivateCommonConfig.ReferencePartConfImpl)hashMap2.get(string);
                    if (encryptionGeneratorConfImpl._reference == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + string);
                    }
                }
                ConfigConstants.getProperties(encryptionGeneratorConfImpl._properties, map.getProperties(), variableMap);
                this._operationGenerators.add(encryptionGeneratorConfImpl);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding encryption generator.");
            }
        }
        if (eList2 != null) {
            n4 = eList2.size();
            for (n3 = 0; n3 < n4; ++n3) {
                map = (SigningInfo)eList2.get(n3);
                PrivateGeneratorConfig.SignatureGeneratorConfImpl signatureGeneratorConfImpl = new PrivateGeneratorConfig.SignatureGeneratorConfImpl();
                valueType = map.getCanonicalizationMethod();
                if (valueType == null) {
                    Tr.warning(tc, "security.wssecurity.nocanonicalization.algo");
                } else {
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = ConfigUtil.trim(valueType.getAlgorithm());
                    ConfigConstants.getProperties(algorithmConfImpl._properties, valueType.getProperties(), variableMap);
                    signatureGeneratorConfImpl._canonicalizationMethod = algorithmConfImpl;
                }
                qName = map.getSignatureMethod();
                if (valueType == null) {
                    Tr.warning(tc, "security.wssecurity.nosignature.algo");
                } else {
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = ConfigUtil.trim(qName.getAlgorithm());
                    if (!bl || webServicesSecurityAlgorithmHelper.getFipsSignatureAlgorithms().contains(algorithmConfImpl._algorithm)) {
                        ConfigConstants.getProperties(algorithmConfImpl._properties, qName.getProperties(), variableMap);
                        signatureGeneratorConfImpl._signatureMethod = algorithmConfImpl;
                    } else {
                        Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"SignatureMethod", algorithmConfImpl._algorithm});
                    }
                }
                object3 = map.getKeyInfoSignature();
                if (object3 != null) {
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = ConfigUtil.trim(object3.getType());
                    ConfigConstants.getProperties(algorithmConfImpl._properties, object3.getProperties(), variableMap);
                    signatureGeneratorConfImpl._keyInfoSignature = algorithmConfImpl;
                }
                keyInfoGeneratorConfImpl = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
                callbackHandler = map.getSigningKeyInfo();
                if ((callbackHandler != null || callbackHandler.size() == 1) && (string = ConfigUtil.trim((certPathSettings = (SigningKeyInfo)callbackHandler.get(0)).getKeyinfoRef())) != null && string.length() > 0) {
                    keyInfoContentGeneratorConfImpl = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)hashMap2.get(string);
                    if (keyInfoContentGeneratorConfImpl == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the key info reference: " + string);
                    }
                    keyInfoGeneratorConfImpl._contentGenerator = keyInfoContentGeneratorConfImpl;
                }
                signatureGeneratorConfImpl._signingKeyInfo = keyInfoGeneratorConfImpl;
                certPathSettings = map.getPartReference();
                if (certPathSettings != null) {
                    n2 = certPathSettings.size();
                    for (n = 0; n < n2; ++n) {
                        object2 = (PartReference)certPathSettings.get(n);
                        PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl = new PrivateCommonConfig.SigningReferenceConfImpl();
                        string = ConfigUtil.trim(object2.getPart());
                        if (string != null && string.length() > 0) {
                            signingReferenceConfImpl._reference = (PrivateCommonConfig.ReferencePartConfImpl)hashMap2.get(string);
                            if (signingReferenceConfImpl._reference == null) {
                                Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{string});
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got the part reference: " + string);
                            }
                        }
                        if ((basicAuth = object2.getDigestMethod()) == null) {
                            Tr.warning(tc, "security.wssecurity.nodigest.algo");
                        } else {
                            algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                            algorithmConfImpl._algorithm = ConfigUtil.trim(basicAuth.getAlgorithm());
                            if (!bl || webServicesSecurityAlgorithmHelper.getFipsDigestAlgorithms().contains(algorithmConfImpl._algorithm)) {
                                ConfigConstants.getProperties(algorithmConfImpl._properties, basicAuth.getProperties(), variableMap);
                                signingReferenceConfImpl._digestMethod = algorithmConfImpl;
                            } else {
                                Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"DigestMethod", algorithmConfImpl._algorithm});
                            }
                        }
                        eList = object2.getTransform();
                        if (eList != null) {
                            int n5 = eList.size();
                            for (int i = 0; i < n5; ++i) {
                                object = (Transform)eList.get(i);
                                if (object == null) continue;
                                algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                                algorithmConfImpl._algorithm = ConfigUtil.trim(object.getAlgorithm());
                                ConfigConstants.getProperties(algorithmConfImpl._properties, object.getProperties(), variableMap);
                                signingReferenceConfImpl._transforms.add(algorithmConfImpl);
                            }
                        }
                        signatureGeneratorConfImpl._references.add(signingReferenceConfImpl);
                    }
                }
                signatureGeneratorConfImpl.putInclusiveNsProperty(this._properties);
                ConfigConstants.getProperties(signatureGeneratorConfImpl._properties, map.getProperties(), variableMap);
                this._operationGenerators.add(signatureGeneratorConfImpl);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding signature generator.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Generator, VariableMap, WSSecurityDefaultConfiguration)");
        }
    }
}

