/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.wssecurity.xss4j.domutil.AttrProxy;
import com.ibm.ws.wssecurity.xss4j.domutil.C14nUtil;
import com.ibm.ws.wssecurity.xss4j.enc.util.DOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

class Canonicalizer {
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";

    Canonicalizer() {
    }

    public static byte[] serializeSubset(NodeList nodeList, boolean bl, Map map) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            Canonicalizer.serializeSubset(nodeList, bl, map, outputStreamWriter);
            ((Writer)outputStreamWriter).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Internal Error: " + iOException);
        }
    }

    public static void serializeSubset(NodeList nodeList, boolean bl, Map map, Writer writer) throws IOException {
        Canonicalizer.serializeSubset(nodeList, bl, map, writer, null);
    }

    static void serializeSubset(NodeList nodeList, boolean bl, Map map, Writer writer, Set set) throws IOException {
        Vector<Object> vector = new Vector<Object>(nodeList.getLength());
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            Node node2 = nodeList.item(i);
            if (map.containsKey(node2)) {
                vector.add(new ReplacedNode(node2));
                int n = nodeList.getLength();
                for (int j = i + 1; j <= n; ++j) {
                    if (j < n && DOMUtil.isDescendantNode(nodeList.item(j), node2)) continue;
                    i = j - 1;
                    continue block0;
                }
                continue;
            }
            if (node2.getNodeType() != 2) {
                Node node3;
                vector.addElement(node2);
                if (node2.getNodeType() != 1) continue;
                Hashtable<String, Node> hashtable = Canonicalizer.collectXMLPrefixAttributesInAncestors(node2);
                if (i + 1 < nodeList.getLength() && (node3 = nodeList.item(i + 1)).getNodeType() == 2 && ((Attr)node3).getOwnerElement() == node2) {
                    if (hashtable == null) {
                        hashtable = new Hashtable<String, Node>();
                    }
                    ++i;
                    while (i < nodeList.getLength() && (node = nodeList.item(i)).getNodeType() == 2 && node2 == ((Attr)node).getOwnerElement()) {
                        hashtable.put(node.getNodeName(), node);
                        ++i;
                    }
                    if (hashtable.containsKey("xmlns") && ((Attr)hashtable.get("xmlns")).getNodeValue().length() == 0) {
                        hashtable.remove("xmlns");
                    }
                    --i;
                    vector.addElement(new Attributes(node2, hashtable));
                    continue;
                }
                if (hashtable == null) continue;
                vector.addElement(new Attributes(node2, hashtable));
                continue;
            }
            Element element = ((Attr)node2).getOwnerElement();
            Hashtable<String, Node> hashtable = new Hashtable<String, Node>();
            while (i < nodeList.getLength() && (node = nodeList.item(i)).getNodeType() == 2 && element == ((Attr)node).getOwnerElement()) {
                hashtable.put(node.getNodeName(), node);
                ++i;
            }
            vector.addElement(new Attributes(element, hashtable));
            --i;
        }
        Stack stack = new Stack();
        for (int i = 0; i < vector.size(); ++i) {
            Canonicalizer.serializeSubset(stack, vector, i, bl, map, writer, set);
        }
    }

    private static void serializeSubset(Stack stack, Vector vector, int n, boolean bl, Map map, Writer writer, Set set) throws IOException {
        Node node;
        Object e2 = vector.elementAt(n);
        if (e2 == null) {
            return;
        }
        if (e2 instanceof Attributes) {
            vector.setElementAt(null, n);
            ((Attributes)e2).serialize(null, writer);
            return;
        }
        if (e2 instanceof ReplacedNode) {
            NodeList nodeList = (NodeList)map.get(((ReplacedNode)e2).getNode());
            HashSet<Node> hashSet = new HashSet<Node>();
            int n2 = 0;
            int n3 = nodeList.getLength();
            block0: while (n2 < n3) {
                Node node2 = nodeList.item(n2);
                hashSet.add(node2);
                for (int i = n2 + 1; i <= n3; ++i) {
                    if (i < n3 && DOMUtil.isDescendantNode(nodeList.item(i), node2)) continue;
                    n2 = i;
                    continue block0;
                }
            }
            Canonicalizer.serializeSubset(nodeList, false, map, writer, hashSet);
            return;
        }
        Node node3 = (Node)e2;
        short s = node3.getNodeType();
        if (s == 9) {
            return;
        }
        if (s != 1) {
            Canonicalizer.serializeNode(null, node3, null, bl, true, writer);
            return;
        }
        writer.write("<");
        writer.write(node3.getNodeName());
        Attributes attributes2 = stack.empty() ? null : (Attributes)stack.peek();
        Attributes attributes3 = null;
        int n4 = n + 1;
        if (n4 >= vector.size() || vector.elementAt(n4) instanceof Node || vector.elementAt(n4) instanceof ReplacedNode) {
            node = node3.getParentNode();
            if (node.getNodeType() != 9 && attributes2 != null && attributes2.contains("xmlns") || set != null && set.contains(node3)) {
                writer.write(" xmlns=\"\"");
            }
        } else {
            attributes3 = (Attributes)vector.elementAt(n4);
            if (!attributes3.contains("xmlns") && ((node = node3.getParentNode()).getNodeType() != 9 && attributes2 != null && attributes2.contains("xmlns") || set != null && set.contains(node3))) {
                writer.write(" xmlns=\"\"");
            }
            attributes3.serialize(attributes2, writer);
            vector.setElementAt(null, n4);
        }
        writer.write(">");
        stack.push(attributes3);
        while (n4 < vector.size()) {
            if (vector.elementAt(n4) == null) {
                ++n4;
                continue;
            }
            if (!Canonicalizer.isAncestor(vector.elementAt(n4), node3)) break;
            Canonicalizer.serializeSubset(stack, vector, n4, bl, map, writer, set);
            vector.setElementAt(null, n4++);
        }
        stack.pop();
        writer.write("</");
        writer.write(node3.getNodeName());
        writer.write(">");
    }

    static boolean isAncestor(Object object, Node node) {
        Node node2 = object instanceof Attributes ? ((Attributes)object).parent : (object instanceof ReplacedNode ? ((ReplacedNode)object).getNode() : (Node)object);
        while (node2 != node) {
            if ((node2 = node2.getNodeType() == 2 ? ((Attr)node2).getOwnerElement() : node2.getParentNode()) != null) continue;
            return false;
        }
        return true;
    }

    static void serializeNode(Node node, Node node2, Node node3, boolean bl, boolean bl2, Writer writer) throws IOException {
        Canonicalizer.serializeNode(node, null, node2, node3, bl, bl2, writer);
    }

    private static void serializeNode(Node node, Stack stack, Node node2, Node node3, boolean bl, boolean bl2, Writer writer) throws IOException {
        if (node3 == node2) {
            return;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        switch (node2.getNodeType()) {
            case 1: {
                if (stack == null) {
                    stack = new Stack();
                }
                writer.write("<");
                writer.write(node2.getNodeName());
                Canonicalizer.serializeAttributes(node, stack, (Element)node2, bl2, writer);
                writer.write(">");
                for (Node node4 = node2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    Canonicalizer.serializeNode(node, stack, node4, node3, bl, bl2, writer);
                }
                stack.pop();
                writer.write("</");
                writer.write(node2.getNodeName());
                writer.write(">");
                break;
            }
            case 3: 
            case 4: {
                String string = node2.getNodeValue();
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '<') {
                        writer.write("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        writer.write("&gt;");
                        continue;
                    }
                    if (c == '&') {
                        writer.write("&amp;");
                        continue;
                    }
                    if (c == '\r') {
                        writer.write("&#xD;");
                        continue;
                    }
                    writer.write(c);
                }
                break;
            }
            case 5: 
            case 9: {
                for (Node node5 = node2.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                    Canonicalizer.serializeNode(node, stack, node5, node3, bl, bl2, writer);
                }
                break;
            }
            case 7: {
                Node node6;
                if (node2.getParentNode().getNodeType() == 9) {
                    node6 = node2;
                    while ((node6 = node6.getPreviousSibling()) != null && node6.getNodeType() != 1) {
                    }
                    if (node6 == null) {
                        bl3 = true;
                    } else {
                        bl4 = true;
                    }
                }
                node6 = (ProcessingInstruction)node2;
                if (bl4) {
                    writer.write("\n");
                }
                writer.write("<?");
                writer.write(node6.getTarget());
                if (node6.getData() != null && node6.getData().length() > 0) {
                    writer.write(" ");
                    String string = node6.getData();
                    int n = 0;
                    for (int i = 0; i < string.length(); ++i) {
                        if (string.charAt(i) != '\r') continue;
                        if (i > n) {
                            writer.write(string, n, i - n);
                        }
                        writer.write("&#xD;");
                        n = i + 1;
                    }
                    if (n < string.length()) {
                        writer.write(string, n, string.length() - n);
                    }
                }
                writer.write("?>");
                if (!bl3) break;
                writer.write("\n");
                break;
            }
            case 8: {
                if (!bl) break;
                if (node2.getParentNode().getNodeType() == 9) {
                    Node node7 = node2;
                    while ((node7 = node7.getPreviousSibling()) != null && node7.getNodeType() != 1) {
                    }
                    if (node7 == null) {
                        bl3 = true;
                    } else {
                        bl4 = true;
                    }
                }
                if (bl4) {
                    writer.write("\n");
                }
                writer.write("<!--");
                writer.write(node2.getNodeValue());
                writer.write("-->");
                if (!bl3) break;
                writer.write("\n");
                break;
            }
            case 10: {
                break;
            }
            case 2: {
                Canonicalizer.serializeAttribute((Attr)node2, writer);
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                throw new RuntimeException("Internal Error: Invalid Node Type: " + node2.getNodeType());
            }
        }
    }

    private static boolean isTopElement(Node node, Element element) {
        if (node == element) {
            return true;
        }
        Node node2 = element.getParentNode();
        if (node2 != null) {
            switch (node2.getNodeType()) {
                case 9: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 5: {
                    node2 = node2.getParentNode();
                }
            }
            throw new RuntimeException("Internal Error: Unexpected node type: " + node2.getNodeType());
        }
        return true;
    }

    private static void serializeAttributes(Node node, Stack stack, Element element, boolean bl, Writer writer) throws IOException {
        Object object;
        String[] stringArray;
        Hashtable hashtable;
        Hashtable hashtable2 = Canonicalizer.collectNamespaceNodesInAncestors(element, false);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            hashtable2.put(namedNodeMap.item(i).getNodeName(), namedNodeMap.item(i));
        }
        if (bl && (hashtable = Canonicalizer.collectXMLPrefixAttributesInAncestors(element)) != null) {
            stringArray = hashtable.elements();
            while (stringArray.hasMoreElements()) {
                object = (Attr)stringArray.nextElement();
                hashtable2.put(object.getNodeName(), object);
            }
        }
        Hashtable hashtable3 = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(hashtable2);
        n = hashtable2.size();
        stringArray = new String[n];
        object = new int[n];
        Attr[] attrArray = new Attr[n];
        int n2 = 0;
        Enumeration enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            Attr attr = (Attr)enumeration.nextElement();
            object[n2] = n2;
            attrArray[n2] = attr;
            stringArray[n2] = Canonicalizer.createSortedString(attr, element);
            ++n2;
        }
        C14nUtil.heapSort((int[])object, stringArray, n);
        for (int i = 0; i < n; ++i) {
            Attr attr;
            Attr attr2;
            Attr attr3 = attrArray[object[i]];
            String string = attr3.getNodeName();
            if (string.equals("xmlns:xml")) continue;
            if (string.equals("xmlns") && attr3.getNodeValue().length() == 0) {
                if (Canonicalizer.isTopElement(node, element)) continue;
                boolean bl2 = false;
                for (int j = stack.size() - 1; j >= 0; --j) {
                    Hashtable hashtable4 = (Hashtable)stack.elementAt(j);
                    Attr attr4 = (Attr)hashtable4.get("xmlns");
                    if (attr4 == null || attr4.getNodeValue().length() <= 0) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
            }
            if (string.equals("xmlns") || string.startsWith("xmlns:") ? hashtable3 != null && (attr2 = (Attr)hashtable3.get(string)) != null && attr2.getNodeValue().equals(attr3.getNodeValue()) : string.startsWith("xml:") && hashtable3 != null && (attr = (Attr)hashtable3.get(string)) != null && attr.getNodeValue().equals(attr3.getNodeValue())) continue;
            Canonicalizer.serializeAttribute(attr3, writer);
        }
    }

    private static void serializeAttribute(Attr attr, Writer writer) throws IOException {
        String string = attr.getNodeName();
        boolean bl = string.equals("xmlns") || string.startsWith("xmlns:");
        writer.write(" ");
        writer.write(string);
        writer.write("=\"");
        String string2 = attr.getNodeValue();
        boolean bl2 = false;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '&') {
                writer.write("&amp;");
                continue;
            }
            if (c == '<') {
                writer.write("&lt;");
                continue;
            }
            if (c == '\"') {
                writer.write("&quot;");
                continue;
            }
            if (c == '\t') {
                writer.write("&#x9;");
                continue;
            }
            if (c == '\n') {
                writer.write("&#xA;");
                continue;
            }
            if (c == '\r') {
                writer.write("&#xD;");
                continue;
            }
            if (bl) {
                if (c == ':') {
                    bl2 = true;
                } else if (c == '/' && !bl2) {
                    throw new RuntimeException("Found a relative URI: " + string2);
                }
            }
            writer.write(c);
        }
        if (string2.length() > 0 && bl && !bl2) {
            throw new RuntimeException("Found a relative URI: " + string2);
        }
        writer.write("\"");
    }

    public static Hashtable collectNamespaceNodesInAncestors(Node node, boolean bl) {
        Object object;
        Node node2 = node;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Document document = node.getOwnerDocument();
        if (node2.getNodeType() == 1 && ((Element)node2).getAttributeNode("xmlns:xml") == null) {
            if (bl) {
                hashtable.put("xmlns:xml", (Object)new AttrProxy(node, document, XMLNS_NS, "xmlns:xml", XML_NAMESPACE));
            } else {
                object = document.createAttributeNS(XMLNS_NS, "xmlns:xml");
                object.setNodeValue(XML_NAMESPACE);
                hashtable.put("xmlns:xml", object);
            }
        }
        do {
            if ((object = node2.getAttributes()) == null) continue;
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Object object2;
                Attr attr = (Attr)object.item(i);
                String string = attr.getNodeName();
                if (!string.equals("xmlns") && !string.startsWith("xmlns:") || hashtable.containsKey(string)) continue;
                if (node2 == node) {
                    hashtable.put(string, attr);
                    continue;
                }
                if (bl) {
                    object2 = new AttrProxy(node, document, XMLNS_NS, string, attr.getNodeValue());
                    hashtable.put(string, object2);
                    continue;
                }
                object2 = document.createAttributeNS(XMLNS_NS, string);
                object2.setNodeValue(attr.getNodeValue());
                hashtable.put(string, object2);
            }
        } while ((node2 = node2.getParentNode()) != null);
        return hashtable;
    }

    public static Hashtable collectXMLPrefixAttributesInAncestors(Node node) {
        Object object;
        int n;
        Object object2;
        Hashtable<String, Object> hashtable = null;
        for (object2 = node.getParentNode(); object2 != null; object2 = object2.getParentNode()) {
            NamedNodeMap namedNodeMap = object2.getAttributes();
            if (namedNodeMap == null) continue;
            n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                object = (Attr)namedNodeMap.item(i);
                String string = object.getNodeName();
                if (!string.startsWith("xml:") || hashtable != null && hashtable.containsKey(string)) continue;
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Object>();
                }
                hashtable.put(string, object);
            }
        }
        if (hashtable != null && (object2 = node.getAttributes()) != null) {
            int n2 = object2.getLength();
            for (n = 0; n < n2; ++n) {
                Attr attr = (Attr)object2.item(n);
                object = attr.getNodeName();
                if (!((String)object).startsWith("xml:") || !hashtable.containsKey(object)) continue;
                hashtable.remove(object);
            }
        }
        return hashtable;
    }

    private static String createSortedString(Attr attr, Node node) {
        String string;
        if (attr.getNodeType() == 2) {
            String string2 = attr.getNodeName();
            if (string2.equals("xmlns")) {
                return "\u0000";
            }
            int n = string2.indexOf(58);
            if (n <= 0) {
                return "\u0001" + string2;
            }
            String string3 = string2.substring(0, n);
            if (string3.equals("xmlns")) {
                return "\u0000" + string2.substring(n + 1);
            }
            String string4 = com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil.getNamespaceForPrefix(string3, node);
            string = string4 == null || string4.length() == 0 ? "\u0001" + string2 : string4 + "\u0001" + string2.substring(n + 1);
        } else {
            throw new IllegalArgumentException("Requires an Attr node.");
        }
        return string;
    }

    static class ReplacedNode {
        private Node fNode;

        ReplacedNode(Node node) {
            this.fNode = node;
        }

        Node getNode() {
            return this.fNode;
        }
    }

    static class Attributes {
        Node parent;
        Hashtable attributes;

        Attributes(Node node, Hashtable hashtable) {
            this.parent = node;
            this.attributes = hashtable;
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            }
        }

        boolean contains(String string) {
            return this.attributes.containsKey(string);
        }

        void serialize(Attributes attributes2, Writer writer) throws IOException {
            Attr attr;
            int n;
            int n2 = this.attributes.size();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            Attr[] attrArray = new Attr[n2];
            Enumeration enumeration = this.attributes.elements();
            for (n = 0; n < n2; ++n) {
                attr = (Attr)enumeration.nextElement();
                nArray[n] = n;
                attrArray[n] = attr;
                stringArray[n] = Canonicalizer.createSortedString(attr, this.parent);
            }
            C14nUtil.heapSort(nArray, stringArray, n2);
            for (n = 0; n < n2; ++n) {
                attr = attrArray[nArray[n]];
                String string = attr.getNodeName();
                if (string.equals("xmlns:xml") || (string.equals("xmlns") || string.startsWith("xmlns:") ? attributes2 != null && attributes2.contains(string) && attributes2.get(string).getNodeValue().equals(attr.getNodeValue()) : string.startsWith("xml:") && attributes2 != null && attributes2.contains(string) && attributes2.get(string).getNodeValue().equals(attr.getNodeValue()))) continue;
                Canonicalizer.serializeAttribute(attr, writer);
            }
        }

        Enumeration enumeration() {
            return this.attributes.elements();
        }

        Attr get(String string) {
            return (Attr)this.attributes.get(string);
        }

        private void remove(String string) {
            Object v = this.attributes.remove(string);
            if (v == null) {
                System.err.println("Internal logic error: No attribute named " + string);
            }
        }

        private boolean usePrefix(String string) {
            if (string.length() == 0) {
                return false;
            }
            Enumeration enumeration = this.enumeration();
            while (enumeration.hasMoreElements()) {
                Attr attr = (Attr)enumeration.nextElement();
                String string2 = attr.getPrefix();
                if (string2 == null || !string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        static boolean inAncestors(Stack stack, String string, String string2) {
            if (stack == null || stack.isEmpty()) {
                return false;
            }
            for (int i = stack.size() - 1; i >= 0; --i) {
                Attributes attributes2 = (Attributes)stack.elementAt(i);
                if (!attributes2.contains(string) || !attributes2.get(string).getNodeValue().equals(string2)) continue;
                return true;
            }
            return false;
        }

        void serialize(Stack stack, Hashtable hashtable, String string, Writer writer) throws IOException {
            Attr attr;
            int n;
            int n2 = this.attributes.size();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            Attr[] attrArray = new Attr[n2];
            Enumeration enumeration = this.attributes.elements();
            for (n = 0; n < n2; ++n) {
                attr = (Attr)enumeration.nextElement();
                nArray[n] = n;
                attrArray[n] = attr;
                stringArray[n] = Canonicalizer.createSortedString(attr, this.parent);
            }
            C14nUtil.heapSort(nArray, stringArray, n2);
            for (n = 0; n < n2; ++n) {
                attr = attrArray[nArray[n]];
                String string2 = attr.getNodeName();
                if (string2.equals("xmlns:xml")) {
                    this.remove(string2);
                    continue;
                }
                if (string2.equals("xmlns") || string2.startsWith("xmlns:")) {
                    String string3;
                    if (Attributes.inAncestors(stack, string2, attr.getNodeValue())) {
                        this.remove(string2);
                        continue;
                    }
                    String string4 = string3 = string2.equals("xmlns") ? "" : string2.substring(6);
                    if (!(hashtable != null && hashtable.get(string3) != null || string == null || string.equals(string3) || this.usePrefix(string3))) {
                        this.remove(string2);
                        continue;
                    }
                }
                Canonicalizer.serializeAttribute(attr, writer);
            }
        }

        public String toString() {
            return "Attributes[#=" + this.attributes.size() + "]";
        }
    }
}

