/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.dsig.Canonicalizer;
import com.ibm.ws.webservices.wssecurity.dsig.ExclusiveCanonicalizer;
import com.ibm.ws.webservices.wssecurity.dsig.STRDTKeyInfoResolver;
import com.ibm.ws.webservices.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class STRDereferenceTransformer
extends Transform {
    private static final TraceComponent tc = Tr.register(STRDereferenceTransformer.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = STRDereferenceTransformer.class.getName();
    public static final String STRT = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    private String _nsWsse = Constants.NS_WSSE;
    private String _nsWsu = Constants.NS_WSU;
    private Document _document;
    private IDResolver _idResolver;
    private STRDTKeyInfoResolver _kiResolver;
    private String _c14nMethod;
    private Hashtable _prefixList;
    private String _keyInfoSignature;

    public String getURI() {
        return STRT;
    }

    public Element createTransformElement(Document document, IndentConfig indentConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTransformElement(Document factory[" + document + "]," + "IndentConfig iconf[" + indentConfig + "])");
        }
        Element element = super.createTransformElement(document, indentConfig);
        if (this._c14nMethod != null) {
            Object object;
            Object object2 = null;
            if (("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this._c14nMethod) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this._c14nMethod)) && this._prefixList != null) {
                object = ExclusiveCanonicalizer.serializePrefixList(this._prefixList);
                object2 = document.createElementNS("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces");
                object2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2001/10/xml-exc-c14n#");
                object2.setAttribute("PrefixList", (String)object);
            }
            object = document.createElementNS(Constants.NS_DSIG, "CanonicalizationMethod");
            object.setAttribute("Algorithm", this._c14nMethod);
            if (object2 != null) {
                object.appendChild((Node)object2);
            }
            object2 = object;
            String string = DOMUtil.getNamespacePrefix(element, this._nsWsse);
            boolean bl = false;
            if (string == null) {
                string = "wsse:";
                bl = true;
            } else if (!"".equals(string)) {
                string = string + ":";
            }
            object = document.createElementNS(this._nsWsse, string + "TransformationParameters");
            if (bl) {
                object.setAttribute("xmlns:wsse", this._nsWsse);
            }
            object.appendChild((Node)object2);
            element.appendChild((Node)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTransformElement(Document factory,IndentConfig iconf) returns Element[" + element + "]");
        }
        return element;
    }

    public void setParameter(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        this._c14nMethod = null;
        this._prefixList = null;
        for (Node node2 = node; node2 != null; node2 = node2.getNextSibling()) {
            String string;
            String string2;
            Element element;
            if (node2.getNodeType() != 1 || !DOMUtil.equals(element = (Element)node2, string2 = this._nsWsse, string = "TransformationParameters")) continue;
            Element element2 = DOMUtil.getFirstElement(element);
            while (element2 != null) {
                string2 = Constants.NS_DSIG;
                string = "CanonicalizationMethod";
                if (DOMUtil.equals(element2, string2, string) && element2.hasAttribute("Algorithm")) {
                    this._c14nMethod = element2.getAttribute("Algorithm");
                    if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this._c14nMethod) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this._c14nMethod)) {
                        Element element3 = DOMUtil.getFirstElement(element2);
                        while (element3 != null) {
                            string2 = "http://www.w3.org/2001/10/xml-exc-c14n#";
                            string = "InclusiveNamespaces";
                            if (DOMUtil.equals(element3, string2, string) && element3.hasAttribute("PrefixList")) {
                                String string3 = element3.getAttribute("PrefixList");
                                this._prefixList = ExclusiveCanonicalizer.parsePrefixList(string3);
                            }
                            element3 = DOMUtil.getNextElement(element3);
                        }
                    }
                }
                element2 = DOMUtil.getNextElement(element2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter(Node node)");
        }
    }

    public void transform(TransformContext transformContext) throws TransformException {
        Object object;
        SignatureContext signatureContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transform(TransformContext context[" + transformContext + "])");
        }
        if ((signatureContext = transformContext.getSignatureContext()) instanceof WSSSignatureContext) {
            object = (WSSSignatureContext)signatureContext;
            this._document = ((WSSSignatureContext)object).getDocument();
            this._idResolver = ((SignatureContext)object).getIDResolver();
            this._kiResolver = ((WSSSignatureContext)object).getSTRDTKeyInfoResolver();
            int n = ((WSSSignatureContext)object).getWssVersion();
            this._nsWsse = Constants.NAMESPACES[0][n];
            this._nsWsu = Constants.NAMESPACES[1][n];
            this._keyInfoSignature = ((WSSSignatureContext)object).getKeyInfoSignature();
        }
        object = null;
        switch (transformContext.getType()) {
            case 0: 
            case 1: {
                object = XPathCanonicalizer.toNodeset(transformContext.getDocument(), null, true);
                break;
            }
            case 3: {
                object = XPathCanonicalizer.toNodeset(transformContext.getNode(), null, true);
                break;
            }
            case 2: {
                object = transformContext.getNodeset();
            }
        }
        byte[] byArray = null;
        if (object != null) {
            this.typeCheck((NodeList)object, this._keyInfoSignature);
            try {
                byArray = this.transform((NodeList)object);
            }
            catch (RuntimeException runtimeException) {
                Tr.processException((Throwable)runtimeException, clsName + ".transform", "215", this);
                throw runtimeException;
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, clsName + ".transform", "218", this);
                throw TransformException.create(exception);
            }
        }
        transformContext.setContent(byArray, "UTF-8");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transform(TransformContext context)");
        }
    }

    private byte[] transform(NodeList nodeList) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transform(NodeList nodeSet[" + nodeList + "])");
        }
        Map map = this.dereferenceSTR(nodeList);
        byte[] byArray = this.serializeNodeSet(nodeList, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transform(NodeList nodeSet)");
        }
        return byArray;
    }

    private Map dereferenceSTR(NodeList nodeList) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceSTR(NodeList nodeSet[" + nodeList + "])");
        }
        HashMap<Node, NodeList> hashMap = new HashMap<Node, NodeList>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !DOMUtil.equals(element = (Element)node, Constants.NS_WSSE, "SecurityTokenReference")) continue;
            NodeList nodeList2 = this.dereferenceSTR(element);
            nodeList2 = this.convertToNodeSet(nodeList2);
            hashMap.put(node, nodeList2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceSTR(NodeList nodeSet), returns Map[" + hashMap + "]");
        }
        return hashMap;
    }

    private byte[] serializeNodeSet(NodeList nodeList, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeNodeSet(NodeList nodeSet[" + nodeList + "]," + "Map replNodeSets[" + map + "])");
        }
        byte[] byArray = null;
        if (this._c14nMethod == null) {
            throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s01");
        }
        if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(this._c14nMethod)) {
            byArray = Canonicalizer.serializeSubset(nodeList, false, map);
        } else if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments".equals(this._c14nMethod)) {
            byArray = Canonicalizer.serializeSubset(nodeList, true, map);
        } else if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this._c14nMethod)) {
            byArray = ExclusiveCanonicalizer.serializeSubset(this._prefixList, nodeList, false, map);
        } else if ("http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this._c14nMethod)) {
            byArray = ExclusiveCanonicalizer.serializeSubset(this._prefixList, nodeList, true, map);
        } else {
            throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s02", this._c14nMethod);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeNodeSet(NodeList nodeSet,Map replNodeSets)");
        }
        return byArray;
    }

    private NodeList dereferenceSTR(Element element) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceSTR(Element secTokenRef[" + DOMUtil.getDisplayName(element) + "])");
        }
        Object object = this.dereferenceToST(element);
        NodeList nodeList = this.wrapInNodeList(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceSTR(Element secTokenRef)");
        }
        return nodeList;
    }

    private Object dereferenceToST(Element element) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceToST(Element secTokenRef[" + DOMUtil.getDisplayName(element) + "])");
        }
        Object object = null;
        Element element2 = DOMUtil.getFirstElement(element);
        if (DOMUtil.equals(element2, this._nsWsse, "Embedded")) {
            object = this.dereferenceEmbedded(element2);
        } else if (DOMUtil.equals(element2, this._nsWsse, "Reference")) {
            object = this.dereferenceReference(element2);
        } else if (DOMUtil.equals(element2, this._nsWsse, "KeyIdentifier")) {
            object = this.dereferenceOthers(element, "KEYID");
        } else if (DOMUtil.equals(element2, Constants.NS_DSIG, "X509Data")) {
            object = this.dereferenceOthers(element, "X509ISSUER");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceToST(Element secTokenRef)");
        }
        return object;
    }

    private Object dereferenceEmbedded(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceEmbedded(Element embedded[" + DOMUtil.getDisplayName(element) + "])");
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (nodeListImpl == null) {
                nodeListImpl = new XPathCanonicalizer.NodeListImpl();
            }
            ((XPathCanonicalizer.NodeListImpl)nodeListImpl).add(node);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceEmbedded(Element embedded) returns Object[" + nodeListImpl + "]");
        }
        return nodeListImpl;
    }

    private Object dereferenceReference(Element element) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceReference(Element ref[" + DOMUtil.getDisplayName(element) + "])");
        }
        String string = null;
        if (element.hasAttribute("URI")) {
            string = element.getAttribute("URI");
        }
        QName qName = null;
        if (element.hasAttribute("ValueType")) {
            qName = DOMUtil.getQName(element, element.getAttribute("ValueType"));
        }
        Object object = this.resolveURI(string, qName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceReference(Element ref) returns Object[" + object + "]");
        }
        return object;
    }

    private Object resolveURI(String string, QName qName) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveURI(String uri[" + string + "]," + "QName valType[" + qName + "])");
        }
        Element element = null;
        if (string != null) {
            if (string.length() < 2 || string.charAt(0) != '#') {
                throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s04", string);
            }
            String string2 = string.substring(1);
            if (this._idResolver == null) {
                throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s03");
            }
            Element element2 = this._idResolver.resolveID(this._document, string2);
            if (element2 != null) {
                element = element2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveURI(String uri,QName valType) returns Object[" + element + "]");
        }
        return element;
    }

    private Object dereferenceOthers(Element element, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceOthers(Element secTokenRef[" + DOMUtil.getDisplayName(element) + "]," + "String keyInfoType[" + string + "])");
        }
        Element element2 = null;
        if (this._kiResolver != null) {
            element2 = this._kiResolver.resolve(element, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceOthers(Element secTokenRef,String keyInfoType) returns Object[" + element2 + "]");
        }
        return element2;
    }

    private NodeList wrapInNodeList(Object object) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "wrapInNodeList(Object secToken[" + object + "])");
        }
        NodeList nodeList = null;
        if (object instanceof Element) {
            XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl(1);
            nodeListImpl.add((Element)object);
            nodeList = nodeListImpl;
        } else if (object instanceof NodeList) {
            nodeList = (NodeList)object;
        } else {
            throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s05");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "wrapInNodeList(Object secToken) returns NodeList[" + nodeList + "]");
        }
        return nodeList;
    }

    private NodeList convertToNodeSet(NodeList nodeList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToNodeSet(NodeList apexNodes[" + nodeList + "])");
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            NodeList nodeList2 = XPathCanonicalizer.toNodeset(nodeList.item(i), null, true);
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                nodeListImpl.add(nodeList2.item(j));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToNodeSet(NodeList apexNodes) returns NodeList[" + nodeListImpl + "]");
        }
        return nodeListImpl;
    }

    private void typeCheck(NodeList nodeList, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "typeIsOk(NodeList nodeset,String kiSign[" + string + "])");
        }
        if (string == null || IntegralDialectElementSelector.KEYSIGNMETHOD[0].equals(string)) {
            boolean bl = false;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !DOMUtil.equals(node, Constants.NS_DSIG, "KeyInfo")) continue;
                bl = true;
                break;
            }
            if (!bl && tc.isDebugEnabled()) {
                Tr.debug(tc, "The nodeset to be signed doesn't include ds:KeyInfo element though the method to sign a key is [" + string + "].");
            }
        } else if (IntegralDialectElementSelector.KEYSIGNMETHOD[1].equals(string)) {
            boolean bl = false;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !DOMUtil.equals(node, Constants.NS_DSIG, "KeyInfo")) continue;
                bl = true;
                break;
            }
            if (bl && tc.isDebugEnabled()) {
                Tr.debug(tc, "The nodeset to be signed includes ds:KeyInfo element though the method to sign a key is [" + string + "].");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "typeIsOk(NodeList nodeset,String kiSign)");
        }
    }
}

