/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSAlgorithmFactory;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.dsig.STRDTKeyInfoResolver;
import com.ibm.ws.webservices.wssecurity.dsig.VerificationResult;
import com.ibm.ws.webservices.wssecurity.dsig.VerifiedConfig;
import com.ibm.ws.webservices.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.webservices.wssecurity.dsig.XMLDTKeyInfoResolver;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xss4j.enc.EncryptedKeyRetriever;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolverBase;
import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.util.SameDocumentEncryptedKeyRetriever;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.Provider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(SignatureConsumer.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SignatureConsumer.class.getName();
    private IdUtil _idResolver = null;
    private Map _selectors = null;
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtil)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Node target[" + DOMUtil.getDisplayName(node) + "]," + "Map context)");
        }
        int n = 0;
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s11");
        }
        String string = node.getNamespaceURI();
        String string2 = node.getLocalName();
        n = string == null ? 0 : string.hashCode() * 31;
        if (node.getNodeType() != 1 || (n += string2 == null ? 0 : string2.hashCode()) != Constants.HASH_DS_SIGNATURE) {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtil.getQualifiedName(node));
        }
        Element element = (Element)node;
        Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int n2 = 0;
        if (v != null && v instanceof Integer) {
            n2 = (Integer)v;
        }
        String string3 = Constants.NAMESPACES[0][n2];
        String string4 = Constants.NAMESPACES[1][n2];
        v = map.remove("com.ibm.ws.webservices.wssecurity.constants.copiedDOMTree");
        boolean bl = ConfigUtil.isTrue((String)v);
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        SignatureConsumerConfig signatureConsumerConfig = (SignatureConsumerConfig)map.remove("com.ibm.wsspi.wssecurity.config.signatureConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SignatureConsumerConfig [" + signatureConsumerConfig + "].");
        }
        Document document = element.getOwnerDocument();
        VerificationResult verificationResult = SignatureConsumer.checkSignature(document, element, wSSConsumerConfig, signatureConsumerConfig, this._idResolver, string3, string4, bl, map);
        if (verificationResult._domRequired) {
            document = verificationResult._copiedDOM;
            object = DOMUtil.getOneOrMoreElements(document.getDocumentElement(), Constants.NS_DSIG, "Signature");
            for (int i = 0; i < object.getLength(); ++i) {
                if (!DOMUtil.equals(element, object.item(i))) continue;
                element = (Element)object.item(i);
                break;
            }
        }
        object = new HashMap();
        Key key = SignatureConsumer.callKeyInfoConsumer(signatureConsumerConfig.getSigningKeyInfo(), "VerifyingKey", object, this._selectors, KeyInfo.searchForKeyInfo(element), map);
        SignatureConsumer.verify(element, key, wSSConsumerConfig, signatureConsumerConfig, this._idResolver, document, verificationResult, this._selectors, map);
        SignatureConsumer.setVerificationResult(verificationResult, signatureConsumerConfig, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Node target,Map context)");
        }
    }

    private static VerificationResult checkSignature(Document document, Element element, WSSConsumerConfig wSSConsumerConfig, SignatureConsumerConfig signatureConsumerConfig, IDResolver iDResolver, String string, String string2, boolean bl, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSignature(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element signature[" + DOMUtil.getDisplayName(element) + "]," + "WSSConsumerConfig gconfig," + "SignatureConsumerConfig config," + "IDResolver idResolver[" + iDResolver + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "boolean domRequired[" + bl + "]," + "Map context)");
        }
        VerificationResult verificationResult = new VerificationResult(signatureConsumerConfig);
        int n = 0;
        Element element2 = DOMUtil.getFirstElement(element);
        while (element2 != null) {
            String string3 = element2.getNamespaceURI();
            String string4 = element2.getLocalName();
            n = string3 == null ? 0 : string3.hashCode() * 31;
            if ((n += string4 == null ? 0 : string4.hashCode()) == Constants.HASH_DS_SIGNEDINFO) {
                SignatureConsumer.checkSignedInfo(document, element2, wSSConsumerConfig, signatureConsumerConfig, verificationResult, iDResolver, string, string2, bl, map);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4 + " is OK.");
                }
            } else if (n == Constants.HASH_DS_KEYINFO || n == Constants.HASH_DS_SIGNATUREVALUE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4 + " is OK.");
                }
            } else if (n == Constants.HASH_DS_OBJECT) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4 + " is OK. But this consumer ignores it.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: There is unknown element " + DOMUtil.getQualifiedName(element2) + " in the " + DOMUtil.getQualifiedName(element) + " element.");
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSignature(Document doc,Element signature,WSSConsumerConfig gconfig,SignatureConsumerConfig config,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,Map context) returns VerificationResult[" + verificationResult + "]");
        }
        return verificationResult;
    }

    private static void checkSignedInfo(Document document, Element element, WSSConsumerConfig wSSConsumerConfig, SignatureConsumerConfig signatureConsumerConfig, VerificationResult verificationResult, IDResolver iDResolver, String string, String string2, boolean bl, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSignedInfo(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element sinfo[" + DOMUtil.getDisplayName(element) + "]," + "WSSConsumerConfig gconfig," + "SignatureConsumerConfig config," + "VerificationResult vresult[" + verificationResult + "]," + "IDResolver idResolver[" + iDResolver + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "boolean domRequired[" + bl + "]," + "Map context)");
        }
        int n = 0;
        Element element2 = DOMUtil.getFirstElement(element);
        while (element2 != null) {
            String string3;
            String string4;
            String string5 = element2.getNamespaceURI();
            String string6 = element2.getLocalName();
            n = string5 == null ? 0 : string5.hashCode() * 31;
            if ((n += string6 == null ? 0 : string6.hashCode()) == Constants.HASH_DS_C14NMETHOD) {
                string4 = DOMUtil.getAttribute(element2, "Algorithm");
                string3 = null;
                if (signatureConsumerConfig.getCanonicalizationMethod() != null) {
                    string3 = signatureConsumerConfig.getCanonicalizationMethod().getAlgorithm();
                }
                if (string3 == null || !string3.equals(string4) || !wSSConsumerConfig.getAllowedCanonicalizationMethods().contains(string4)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s08", string4);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string6 + " [" + string4 + "] is OK.");
                }
            } else if (n == Constants.HASH_DS_SIGNATUREMETHOD) {
                string4 = DOMUtil.getAttribute(element2, "Algorithm");
                string3 = null;
                if (signatureConsumerConfig.getSignatureMethod() != null) {
                    string3 = signatureConsumerConfig.getSignatureMethod().getAlgorithm();
                }
                if (string3 == null || !string3.equals(string4) || !wSSConsumerConfig.getAllowedSignatureMethods().contains(string4)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s09", string4);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string6 + " [" + string4 + "] is OK.");
                }
            } else if (n == Constants.HASH_DS_REFERENCE) {
                SignatureConsumer.checkReference(document, element2, wSSConsumerConfig, signatureConsumerConfig.getReferences(), verificationResult, iDResolver, string, string2, bl, map);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string6 + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: There is unknown element " + DOMUtil.getQualifiedName(element2) + " in the " + DOMUtil.getQualifiedName(element) + " element.");
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSignedInfo(Document doc,Element sinfo,WSSConsumerConfig gconfig,SignatureConsumerConfig config,VerificationResult vresult,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,Map context)");
        }
    }

    private static void checkReference(Document document, Element element, WSSConsumerConfig wSSConsumerConfig, List list, VerificationResult verificationResult, IDResolver iDResolver, String string, String string2, boolean bl, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkReference(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element reference[" + DOMUtil.getDisplayName(element) + "]," + "WSSConsumerConfig gconfig," + "List config," + "VerificationResult vresult[" + verificationResult + "]," + "IDResolver idResolver[" + iDResolver + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "boolean domRequired[" + bl + "]," + "Map context)");
        }
        boolean bl2 = false;
        Exception[] exceptionArray = new Exception[list.size()];
        int n = 0;
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                SigningReferenceConfig signingReferenceConfig = (SigningReferenceConfig)iterator.next();
                n2 = verificationResult._verifiedParts.size() - 1;
                SignatureConsumer.checkReference(document, element, wSSConsumerConfig, signingReferenceConfig, verificationResult, iDResolver, string, string2, bl, map);
                verificationResult._srconfig = signingReferenceConfig;
                bl2 = true;
                break;
            }
            catch (Exception exception) {
                exceptionArray[n++] = exception;
                for (int i = verificationResult._verifiedParts.size() - 1; i > n2; --i) {
                    verificationResult._verifiedParts.remove(i);
                }
            }
        }
        if (!bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, n + " exceptions were catched.");
                for (int i = 0; i < n; ++i) {
                    Tr.debug(tc, "No." + iterator + "'s exception: " + exceptionArray[i]);
                }
            }
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s12", exceptionArray[n - 1]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkReference(Document doc,Element reference,WSSConsumerConfig gconfig,List config,VerificationResult vresult,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,Map context)");
        }
    }

    private static void checkReference(Document node, Element element, WSSConsumerConfig wSSConsumerConfig, SigningReferenceConfig signingReferenceConfig, VerificationResult verificationResult, IDResolver iDResolver, String string, String string2, boolean bl, Map map) throws SoapSecurityException {
        Element element2;
        Element element3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkReference(Document doc[" + DOMUtil.getDisplayName(node) + "]," + "Element reference[" + DOMUtil.getDisplayName(element) + "]," + "WSSConsumerConfig gconfig," + "SigningReferenceConfig config," + "VerificationResult vresult[" + verificationResult + "]," + "IDResolver idResolver[" + iDResolver + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "boolean domRequired[" + bl + "]," + "Map context)");
        }
        boolean bl2 = false;
        int n = 0;
        Element element4 = null;
        VerificationResult.VerifiedPart verifiedPart = new VerificationResult.VerifiedPart();
        Node node2 = DOMUtil.getFirstElement(element);
        while (node2 != null) {
            String string3 = node2.getNamespaceURI();
            String string4 = node2.getLocalName();
            n = string3 == null ? 0 : string3.hashCode() * 31;
            if ((n += string4 == null ? 0 : string4.hashCode()) == Constants.HASH_DS_TRANSFORMS) {
                SignatureConsumer.checkTransforms(node2, wSSConsumerConfig, signingReferenceConfig.getTransforms(), verifiedPart, bl, map);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4 + " is OK.");
                }
            } else if (n == Constants.HASH_DS_DIGESTMETHOD) {
                String string5 = DOMUtil.getAttribute(node2, "Algorithm");
                String string6 = null;
                if (signingReferenceConfig.getDigestMethod() != null) {
                    string6 = signingReferenceConfig.getDigestMethod().getAlgorithm();
                }
                if (string6 == null || !string6.equals(string5) || !wSSConsumerConfig.getAllowedDigestMethods().contains(string5)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s11", string5);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4 + " [" + string5 + "] is OK.");
                }
            } else if (n == Constants.HASH_DS_DIGESTVALUE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4 + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: There is unknown element " + DOMUtil.getQualifiedName(node2) + " in the " + DOMUtil.getQualifiedName(element) + " element.");
            }
            node2 = DOMUtil.getNextElement(node2);
        }
        if (verificationResult._domRequired) {
            node = verificationResult._copiedDOM;
        } else if (verifiedPart._domRequired) {
            node2 = (Document)node.cloneNode(true);
            verificationResult._domRequired = true;
            verificationResult._copiedDOM = node2;
            node = node2;
        }
        String string7 = DOMUtil.getAttribute(element, "URI");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing URI [" + string7 + "]...");
        }
        if (string7.length() == 0) {
            element4 = node.getDocumentElement();
        } else {
            if (string7.length() < 2 || string7.charAt(0) != '#') {
                throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s02", string7);
            }
            string7 = string7.substring(1);
            element4 = iDResolver.resolveID((Document)node, string7);
        }
        if (element4 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The URI [" + string7 + "] is not supported." + "  Either the id is defined in the wrong namespace or no id's have a matching value.");
            }
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s02", string7);
        }
        verifiedPart._parent = element4.getParentNode();
        verifiedPart._object = element4;
        verifiedPart._timestamp = element3 = NonceUtil.getTimestamp(element4, string2);
        verifiedPart._nonce = element2 = NonceUtil.getNonce(element4, string);
        verifiedPart._noncefirst = bl2 = NonceUtil.isNonceFirst(element4, element2, element3);
        verificationResult._verifiedParts.add(verifiedPart);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added Verified part[" + verifiedPart + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkReference(Document doc,Element reference,WSSConsumerConfig gconfig,SignatureConsumerConfig config,List parts,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,Map context)");
        }
    }

    private static void checkTransforms(Element element, WSSConsumerConfig wSSConsumerConfig, List list, VerificationResult.VerifiedPart verifiedPart, boolean bl, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTransform(Element transforms[" + DOMUtil.getDisplayName(element) + "]," + "WSSConsumerConfig gconfig," + "List config[" + list + "]," + "VerifiedPart part[" + verifiedPart + "]," + "boolean domRequired[" + bl + "]," + "Map context])");
        }
        int n = 0;
        Element element2 = DOMUtil.getFirstElement(element);
        while (element2 != null) {
            Element element3 = DOMUtil.getNextElement(element2);
            String string = element2.getNamespaceURI();
            String string2 = element2.getLocalName();
            n = string == null ? 0 : string.hashCode() * 31;
            if ((n += string2 == null ? 0 : string2.hashCode()) == Constants.HASH_DS_TRANSFORM) {
                SignatureConsumer.checkTransform(element2, element3 == null, wSSConsumerConfig, list, verifiedPart, bl, map);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: There is unknown element " + DOMUtil.getQualifiedName(element2) + " in the " + DOMUtil.getQualifiedName(element) + " element.");
            }
            element2 = element3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTransform(Element transforms,WSSConsumerConfig gconfig,List config,VerifiedPart part,boolean domRequired,Map context)");
        }
    }

    private static void checkTransform(Element element, boolean bl, WSSConsumerConfig wSSConsumerConfig, List list, VerificationResult.VerifiedPart verifiedPart, boolean bl2, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTransform(Element transform[" + DOMUtil.getDisplayName(element) + "]," + "boolean lastTransform[" + bl + "]," + "WSSConsumerConfig gconfig," + "List config[" + list + "]," + "VerifiedPart part[" + verifiedPart + "]," + "boolean domRequired[" + bl2 + "]," + "Map context)");
        }
        boolean bl3 = false;
        Iterator iterator = list.iterator();
        String string = element.getAttribute("Algorithm");
        while (iterator.hasNext()) {
            AlgorithmConfig algorithmConfig = (AlgorithmConfig)iterator.next();
            String string2 = algorithmConfig.getAlgorithm();
            if (!string2.equals(string) || !wSSConsumerConfig.getAllowedTransforms().contains(string)) continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s12", string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Transform [" + string + "] is OK.");
        }
        if (ConfigUtil.isC14nTransform(string)) {
            ++verifiedPart._numC14n;
            if (bl) {
                verifiedPart._lastIsC14n = true;
            }
        } else if (bl2 && ConfigUtil.isDOMRequiredTransform(string)) {
            verifiedPart._domRequired = bl2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTransform(List config,WSSConsumerConfig gconfig,String algorithm,VerifiedPart part,boolean domRequired,Map context)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verify(Element element, Key key, WSSConsumerConfig wSSConsumerConfig, SignatureConsumerConfig signatureConsumerConfig, IDResolver iDResolver, Document document, VerificationResult verificationResult, Map map, Map map2) throws SoapSecurityException {
        Object object;
        Object object2;
        Iterator iterator;
        Cloneable cloneable;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verify(Element signature[" + DOMUtil.getDisplayName(element) + "]," + "Key key[" + key + "]," + "WSSConsumerConfig gconfig," + "SignatureConsumerConfig config," + "IDResolver idResolver[" + iDResolver + "]," + "Document document[" + DOMUtil.getDisplayName(document) + "]," + "VerificationResult vresult[" + verificationResult + "]," + "Map selectors," + "Map context)");
        }
        WSSSignatureContext wSSSignatureContext = new WSSSignatureContext();
        wSSSignatureContext.setContext(map2);
        String string = null;
        String string2 = null;
        Map map3 = wSSConsumerConfig.getProperties();
        string = (String)map2.remove("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
        wSSSignatureContext.setHWKeyStoreName(string);
        String string3 = null;
        if (signatureConsumerConfig.getSignatureMethod() != null) {
            string3 = signatureConsumerConfig.getSignatureMethod().getAlgorithm();
        }
        wSSSignatureContext.setSigAlgorithm(string3);
        if (wSSSignatureContext.useHWKeyStore()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Key Store Name is: ", wSSSignatureContext.getHWKeyStoreName());
            }
            if ((object3 = ConfigUtil.getHWCryptoProviderInstance(wSSSignatureContext.getHWKeyStoreName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                wSSSignatureContext.setHWKeyStoreProvider((Provider)object3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + ((Provider)object3).getName());
                }
            }
        }
        string2 = (String)map3.get("HWCONFIG");
        wSSSignatureContext.setHWConfigName(string2);
        wSSSignatureContext.setOffload((Boolean)map3.get("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography"));
        if (wSSSignatureContext.shouldChangeProvider()) {
            object3 = HWKeyCache.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Acceleration enabled, Key Store Name is: ", wSSSignatureContext.getHWConfigName());
            }
            if ((cloneable = ConfigUtil.getHWCryptoProviderInstance(wSSSignatureContext.getHWConfigName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                wSSSignatureContext.setHWAccelerationProvider((Provider)cloneable);
                iterator = (Integer)map3.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                ((HWKeyCache)object3).setProvider((Provider)cloneable, (Integer)((Object)iterator));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for HW Acceleration" + ((Provider)cloneable).getName());
                }
            }
        }
        object3 = null;
        if (!(!(key instanceof PKCS11Key) || string2 != null && string2.length() != 0 || string != null && string.length() != 0)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PKCS11 Key is in use, but did not find hardware keystore/acceleration in the config");
            }
            if ((object3 = (String)map3.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore")) != null) {
                wSSSignatureContext.setHWKeyStoreName((String)object3);
                if (wSSSignatureContext.useHWKeyStore()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "HARDWARE Key Store Name is: ", wSSSignatureContext.getHWKeyStoreName());
                    }
                    if ((cloneable = ConfigUtil.getHWCryptoProviderInstance(wSSSignatureContext.getHWKeyStoreName())) == null) {
                        Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                    } else {
                        wSSSignatureContext.setHWKeyStoreProvider((Provider)cloneable);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + ((Provider)cloneable).getName());
                        }
                    }
                } else {
                    Tr.error(tc, "Missing Hardware KeyStore Configuration, cannot use the PKCS11 type for signing");
                    throw SoapSecurityException.format("Missing Hardware KeyStore Configuration");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            wSSSignatureContext.setResourceShower(ShowerImpl.getInstance());
        }
        if (iDResolver != null) {
            wSSSignatureContext.setIDResolver(iDResolver);
        }
        cloneable = new HashSet();
        iterator = wSSConsumerConfig.getSignatureConsumers().iterator();
        while (iterator.hasNext()) {
            cloneable.add(((SignatureConsumerConfig)iterator.next()).getSigningKeyInfo());
        }
        HashSet<KeyInfoConsumerConfig> hashSet = new HashSet<KeyInfoConsumerConfig>();
        iterator = wSSConsumerConfig.getEncryptionConsumers().iterator();
        while (iterator.hasNext()) {
            hashSet.add(((EncryptionConsumerConfig)iterator.next()).getEncryptionKeyInfo());
        }
        Set set = wSSConsumerConfig.getTokenConsumers();
        WSSAlgorithmFactory wSSAlgorithmFactory = wSSConsumerConfig.getAlgorithmFactory();
        wSSSignatureContext.setAlgorithmFactory(wSSAlgorithmFactory);
        wSSSignatureContext.setDocument(document);
        if (signatureConsumerConfig.getKeyInfoSignature() != null) {
            wSSSignatureContext.setKeyInfoSignature(signatureConsumerConfig.getKeyInfoSignature().getAlgorithm());
        } else {
            wSSSignatureContext.setKeyInfoSignature(null);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DecryptionTransform is used: " + signatureConsumerConfig.isDecryptionTransformEnabled());
        }
        if (signatureConsumerConfig.isDecryptionTransformEnabled()) {
            object2 = null;
            try {
                object2 = new SameDocumentEncryptedKeyRetriever(document);
            }
            catch (StructureException structureException) {
                Tr.processException(structureException, clsName + ".verify", "826");
                throw new SoapSecurityException(structureException);
            }
            wSSSignatureContext.setEncryptedKeyRetriever((EncryptedKeyRetriever)object2);
            object = new XMLDTKeyInfoResolver();
            ((KeyInfoResolverBase)object).setAlgorithmFactory(wSSAlgorithmFactory);
            ((XMLDTKeyInfoResolver)object).setContext(map2);
            ((XMLDTKeyInfoResolver)object).setSelectors(map);
            ((XMLDTKeyInfoResolver)object).setIdResolver(iDResolver);
            ((XMLDTKeyInfoResolver)object).setEncKeyInfoConsumers(hashSet);
            ((XMLDTKeyInfoResolver)object).setTokenConsumers(set);
            wSSSignatureContext.setKeyInfoResolver((KeyInfoResolver)object);
        }
        object2 = new STRDTKeyInfoResolver();
        ((STRDTKeyInfoResolver)object2).setContext(map2);
        ((STRDTKeyInfoResolver)object2).setSelectors(map);
        ((STRDTKeyInfoResolver)object2).setDsigKeyInfoSet((Set)((Object)cloneable));
        ((STRDTKeyInfoResolver)object2).setEncKeyInfoSet(hashSet);
        ((STRDTKeyInfoResolver)object2).setGeneration(false);
        ((STRDTKeyInfoResolver)object2).setIdResolver(iDResolver);
        wSSSignatureContext.setSTRDTKeyInfoResolver((STRDTKeyInfoResolver)object2);
        wSSSignatureContext.setVerificationResult(verificationResult);
        object = null;
        try {
            object = wSSSignatureContext.verify(element, key);
        }
        finally {
            if (wSSSignatureContext.isHWAccelerationProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance(wSSSignatureContext.getHWConfigName(), wSSSignatureContext.getHWAccelerationProvider());
            }
            if (wSSSignatureContext.useHWKeyStore()) {
                ConfigUtil.returnHWCryptoProviderInstance(wSSSignatureContext.getHWKeyStoreName(), wSSSignatureContext.getHWKeyStoreProvider());
            }
        }
        boolean bl = object.getCoreValidity();
        String string4 = null;
        if (!bl || tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Core validity=");
            stringBuffer.append(bl);
            stringBuffer.append(" Signed info validity=");
            stringBuffer.append(object.getSignedInfoValidity());
            stringBuffer.append(" Signed info message='");
            stringBuffer.append(object.getSignedInfoMessage());
            stringBuffer.append("'");
            int n = object.getNumberOfReferences();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(" Ref[");
                stringBuffer.append(iterator);
                stringBuffer.append("](validity=");
                stringBuffer.append(object.getReferenceValidity(i));
                stringBuffer.append(" message='");
                stringBuffer.append(object.getReferenceMessage(i));
                stringBuffer.append("' uri='");
                stringBuffer.append(object.getReferenceURI(i));
                stringBuffer.append("' type='");
                stringBuffer.append(object.getReferenceType(i));
                stringBuffer.append("')");
            }
            string4 = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string4);
            }
            if (bl) {
                string4 = null;
            }
        }
        if (string4 != null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s01", string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verify(Element signature,Key key,WSSConsumerConfig gconfig,SignatureConsumerConfig config,IDResolver idResolver,Document document,VerificationResult vresult,Map selectors,Map context)");
        }
    }

    public static Key callKeyInfoConsumer(KeyInfoConsumerConfig keyInfoConsumerConfig, String string, Map map, Map map2, Element element, Map map3) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callKeyInfoConsumer(KeyInfoConsumerConfig config,String keytype[" + string + "]," + "Map type," + "Map properties," + "Element target[" + DOMUtil.getDisplayName(element) + "]," + "Map context)");
        }
        KeyInfoConsumer keyInfoConsumer = (KeyInfoConsumer)map2.get(KeyInfoConsumer.class);
        map.clear();
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE, string);
        map3.put("com.ibm.wsspi.wssecurity.config.keyinfoConsumer.configKey", keyInfoConsumerConfig);
        Key key = keyInfoConsumer.getKey(element, map, map3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callKeyInfoConsumer(KeyInfoConsumerConfig config,String keytype,Map type,Map properties,Element target,Map context) returns Key[" + key + "]");
        }
        return key;
    }

    private static void setVerificationResult(VerificationResult verificationResult, SignatureConsumerConfig signatureConsumerConfig, Map map) throws SoapSecurityException {
        Token token;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVerificationResult(VerificationResult vresult[" + verificationResult + "]," + "SignatureConsumerConfig sconfig," + "Map context)");
        }
        Iterator iterator = verificationResult._verifiedParts.iterator();
        while (iterator.hasNext()) {
            VerificationResult.VerifiedPart verifiedPart = (VerificationResult.VerifiedPart)iterator.next();
            SignatureConsumer.removeNode(verifiedPart._timestamp, "wedsig");
            SignatureConsumer.removeNode(verifiedPart._nonce, "wedsig");
        }
        verificationResult._token = token = SignatureConsumer.getToken(verificationResult, signatureConsumerConfig, map);
        ResultPool.add(map, verificationResult);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVerificationResult(VerificationResult vresult,SignatureConsumerConfig sconfig,Map context)");
        }
    }

    public static void removeNode(Element element, String string) {
        Node node;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNode(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String type[" + string + "])");
        }
        if (element != null && (string2 = element.getAttribute("wasextention")) != null && string2.equals(string) && (node = element.getParentNode()) != null) {
            node.removeChild(element);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNode(Element element,String type)");
        }
    }

    protected static KeyInfoResult[] getKeyInfoResults(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfoResults(Map context)");
        }
        KeyInfoResult[] keyInfoResultArray = null;
        Result[] resultArray = ResultPool.get(map, KeyInfoResult.class);
        if (resultArray != null) {
            keyInfoResultArray = new KeyInfoResult[resultArray.length];
            for (int i = 0; i < resultArray.length; ++i) {
                keyInfoResultArray[i] = (KeyInfoResult)resultArray[i];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInfoResults(Map context) returns KeyInfoResult[][" + keyInfoResultArray + "]");
        }
        return keyInfoResultArray;
    }

    private static KeyInfoResult getProcessedResult(VerificationResult verificationResult, KeyInfoResult[] keyInfoResultArray, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessedResult(VerificationResult vresult,KeyInfoResult[] results,List kclist");
        }
        KeyInfoResult keyInfoResult = null;
        if (keyInfoResultArray != null) {
            for (int i = 0; i < keyInfoResultArray.length; ++i) {
                KeyInfoResult keyInfoResult2 = keyInfoResultArray[i];
                if (keyInfoResult == null && list.contains(keyInfoResult2.getKeyInfoContentConsumer()) && keyInfoResult2.getError() == null) {
                    keyInfoResult = keyInfoResult2;
                    continue;
                }
                verificationResult._kresults.put(keyInfoResult2.getKeyInfoContentConsumer(), keyInfoResult2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessedResult(VerificationResult vresult,KeyInfoResult[] results,List kclist) returns KeyInfoResult[" + keyInfoResult + "]");
        }
        return keyInfoResult;
    }

    private static Token getToken(VerificationResult verificationResult, SignatureConsumerConfig signatureConsumerConfig, Map map) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getToken(VerificationResult vresult[" + verificationResult + "]," + "SignatureConsumerConfig sconfig," + "Map context)");
        }
        Token token = null;
        Set set = null;
        KeyInfoResult[] keyInfoResultArray = SignatureConsumer.getKeyInfoResults(map);
        KeyInfoResult keyInfoResult = SignatureConsumer.getProcessedResult(verificationResult, keyInfoResultArray, signatureConsumerConfig.getSigningKeyInfo().getContentConsumers());
        if (keyInfoResult != null) {
            object4 = keyInfoResult.getIdInSubject();
            token = TokenManager.getToken(map, keyInfoResult.getKeyInfoContentConsumer().getTokenConsumer(), (String)object4);
            if (token != null) {
                if (token.getError() != null) {
                    throw token.getError();
                }
                token.setReferenced(true);
            }
            set = TokenManager.getTokens(map, (String)object4);
        }
        if ((object4 = (List)signatureConsumerConfig.getIdentityMap().get(verificationResult._srconfig)) != null && object4.size() > 0) {
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                object3 = (VerifiedConfig)iterator.next();
                object2 = ((VerifiedConfig)object3)._sconfig.getSigningKeyInfo().getContentConsumers().iterator();
                block1: while (object2.hasNext()) {
                    object = (KeyInfoContentConsumerConfig)object2.next();
                    for (int i = 0; i < keyInfoResultArray.length; ++i) {
                        if (!object.equals(keyInfoResultArray[i].getKeyInfoContentConsumer())) continue;
                        verificationResult._identities.put(object3, keyInfoResultArray[i]);
                        continue block1;
                    }
                }
            }
        }
        if (set != null && set.size() > 0) {
            block3: for (int i = 0; i < keyInfoResultArray.length; ++i) {
                object3 = keyInfoResultArray[i];
                object2 = ((KeyInfoResult)object3).getKeyInfoContentConsumer().getTokenConsumer();
                if (object2 == null) continue;
                object = set.iterator();
                while (object.hasNext()) {
                    Token token2 = (Token)object.next();
                    if (!object2.equals(token2.getUsedTokenConsumer())) continue;
                    verificationResult._kresults.put(object3, token2);
                    continue block3;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getToken(VerificationResult vresult,SignatureConsumerConfig sconfig,Map context)returns Token[" + token + "]");
        }
        return token;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showSignedResource(Element element, int n, String string, String string2, byte[] byArray, String string3) {
            String string4 = null;
            try {
                string4 = string3 == null ? new String(byArray, "UTF-8") : new String(byArray, string3);
            }
            catch (Exception exception) {
                Tr.debug(tc, "WARNING: An exception occured while the content is encoded with [" + string3 + "].");
            }
            if (n < 0) {
                Tr.debug(tc, "ResourceShower logs verify-SignedInfo: " + string4);
            } else if (string == null || string.length() == 0) {
                Tr.debug(tc, "ResourceShower logs verify-resource_" + n + ": " + string4);
            } else {
                Tr.debug(tc, "ResourceShower logs verify-" + string + ": " + string4);
            }
        }
    }
}

