/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.websphere.webservices.soap.IBMAttr;
import com.ibm.websphere.webservices.soap.IBMSOAPElement;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.ElementSelector;
import com.ibm.ws.webservices.wssecurity.core.RequestMessagePool;
import com.ibm.ws.webservices.wssecurity.dsig.STRDTKeyInfoResolver;
import com.ibm.ws.webservices.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoGenerator;
import com.ibm.ws.webservices.wssecurity.time.TimestampGenerator;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.webservices.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.webservices.wssecurity.util.XPathElementSelector;
import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.dsig.Reference;
import com.ibm.ws.wssecurity.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.dsig.TemplateGenerator;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedData;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SignatureGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(SignatureGenerator.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SignatureGenerator.class.getName();
    private static final String SIGNATURE_PREFIX = "ds";
    private IdUtil _idResolver = null;
    private Map _selectors = null;
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtil)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        Element element2;
        NodeList nodeList;
        Node node;
        Object object12;
        Object object13;
        boolean bl;
        ReferencePartConfig.PartConfig partConfig;
        SigningReferenceConfig signingReferenceConfig;
        Map map2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element parent[" + DOMUtil.getDisplayName(element) + "]," + "Map context)");
        }
        Object object14 = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int n = 0;
        if (object14 != null && object14 instanceof Integer) {
            n = (Integer)object14;
        }
        String string = Constants.NAMESPACES[0][n];
        String string2 = Constants.NAMESPACES[1][n];
        String string3 = DOMUtil.getNamespacePrefix(element, string);
        if (element == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s13");
        }
        String string4 = element.getLocalName();
        String string5 = element.getNamespaceURI();
        if (NamespaceUtil.isWsse(string5) != n || !"Security".equals(string4)) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", DOMUtil.getQualifiedName(element));
        }
        WSSGeneratorConfig wSSGeneratorConfig = (WSSGeneratorConfig)map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        SignatureGeneratorConfig signatureGeneratorConfig = (SignatureGeneratorConfig)map.remove("com.ibm.wsspi.wssecurity.config.signatureGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SignatureGeneratorConfig [" + signatureGeneratorConfig + "].");
        }
        HashMap hashMap = new HashMap();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>(map);
        hashMap2.put("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver", this._idResolver);
        hashMap2.put(NonceManager.class, wSSGeneratorConfig.getNonceManager());
        if (signatureGeneratorConfig.getKeyInfoSignature() != null) {
            hashMap2.put("security.wssecurity.integraldialectelementselector.keysigntype", signatureGeneratorConfig.getKeyInfoSignature().getAlgorithm());
        }
        String string6 = signatureGeneratorConfig.getCanonicalizationMethod().getAlgorithm();
        String string7 = signatureGeneratorConfig.getSignatureMethod().getAlgorithm();
        TemplateGenerator templateGenerator = new TemplateGenerator(document, null, string6, string7);
        templateGenerator.setPrefix(SIGNATURE_PREFIX);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining signing parts.");
        }
        Element element3 = document.getDocumentElement();
        boolean bl2 = false;
        boolean bl3 = false;
        HashSet<ReferencePartConfig.PartConfig> hashSet = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig> hashMap3 = new HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig>();
        HashMap hashMap4 = new HashMap();
        boolean bl4 = false;
        HashSet<ReferencePartConfig.PartConfig> hashSet2 = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig> hashMap5 = new HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig>();
        HashMap hashMap6 = new HashMap();
        hashMap2.put("com.ibm.ws.webservices.wssecurity.util.selector.config", wSSGeneratorConfig.getTokenGenerators());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = null;
        if (signatureGeneratorConfig != null && signatureGeneratorConfig.getReferences() != null && signatureGeneratorConfig.getReferences().iterator() != null) {
            iterator = signatureGeneratorConfig.getReferences().iterator();
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                map2 = new HashMap(hashMap2);
                signingReferenceConfig = (SigningReferenceConfig)iterator.next();
                SignatureGenerator.prepareTransform(signingReferenceConfig, map2);
                ReferencePartConfig referencePartConfig = signingReferenceConfig.getReference();
                if (referencePartConfig == null || referencePartConfig.getParts() == null || referencePartConfig.getParts().iterator() == null) continue;
                Iterator iterator2 = referencePartConfig.getParts().iterator();
                while (iterator2.hasNext()) {
                    partConfig = (ReferencePartConfig.PartConfig)iterator2.next();
                    if (partConfig.isTimestamp() || partConfig.isNonce()) {
                        bl3 = true;
                        hashSet.add(partConfig);
                        hashMap3.put(partConfig, signingReferenceConfig);
                        hashMap4.put(partConfig, map2);
                        continue;
                    }
                    if (Constants.DIALECT_WAS.equals(partConfig.getDialect()) && (IntegralDialectElementSelector.WASDIALECTS[2].equals(partConfig.getKeyword()) || IntegralDialectElementSelector.WASDIALECTS[3].equals(partConfig.getKeyword()))) {
                        bl4 = true;
                        hashSet2.add(partConfig);
                        hashMap5.put(partConfig, signingReferenceConfig);
                        hashMap6.put(partConfig, map2);
                        continue;
                    }
                    bl = false;
                    object13 = partConfig.getDialect();
                    object12 = partConfig.getKeyword();
                    node = document;
                    int n2 = -1;
                    while (node != null) {
                        nodeList = SignatureGenerator.getMessagePart((Document)node, (String)object13, (String)object12, "signature_mode", this._selectors, class$com$ibm$ws$webservices$wssecurity$util$IntegralDialectElementSelector == null ? SignatureGenerator.class$("com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector") : class$com$ibm$ws$webservices$wssecurity$util$IntegralDialectElementSelector, map2);
                        if (nodeList != null && nodeList.getLength() > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, nodeList.getLength() + " parts found.");
                            }
                            for (int i = 0; i < nodeList.getLength(); ++i) {
                                element2 = (Element)nodeList.item(i);
                                if (n2 >= 0) {
                                    object11 = RequestMessagePool.convertElement(map, element2, n2);
                                    if (object11 == null) continue;
                                    if (((RequestMessagePool.EncryptedObject)object11).getEncryptedData() != null) {
                                        object10 = "#" + SignatureGenerator.addWsuId(document, ((RequestMessagePool.EncryptedObject)object11).getEncryptedData(), string2);
                                        object9 = templateGenerator.createReference((String)object10);
                                        ((Reference)object9).setDigestMethod(signingReferenceConfig.getDigestMethod().getAlgorithm());
                                        SignatureGenerator.addTransforms((Reference)object9, document, ((RequestMessagePool.EncryptedObject)object11).getEncryptedData(), signingReferenceConfig.getTransforms(), string3, string, signatureGeneratorConfig.addInclusiveNamespaces());
                                        templateGenerator.addReference((Reference)object9);
                                        bl2 = true;
                                        arrayList.add(element2);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Added the encrypted data[" + DOMUtil.getDisplayName(((RequestMessagePool.EncryptedObject)object11).getEncryptedData()) + "] because the element[" + DOMUtil.getDisplayName(element2) + "] has already encrypted.");
                                        }
                                    }
                                    if (((RequestMessagePool.EncryptedObject)object11).getHeaderInfo() == null) continue;
                                    object10 = "#" + SignatureGenerator.addWsuId(document, ((RequestMessagePool.EncryptedObject)object11).getHeaderInfo(), string2);
                                    object9 = templateGenerator.createReference((String)object10);
                                    ((Reference)object9).setDigestMethod(signingReferenceConfig.getDigestMethod().getAlgorithm());
                                    SignatureGenerator.addTransforms((Reference)object9, document, ((RequestMessagePool.EncryptedObject)object11).getHeaderInfo(), signingReferenceConfig.getTransforms(), string3, string, signatureGeneratorConfig.addInclusiveNamespaces());
                                    templateGenerator.addReference((Reference)object9);
                                    bl2 = true;
                                    arrayList.add(element2);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Added the header info[" + DOMUtil.getDisplayName(((RequestMessagePool.EncryptedObject)object11).getHeaderInfo()) + "] because the element[" + DOMUtil.getDisplayName(element2) + "] has already encrypted.");
                                    continue;
                                }
                                object11 = DOMUtil.equals(element2, element3) ? "" : "#" + SignatureGenerator.addWsuId(document, element2, string2);
                                object10 = templateGenerator.createReference((String)object11);
                                ((Reference)object10).setDigestMethod(signingReferenceConfig.getDigestMethod().getAlgorithm());
                                SignatureGenerator.addTransforms((Reference)object10, document, element2, signingReferenceConfig.getTransforms(), string3, string, signatureGeneratorConfig.addInclusiveNamespaces());
                                templateGenerator.addReference((Reference)object10);
                                bl2 = true;
                                arrayList.add(element2);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Added the element[" + DOMUtil.getDisplayName(element2) + "].");
                            }
                            bl = true;
                            break;
                        }
                        node = RequestMessagePool.getDocument(map, ++n2);
                    }
                    if (bl) continue;
                    throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", (String)object13, (String)object12);
                }
            }
        }
        if (!bl2 && !bl4) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc,Element parent,Map context)");
            }
            return;
        }
        bl = false;
        if (!bl2) {
            bl = true;
            object13 = templateGenerator.createReference("#dummy001");
            templateGenerator.addReference((Reference)object13);
        }
        object13 = wSSGeneratorConfig.getAlgorithmFactory();
        object12 = signatureGeneratorConfig.getSignatureMethod();
        node = null;
        try {
            object8 = ((AlgorithmFactory)object13).convertParameter(object12.getAlgorithm(), object12.getProperties());
            if (object8 != null) {
                templateGenerator.setSignatureMethodParameter((AlgorithmParameterSpec)object8);
            }
            node = templateGenerator.getSignatureElement((AlgorithmFactory)object13);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            Tr.processException(invalidAlgorithmParameterException, clsName + ".invoke", "424");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s11", new Object[]{invalidAlgorithmParameterException});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", invalidAlgorithmParameterException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Tr.processException(noSuchAlgorithmException, clsName + ".invoke", "428");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s11", new Object[]{noSuchAlgorithmException});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Tr.processException(noSuchProviderException, clsName + ".invoke", "432");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s11", new Object[]{noSuchProviderException});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", noSuchProviderException);
        }
        if (wSSGeneratorConfig.isUserDefinedComponentsUsed()) {
            object8 = document.createElementNS(Constants.NS_DSIG, "ds:KeyInfo");
            object8 = (Element)node.appendChild((Node)object8);
        }
        node = SignatureGenerator.insertElement(element, node, string2, map);
        object8 = wSSGeneratorConfig.getTimestampGenerator();
        if (object8 != null && !object8.isDefault()) {
            TimestampGenerator.moveTimestamp(document, wSSGeneratorConfig.getTimestampGenerator(), this._selectors, map);
        }
        Key key = SignatureGenerator.callKeyInfoGenerator(signatureGeneratorConfig.getSigningKeyInfo(), "SigningKey", hashMap, this._selectors, document, node, map);
        element2 = DOMUtil.getOneChildElement(node, Constants.NS_DSIG, "SignedInfo");
        if (signatureGeneratorConfig.addInclusiveNamespaces() && ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(string6) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(string6)) && (object10 = SignatureGenerator.createInclusiveNamespaces(document, (Element)(object11 = DOMUtil.getOneChildElement(element2, Constants.NS_DSIG, "CanonicalizationMethod")))) != null) {
            object11.appendChild((Node)object10);
        }
        if (bl) {
            object11 = DOMUtil.getOneChildElement(element2, Constants.NS_DSIG, "Reference");
            element2.removeChild((Node)object11);
        }
        if (bl4) {
            iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                partConfig = (ReferencePartConfig.PartConfig)iterator.next();
                signingReferenceConfig = (SigningReferenceConfig)hashMap5.get(partConfig);
                map2 = (Map)hashMap6.get(partConfig);
                boolean bl5 = false;
                object10 = partConfig.getDialect();
                object9 = partConfig.getKeyword();
                object7 = document;
                int n3 = -1;
                while (object7 != null) {
                    nodeList = SignatureGenerator.getSpecialPart((Document)object7, partConfig, "signature_mode", this._selectors, map2);
                    if (nodeList != null && nodeList.getLength() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, nodeList.getLength() + " parts found.");
                        }
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            object6 = (Element)nodeList.item(i);
                            if (n3 >= 0) {
                                object5 = RequestMessagePool.convertElement(map, (Element)object6, n3);
                                if (object5 == null) continue;
                                if (((RequestMessagePool.EncryptedObject)object5).getEncryptedData() != null) {
                                    object4 = "#" + SignatureGenerator.addWsuId(document, ((RequestMessagePool.EncryptedObject)object5).getEncryptedData(), string2);
                                    object3 = templateGenerator.createReference((String)object4);
                                    ((Reference)object3).setDigestMethod(signingReferenceConfig.getDigestMethod().getAlgorithm());
                                    SignatureGenerator.addTransforms((Reference)object3, document, ((RequestMessagePool.EncryptedObject)object5).getEncryptedData(), signingReferenceConfig.getTransforms(), string3, string, signatureGeneratorConfig.addInclusiveNamespaces());
                                    element2.appendChild(((Reference)object3).getReferenceElement());
                                    arrayList.add(object6);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Added the encrypted data[" + DOMUtil.getDisplayName(((RequestMessagePool.EncryptedObject)object5).getEncryptedData()) + "] because the element[" + DOMUtil.getDisplayName((Node)object6) + "] has already encrypted.");
                                    }
                                }
                                if (((RequestMessagePool.EncryptedObject)object5).getHeaderInfo() == null) continue;
                                object4 = "#" + SignatureGenerator.addWsuId(document, ((RequestMessagePool.EncryptedObject)object5).getHeaderInfo(), string2);
                                object3 = templateGenerator.createReference((String)object4);
                                ((Reference)object3).setDigestMethod(signingReferenceConfig.getDigestMethod().getAlgorithm());
                                SignatureGenerator.addTransforms((Reference)object3, document, ((RequestMessagePool.EncryptedObject)object5).getHeaderInfo(), signingReferenceConfig.getTransforms(), string3, string, signatureGeneratorConfig.addInclusiveNamespaces());
                                element2.appendChild(((Reference)object3).getReferenceElement());
                                arrayList.add(object6);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Added the header info[" + DOMUtil.getDisplayName(((RequestMessagePool.EncryptedObject)object5).getHeaderInfo()) + "] because the element[" + DOMUtil.getDisplayName((Node)object6) + "] has already encrypted.");
                                continue;
                            }
                            object5 = DOMUtil.equals((Node)object6, element3) ? "" : "#" + SignatureGenerator.addWsuId(document, (Element)object6, string2);
                            object4 = templateGenerator.createReference((String)object5);
                            ((Reference)object4).setDigestMethod(signingReferenceConfig.getDigestMethod().getAlgorithm());
                            SignatureGenerator.addTransforms((Reference)object4, document, (Element)object6, signingReferenceConfig.getTransforms(), string3, string, signatureGeneratorConfig.addInclusiveNamespaces());
                            element2.appendChild(((Reference)object4).getReferenceElement());
                            arrayList.add(object6);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Added the element[" + DOMUtil.getDisplayName((Node)object6) + "].");
                        }
                        bl5 = true;
                        break;
                    }
                    object7 = RequestMessagePool.getDocument(map, ++n3);
                }
                if (bl5) continue;
                throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", (String)object10, (String)object9);
            }
        }
        if (bl3) {
            Object[] objectArray = arrayList.toArray();
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                partConfig = (ReferencePartConfig.PartConfig)iterator.next();
                signingReferenceConfig = (SigningReferenceConfig)hashMap3.get(partConfig);
                nodeList = SignatureGenerator.getNoncePart(document, objectArray, partConfig, "signature_mode", this._selectors, class$com$ibm$ws$webservices$wssecurity$util$IntegralDialectElementSelector == null ? SignatureGenerator.class$("com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector") : class$com$ibm$ws$webservices$wssecurity$util$IntegralDialectElementSelector, map2 = (Map)hashMap4.get(partConfig));
                if (nodeList == null || nodeList.getLength() <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, nodeList.getLength() + " parts found.");
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    object9 = (Element)nodeList.item(i);
                    object7 = DOMUtil.equals((Node)object9, element3) ? "" : "#" + SignatureGenerator.addWsuId(document, (Element)object9, string2);
                    Reference reference = templateGenerator.createReference((String)object7);
                    reference.setDigestMethod(signingReferenceConfig.getDigestMethod().getAlgorithm());
                    SignatureGenerator.addTransforms(reference, document, (Element)object9, signingReferenceConfig.getTransforms(), string3, string, signatureGeneratorConfig.addInclusiveNamespaces());
                    element2.appendChild(reference.getReferenceElement());
                    arrayList.add(object9);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added the element[" + DOMUtil.getDisplayName((Node)object9) + "].");
                }
            }
        }
        if (wSSGeneratorConfig.doIndentation()) {
            DOMUtil.indent(node, 6, 2);
            element.insertBefore(document.createTextNode("\n      "), node);
        }
        WSSSignatureContext wSSSignatureContext = new WSSSignatureContext();
        if (tc.isDebugEnabled()) {
            wSSSignatureContext.setResourceShower(ShowerImpl.getInstance());
        }
        wSSSignatureContext.setIDResolver(this._idResolver);
        wSSSignatureContext.setAlgorithmFactory((AlgorithmFactory)object13);
        wSSSignatureContext.setDocument(document);
        if (signatureGeneratorConfig.getKeyInfoSignature() != null) {
            wSSSignatureContext.setKeyInfoSignature(signatureGeneratorConfig.getKeyInfoSignature().getAlgorithm());
        } else {
            wSSSignatureContext.setKeyInfoSignature(null);
        }
        HashSet<KeyInfoGeneratorConfig> hashSet3 = new HashSet<KeyInfoGeneratorConfig>();
        object9 = new HashSet();
        object7 = wSSGeneratorConfig.getOperationGenerators().iterator();
        while (object7.hasNext()) {
            object14 = object7.next();
            if (object14 instanceof SignatureGeneratorConfig) {
                hashSet3.add(((SignatureGeneratorConfig)object14).getSigningKeyInfo());
                continue;
            }
            if (!(object14 instanceof EncryptionGeneratorConfig)) continue;
            object9.add(((EncryptionGeneratorConfig)object14).getEncryptionKeyInfo());
        }
        STRDTKeyInfoResolver sTRDTKeyInfoResolver = new STRDTKeyInfoResolver();
        sTRDTKeyInfoResolver.setContext(map);
        sTRDTKeyInfoResolver.setSelectors(this._selectors);
        sTRDTKeyInfoResolver.setDsigKeyInfoSet(hashSet3);
        sTRDTKeyInfoResolver.setEncKeyInfoSet((Set)object9);
        sTRDTKeyInfoResolver.setGeneration(true);
        sTRDTKeyInfoResolver.setIdResolver(this._idResolver);
        wSSSignatureContext.setSTRDTKeyInfoResolver(sTRDTKeyInfoResolver);
        String string8 = null;
        object6 = signatureGeneratorConfig.getSignatureMethod();
        if (object6 != null) {
            string8 = object6.getAlgorithm();
        }
        wSSSignatureContext.setSigAlgorithm(string8);
        object5 = signatureGeneratorConfig.getProperties();
        object4 = wSSGeneratorConfig.getProperties();
        object3 = null;
        object3 = (String)object4.get("HWCONFIG");
        wSSSignatureContext.setHWConfigName((String)object3);
        wSSSignatureContext.setOffload(Boolean.TRUE);
        if (wSSSignatureContext.shouldChangeProvider()) {
            object2 = HWKeyCache.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Acceleration enabled, Key Store Name is: ", wSSSignatureContext.getHWConfigName());
            }
            if ((object = ConfigUtil.getHWCryptoProviderInstance(wSSSignatureContext.getHWConfigName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                wSSSignatureContext.setHWAccelerationProvider((Provider)object);
                serializable = (Integer)object4.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                ((HWKeyCache)object2).setProvider((Provider)object, (Integer)serializable);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for HW Acceleration" + ((Provider)object).getName());
                }
            }
            try {
                key = ((HWKeyCache)object2).translate(key);
            }
            catch (Exception exception) {
                throw new SoapSecurityException(exception);
            }
        }
        object2 = null;
        object2 = (String)object5.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "hwKsRef = " + (String)object2);
        }
        wSSSignatureContext.setHWKeyStoreName((String)object2);
        if (wSSSignatureContext.useHWKeyStore()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Key Store Name is: ", wSSSignatureContext.getHWKeyStoreName());
            }
            if ((object = ConfigUtil.getHWCryptoProviderInstance(wSSSignatureContext.getHWKeyStoreName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                wSSSignatureContext.setHWKeyStoreProvider((Provider)object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + ((Provider)object).getName());
                }
            }
        }
        object = null;
        if (!(!(key instanceof PKCS11Key) || object3 != null && ((String)object3).length() != 0 || object2 != null && ((String)object2).length() != 0)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PKCS11 Key is in use, but did not find hardware keystore/acceleration in the config");
            }
            if ((object = (String)object4.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore")) != null) {
                wSSSignatureContext.setHWKeyStoreName((String)object);
                if (wSSSignatureContext.useHWKeyStore()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "HARDWARE Key Store Name is: ", wSSSignatureContext.getHWKeyStoreName());
                    }
                    if ((serializable = ConfigUtil.getHWCryptoProviderInstance(wSSSignatureContext.getHWKeyStoreName())) == null) {
                        Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                    } else {
                        wSSSignatureContext.setHWKeyStoreProvider((Provider)serializable);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + ((Provider)serializable).getName());
                        }
                    }
                } else {
                    Tr.error(tc, "Missing Hardware KeyStore Configuration, cannot use the PKCS11 type for sign/verify");
                    throw SoapSecurityException.format("Missing Hardware KeyStore Configuration");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing started.");
        }
        try {
            wSSSignatureContext.sign((Element)node, key);
        }
        catch (XSignatureException xSignatureException) {
            Exception exception = xSignatureException.getException();
            Tr.processException(exception, clsName + ".invoke", "711");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s12", exception);
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s12", exception);
        }
        finally {
            if (wSSSignatureContext.isHWAccelerationProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance(wSSSignatureContext.getHWConfigName(), wSSSignatureContext.getHWAccelerationProvider());
            }
            if (wSSSignatureContext.useHWKeyStore()) {
                ConfigUtil.returnHWCryptoProviderInstance(wSSSignatureContext.getHWKeyStoreName(), wSSSignatureContext.getHWKeyStoreProvider());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing done.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc,Element parent,Map context)");
        }
    }

    public static NodeList getMessagePart(Document document, String string, String string2, String string3, Map map, Class clazz, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessagePart(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "String dialect[" + string + "]," + "String keyword[" + string2 + "]," + "String type[" + string3 + "]," + "Map selectors," + "Class dialectSelector[" + clazz + "]," + "Map selectorMap)");
        }
        map2.put("com.ibm.ws.webservices.wssecurity.util.selector.dialect", string);
        map2.put("com.ibm.ws.webservices.wssecurity.util.selector.keyword", string2);
        map2.put("com.ibm.ws.webservices.wssecurity.util.selector.operation", string3);
        ElementSelector elementSelector = null;
        if (Constants.DIALECT_WAS.equals(string)) {
            elementSelector = (ElementSelector)map.get(clazz);
        } else if (Constants.DIALECT_FUNCTION.equals(string)) {
            elementSelector = (ElementSelector)map.get(WSPFunctionElementSelector.class);
        } else if (Constants.DIALECT_XPATH.equals(string)) {
            elementSelector = (ElementSelector)map.get(XPathElementSelector.class);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", string);
        }
        NodeList nodeList = elementSelector.getElements(document, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessagePart(Document doc,String dialect,String keyword,String type,Map selectors,Class dialectSelector,Map selectorMap,Map context) returns NodeList[" + nodeList + "]");
        }
        return nodeList;
    }

    private static NodeList getSpecialPart(Document document, ReferencePartConfig.PartConfig partConfig, String string, Map map, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSpecialPart(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "PartConfig pconfig[" + partConfig + "]," + "String type[" + string + "]," + "Map selectors," + "Map selectorMap)");
        }
        String string2 = partConfig.getDialect();
        String string3 = partConfig.getKeyword();
        map2.put("com.ibm.ws.webservices.wssecurity.util.selector.dialect", string2);
        map2.put("com.ibm.ws.webservices.wssecurity.util.selector.keyword", string3);
        map2.put("com.ibm.ws.webservices.wssecurity.util.selector.operation", string);
        ElementSelector elementSelector = (ElementSelector)map.get(IntegralDialectElementSelector.class);
        NodeList nodeList = elementSelector.getElements(document, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSpecialPart(Document doc,PartConfig pconfig,String type,Map selectors,Map selectorMap) returns NodeList[" + nodeList + "]");
        }
        return nodeList;
    }

    public static NodeList getNoncePart(Document document, Object[] objectArray, ReferencePartConfig.PartConfig partConfig, String string, Map map, Class clazz, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNoncePart(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Object[] parents[" + objectArray + "]," + "PartConfig pconfig[" + partConfig + "]," + "String type[" + string + "]," + "Map selectors," + "Class dialectSelector[" + clazz + "]," + "Map selectorMap)");
        }
        String string2 = partConfig.getDialect();
        String string3 = partConfig.getKeyword();
        map2.put("com.ibm.ws.webservices.wssecurity.util.selector.dialect", string2);
        map2.put("com.ibm.ws.webservices.wssecurity.util.selector.keyword", string3);
        map2.put("com.ibm.ws.webservices.wssecurity.util.selector.operation", string);
        if (objectArray != null) {
            map2.put("com.ibm.ws.webservices.wssecurity.util.selector.element", objectArray);
        }
        map2.remove("security.wssecurity.integraldialectelementselector.duration");
        if (partConfig.isTimestamp()) {
            map2.put("com.ibm.ws.webservices.wssecurity.util.selector.processType", "timestamp");
            Duration duration = partConfig.getDuration();
            if (duration != null) {
                map2.put("security.wssecurity.integraldialectelementselector.duration", duration);
            }
        } else if (partConfig.isNonce()) {
            map2.put("com.ibm.ws.webservices.wssecurity.util.selector.processType", "nonce");
        }
        NodeList nodeList = null;
        ElementSelector elementSelector = null;
        if (Constants.DIALECT_WAS.equals(string2)) {
            elementSelector = (ElementSelector)map.get(clazz);
        } else if (Constants.DIALECT_FUNCTION.equals(string2)) {
            elementSelector = (ElementSelector)map.get(WSPFunctionElementSelector.class);
        } else if (Constants.DIALECT_XPATH.equals(string2)) {
            elementSelector = (ElementSelector)map.get(XPathElementSelector.class);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", string2);
        }
        nodeList = elementSelector.getElements(document, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNoncePart(Document doc,Object[] parents,PartConfig pconfig,String typeMap selectors,Class dialectSelector,Map selectorMap) returns NodeList[" + nodeList + "]");
        }
        return nodeList;
    }

    private static String addWsuId(Document document, Element element, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWsuId(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element part[" + DOMUtil.getDisplayName(element) + "]," + "String nsWsu[" + string + "])");
        }
        String string2 = null;
        String string3 = IdUtil.getInstance().getIdAttributeName(element);
        if (string3 != null) {
            string2 = element.getAttribute(string3);
        }
        if (string2 == null || string2.length() == 0) {
            String string4 = element.getNamespaceURI();
            String string5 = element.getLocalName();
            int n = string4 == null ? 0 : string4.hashCode();
            int n2 = n * 31;
            n2 += string5 == null ? 0 : string5.hashCode();
            if (n == Constants.HASH_DS) {
                if (n2 == Constants.HASH_DS_SIGNATURE || n2 == Constants.HASH_DS_SIGNATUREVALUE || n2 == Constants.HASH_DS_SIGNEDINFO || n2 == Constants.HASH_DS_REFERENCE || n2 == Constants.HASH_DS_KEYINFO || n2 == Constants.HASH_DS_OBJECT || n2 == Constants.HASH_DS_MANIFEST || n2 == Constants.HASH_DS_SIGNATUREPROPS || n2 == Constants.HASH_DS_SIGNATUREPROP) {
                    string2 = IdUtil.getInstance().makeUniqueId(document, "wssecurity_signature_id_");
                    element.setAttribute("Id", string2);
                }
            } else if (n == Constants.HASH_ENC && (n2 == Constants.HASH_ENC_ENCRYPTEDKEY || n2 == Constants.HASH_ENC_ENCRYPTEDDATA || n2 == Constants.HASH_ENC_ENCRYPTIONPROPS || n2 == Constants.HASH_ENC_ENCRYPTIONPROP)) {
                string2 = IdUtil.getInstance().makeUniqueId(document, "wssecurity_signature_id_");
                element.setAttribute("Id", string2);
            }
            if (string2 == null) {
                string2 = IdUtil.getInstance().makeUniqueId(document, "wssecurity_signature_id_");
                String string6 = DOMUtil.getNamespacePrefix(element, string);
                if (string6 == null) {
                    string6 = "wsu";
                }
                element.setAttributeNS(string, string6 + ":Id", string2);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string6, string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWsuId(Document doc,Element part,String nsWsu) returns String[" + string2 + "]");
        }
        return string2;
    }

    private static void addTransforms(Reference reference, Document document, Element element, List list, String string, String string2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTransforms(Reference gen[" + reference + "]," + "Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element part[" + DOMUtil.getDisplayName(element) + "]," + "List config[" + list + "]," + "String pWsse[" + string + "]," + "String nsWsse[" + string2 + "]," + "boolean addIncNS[" + bl + "])");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AlgorithmConfig algorithmConfig = (AlgorithmConfig)iterator.next();
            String string3 = algorithmConfig.getAlgorithm();
            Map map = algorithmConfig.getProperties();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding the transform [" + string3 + "]...");
            }
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(string3) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(string3)) {
                reference.addTransform(SignatureGenerator.createInclusiveTransform(document, element, string3, bl));
                continue;
            }
            if ("http://www.w3.org/2002/07/decrypt#XML".equals(string3)) {
                Set set = SignatureGenerator.collectIdsOfEncryptedData(element, document);
                reference.addTransform(SignatureGenerator.createDecryptionTransform(document, set, string3));
                continue;
            }
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(string3)) {
                reference.addTransform(SignatureGenerator.createSTRTransform(document, element, string3, string, string2));
                continue;
            }
            if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(string3)) {
                reference.addTransform(SignatureGenerator.createXPathTransform(document, string3, map));
                continue;
            }
            if ("http://www.w3.org/2002/06/xmldsig-filter2".equals(string3)) {
                reference.addTransform(SignatureGenerator.createXPath2Transform(document, string3, map));
                continue;
            }
            reference.addTransform(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTransforms(Reference gen,Document doc,Element part,List config,String pWsse,String nsWsse,boolean addIncNS)");
        }
    }

    private static Element createInclusiveTransform(Document document, Element element, String string, boolean bl) {
        Element element2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createInclusiveTransform(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element part[" + DOMUtil.getDisplayName(element) + "]," + "String transform[" + string + "]," + "boolean addIncNS[" + bl + "])");
        }
        Element element3 = document.createElementNS(Constants.NS_DSIG, "ds:Transform");
        element3.setAttributeNS(null, "Algorithm", string);
        if (bl && (element2 = SignatureGenerator.createInclusiveNamespaces(document, element)) != null) {
            element3.appendChild(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createInclusiveTransform(Document doc,Element part,String transform,boolean addIncNS) returns Element[" + DOMUtil.getDisplayName(element3) + "]");
        }
        return element3;
    }

    private static Element createInclusiveNamespaces(Document document, Element element) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createInclusiveNamespaces(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element part[" + DOMUtil.getDisplayName(element) + "])");
        }
        StringBuffer stringBuffer = null;
        if (element != null && element instanceof IBMSOAPElement) {
            object = ((IBMSOAPElement)((Object)element)).getNamespaceDeclarations(true, true, true);
            if (object != null) {
                stringBuffer = new StringBuffer();
                ListIterator listIterator = object.listIterator();
                String string = null;
                IBMAttr iBMAttr = null;
                while (listIterator.hasNext()) {
                    iBMAttr = (IBMAttr)listIterator.next();
                    if (iBMAttr.getNodeName().equals("xmlns")) {
                        stringBuffer.append("#default ");
                        continue;
                    }
                    string = iBMAttr.getLocalName();
                    if (string == null) continue;
                    stringBuffer.append(string);
                    stringBuffer.append(" ");
                }
            }
        } else {
            Object object2;
            HashSet<String> hashSet = new HashSet<String>();
            for (object = element; object != null && object.getNodeType() == 1; object = object.getParentNode()) {
                if (!object.hasAttributes()) continue;
                object2 = object.getAttributes();
                int n = object2.getLength();
                for (int i = 0; i < n; ++i) {
                    String string = object2.item(i).getNodeName();
                    if (string.equals("xmlns")) {
                        hashSet.add("#default");
                        continue;
                    }
                    if (!string.startsWith("xmlns:")) continue;
                    hashSet.add(string.substring(6));
                }
            }
            SignatureGenerator.scanNamespaceDecls(element, hashSet);
            if (hashSet.size() > 0) {
                stringBuffer = new StringBuffer();
                object2 = hashSet.iterator();
                while (object2.hasNext()) {
                    stringBuffer.append(object2.next());
                    stringBuffer.append(" ");
                }
            }
        }
        object = null;
        if (stringBuffer != null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "node search generated PrefixList: " + stringBuffer);
            }
            object = document.createElementNS("http://www.w3.org/2001/10/xml-exc-c14n#", "ec:InclusiveNamespaces");
            object.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ec", "http://www.w3.org/2001/10/xml-exc-c14n#");
            object.setAttributeNS(null, "PrefixList", new String(stringBuffer));
        } else if (tc.isEntryEnabled()) {
            Tr.debug(tc, "node search generated an empty list");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createInclusiveNamespaces(Document doc,Element part) returns Element[" + DOMUtil.getDisplayName((Node)object) + "]");
        }
        return object;
    }

    private static void scanNamespaceDecls(Node node, Set set) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scanNamespaceDecls(Node node[" + DOMUtil.getDisplayName(node) + "]," + "Set prefixes[" + set + "])");
        }
        if (node.hasAttributes()) {
            object = node.getAttributes();
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                String string = object.item(i).getNodeName();
                if (string.equals("xmlns")) {
                    set.add("#default");
                    continue;
                }
                if (!string.startsWith("xmlns:")) continue;
                set.add(string.substring(6));
            }
        }
        if (node.hasChildNodes()) {
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (object.getNodeType() != 1) continue;
                SignatureGenerator.scanNamespaceDecls((Node)object, set);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scanNamespaceDecls(Node node,Set prefixes)");
        }
    }

    private static Set collectIdsOfEncryptedData(Node node, Document document) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectIdsOfEncryptedData(Node node[" + DOMUtil.getDisplayName(node) + "]," + "Document doc[" + DOMUtil.getDisplayName(document) + "])");
        }
        HashSet hashSet = new HashSet();
        if (node != null) {
            Document document2 = document;
            if (document2 == null) {
                document2 = node.getOwnerDocument();
            }
            SignatureGenerator.collectIdsOfEncryptedData(node, document2, hashSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectIdsOfEncryptedData(Node node,Document doc) returns Set[" + hashSet + "]");
        }
        return hashSet;
    }

    private static void collectIdsOfEncryptedData(Node node, Document document, Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectIdsOfEncryptedData(Node node[" + DOMUtil.getDisplayName(node) + "]," + "Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Set ids[" + set + "])");
        }
        if (node.getNodeType() == 1 && EncryptedData.isOfType((Element)node)) {
            String string;
            Element element = (Element)node;
            if (element.hasAttribute("Id")) {
                string = element.getAttribute("Id");
            } else {
                string = IdUtil.getInstance().makeUniqueId(document, "wssecurity_encryption_id_");
                element.setAttribute("Id", string);
            }
            set.add(string);
        } else {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 1 && node2.getNodeType() != 5) continue;
                SignatureGenerator.collectIdsOfEncryptedData(node2, document, set);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectIdsOfEncryptedData(Node node,Document doc,Set ids)");
        }
    }

    private static Element createDecryptionTransform(Document document, Set set, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDecryptionTransform(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Set ids[" + set + "]," + "String transform[" + string + "])");
        }
        Element element = document.createElementNS(Constants.NS_DSIG, "ds:Transform");
        element.setAttribute("Algorithm", string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Element element2 = document.createElementNS("http://www.w3.org/2002/07/decrypt#", "Except");
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2002/07/decrypt#");
            element2.setAttribute("URI", "#" + string2);
            element.appendChild(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDecryptionTransform(Document doc,Set ids) returns Element[" + DOMUtil.getDisplayName(element) + "]");
        }
        return element;
    }

    private static Element createSTRTransform(Document document, Element element, String string, String string2, String string3) {
        Object object;
        int n;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSTRTransform(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element part[" + DOMUtil.getDisplayName(element) + "]," + "String transform[" + string + "]," + "String pWsse[" + string2 + "]," + "String nsWsse[" + string3 + "])");
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Node node = element; node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            object2 = node.getAttributes();
            n = object2 == null ? 0 : object2.getLength();
            for (int i = 0; i < n; ++i) {
                object = object2.item(i).getNodeName();
                if (((String)object).equals("xmlns")) {
                    hashSet.add("#default");
                    continue;
                }
                if (!((String)object).startsWith("xmlns:")) continue;
                hashSet.add(((String)object).substring(6));
            }
        }
        SignatureGenerator.scanNamespaceDecls(element, hashSet);
        object2 = document.createElementNS(Constants.NS_DSIG, "ds:Transform");
        object2.setAttributeNS(null, "Algorithm", string);
        n = 0;
        String string4 = string2;
        if (string4 == null) {
            string4 = "wsse:";
            n = 1;
        } else if (!"".equals(string4)) {
            string4 = string4 + ":";
        }
        object = document.createElementNS(string3, string4 + "TransformationParameters");
        if (n != 0) {
            object.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", string3);
        }
        object = (Element)object2.appendChild((Node)object);
        Element element2 = document.createElementNS(Constants.NS_DSIG, "ds:CanonicalizationMethod");
        element2.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        element2 = (Element)object.appendChild(element2);
        if (hashSet.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                stringBuffer.append(" ");
            }
            Element element3 = document.createElementNS("http://www.w3.org/2001/10/xml-exc-c14n#", "ec:InclusiveNamespaces");
            element3.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ec", "http://www.w3.org/2001/10/xml-exc-c14n#");
            element3.setAttributeNS(null, "PrefixList", new String(stringBuffer));
            element2.appendChild(element3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSTRTransform(Document doc,Element part,String transform,String pWsse,String nsWsse) returns Element[" + DOMUtil.getDisplayName((Node)object2) + "]");
        }
        return object2;
    }

    private static Element createXPathTransform(Document document, String string, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createXPathTransform(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "String transform[" + string + "]," + "Map properties)");
        }
        String string2 = (String)map.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_XPATH_EXPRESSION);
        Element element = document.createElementNS(Constants.NS_DSIG, "ds:Transform");
        element.setAttributeNS(null, "Algorithm", string);
        Element element2 = document.createElementNS(Constants.NS_DSIG, "ds:XPath");
        element2 = (Element)element.appendChild(element2);
        Text text = document.createTextNode(string2);
        element2.appendChild(text);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createXPathTransform(Document doc,String transform,Map properties) returns Element[" + DOMUtil.getDisplayName(element) + "]");
        }
        return element;
    }

    private static Element createXPath2Transform(Document document, String string, Map map) {
        Object object;
        String[] stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createXPath2Transform(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "String transform[" + string + "]," + "Map properties)");
        }
        Element element = document.createElementNS(Constants.NS_DSIG, "ds:Transform");
        element.setAttributeNS(null, "Algorithm", string);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
        String string2 = com.ibm.wsspi.wssecurity.Constants.WSSECURITY_XPATH2_ORDER + "_";
        String string3 = com.ibm.wsspi.wssecurity.Constants.WSSECURITY_XPATH2_FILTER + "_";
        String string4 = com.ibm.wsspi.wssecurity.Constants.WSSECURITY_XPATH2_EXPRESSION + "_";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            object = (String)map.get(stringArray);
            if (stringArray.startsWith(string4)) {
                hashMap3.put(stringArray.substring(string4.length()), object);
                continue;
            }
            if (stringArray.startsWith(string3)) {
                hashMap2.put(stringArray.substring(string3.length()), object);
                continue;
            }
            if (!stringArray.startsWith(string2)) continue;
            hashMap.put(stringArray.substring(string2.length()), new Integer((String)object));
        }
        int n = hashMap.keySet().size();
        if (n > 0) {
            String string5;
            stringArray = new String[n];
            object = new int[n];
            int n2 = -1;
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                ++n2;
                string5 = (String)iterator2.next();
                int n3 = (Integer)hashMap.get(string5);
                boolean bl = false;
                for (int i = 0; i < n2; ++i) {
                    if (n3 >= object[i]) continue;
                    for (int j = n2 - 1; j >= i; --j) {
                        stringArray[j + 1] = stringArray[j];
                        object[j + 1] = object[j];
                    }
                    stringArray[i] = string5;
                    object[i] = n3;
                    bl = true;
                    break;
                }
                if (bl) continue;
                stringArray[n2] = string5;
                object[n2] = n3;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                string5 = (String)hashMap2.get(stringArray[i]);
                String string6 = (String)hashMap3.get(stringArray[i]);
                Element element2 = document.createElementNS("http://www.w3.org/2002/06/xmldsig-filter2", "dsf2:XPath");
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dsf2", "http://www.w3.org/2002/06/xmldsig-filter2");
                element2.setAttribute("Filter", string5);
                element2 = (Element)element.appendChild(element2);
                Text text = document.createTextNode(string6);
                element2.appendChild(text);
                element.appendChild(element2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createXPathTransform(Document doc,String transform,Map properties) returns Element[" + DOMUtil.getDisplayName(element) + "]");
        }
        return element;
    }

    protected static void prepareTransform(SigningReferenceConfig signingReferenceConfig, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTransform(SigningReferenceConfig srconfig],Map selectorMap)");
        }
        boolean bl = false;
        Iterator iterator = signingReferenceConfig.getTransforms().iterator();
        while (iterator.hasNext()) {
            AlgorithmConfig algorithmConfig = (AlgorithmConfig)iterator.next();
            String string = algorithmConfig.getAlgorithm();
            if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(string)) continue;
            bl = true;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "STR-Transform transform found.");
        }
        if (bl) {
            map.put("security.wssecurity.integraldialectelementselector.existstrtransform", Boolean.toString(bl));
        } else {
            map.remove("security.wssecurity.integraldialectelementselector.existstrtransform");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTransform(SigningReferenceConfig srconfig,Map selectorMap)");
        }
    }

    public static Key callKeyInfoGenerator(KeyInfoGeneratorConfig keyInfoGeneratorConfig, String string, Map map, Map map2, Document document, Element element, Map map3) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callKeyInfoGenerator(KeyInfoGeneratorConfig config,String keytype[" + string + "]," + "Map type," + "Map properties," + "Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element parent[" + DOMUtil.getDisplayName(element) + "]," + "Map context)");
        }
        KeyInfoGenerator keyInfoGenerator = (KeyInfoGenerator)map2.get(KeyInfoGenerator.class);
        map.clear();
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE, string);
        map3.put("com.ibm.wsspi.wssecurity.config.keyinfoGenerator.configKey", keyInfoGeneratorConfig);
        Key key = keyInfoGenerator.getKey(document, element, map, map3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callKeyInfoGenerator(KeyInfoGeneratorConfig config,String keytype,Map type,Map properties,Document doc,Element parent,Map context) returns Key[" + key + "]");
        }
        return key;
    }

    public static Element insertElement(Element element, Element element2, String string, Map map) {
        String string2;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertElement(Element parent[" + DOMUtil.getDisplayName(element) + "]," + "Element elem[" + DOMUtil.getDisplayName(element2) + "]," + "String nsWsu[" + string + "]," + "Map context)");
        }
        Set set = (Set)map.get("com.ibm.ws.webservices.wssecurity.constants.standAloneElements");
        String string3 = "Signature";
        String string4 = "EncryptedKey";
        String string5 = "ReferenceList";
        Object object2 = null;
        Node node = null;
        if (element != null) {
            object = DOMUtil.getFirstElement(element);
            while (object != null) {
                node = object;
                if (set != null && set.contains(object)) {
                    object2 = object;
                    break;
                }
                string2 = object.getNamespaceURI();
                String string6 = object.getLocalName();
                if (Constants.NS_ENC.equals(string2) && (string4.equals(string6) || string5.equals(string6)) || Constants.NS_DSIG.equals(string2) && string3.equals(string6)) {
                    object2 = object;
                    break;
                }
                object = DOMUtil.getNextElement((Node)object);
            }
        }
        if (object2 == null && node != null) {
            object = node.getNamespaceURI();
            string2 = node.getLocalName();
            if (string.equals(object) && string2.equals("Timestamp")) {
                object2 = node;
            }
        }
        element2 = node == null ? (Element)element.appendChild(element2) : (Element)element.insertBefore(element2, (Node)object2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertElement(Element parent,Element elem,String nsWsu,Map context) returns Element[" + DOMUtil.getDisplayName(element2) + "]");
        }
        return element2;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showSignedResource(Element element, int n, String string, String string2, byte[] byArray, String string3) {
            String string4 = null;
            try {
                string4 = string3 == null ? new String(byArray, "UTF-8") : new String(byArray, string3);
            }
            catch (Exception exception) {
                Tr.debug(tc, "WARNING: An exception occured while the content is encoded with [" + string3 + "].");
            }
            if (n < 0) {
                Tr.debug(tc, "ResourceShower logs sign-SignedInfo: " + string4);
            } else if (string == null || string.length() == 0) {
                Tr.debug(tc, "ResourceShower logs sign-resource_" + n + ": " + string4);
            } else {
                Tr.debug(tc, "ResourceShower logs sign-" + string + ": " + string4);
            }
        }
    }
}

