/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.ResultMessagePool;
import com.ibm.ws.webservices.wssecurity.dsig.PartList;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.webservices.wssecurity.dsig.VerificationResult;
import com.ibm.ws.webservices.wssecurity.dsig.VerifiedConfig;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.token.AuthResult;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifiedPartChecker
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(VerifiedPartChecker.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = VerifiedPartChecker.class.getName();
    private Map _selectors = null;
    private IDResolver _idResolver = null;
    private boolean _initialized = false;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$util$IntegralDialectElementSelector;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtil)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Node target[" + DOMUtil.getDisplayName(node) + "]," + "Map context)");
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.VerifiedPartChecker.s05");
        }
        Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int n = 0;
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string = Constants.NAMESPACES[0][n];
        String string2 = Constants.NAMESPACES[1][n];
        Document document = null;
        document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        HashMap<SignatureConsumerConfig, Document> hashMap = new HashMap<SignatureConsumerConfig, Document>();
        Result[] resultArray = ResultPool.get(map, VerificationResult.class);
        if (resultArray != null && resultArray.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, resultArray.length + " verified results found.");
            }
            for (int i = 0; i < resultArray.length; ++i) {
                object4 = (VerificationResult)resultArray[i];
                hashMap.put(((VerificationResult)object4)._sconfig, ((VerificationResult)object4)._copiedDOM);
            }
        }
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        object4 = wSSConsumerConfig.getNonceManager();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>(map);
        hashMap2.put(NonceManager.class, object4);
        hashMap2.put("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver", this._idResolver);
        hashMap2.put("com.ibm.ws.webservices.wssecurity.util.selector.config", wSSConsumerConfig.getTokenConsumers());
        Set set = VerifiedPartChecker.preprocess(document, hashMap, wSSConsumerConfig.getRequiredIntegralParts(), wSSConsumerConfig.getSignatureConsumers(), this._selectors, hashMap2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing the verified results...");
        }
        HashSet<ReferencePartConfig> hashSet = new HashSet<ReferencePartConfig>();
        if (resultArray != null && resultArray.length > 0) {
            for (int i = 0; i < resultArray.length; ++i) {
                object3 = (VerificationResult)resultArray[i];
                hashSet.clear();
                object2 = ((VerificationResult)object3)._verifiedParts.iterator();
                while (object2.hasNext()) {
                    VerificationResult.VerifiedPart verifiedPart = (VerificationResult.VerifiedPart)object2.next();
                    object = VerifiedPartChecker.getRelatedPart((VerificationResult)object3, verifiedPart, set, map);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "VerifiedPart [" + verifiedPart + "], RequiredPart [" + object + "]");
                    }
                    if (object == null) continue;
                    if (((RequiredPart)object)._requiredNonce) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking required nonce...");
                        }
                        if (verifiedPart._nonce == null) {
                            String string3 = ((RequiredPart)object)._pconfig.getKeyword();
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s02", string3);
                        }
                        NonceUtil.checkNonce(verifiedPart._nonce, string, (NonceManager)object4);
                    }
                    if (((RequiredPart)object)._requiredTimestamp) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking required timestamp...");
                        }
                        if (verifiedPart._timestamp == null) {
                            String string4 = ((RequiredPart)object)._pconfig.getKeyword();
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s03", string4);
                        }
                        NonceUtil.checkTimestamp(verifiedPart._timestamp, string2, wSSConsumerConfig.getTimestampMaxAge(), wSSConsumerConfig.getTimestampClockSkew(), false);
                    }
                    ((RequiredPart)object)._processed = true;
                    ((RequiredPart)object)._tokens.add(((VerificationResult)object3)._token);
                    hashSet.add(((RequiredPart)object)._rconfig);
                }
                VerifiedPartChecker.checkCaller((VerificationResult)object3, hashSet, wSSConsumerConfig, map);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking whether all required integrity is processed...");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object3 = (RequiredParts)iterator.next();
            object2 = ((RequiredParts)object3)._parts;
            for (int i = 0; i < ((RequiredPart[])object2).length; ++i) {
                object = ((RequiredPart)object2[i])._pconfig.getUsage();
                String string5 = ((RequiredPart)object2[i])._pconfig.getKeyword();
                if (!((RequiredPart)object2[i])._processed) {
                    if (ConfigUtil.isUsageRequired((String)object)) {
                        throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s01", string5);
                    }
                    if (!ConfigUtil.isUsageOptional((String)object) && !ConfigUtil.isUsageObserved((String)object)) continue;
                    Tr.warning(tc, "security.wssecurity.VerifiedPartChecker.s01", string5);
                    continue;
                }
                if (!ConfigUtil.isUsageRejected((String)object)) continue;
                throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s04", string5);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Node target,Map context)");
        }
    }

    private static Set preprocess(Document document, Map map, Set set, Set set2, Map map2, Map map3) throws SoapSecurityException {
        RequiredParts requiredParts;
        int n;
        RequiredPart[] requiredPartArray;
        String string;
        String string2;
        NodeList nodeList;
        ReferencePartConfig.PartConfig partConfig;
        Iterator iterator;
        Document document2;
        Map map4;
        ReferencePartConfig referencePartConfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preprocess(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Map docMap[" + map + "]," + "Set requiredIntegrity[" + set + "]," + "Set sconsumers," + "Map selectors," + "Map selectorMap)");
        }
        HashSet<RequiredParts> hashSet = new HashSet<RequiredParts>();
        HashSet<ReferencePartConfig.PartConfig> hashSet2 = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap hashMap = new HashMap();
        HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig> hashMap2 = new HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig>();
        HashMap<ReferencePartConfig.PartConfig, Document> hashMap3 = new HashMap<ReferencePartConfig.PartConfig, Document>();
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            referencePartConfig = (ReferencePartConfig)iterator2.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing ReferencePartConfig [" + referencePartConfig + "]...");
            }
            map4 = new HashMap(map3);
            document2 = VerifiedPartChecker.setNecessaryInfo(map4, set2, referencePartConfig, document, map);
            iterator = referencePartConfig.getParts().iterator();
            while (iterator.hasNext()) {
                partConfig = (ReferencePartConfig.PartConfig)iterator.next();
                if (partConfig.isTimestamp() || partConfig.isNonce()) {
                    hashSet2.add(partConfig);
                    hashMap.put(partConfig, map4);
                    hashMap2.put(partConfig, referencePartConfig);
                    hashMap3.put(partConfig, document2);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing PartConfig [" + partConfig + "]...");
                }
                if ((nodeList = SignatureGenerator.getMessagePart(document2, string2 = partConfig.getDialect(), string = partConfig.getKeyword(), "verification_mode", map2, class$com$ibm$ws$webservices$wssecurity$util$IntegralDialectElementSelector == null ? VerifiedPartChecker.class$("com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector") : class$com$ibm$ws$webservices$wssecurity$util$IntegralDialectElementSelector, map4)) != null && nodeList.getLength() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, nodeList.getLength() + " parts found.");
                    }
                    if (nodeList instanceof PartList) {
                        requiredPartArray = new RequiredPart[]{new RequiredPart(referencePartConfig, partConfig, nodeList)};
                    } else {
                        requiredPartArray = new RequiredPart[nodeList.getLength()];
                        for (n = 0; n < requiredPartArray.length; ++n) {
                            requiredPartArray[n] = new RequiredPart(referencePartConfig, partConfig, (Element)nodeList.item(n));
                        }
                    }
                    requiredParts = new RequiredParts(requiredPartArray);
                    hashSet.add(requiredParts);
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", string2, string);
            }
        }
        iterator2 = hashSet2.iterator();
        while (iterator2.hasNext()) {
            partConfig = (ReferencePartConfig.PartConfig)iterator2.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing PartConfig [" + partConfig + "]...");
            }
            map4 = (Map)hashMap.get(partConfig);
            referencePartConfig = (ReferencePartConfig)hashMap2.get(partConfig);
            document2 = (Document)hashMap3.get(partConfig);
            if (!partConfig.isTimestamp() && !partConfig.isNonce()) continue;
            nodeList = SignatureGenerator.getNoncePart(document2, null, partConfig, "verification_mode", map2, class$com$ibm$ws$webservices$wssecurity$util$IntegralDialectElementSelector == null ? VerifiedPartChecker.class$("com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector") : class$com$ibm$ws$webservices$wssecurity$util$IntegralDialectElementSelector, map4);
            if (nodeList != null && nodeList.getLength() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, nodeList.getLength() + " parts found.");
                }
                boolean bl = false;
                for (n = 0; n < nodeList.getLength(); ++n) {
                    Node node = nodeList.item(n);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    iterator = hashSet.iterator();
                    block5: while (iterator.hasNext()) {
                        requiredParts = (RequiredParts)iterator.next();
                        for (int i = 0; i < requiredParts._parts.length; ++i) {
                            RequiredPart requiredPart = requiredParts._parts[i];
                            if (!DOMUtil.equals(element, requiredPart._element)) continue;
                            if (partConfig.isTimestamp()) {
                                requiredPart._requiredTimestamp = partConfig.isTimestamp();
                            }
                            if (partConfig.isNonce()) {
                                requiredPart._requiredNonce = partConfig.isNonce();
                            }
                            bl = true;
                            continue block5;
                        }
                    }
                    if (bl) continue;
                    requiredPartArray = new RequiredPart[]{new RequiredPart(referencePartConfig, partConfig, element)};
                    requiredPartArray[0]._requiredTimestamp = partConfig.isTimestamp();
                    requiredPartArray[0]._requiredNonce = partConfig.isNonce();
                    requiredParts = new RequiredParts(requiredPartArray);
                    hashSet.add(requiredParts);
                }
                continue;
            }
            string2 = partConfig.getDialect();
            string = partConfig.getKeyword();
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", string2, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preprocess(Document doc,Map docMap,Set requiredIntegrity,Set sconsumers,Map selectors,Map selectorMap) returns Set[" + hashSet + "]");
        }
        return hashSet;
    }

    private static Document setNecessaryInfo(Map map, Set set, ReferencePartConfig referencePartConfig, Document document, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNecessaryInfo(Map selectorMap,Set sconsumers,ReferencePartConfig rconfig[" + referencePartConfig + "]," + "Document doc[" + document + "]," + "Map docMap)");
        }
        boolean bl = false;
        String string = null;
        Document document2 = document;
        SigningReferenceConfig signingReferenceConfig = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Document document3;
            SignatureConsumerConfig signatureConsumerConfig = (SignatureConsumerConfig)iterator.next();
            Iterator iterator2 = signatureConsumerConfig.getReferences().iterator();
            while (iterator2.hasNext()) {
                signingReferenceConfig = (SigningReferenceConfig)iterator2.next();
                if (!signingReferenceConfig.getReference().equals(referencePartConfig)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            AlgorithmConfig algorithmConfig = signatureConsumerConfig.getKeyInfoSignature();
            if (algorithmConfig != null) {
                string = algorithmConfig.getAlgorithm();
            }
            if ((document3 = (Document)map2.get(signatureConsumerConfig)) == null) break;
            document2 = document3;
            break;
        }
        if (string != null) {
            map.put("security.wssecurity.integraldialectelementselector.keysigntype", string);
        } else {
            map.remove("security.wssecurity.integraldialectelementselector.keysigntype");
        }
        SignatureGenerator.prepareTransform(signingReferenceConfig, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNecessaryInfo(Map selectorMap,Set sconsumers,ReferencePartConfig rconfig,Docoment doc,Map docMap)");
        }
        return document2;
    }

    private static RequiredPart getRelatedPart(VerificationResult verificationResult, VerificationResult.VerifiedPart verifiedPart, Set set, Map map) throws SoapSecurityException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelatedPart(VerificationResult vresult,VerifiedPart vpart[" + verifiedPart + "]," + "Set requiredParts[" + set + "]," + "Map context)");
        }
        boolean bl2 = verifiedPart._nodeset != null;
        boolean bl3 = bl = verifiedPart._node != null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Is the verified part is nodeset?: " + bl2);
            Tr.debug(tc, "Is the verified part is node?: " + bl);
            Tr.debug(tc, set.size() + " required parts found.");
        }
        SoapSecurityException soapSecurityException = null;
        RequiredPart requiredPart = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            RequiredParts requiredParts = (RequiredParts)iterator.next();
            RequiredPart[] requiredPartArray = requiredParts._parts;
            for (int i = 0; i < requiredPartArray.length; ++i) {
                if (requiredPartArray[i]._processed) continue;
                SoapSecurityException soapSecurityException2 = VerifiedPartChecker.checkBinding(requiredPartArray[i]._rconfig.getBindings(), verificationResult);
                if (soapSecurityException2 == null) {
                    Object object;
                    if (requiredPartArray[i]._isNodeset) {
                        if (bl2) {
                            if (requiredPartArray[i]._nodeset == null) {
                                requiredPartArray[i]._nodeset = XPathCanonicalizer.toNodeset(requiredPartArray[i]._element, null, false);
                            }
                            if (!DOMUtil.includeNodeset(verifiedPart._nodeset, requiredPartArray[i]._nodeset)) continue;
                            requiredPart = requiredPartArray[i];
                            break;
                        }
                        if (bl) {
                            object = XPathCanonicalizer.toNodeset(verifiedPart._node, null, false);
                            if (!DOMUtil.includeNodeset((NodeList)object, requiredPartArray[i]._nodeset)) continue;
                            requiredPart = requiredPartArray[i];
                            break;
                        }
                        object = XPathCanonicalizer.toNodeset(verifiedPart._object, null, false);
                        if (!DOMUtil.includeNodeset((NodeList)object, requiredPartArray[i]._nodeset)) continue;
                        requiredPart = requiredPartArray[i];
                        break;
                    }
                    if (bl2) {
                        if (requiredPartArray[i]._nodeset == null) {
                            requiredPartArray[i]._nodeset = XPathCanonicalizer.toNodeset(requiredPartArray[i]._element, null, false);
                        }
                        if (!DOMUtil.includeNodeset(verifiedPart._nodeset, requiredPartArray[i]._nodeset)) continue;
                        requiredPart = requiredPartArray[i];
                        break;
                    }
                    if (bl) {
                        if (VerifiedPartChecker.hasSameUri(requiredPartArray[i]._element, verifiedPart._node) || DOMUtil.equals(requiredPartArray[i]._element, verifiedPart._node)) {
                            requiredPart = requiredPartArray[i];
                            break;
                        }
                        object = ResultMessagePool.getElement(map, verifiedPart._node);
                        if (object == null || !VerifiedPartChecker.hasSameUri(requiredPartArray[i]._element, (Element)object) && !DOMUtil.equals(requiredPartArray[i]._element, (Node)object)) continue;
                        requiredPart = requiredPartArray[i];
                        break;
                    }
                    if (VerifiedPartChecker.hasSameUri(requiredPartArray[i]._element, verifiedPart._object) || DOMUtil.equals(requiredPartArray[i]._element, verifiedPart._object)) {
                        requiredPart = requiredPartArray[i];
                        break;
                    }
                    object = ResultMessagePool.getElement(map, verifiedPart._object);
                    if (object == null || !VerifiedPartChecker.hasSameUri(requiredPartArray[i]._element, (Element)object) && !DOMUtil.equals(requiredPartArray[i]._element, (Node)object)) continue;
                    requiredPart = requiredPartArray[i];
                    break;
                }
                soapSecurityException = soapSecurityException2;
            }
            if (requiredPart == null) continue;
            soapSecurityException = null;
            break;
        }
        if (soapSecurityException != null) {
            throw soapSecurityException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelatedPart(VerificationResult vresult,VerifiedPart vpart,Set requiredParts,Map context) retutns RequiredPart[" + requiredPart + "]");
        }
        return requiredPart;
    }

    private static boolean hasSameUri(Element element, Element element2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasSameUri(Element rpart[" + DOMUtil.getDisplayName(element) + "]," + "Element vpart[" + DOMUtil.getDisplayName(element2) + "])");
        }
        boolean bl = false;
        String string = IdUtil.getInstance().getId(element);
        String string2 = IdUtil.getInstance().getId(element2);
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string.equals(string2)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasSameUri(Element rpart,Element vpart) returns boolean[" + bl + "]");
        }
        return bl;
    }

    private static void checkCaller(VerificationResult verificationResult, Set set, WSSConsumerConfig wSSConsumerConfig, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCaller(VerificationResult vresult[" + verificationResult + "]," + "Set rpconfigs[" + set + "]," + "WSSConsumerConfig gconfig," + "Map context)");
        }
        Set set2 = wSSConsumerConfig.getCallers();
        boolean bl = true;
        if (set2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, set2.size() + " Callers found, so start to process it...");
            }
            if (verificationResult._token == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The token used for signature verification not found...");
                }
            } else {
                boolean bl2 = verificationResult._token.isTrusted();
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object object2;
                    Object object3;
                    WSSConsumerConfig.CallerConfig callerConfig = (WSSConsumerConfig.CallerConfig)iterator.next();
                    if (!bl2) {
                        object3 = callerConfig.getTokenType();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking the value type of the caller[" + object3 + "]");
                        }
                        if (object3 != null && !((QName)object3).equals(verificationResult._token.getType())) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The value types are different: Caller config[" + object3 + "] and verified result[" + verificationResult._token.getType() + "]");
                            }
                            bl = false;
                        }
                        if (bl) {
                            object2 = callerConfig.getPart();
                            if (object2 == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "ReferencePart of Caller Config is null.");
                                }
                            } else if (!object2.isOneOfIntegralParts()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "ReferencePart of Caller Config is not integral part.");
                                }
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Checking the part of Caller config[" + object2 + "]");
                                }
                                if (set.contains(object2)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Linked the token[" + verificationResult._token + "] and the Caller[" + callerConfig + "].");
                                    }
                                    object = new AuthResult(verificationResult._token, callerConfig);
                                    ResultPool.add(map, (Result)object);
                                }
                            }
                        }
                    }
                    bl = true;
                    object3 = callerConfig.getTrustMethod();
                    if (object3 == null || !bl2) continue;
                    object2 = object3.getTokenType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking the value type of the TrustMethod[" + object2 + "]");
                    }
                    if (object2 != null && !((QName)object2).equals(verificationResult._token.getType())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The value types are different: TrustMethod Config[" + object2 + "] and Verified Result[" + verificationResult._token.getType() + "]");
                        }
                        bl = false;
                    }
                    if (!bl) continue;
                    object = object3.getPart();
                    if (object == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "ReferencePart of TrustMethod Config is null.");
                        continue;
                    }
                    if (!object.isOneOfIntegralParts()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "ReferencePart of TrustMethod Config is not integral part.");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking the ReferencePart config[" + object + "]");
                    }
                    if (!set.contains(object)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Linked the token[" + verificationResult._token + "] and the TrustMethod[" + object3 + "].");
                    }
                    AuthResult authResult = new AuthResult(verificationResult._token, (WSSConsumerConfig.CallerConfig)object3);
                    ResultPool.add(map, authResult);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCaller(VerificationResult vresult,Set rpconfigs,WSSConsumerConfig gconfig,Map context)");
        }
    }

    private static SoapSecurityException checkBinding(Set set, VerificationResult verificationResult) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkBinding(Set bindings[" + set + "]," + "VerificationResult vresult[" + verificationResult + "])");
        }
        Throwable throwable = null;
        boolean bl = set.contains(verificationResult._sconfig);
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The configuration of signature consumer used for verification was found in the bindings.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The configuration of signature consumer used for verification was NOT found in the bindings.");
            }
            object = set.iterator();
            block0: while (!bl && object.hasNext()) {
                SignatureConsumerConfig signatureConsumerConfig = (SignatureConsumerConfig)object.next();
                Iterator iterator = signatureConsumerConfig.getReferences().iterator();
                while (!bl && iterator.hasNext()) {
                    SigningReferenceConfig signingReferenceConfig = (SigningReferenceConfig)iterator.next();
                    KeyInfoResult keyInfoResult = (KeyInfoResult)verificationResult._identities.get(new VerifiedConfig(signatureConsumerConfig, signingReferenceConfig));
                    if (keyInfoResult == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "There is no keyinfo result corresponding to the SigningReferenceConfig.");
                        continue;
                    }
                    Exception exception = keyInfoResult.getError();
                    if (exception == null) {
                        Token token;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The keyinfo result has no exception.");
                        }
                        if ((token = (Token)verificationResult._kresults.get(keyInfoResult)) == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "There is no token corresponding to the keyinfo result.");
                            continue;
                        }
                        if (token.getError() == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The token [" + token + "] has no exception.");
                            }
                            bl = true;
                            continue block0;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The token [" + token + "] has the exception [" + exception.getMessage() + "].");
                        }
                        throwable = token.getError();
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The keyinfo result has the exception [" + exception.getMessage() + "].");
                    }
                    if (exception instanceof SoapSecurityException) {
                        throwable = (SoapSecurityException)exception;
                        continue;
                    }
                    throwable = SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey04", exception);
                }
            }
            if (bl) {
                throwable = null;
            }
        }
        if (tc.isEntryEnabled()) {
            object = throwable == null ? "null" : throwable.toString();
            Tr.exit(tc, "checkBinding(Set bindings,VerificationResult vresult) returns SoapSecurityException[" + (String)object + "]");
        }
        return throwable;
    }

    private static class RequiredPart {
        private ReferencePartConfig _rconfig;
        private ReferencePartConfig.PartConfig _pconfig;
        private Element _element;
        private NodeList _nodeset;
        private Set _tokens;
        private boolean _isNodeset;
        private boolean _requiredTimestamp;
        private boolean _requiredNonce;
        private boolean _processed;

        RequiredPart(ReferencePartConfig referencePartConfig, ReferencePartConfig.PartConfig partConfig, Element element) {
            this._rconfig = referencePartConfig;
            this._pconfig = partConfig;
            this._element = element;
            this._nodeset = null;
            this._isNodeset = false;
            this._tokens = new HashSet();
            this._processed = false;
            this._requiredTimestamp = false;
            this._requiredNonce = false;
        }

        RequiredPart(ReferencePartConfig referencePartConfig, ReferencePartConfig.PartConfig partConfig, NodeList nodeList) {
            this._rconfig = referencePartConfig;
            this._pconfig = partConfig;
            this._element = null;
            this._nodeset = nodeList;
            this._isNodeset = true;
            this._tokens = new HashSet();
            this._processed = false;
            this._requiredTimestamp = false;
            this._requiredNonce = false;
        }
    }

    private static class RequiredParts {
        private RequiredPart[] _parts;

        RequiredParts(RequiredPart[] requiredPartArray) {
            this._parts = requiredPartArray;
        }
    }
}

