/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.transform.XMLDecryptionTransformer2;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDecryptionTransformer
extends XMLDecryptionTransformer2 {
    private static final TraceComponent tc = Tr.register(XMLDecryptionTransformer.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = XMLDecryptionTransformer.class.getName();
    private String _nsWsse;
    private String _nsWsu;

    public void transform(TransformContext transformContext) throws TransformException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transform(TransformContext context[" + transformContext + "])");
        }
        super.transform(transformContext);
        SignatureContext signatureContext = transformContext.getSignatureContext();
        if (signatureContext instanceof WSSSignatureContext) {
            object = (WSSSignatureContext)signatureContext;
            int n = ((WSSSignatureContext)object).getWssVersion();
            this._nsWsse = Constants.NAMESPACES[0][n];
            this._nsWsu = Constants.NAMESPACES[1][n];
        }
        object = null;
        switch (transformContext.getType()) {
            case 0: 
            case 1: {
                object = XPathCanonicalizer.toNodeset(transformContext.getDocument(), null, true);
                break;
            }
            case 3: {
                object = XPathCanonicalizer.toNodeset(transformContext.getNode(), null, true);
                break;
            }
            case 2: {
                object = transformContext.getNodeset();
            }
        }
        if (object != null) {
            object = this.removeNonce((NodeList)object, this._nsWsse, this._nsWsu);
        }
        transformContext.setContent((NodeList)object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transform(TransformContext context)");
        }
    }

    private NodeList removeNonce(NodeList nodeList, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNonce(NodeList nl[" + nodeList + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "])");
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (DOMUtil.equals(node, string, "Nonce")) {
                    if ("weenc".equals(element.getAttribute("wasextention"))) {
                        i = this.removeNodes(nodeList, i + 1, element);
                        continue;
                    }
                } else if (DOMUtil.equals(node, string2, "Timestamp") && "weenc".equals(element.getAttribute("wasextention"))) {
                    i = this.removeNodes(nodeList, i + 1, element);
                    continue;
                }
            }
            nodeListImpl.add(node);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNonce(NodeList nl,String nsWsse,String nsWsu) returns NodeList[" + nodeListImpl + "]");
        }
        return nodeListImpl;
    }

    private int removeNodes(NodeList nodeList, int n, Node node) {
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNodes(NodeList nl[" + nodeList + "]," + "int start[" + n + "]," + "Node root[" + DOMUtil.getDisplayName(node) + "])");
        }
        boolean bl = false;
        int n3 = nodeList.getLength();
        for (n2 = n; n2 < n3; ++n2) {
            Node node2 = nodeList.item(n2);
            switch (node2.getNodeType()) {
                case 1: {
                    if (node2.getParentNode().equals(node)) {
                        n2 = this.removeNodes(nodeList, n2 + 1, node2);
                        break;
                    }
                    bl = true;
                }
            }
            if (bl) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNodes(NodeList nl,int start,Node root)");
        }
        return n2 - 1;
    }
}

