/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.enc;

import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSAlgorithmFactory;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.ResultMessagePool;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.webservices.wssecurity.enc.DecryptionResult;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.enc.type.DataReference;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyReference;
import com.ibm.ws.wssecurity.xss4j.enc.type.ReferenceList;
import com.ibm.ws.wssecurity.xss4j.enc.type.ReferenceType;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptionConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(EncryptionConsumer.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = EncryptionConsumer.class.getName();
    private IdUtil _idResolver = null;
    private Map _selectors = null;
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtil)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Node target[" + DOMUtil.getDisplayName(node) + "]," + "Map context)");
        }
        int n = 0;
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s13");
        }
        String string = node.getNamespaceURI();
        String string2 = node.getLocalName();
        n = string == null ? 0 : string.hashCode() * 31;
        if (node.getNodeType() != 1 || (n += string2 == null ? 0 : string2.hashCode()) != Constants.HASH_ENC_ENCRYPTEDKEY && n != Constants.HASH_ENC_REFERENCELIST) {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtil.getQualifiedName(node));
        }
        Element element = (Element)node;
        Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int n2 = 0;
        if (v != null && v instanceof Integer) {
            n2 = (Integer)v;
        }
        String string3 = Constants.NAMESPACES[0][n2];
        String string4 = Constants.NAMESPACES[1][n2];
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        EncryptionConsumerConfig encryptionConsumerConfig = (EncryptionConsumerConfig)map.remove("com.ibm.wsspi.wssecurity.config.encryptionConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "EncryptionConsumerConfig [" + encryptionConsumerConfig + "].");
        }
        if (EncryptedKey.isOfType(element)) {
            EncryptionConsumer.checkEncryptedKey(element, encryptionConsumerConfig);
        } else {
            EncryptionConsumer.checkReferenceList(element, encryptionConsumerConfig);
        }
        HashMap hashMap = new HashMap();
        Document document = element.getOwnerDocument();
        DecryptionResult decryptionResult = EncryptionConsumer.decrypt(element, encryptionConsumerConfig, this._idResolver, document, wSSConsumerConfig, hashMap, this._selectors, string3, string4, map);
        EncryptionConsumer.setDecryptionResult(decryptionResult, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Node target,Map context)");
        }
    }

    private static void checkEncryptedKey(Element element, EncryptionConsumerConfig encryptionConsumerConfig) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkEncryptedKey(Element enckey[" + DOMUtil.getDisplayName(element) + "]," + "EncryptionConsumerConfig config)");
        }
        int n = 0;
        Element element2 = DOMUtil.getFirstElement(element);
        while (element2 != null) {
            String string = element2.getNamespaceURI();
            String string2 = element2.getLocalName();
            n = string == null ? 0 : string.hashCode() * 31;
            if ((n += string2 == null ? 0 : string2.hashCode()) == Constants.HASH_ENC_ENCRYPTIONMETHOD) {
                String string3 = element2.getAttribute("Algorithm");
                if (encryptionConsumerConfig.getKeyEncryptionMethod() == null || !encryptionConsumerConfig.getKeyEncryptionMethod().getAlgorithm().equals(string3)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s15", string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " [" + string3 + "] is OK.");
                }
            } else if (n == Constants.HASH_ENC_REFERENCELIST) {
                EncryptionConsumer.checkReferenceList(element2, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (n == Constants.HASH_ENC_CIPHERDATA || n == Constants.HASH_DS_KEYINFO) {
                EncryptionConsumer.checkCipherData(element2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (n == Constants.HASH_ENC_CARRIEDKEYNAME || n == Constants.HASH_ENC_ENCRYPTIONPROPS) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK. But this consumer ignores it.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: There is unknown element " + DOMUtil.getQualifiedName(element2) + " in the " + DOMUtil.getQualifiedName(element) + " element.");
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkEncryptedKey(Element enckey,EncryptionConsumerConfig config)");
        }
    }

    private static void checkReferenceList(Element element, EncryptionConsumerConfig encryptionConsumerConfig) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkReferenceList(Element reflist[" + DOMUtil.getDisplayName(element) + "]," + "EncryptionConsumerConfig config)");
        }
        if (encryptionConsumerConfig != null && encryptionConsumerConfig.getKeyEncryptionMethod() != null && encryptionConsumerConfig.getKeyEncryptionMethod().getAlgorithm().length() > 0) {
            throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.EncryptionConsumer.s12", encryptionConsumerConfig.getKeyEncryptionMethod().getAlgorithm());
        }
        int n = 0;
        Element element2 = DOMUtil.getFirstElement(element);
        while (element2 != null) {
            String string = element2.getNamespaceURI();
            String string2 = element2.getLocalName();
            n = string == null ? 0 : string.hashCode() * 31;
            if ((n += string2 == null ? 0 : string2.hashCode()) == Constants.HASH_ENC_DATAREFERENCE || n == Constants.HASH_ENC_KEYREFERENCE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: There is unknown element " + DOMUtil.getQualifiedName(element2) + " in the " + DOMUtil.getQualifiedName(element) + " element.");
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkReferenceList(Element reflist,EncryptionConsumerConfig config)");
        }
    }

    private static void checkEncryptedData(Element element, EncryptionConsumerConfig encryptionConsumerConfig) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkEncryptedKey(Element encdata[" + DOMUtil.getDisplayName(element) + "]," + "EncryptionConsumerConfig config)");
        }
        int n = 0;
        Element element2 = DOMUtil.getFirstElement(element);
        while (element2 != null) {
            String string = element2.getNamespaceURI();
            String string2 = element2.getLocalName();
            n = string == null ? 0 : string.hashCode() * 31;
            if ((n += string2 == null ? 0 : string2.hashCode()) == Constants.HASH_ENC_ENCRYPTIONMETHOD) {
                String string3 = element2.getAttribute("Algorithm");
                if (!encryptionConsumerConfig.getDataEncryptionMethod().getAlgorithm().equals(string3)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s14", string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " [" + string3 + "] is OK.");
                }
            } else if (n == Constants.HASH_ENC_CIPHERDATA) {
                EncryptionConsumer.checkCipherData(element2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (n == Constants.HASH_DS_KEYINFO) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (n == Constants.HASH_ENC_ENCRYPTIONPROPS) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK. But this consumer igonores it.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: There is unknown element " + DOMUtil.getQualifiedName(element2) + " in the " + DOMUtil.getQualifiedName(element) + " element.");
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkEncryptedData(Element encdata,EncryptionConsumerConfig config)");
        }
    }

    private static void checkCipherData(Element element) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCipherData(Element cipdata[" + DOMUtil.getDisplayName(element) + "])");
        }
        int n = 0;
        Element element2 = DOMUtil.getFirstElement(element);
        while (element2 != null) {
            String string = element2.getNamespaceURI();
            String string2 = element2.getLocalName();
            n = string == null ? 0 : string.hashCode() * 31;
            if ((n += string2 == null ? 0 : string2.hashCode()) == Constants.HASH_ENC_CIPHERVALUE || n == Constants.HASH_ENC_CIPHERREFERENCE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: There is unknown element " + DOMUtil.getQualifiedName(element2) + " in the " + DOMUtil.getQualifiedName(element) + " element.");
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCipherData(Element cipdata)");
        }
    }

    private static DecryptionResult decrypt(Element element, EncryptionConsumerConfig encryptionConsumerConfig, IdUtil idUtil, Document document, WSSConsumerConfig wSSConsumerConfig, Map map, Map map2, String string, String string2, Map map3) throws SoapSecurityException {
        Cloneable cloneable;
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decrypt(Element target[" + DOMUtil.getDisplayName(element) + "]," + "EncryptionConsumerConfig config," + "IdUtil idResolver[" + idUtil + "]," + "Document document[" + DOMUtil.getDisplayName(document) + "]," + "WSSConsumerConfig gconfig," + "Map type," + "Map properties," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "Map context)");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DecryptionContext decryptionContext = new DecryptionContext();
        decryptionContext.setIdResolver(idUtil);
        WSSAlgorithmFactory wSSAlgorithmFactory = wSSConsumerConfig.getAlgorithmFactory();
        decryptionContext.setAlgorithmFactory(wSSAlgorithmFactory);
        if (tc.isDebugEnabled()) {
            decryptionContext.setResourceShower(ShowerImpl.getInstance());
        }
        Map map4 = wSSConsumerConfig.getProperties();
        decryptionContext.setHWConfigName((String)map4.get("HWCONFIG"));
        String string3 = (String)map4.get("com.ibm.ws.wssecurity.handler.OffloadAllCryptography");
        decryptionContext.setHWKeyStoreName((String)map3.remove("com.ibm.ws.wssecurity.config.keystore.keyStoreRef"));
        String string4 = null;
        AlgorithmConfig algorithmConfig = encryptionConsumerConfig.getKeyEncryptionMethod();
        if (algorithmConfig != null) {
            string4 = algorithmConfig.getAlgorithm();
        }
        decryptionContext.setEncAlgorithm(string4);
        decryptionContext.setOffload(Boolean.TRUE);
        if (decryptionContext.shouldChangeProvider()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Acceleration enabled, Key Store Name is: ", decryptionContext.getHWConfigName());
            }
            if ((object3 = ConfigUtil.getHWCryptoProviderInstance(decryptionContext.getHWConfigName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                object2 = (Integer)map4.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                decryptionContext.setHWAccelerationProvider((Provider)object3, (Integer)object2);
                decryptionContext.setCryptoOffloadProperty(string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for HW Acceleration" + ((Provider)object3).getName());
                }
            }
        }
        object3 = EncryptionConsumer.getIds(element);
        Key key = null;
        Key key2 = null;
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            Element element2 = idUtil.resolveID(document, (String)object2);
            if (element2 != null) {
                if (EncryptedData.isOfType(element2)) {
                    EncryptionConsumer.checkEncryptedData(element2, encryptionConsumerConfig);
                    if (EncryptedKey.isOfType(element)) {
                        if (key == null) {
                            key = SignatureConsumer.callKeyInfoConsumer(encryptionConsumerConfig.getEncryptionKeyInfo(), "DecryptingKey", map, map2, KeyInfo.searchForKeyInfo(element), map3);
                            if (decryptionContext.useHWKeyStore()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "HARDWARE Key Store Name is: ", decryptionContext.getHWKeyStoreName());
                                }
                                if ((object = ConfigUtil.getHWCryptoProviderInstance(decryptionContext.getHWKeyStoreName())) == null) {
                                    Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                                } else {
                                    decryptionContext.setHWKeyStoreProvider((Provider)object);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + ((Provider)object).getName());
                                    }
                                }
                            } else if (key instanceof PKCS11Key && !decryptionContext.shouldChangeProvider()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "PKCS11 Key is in use, but did not find hardware keystore/acceleration in the config");
                                }
                                if ((object = (String)map4.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore")) != null) {
                                    decryptionContext.setHWKeyStoreName((String)object);
                                    if (decryptionContext.useHWKeyStore()) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "HARDWARE Key Store Name is: ", decryptionContext.getHWKeyStoreName());
                                        }
                                        if ((cloneable = ConfigUtil.getHWCryptoProviderInstance(decryptionContext.getHWKeyStoreName())) == null) {
                                            Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                                        } else {
                                            decryptionContext.setHWKeyStoreProvider((Provider)cloneable);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + ((Provider)cloneable).getName());
                                            }
                                        }
                                    } else {
                                        Tr.error(tc, "Missing Hardware KeyStore Configuration, cannot use the PKCS11 type for encrypt/decrypt");
                                        throw SoapSecurityException.format("Missing Hardware KeyStore Configuration");
                                    }
                                }
                            }
                        }
                        if (key2 == null) {
                            key2 = EncryptionConsumer.decryptEncryptedKey(element, decryptionContext, key, element2);
                        }
                    } else {
                        key2 = SignatureConsumer.callKeyInfoConsumer(encryptionConsumerConfig.getEncryptionKeyInfo(), "DecryptingKey", map, map2, KeyInfo.searchForKeyInfo(element2), map3);
                        if (decryptionContext.useHWKeyStore()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "HARDWARE Key Store Name is: ", decryptionContext.getHWKeyStoreName());
                            }
                            if ((object = ConfigUtil.getHWCryptoProviderInstance(decryptionContext.getHWKeyStoreName())) == null) {
                                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                            } else {
                                decryptionContext.setHWKeyStoreProvider((Provider)object);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + ((Provider)object).getName());
                                }
                            }
                        } else if (key instanceof PKCS11Key && !decryptionContext.shouldChangeProvider()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "PKCS11 Key is in use, but did not find hardware keystore/acceleration in the config");
                            }
                            if ((object = (String)map4.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore")) != null) {
                                decryptionContext.setHWKeyStoreName((String)object);
                                if (decryptionContext.useHWKeyStore()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "HARDWARE Key Store Name is: ", decryptionContext.getHWKeyStoreName());
                                    }
                                    if ((cloneable = ConfigUtil.getHWCryptoProviderInstance(decryptionContext.getHWKeyStoreName())) == null) {
                                        Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                                    } else {
                                        decryptionContext.setHWKeyStoreProvider((Provider)cloneable);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + ((Provider)cloneable).getName());
                                        }
                                    }
                                } else {
                                    Tr.error(tc, "Missing Hardware KeyStore Configuration, cannot use the PKCS11 type for encrypt/decrypt");
                                    throw SoapSecurityException.format("Missing Hardware KeyStore Configuration");
                                }
                            }
                        }
                    }
                    object = EncryptionConsumer.decryptEncryptedData(element2, decryptionContext, key2, string, string2, map3);
                    arrayList.add(object);
                } else {
                    throw SoapSecurityException.format("security.wssecurity.EncryptionReceiver.enc13", element2.getTagName());
                }
            }
            if (!decryptionContext.useHWKeyStore()) continue;
            ConfigUtil.returnHWCryptoProviderInstance(decryptionContext.getHWKeyStoreName(), decryptionContext.getHWKeyStoreProvider());
            decryptionContext.setHWKeyStoreProvider(null);
            decryptionContext.setHWKeyStoreName(null);
        }
        if (decryptionContext.isHWAccelerationProvider()) {
            ConfigUtil.returnHWCryptoProviderInstance(decryptionContext.getHWConfigName(), decryptionContext.getHWAccelerationProvider());
        }
        if (decryptionContext.useHWKeyStore()) {
            ConfigUtil.returnHWCryptoProviderInstance(decryptionContext.getHWKeyStoreName(), decryptionContext.getHWKeyStoreProvider());
        }
        decryptionContext.clearLocalProviderMap();
        object = new DecryptionResult(encryptionConsumerConfig, arrayList);
        cloneable = EncryptionConsumer.getToken((DecryptionResult)object, encryptionConsumerConfig, map3);
        ((DecryptionResult)object)._token = cloneable;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrypt(Element target,EncryptionConsumerConfig config,IdUtil idResolver,Document document,WSSConsumerConfig gconfig,Map type,Map properties,String nsWsse,String nsWsu,Map context) returns DecryptionResult[" + object + "]");
        }
        return object;
    }

    private static List getIds(Element element) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIds(Element target[" + DOMUtil.getDisplayName(element) + "])");
        }
        Element element2 = null;
        if (EncryptedKey.isOfType(element)) {
            element2 = DOMUtil.getChildElement(element, Constants.NS_ENC, "ReferenceList");
        } else if (ReferenceList.isOfType(element)) {
            element2 = element;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (element2 != null) {
            ReferenceList referenceList = new ReferenceList(element2);
            Iterator iterator = referenceList.getReferences().iterator();
            while (iterator.hasNext()) {
                ReferenceType referenceType = (ReferenceType)iterator.next();
                if (referenceType instanceof DataReference) {
                    String string = ((DataReference)referenceType).getURI();
                    if (string == null) {
                        throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s01");
                    }
                    if (string.length() <= 1 || string.charAt(0) != '#') continue;
                    arrayList.add(string.substring(1));
                    continue;
                }
                if (!(referenceType instanceof KeyReference)) continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIds(Element target) returns List[" + arrayList + "]");
        }
        return arrayList;
    }

    private static Key decryptEncryptedKey(Element element, DecryptionContext decryptionContext, Key key, Element element2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptEncryptedKey(Element enckey[" + DOMUtil.getDisplayName(element) + "]," + "DecryptionContext dcontext[" + decryptionContext + "]," + "Key kek[" + key + "]," + "Element encData[" + DOMUtil.getDisplayName(element2) + "])");
        }
        Key key2 = null;
        try {
            decryptionContext.setEncryptedType(element, null, null, null);
            decryptionContext.setEncryptionMethod(DOMUtil.getChildElement(element2, Constants.NS_ENC, "EncryptionMethod"));
            if (decryptionContext.isHWAccelerationProvider()) {
                decryptionContext.setHWKey(key);
            } else {
                decryptionContext.setKey(key);
            }
            decryptionContext.decrypt();
            key2 = (Key)decryptionContext.getData();
            decryptionContext.setEncryptionMethod((Element)null);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception from decrypting the key: ", exception);
            }
            Tr.processException(exception, clsName + ".decryptEncryptedKey", "586");
            Tr.error(tc, "security.wssecurity.EncryptionConsumer.s11", new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s11", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptEncryptedKey(Element enckey,DecryptionContext dcontext,Key kek,Element encdata) returns Key[" + key2 + "]");
        }
        return key2;
    }

    private static DecryptionResult.DecryptedPart decryptEncryptedData(Element element, DecryptionContext decryptionContext, Key key, String string, String string2, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptEncryptedData(Element encdata[" + DOMUtil.getDisplayName(element) + "]," + "DecryptionContext dcontext[" + decryptionContext + "]," + "Key kek[" + key + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "Map context)");
        }
        DecryptionResult.DecryptedPart decryptedPart = null;
        try {
            decryptionContext.setEncryptedType(element, null, null, null);
            decryptionContext.setKey(key);
            decryptionContext.decrypt();
            decryptionContext.replace();
            decryptedPart = EncryptionConsumer.createDecryptedPart(element, decryptionContext, string, string2, map);
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".decryptEncryptedData", "628");
            Tr.error(tc, "security.wssecurity.EncryptionConsumer.s11", new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s11", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptEncryptedData(Element encdata,DecryptionContext dcontext,Key dek,String nsWsse,String nsWsu,Map context) returns DecryptedPart[" + decryptedPart + "]");
        }
        return decryptedPart;
    }

    private static DecryptionResult.DecryptedPart createDecryptedPart(Element element, DecryptionContext decryptionContext, String string, String string2, Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDecryptedPart(Element encdata[" + DOMUtil.getDisplayName(element) + "]," + "DecryptionContext dcontext[" + decryptionContext + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "Map context)");
        }
        boolean bl = false;
        String string3 = decryptionContext.getType();
        DecryptionResult.DecryptedPart decryptedPart = null;
        NodeList nodeList = decryptionContext.getDataAsNodeList();
        int n = nodeList.getLength();
        if (n > 0) {
            Node node = nodeList.item(0);
            if (string3.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                Element element2 = (Element)node;
                String string4 = IdUtil.getInstance().getId(element2);
                Element element3 = NonceUtil.getTimestamp(element2, string2);
                Element element4 = NonceUtil.getNonce(element2, string);
                bl = NonceUtil.isNonceFirst(element2, element4, element3);
                decryptedPart = new DecryptionResult.DecryptedPart(string3, string4, element2, element4, element3, bl);
                ResultMessagePool.addElement(map, element, element2);
            } else if (string3.equals("http://www.w3.org/2001/04/xmlenc#Content") && (node = node.getParentNode()) != null && node.getNodeType() == 1) {
                Element element5 = (Element)node;
                String string5 = IdUtil.getInstance().getId(element5);
                Element element6 = NonceUtil.getTimestamp(element5, string2);
                Element element7 = NonceUtil.getNonce(element5, string);
                bl = NonceUtil.isNonceFirst(element5, element7, element6);
                decryptedPart = new DecryptionResult.DecryptedPart(string3, string5, element5, element7, element6, bl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDecryptedPart(Element encdata,DecryptionContext dcontext,String nsWsse,String nsWsu,Map context) returns DecryptedPart[" + decryptedPart + "]");
        }
        return decryptedPart;
    }

    private static void setDecryptionResult(DecryptionResult decryptionResult, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDecryptionResult(DecryptionResult dresult[" + decryptionResult + "]," + "Map context)");
        }
        Iterator iterator = decryptionResult._decryptedParts.iterator();
        while (iterator.hasNext()) {
            DecryptionResult.DecryptedPart decryptedPart = (DecryptionResult.DecryptedPart)iterator.next();
            SignatureConsumer.removeNode(decryptedPart._timestamp, "weenc");
            SignatureConsumer.removeNode(decryptedPart._nonce, "weenc");
        }
        ResultPool.add(map, decryptionResult);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDecryptionResult(DecryptionResult dresult,Map context)");
        }
    }

    private static KeyInfoResult[] getKeyInfoResults(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfoResults(Map context)");
        }
        KeyInfoResult[] keyInfoResultArray = null;
        Result[] resultArray = ResultPool.get(map, KeyInfoResult.class);
        if (resultArray != null) {
            keyInfoResultArray = new KeyInfoResult[resultArray.length];
            for (int i = 0; i < resultArray.length; ++i) {
                keyInfoResultArray[i] = (KeyInfoResult)resultArray[i];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInfoResults(Map context) returns KeyInfoResult[][" + keyInfoResultArray + "]");
        }
        return keyInfoResultArray;
    }

    private static KeyInfoResult getProcessedResult(DecryptionResult decryptionResult, KeyInfoResult[] keyInfoResultArray, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessedResult(DecryptionResult dresult,KeyInfoResult[] results,List kclist");
        }
        KeyInfoResult keyInfoResult = null;
        if (keyInfoResultArray != null) {
            for (int i = 0; i < keyInfoResultArray.length; ++i) {
                KeyInfoResult keyInfoResult2 = keyInfoResultArray[i];
                if (keyInfoResult == null && list.contains(keyInfoResult2.getKeyInfoContentConsumer()) && keyInfoResult2.getError() == null) {
                    keyInfoResult = keyInfoResult2;
                    continue;
                }
                decryptionResult._kresults.put(keyInfoResult2.getKeyInfoContentConsumer(), keyInfoResult2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessedResult(DecryptionResult vresult,KeyInfoResult[] results,List kclist) returns KeyInfoResult[" + keyInfoResult + "]");
        }
        return keyInfoResult;
    }

    private static Token getToken(DecryptionResult decryptionResult, EncryptionConsumerConfig encryptionConsumerConfig, Map map) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getToken(DecryptionResult dresult[" + decryptionResult + "]," + "EncryptionConsumerConfig econfig," + "Map context)");
        }
        Token token = null;
        Set set = null;
        KeyInfoResult[] keyInfoResultArray = EncryptionConsumer.getKeyInfoResults(map);
        KeyInfoResult keyInfoResult = EncryptionConsumer.getProcessedResult(decryptionResult, keyInfoResultArray, encryptionConsumerConfig.getEncryptionKeyInfo().getContentConsumers());
        if (keyInfoResult != null) {
            object4 = keyInfoResult.getIdInSubject();
            token = TokenManager.getToken(map, keyInfoResult.getKeyInfoContentConsumer().getTokenConsumer(), (String)object4);
            if (token != null) {
                if (token.getError() != null) {
                    throw token.getError();
                }
                token.setReferenced(true);
            }
            set = TokenManager.getTokens(map, (String)object4);
        }
        if ((object4 = encryptionConsumerConfig.getIdentityList()) != null && object4.size() > 0) {
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                object3 = (EncryptionConsumerConfig)iterator.next();
                object2 = object3.getEncryptionKeyInfo().getContentConsumers().iterator();
                block1: while (object2.hasNext()) {
                    object = (KeyInfoContentConsumerConfig)object2.next();
                    for (int i = 0; i < keyInfoResultArray.length; ++i) {
                        if (!object.equals(keyInfoResultArray[i].getKeyInfoContentConsumer())) continue;
                        decryptionResult._identities.put(object3, keyInfoResultArray[i]);
                        continue block1;
                    }
                }
            }
        }
        if (set != null && set.size() > 0) {
            block3: for (int i = 0; i < keyInfoResultArray.length; ++i) {
                object3 = keyInfoResultArray[i];
                object2 = ((KeyInfoResult)object3).getKeyInfoContentConsumer().getTokenConsumer();
                if (object2 == null) continue;
                object = set.iterator();
                while (object.hasNext()) {
                    Token token2 = (Token)object.next();
                    if (!object2.equals(token2.getUsedTokenConsumer())) continue;
                    decryptionResult._kresults.put(object3, token2);
                    continue block3;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getToken(DecryptionResult dresult,EncryptionConsumerConfig econfig,Map context) returns Token[" + token + "]");
        }
        return token;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showEncryptedResource(byte[] byArray, Object object, Element element) {
            String string = null;
            try {
                string = EncryptedData.isOfType(element) ? new String(byArray, "UTF-8") : Base64.encode(byArray);
            }
            catch (Exception exception) {
                Tr.debug(tc, "WARNING: An exception occured while the content is encoded with [UTF-8].");
            }
            if (EncryptedData.isOfType(element)) {
                Tr.debug(tc, "ResourceShower logs decrypt-" + element.getAttribute("Id") + ": " + string);
            } else {
                Tr.debug(tc, "ResourceShower logs decrypt-EncryptedKey: " + string);
            }
        }
    }
}

