/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.enc;

import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSAlgorithmFactory;
import com.ibm.ws.webservices.wssecurity.WSSGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.RequestMessagePool;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.webservices.wssecurity.enc.PartList;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xss4j.enc.EncryptionContext;
import com.ibm.ws.wssecurity.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xss4j.enc.type.DataReference;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.enc.type.ReferenceList;
import com.ibm.ws.wssecurity.xss4j.enc.type.Type;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptionGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(EncryptionGenerator.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = EncryptionGenerator.class.getName();
    private IdUtil _idResolver = null;
    private Map _selectors = null;
    private boolean _initialized = false;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$util$ConfidentialDialectElementSelector;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtil)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        Type type;
        Object object;
        String string;
        PartList partList;
        ReferencePartConfig.PartConfig partConfig;
        Iterator iterator;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element parent[" + DOMUtil.getDisplayName(element) + "]," + "Map context)");
        }
        Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        int n = 0;
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string2 = Constants.NAMESPACES[2][n];
        v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int n2 = 0;
        if (v != null && v instanceof Integer) {
            n2 = (Integer)v;
        }
        String string3 = Constants.NAMESPACES[0][n2];
        String string4 = Constants.NAMESPACES[1][n2];
        if (element == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", "Null", "the parent element");
        }
        String string5 = element.getLocalName();
        String string6 = element.getNamespaceURI();
        if (NamespaceUtil.isWsse(string6) != n2 || !"Security".equals(string5)) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", DOMUtil.getQualifiedName(element));
        }
        WSSGeneratorConfig wSSGeneratorConfig = (WSSGeneratorConfig)map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        EncryptionGeneratorConfig encryptionGeneratorConfig = (EncryptionGeneratorConfig)map.remove("com.ibm.wsspi.wssecurity.config.encryptionGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "EncryptionGeneratorConfig [" + encryptionGeneratorConfig + "].");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining encrypting parts.");
        }
        boolean bl = false;
        boolean bl2 = false;
        HashSet<ReferencePartConfig.PartConfig> hashSet = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(map);
        hashMap.put(NonceManager.class, wSSGeneratorConfig.getNonceManager());
        hashMap.put("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver", this._idResolver);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<PartList> arrayList2 = new ArrayList<PartList>();
        ArrayList<Node> arrayList3 = new ArrayList<Node>();
        ReferencePartConfig referencePartConfig = encryptionGeneratorConfig.getReference();
        if (referencePartConfig != null && referencePartConfig.getParts() != null && referencePartConfig.getParts().iterator() != null) {
            iterator = referencePartConfig.getParts().iterator();
            while (iterator.hasNext()) {
                String string7;
                partConfig = (ReferencePartConfig.PartConfig)iterator.next();
                if (partConfig.isTimestamp() || partConfig.isNonce()) {
                    bl2 = true;
                    hashSet.add(partConfig);
                    continue;
                }
                String string8 = partConfig.getDialect();
                partList = (PartList)SignatureGenerator.getMessagePart(document, string8, string7 = partConfig.getKeyword(), "encryption_mode", this._selectors, class$com$ibm$ws$webservices$wssecurity$util$ConfidentialDialectElementSelector == null ? EncryptionGenerator.class$("com.ibm.ws.webservices.wssecurity.util.ConfidentialDialectElementSelector") : class$com$ibm$ws$webservices$wssecurity$util$ConfidentialDialectElementSelector, hashMap);
                if (partList != null && partList.getLength() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, partList.getLength() + " parts found.");
                    }
                    arrayList2.add(partList);
                    for (int i = 0; i < partList.getLength(); ++i) {
                        arrayList3.add(partList.item(i));
                        boolean bl3 = false;
                        while (!bl3) {
                            string = IdUtil.getInstance().makeUniqueId(document, "wssecurity_encryption_id_");
                            if (arrayList.contains(string)) continue;
                            arrayList.add(string);
                            bl3 = true;
                        }
                        bl = true;
                    }
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", string8, string7);
            }
        }
        if (!bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc,Element parent,Map context)");
            }
            return;
        }
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        EncryptionContext encryptionContext = new EncryptionContext();
        string = null;
        AlgorithmConfig algorithmConfig = encryptionGeneratorConfig.getKeyEncryptionMethod();
        if (algorithmConfig != null) {
            string = algorithmConfig.getAlgorithm();
        }
        encryptionContext.setEncAlgorithm(string);
        WSSAlgorithmFactory wSSAlgorithmFactory = wSSGeneratorConfig.getAlgorithmFactory();
        encryptionContext.setAlgorithmFactory(wSSAlgorithmFactory);
        Map map2 = encryptionGeneratorConfig.getProperties();
        Map map3 = wSSGeneratorConfig.getProperties();
        String string9 = null;
        String string10 = null;
        string9 = (String)map3.get("HWCONFIG");
        encryptionContext.setHWConfigName(string9);
        String string11 = (String)map3.get("com.ibm.ws.wssecurity.handler.OffloadAllCryptography");
        encryptionContext.setOffload((Boolean)map3.get("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography"));
        if (encryptionContext.shouldChangeProvider()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Acceleration enabled, Key Store Name is: ", encryptionContext.getHWConfigName());
            }
            if ((object = ConfigUtil.getHWCryptoProviderInstance(encryptionContext.getHWConfigName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                Integer n3 = (Integer)map3.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                encryptionContext.setHWAccelerationProvider((Provider)object, n3);
                encryptionContext.setCryptoOffloadProperty(string11);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for HW Acceleration" + ((Provider)object).getName());
                }
            }
        }
        string10 = (String)map2.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
        encryptionContext.setHWKeyStoreName(string10);
        if (encryptionContext.useHWKeyStore()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Key Store Name is: ", encryptionContext.getHWKeyStoreName());
            }
            if ((object = ConfigUtil.getHWCryptoProviderInstance(encryptionContext.getHWKeyStoreName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                encryptionContext.setHWKeyStoreProvider((Provider)object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + ((Provider)object).getName());
                }
            }
        }
        hashMap2.put("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore", (String)map3.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore"));
        if (tc.isDebugEnabled()) {
            encryptionContext.setResourceShower(ShowerImpl.getInstance());
        }
        object = null;
        if (encryptionGeneratorConfig.getKeyEncryptionMethod() != null) {
            object = encryptionGeneratorConfig.getKeyEncryptionMethod().getAlgorithm();
        }
        boolean bl4 = object != null && ((String)object).length() > 0;
        EncryptedData encryptedData = EncryptionGenerator.createEncryptedData(encryptionGeneratorConfig, document, !bl4 && wSSGeneratorConfig.isUserDefinedComponentsUsed(), wSSAlgorithmFactory);
        Element element2 = null;
        Element element3 = null;
        Key key = null;
        if (bl4) {
            type = EncryptionGenerator.createEncryptedKey(encryptionGeneratorConfig, arrayList, wSSAlgorithmFactory, document, string2, string3, string4, wSSGeneratorConfig.isUserDefinedComponentsUsed());
            try {
                element2 = ((EncryptedKey)type).createElement(document, true);
                element2 = SignatureGenerator.insertElement(element, element2, string4, map);
            }
            catch (StructureException structureException) {
                Tr.processException(structureException, clsName + ".invoke", "322");
                throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s01", "EncryptedKey", (Throwable)structureException);
            }
            Key key2 = SignatureGenerator.callKeyInfoGenerator(encryptionGeneratorConfig.getEncryptionKeyInfo(), "EncryptingKey", hashMap2, this._selectors, document, element2, map);
            String string12 = null;
            if (key2 instanceof PKCS11Key && !encryptionContext.shouldChangeProvider() && !encryptionContext.useHWKeyStore()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PKCS11 Key is in use, but did not find hardware keystore/acceleration in the config");
                }
                if ((string12 = (String)map3.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore")) != null) {
                    encryptionContext.setHWKeyStoreName(string12);
                    if (encryptionContext.useHWKeyStore()) {
                        Provider provider;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "HARDWARE Key Store Name is: ", encryptionContext.getHWKeyStoreName());
                        }
                        if ((provider = ConfigUtil.getHWCryptoProviderInstance(encryptionContext.getHWKeyStoreName())) == null) {
                            Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                        } else {
                            encryptionContext.setHWKeyStoreProvider(provider);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + provider.getName());
                            }
                        }
                    } else {
                        Tr.error(tc, "Missing Hardware KeyStore Configuration, cannot use the PKCS11 type for encrypt/decrypt");
                        throw SoapSecurityException.format("Missing Hardware KeyStore Configuration");
                    }
                }
            }
            key = EncryptionGenerator.generateKey(encryptionContext, encryptedData, document, key2);
            EncryptionGenerator.encryptKey(map, encryptionContext, element2, document, key, key2);
            element3 = DOMUtil.getOneChildElement(element2, Constants.NS_ENC, "ReferenceList");
        } else {
            type = EncryptionGenerator.createReferenceList(arrayList, document, string2, string3, string4);
            try {
                element2 = ((ReferenceList)type).createElement(document, true);
                element2 = SignatureGenerator.insertElement(element, element2, string4, map);
            }
            catch (StructureException structureException) {
                Tr.processException(structureException, clsName + ".invoke", "355");
                throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s01", "ReferenceLost", (Throwable)structureException);
            }
            key = null;
            element3 = element2;
        }
        if (bl2) {
            type = arrayList3.toArray();
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                partConfig = (ReferencePartConfig.PartConfig)iterator.next();
                partList = (PartList)SignatureGenerator.getNoncePart(document, (Object[])type, partConfig, "encryption_mode", this._selectors, class$com$ibm$ws$webservices$wssecurity$util$ConfidentialDialectElementSelector == null ? EncryptionGenerator.class$("com.ibm.ws.webservices.wssecurity.util.ConfidentialDialectElementSelector") : class$com$ibm$ws$webservices$wssecurity$util$ConfidentialDialectElementSelector, hashMap);
            }
        }
        EncryptionGenerator.encrypt(encryptionGeneratorConfig.getEncryptionKeyInfo(), hashMap2, this._selectors, document, map, encryptionGeneratorConfig.remainSignatureAfterEncryption(), arrayList2, arrayList, encryptionContext, element2, encryptedData, key, wSSGeneratorConfig.isUserDefinedComponentsUsed());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc,Element parent,Map context)");
        }
    }

    private static EncryptedKey createEncryptedKey(EncryptionGeneratorConfig encryptionGeneratorConfig, List list, WSSAlgorithmFactory wSSAlgorithmFactory, Document document, String string, String string2, String string3, boolean bl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptedKey(EncryptionGeneratorConfig config,List ids[" + list + "]," + "WSSAlgorithmFactory factory[" + wSSAlgorithmFactory + "]," + "Document doc[" + DOMUtil.getDisplayName(document) + "]," + "String nsSoap[" + string + "]," + "String nsWsse[" + string2 + "]," + "String nsWsu[" + string3 + "]," + "boolean userDefinedComponentsUsed[" + bl + "])");
        }
        EncryptedKey encryptedKey = new EncryptedKey();
        encryptedKey.setEncryptionMethod(EncryptionGenerator.createEncryptionMethod(encryptionGeneratorConfig.getKeyEncryptionMethod(), wSSAlgorithmFactory));
        if (bl) {
            encryptedKey.setKeyInfo(EncryptionGenerator.createKeyInfo(document));
        }
        encryptedKey.setCipherData(EncryptionGenerator.createCipherData());
        encryptedKey.setReferenceList(EncryptionGenerator.createReferenceList(list, document, string, string2, string3));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptedKey(EncryptionGeneratorConfig config,List ids,WSSAlgorithmFactory factory,Document doc,String nsSoap,String nsWsse,String nsWsu,boolean userDefinedComponentsUsed) returns EncryptedKey[" + encryptedKey + "]");
        }
        return encryptedKey;
    }

    private static EncryptionMethod createEncryptionMethod(AlgorithmConfig algorithmConfig, WSSAlgorithmFactory wSSAlgorithmFactory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptionMethod(AlgorithmConfig aconfig[" + algorithmConfig + "]," + "WSSAlgorithmFactory factory[" + wSSAlgorithmFactory + "])");
        }
        EncryptionMethod encryptionMethod = new EncryptionMethod();
        encryptionMethod.setAlgorithm(algorithmConfig.getAlgorithm());
        try {
            AlgorithmParameterSpec algorithmParameterSpec = wSSAlgorithmFactory.convertParameter(algorithmConfig.getAlgorithm(), algorithmConfig.getProperties());
            if (algorithmParameterSpec != null) {
                encryptionMethod.setParameterSpec(wSSAlgorithmFactory, algorithmParameterSpec);
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            Tr.processException(invalidAlgorithmParameterException, clsName + ".createEncryptionMethod", "493");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s14", new Object[]{invalidAlgorithmParameterException});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s14", invalidAlgorithmParameterException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Tr.processException(noSuchAlgorithmException, clsName + ".createEncryptionMethod", "497");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s14", new Object[]{noSuchAlgorithmException});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s14", noSuchAlgorithmException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptionMethod(AlgorithmConfig aconfig,WSSAlgorithmFactory factory) returns EncryptionMethod[" + encryptionMethod + "]");
        }
        return encryptionMethod;
    }

    private static KeyInfo createKeyInfo(Document document) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKeyInfo(Document doc[" + DOMUtil.getDisplayName(document) + "])");
        }
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.addElement(document.createElement("dummy"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyInfo(Document doc) returns KeyInfo[" + keyInfo + "]");
        }
        return keyInfo;
    }

    private static CipherData createCipherData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCipherData()");
        }
        CipherValue cipherValue = new CipherValue();
        CipherData cipherData = new CipherData();
        cipherData.setCipherValue(cipherValue);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCipherData() returns CipherData[" + cipherData + "]");
        }
        return cipherData;
    }

    private static ReferenceList createReferenceList(List list, Document document, String string, String string2, String string3) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createReferenceList(List ids[" + list + "]," + "Document doc[" + DOMUtil.getDisplayName(document) + "]," + "String nsSoap[" + string + "]," + "String nsWsse[" + string2 + "]," + "String nsWsu[" + string3 + "])");
        }
        ReferenceList referenceList = new ReferenceList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            DataReference dataReference = new DataReference();
            dataReference.setURI("#" + string4);
            referenceList.addDataReference(dataReference);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createReferenceList(List ids,Document doc,String nsSoap,String nsWsse,String nsWsu) returns ReferenceList[" + referenceList + "]");
        }
        return referenceList;
    }

    private static EncryptedData createEncryptedData(EncryptionGeneratorConfig encryptionGeneratorConfig, Document document, boolean bl, WSSAlgorithmFactory wSSAlgorithmFactory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptedData(EncryptionGeneratorConfig config,Document doc[" + DOMUtil.getDisplayName(document) + "]," + "boolean createKeyInfo[" + bl + "]," + "WSSAlgorithmFactory factory[" + wSSAlgorithmFactory + "])");
        }
        EncryptedData encryptedData = new EncryptedData();
        encryptedData.setEncryptionMethod(EncryptionGenerator.createEncryptionMethod(encryptionGeneratorConfig.getDataEncryptionMethod(), wSSAlgorithmFactory));
        if (bl) {
            encryptedData.setKeyInfo(EncryptionGenerator.createKeyInfo(document));
        }
        encryptedData.setCipherData(EncryptionGenerator.createCipherData());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptedData(EncryptionGeneratorConfig config,Document doc,boolean createKeyInfo,WSSAlgorithmFactory factory) returns EncryptedData[" + encryptedData + "]");
        }
        return encryptedData;
    }

    private static Key generateKey(EncryptionContext encryptionContext, EncryptedData encryptedData, Document document, Key key) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKey(EncryptionContext econtext[" + encryptionContext + "]," + "EncryptedData ed[" + encryptedData + "]," + "Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Key kek[" + key + "])");
        }
        Key key2 = null;
        try {
            encryptionContext.setEncryptedType(encryptedData.createElement(document, true), null, null, null);
            key2 = encryptionContext.generateKey();
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".generateKey", "638");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s11", new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s11", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateKey(EncryptionContext econtext,EncryptedData ed,Document doc,Key kek) returns Key[" + key2 + "]");
        }
        return key2;
    }

    private static void encrypt(KeyInfoGeneratorConfig keyInfoGeneratorConfig, Map map, Map map2, Document document, Map map3, boolean bl, List list, List list2, EncryptionContext encryptionContext, Element element, EncryptedData encryptedData, Key key, boolean bl2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encrypt(KeyInfoGeneratorConfig config,Map type,Map properties,Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Map context," + "boolean sigAfterEnc," + "List pList[" + list + "]," + "List idList[" + list2 + "]," + "EncryptionContext econtext[" + encryptionContext + "]," + "Element einfo[" + DOMUtil.getDisplayName(element) + "]," + "EncryptedData ed[" + encryptedData + "]," + "Key dek[" + key + "], " + "boolean userDefinedComponentsUsed[" + bl2 + "])");
        }
        if (key == null && bl2) {
            encryptedData.setKeyInfo(EncryptionGenerator.createKeyInfo(document));
        }
        RequestMessagePool.addDocument(map3, document, list, bl);
        try {
            int n = list2.size() - 1;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PartList partList = (PartList)iterator.next();
                for (int i = 0; i < partList.getLength(); ++i) {
                    String string = partList.getType();
                    Element element2 = (Element)partList.item(i);
                    String string2 = (String)list2.get(n--);
                    encryptedData.setId(string2);
                    encryptedData.setType(string);
                    encryptionContext.setData(element2);
                    Element element3 = encryptedData.createElement(document, true);
                    if (key == null) {
                        Key key2 = SignatureGenerator.callKeyInfoGenerator(keyInfoGeneratorConfig, "EncryptingKey", map, map2, document, element3, map3);
                        String string3 = null;
                        if (key2 instanceof PKCS11Key && !encryptionContext.shouldChangeProvider() && !encryptionContext.useHWKeyStore()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "PKCS11 Key is in use, but did not find hardware keystore/acceleration in the config");
                            }
                            if ((string3 = (String)map.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore")) != null) {
                                encryptionContext.setHWKeyStoreName(string3);
                                if (encryptionContext.useHWKeyStore()) {
                                    Provider provider;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "HARDWARE Key Store Name is: ", encryptionContext.getHWKeyStoreName());
                                    }
                                    if ((provider = ConfigUtil.getHWCryptoProviderInstance(encryptionContext.getHWKeyStoreName())) == null) {
                                        Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                                    } else {
                                        encryptionContext.setHWKeyStoreProvider(provider);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + provider.getName());
                                        }
                                    }
                                } else {
                                    Tr.error(tc, "Missing Hardware KeyStore Configuration, cannot use the PKCS11 type for encrypt/decrypt");
                                    throw SoapSecurityException.format("Missing Hardware KeyStore Configuration");
                                }
                            }
                        }
                        encryptionContext.setKey(key2);
                    } else {
                        encryptionContext.setKey(key);
                    }
                    encryptionContext.setEncryptedType(element3, null, null, null);
                    encryptionContext.encrypt();
                    encryptionContext.replace();
                    RequestMessagePool.addElement(map3, element2, encryptionContext.getEncryptedTypeAsElement(), element);
                }
            }
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".encrypt", "730");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s12", new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s12", exception);
        }
        finally {
            encryptionContext.clearLocalProviderMap();
            if (encryptionContext.isHWAccelerationProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance(encryptionContext.getHWConfigName(), encryptionContext.getHWAccelerationProvider());
            }
            if (encryptionContext.isHWKeyStoreProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance(encryptionContext.getHWKeyStoreName(), encryptionContext.getHWKeyStoreProvider());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encrypt(KeyInfoGeneratorConfig config,Map type,Map properties,Document doc,Map context,boolean sigAfterEnc,List pList,List idList,EncryptionContext econtext,Element einfo,EncryptedData ed,Document doc,Key dek, boolean userDefinedComponentsUsed)");
        }
    }

    private static void encryptKey(Map map, EncryptionContext encryptionContext, Element element, Document document, Key key, Key key2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptKey(EncryptionContext econtext[" + encryptionContext + "]," + "EncryptedData ed[" + element + "]," + "Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Key dek[" + key + "]," + "Key kek[" + key2 + "])");
        }
        try {
            encryptionContext.setData(key);
            encryptionContext.setEncryptedType(element, null, null, null);
            if (encryptionContext.isHWAccelerationProvider()) {
                encryptionContext.setHWKeyFromCache((PublicKey)key2);
            } else {
                encryptionContext.setKey(key2);
            }
            encryptionContext.encrypt();
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".encryptKey", "776");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s13", new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s13", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptKey(EncryptionContext econtext,EncryptedData ed,Document doc,Key dek,Key kek)");
        }
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showEncryptedResource(byte[] byArray, Object object, Element element) {
            String string = null;
            try {
                string = EncryptedData.isOfType(element) ? new String(byArray, "UTF-8") : Base64.encode(byArray);
            }
            catch (Exception exception) {
                Tr.debug(tc, "WARNING: An exception occured while the content is encoded with [UTF-8].");
            }
            if (EncryptedData.isOfType(element)) {
                Tr.debug(tc, "ResourceShower logs encrypt-" + element.getAttribute("Id") + ": " + string);
            } else {
                Tr.debug(tc, "ResourceShower logs encrypt-EncryptedKey: " + string);
            }
        }
    }
}

