/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.BasicAuth;
import com.ibm.etools.webservice.wscbnd.LoginBinding;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestSenderBindingConfig;
import com.ibm.etools.webservice.wscext.LoginConfig;
import com.ibm.etools.webservice.wscext.SecurityRequestSenderServiceConfig;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonext.AddCreatedTimeStamp;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.IDAssertion;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wscommonext.ReferencePart;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ClientVariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.confimpl.PrivateSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public class WSEMFRequestSenderConfig
extends PrivateSenderConfig {
    private String wsseNS = com.ibm.xml.soapsec.Constants.NS_WSSE;
    private String wsuNS = com.ibm.xml.soapsec.Constants.NS_WSU;
    private String origin = "non-ws-security";
    private static final TraceComponent tc = Tr.register(WSEMFRequestSenderConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSEMFRequestSenderConfig.class.getName();

    public WSEMFRequestSenderConfig(SecurityRequestSenderBindingConfig securityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig securityRequestSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService) throws SoapSecurityException {
        this(securityRequestSenderBindingConfig, securityRequestSenderServiceConfig, string, variableMap, wSSecurityService, null, null);
    }

    public WSEMFRequestSenderConfig(SecurityRequestSenderBindingConfig securityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig securityRequestSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService, ClassLoader classLoader) throws SoapSecurityException {
        this(securityRequestSenderBindingConfig, securityRequestSenderServiceConfig, string, variableMap, wSSecurityService, null, null);
    }

    public WSEMFRequestSenderConfig(SecurityRequestSenderBindingConfig securityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig securityRequestSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService, ClassLoader classLoader, PortQnameBinding portQnameBinding) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFRequestSenderConfig(SecurityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader, portQnBnd):", new Object[]{securityRequestSenderBindingConfig, securityRequestSenderServiceConfig, string, variableMap, wSSecurityService, classLoader});
        }
        this.init(securityRequestSenderBindingConfig, securityRequestSenderServiceConfig, string, variableMap, wSSecurityService, classLoader, portQnameBinding);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFRequestSenderConfig()");
        }
    }

    WSEMFRequestSenderConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFRequestSenderConfig()");
            Tr.exit(tc, "WSEMFRequestSenderConfig()");
        }
    }

    final void init(SecurityRequestSenderBindingConfig securityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig securityRequestSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService, ClassLoader classLoader, PortQnameBinding portQnameBinding) throws SoapSecurityException {
        Object object;
        KeyEncryptionMethod keyEncryptionMethod;
        Object object2;
        BasicAuth basicAuth;
        String string2;
        Object object3;
        Object object4;
        String string3;
        ReferencePart referencePart;
        Reference reference;
        int n;
        String string4;
        Object object5;
        Object object6;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(SecurityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig, actorURI, VariableMap, Object, ClassLoader, portQnBnd):", new Object[]{securityRequestSenderBindingConfig, securityRequestSenderServiceConfig, string, variableMap, wSSecurityService, classLoader});
        }
        AddCreatedTimeStamp addCreatedTimeStamp = null;
        Confidentiality confidentiality = null;
        Integrity integrity = null;
        LoginConfig loginConfig = null;
        IDAssertion iDAssertion = null;
        String string5 = null;
        if (variableMap == null) {
            variableMap = ClientVariableMap.getInstance();
        }
        WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = null;
        if (wSSecurityService != null && (object6 = wSSecurityService.getConfig()) instanceof WSSecurityDefaultConfiguration) {
            wSSecurityDefaultConfiguration = (WSSecurityDefaultConfiguration)object6;
        }
        object6 = null;
        Map map = null;
        Map map2 = null;
        Map map3 = null;
        this._properties = new HashMap();
        if (wSSecurityDefaultConfiguration != null) {
            object5 = wSSecurityDefaultConfiguration.getDefaultGeneratorBinding();
            if (object5 != null) {
                object6 = object5.getProperties();
                if (object6 != null) {
                    this._properties.putAll(object6);
                }
            } else {
                object6 = wSSecurityDefaultConfiguration.getProperties();
                if (object6 != null) {
                    this._properties.putAll(object6);
                }
            }
        }
        if (securityRequestSenderServiceConfig != null && (object5 = securityRequestSenderServiceConfig.getProperties()) != null && (map = ConfigConstants.getProperties((EList)object5, variableMap)) != null) {
            this._properties.putAll(map);
        }
        if (portQnameBinding != null && (object5 = portQnameBinding.getParameters()) != null && (map3 = ConfigConstants.getProperties((EList)object5, variableMap)) != null) {
            this._properties.putAll(map3);
        }
        if (securityRequestSenderBindingConfig != null && (object5 = securityRequestSenderBindingConfig.getProperties()) != null && (map2 = ConfigConstants.getProperties((EList)object5, variableMap)) != null) {
            this._properties.putAll(map2);
        }
        if (securityRequestSenderServiceConfig != null) {
            confidentiality = securityRequestSenderServiceConfig.getConfidentiality();
            integrity = securityRequestSenderServiceConfig.getIntegrity();
            string5 = securityRequestSenderServiceConfig.getActor();
            loginConfig = securityRequestSenderServiceConfig.getLoginConfig();
            iDAssertion = securityRequestSenderServiceConfig.getIdAssertion();
            addCreatedTimeStamp = securityRequestSenderServiceConfig.getAddCreatedTimeStamp();
            if (tc.isDebugEnabled()) {
                if (map != null) {
                    Tr.debug(tc, "Request Sender Service Config(Confidentiality, Integrity, Actor, LoginConfig, IdAssertion, AddCreatedTimeStamp, Properties):", new Object[]{confidentiality, integrity, string5, loginConfig, iDAssertion, addCreatedTimeStamp, map});
                } else {
                    Tr.debug(tc, "Request Sender Service Config(Confidentiality, Integrity, Actor, LoginConfig, IdAssertion, AddCreatedTimeStamp):", new Object[]{confidentiality, integrity, string5, loginConfig, iDAssertion, addCreatedTimeStamp});
                }
            }
        }
        this.clientSetMustUnderstand = ConfigUtil.getIsFalseProperty(this._properties, Constants.WSSECURITY_SET_MUSTUNDERSTAND);
        object5 = new ConfigValidation(variableMap, wSSecurityDefaultConfiguration);
        if (!((ConfigValidation)object5).confidentialityValid(confidentiality)) {
            throw new SoapSecurityException("Invalid Confidentiality");
        }
        if (!((ConfigValidation)object5).integrityValid(integrity)) {
            throw new SoapSecurityException("Invalid Integrity");
        }
        if (!((ConfigValidation)object5).idAssertionValid(iDAssertion)) {
            throw new SoapSecurityException("Invalid IDAssertion");
        }
        if (string != null) {
            string4 = string.trim();
            if (string4.length() != 0) {
                this.myactor = string4;
            }
        } else {
            this.myactor = null;
        }
        if (string5 != null) {
            string4 = string5.trim();
            if (string4.length() != 0) {
                this.targetactor = string4;
            }
        } else {
            this.targetactor = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "actorURI = " + this.myactor + ", actor = " + this.targetactor);
        }
        if (addCreatedTimeStamp != null) {
            this.enableCreatedTimestamp = addCreatedTimeStamp.isFlag();
            string4 = addCreatedTimeStamp.getExpires();
            if (string4 != null && string4.length() > 0) {
                try {
                    this.duration = Duration.parse(string4);
                }
                catch (ParseException parseException) {
                    String string6 = "security.wssecurity.CommonSenderConfig.sconf07";
                    FFDCFilter.processException((Throwable)parseException, clsName + ".WSEMFRequestSenderConfig", "205", this);
                    Tr.error(tc, string6, string4);
                    throw SoapSecurityException.format(string6, string4, (Throwable)parseException);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addCreatedTimeStamp = " + this.enableCreatedTimestamp + ", expires = " + addCreatedTimeStamp.getExpires() + ", duration = " + this.duration);
            }
        }
        if (integrity != null) {
            int n2 = integrity.getReferences().size();
            for (n = 0; n < n2; ++n) {
                reference = (Reference)integrity.getReferences().get(n);
                referencePart = reference.getPart();
                string3 = referencePart.getName();
                this.integralParts.add(string3);
                if (!string3.equals("securitytoken")) continue;
                this.isSecTokenSigned = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "integrity constraints = " + this.integralParts + "signed security token = " + this.isSecTokenSigned);
            }
        }
        if (confidentiality != null) {
            int n3 = confidentiality.getConfidentialParts().size();
            for (n = 0; n < n3; ++n) {
                reference = (ConfidentialPart)confidentiality.getConfidentialParts().get(n);
                referencePart = reference.getPart();
                string3 = referencePart.getName();
                this.confidentialParts.add(string3);
                if (!string3.equals("usernametoken")) continue;
                this.isUsernameTokenEncrypted = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "confidentiality constraints = " + this.confidentialParts + "encrypt username token = " + this.isUsernameTokenEncrypted);
            }
        }
        if (iDAssertion != null) {
            this.idType = iDAssertion.getIdType();
            this.idType = this.idType == null ? this.idType : this.idType.trim();
            this.trustMode = iDAssertion.getTrustMode();
            String string7 = this.trustMode = this.trustMode == null ? this.trustMode : this.trustMode.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IDType = " + this.idType + "Trust Mode = " + this.trustMode);
            }
        }
        this.nonceManager = NonceManagerFactory.getInstance();
        if (loginConfig != null) {
            this.authMethod = loginConfig.getAuthMethod().trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AuthMethod = " + this.authMethod);
            }
            if (map != null && !map.isEmpty()) {
                String string8 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce");
                if (string8 != null) {
                    if ((string8 = string8.trim()).length() != 0) {
                        this.addNonce = Boolean.valueOf(string8);
                        if (this.addNonce) {
                            if (!"BasicAuth".equals(this.authMethod)) {
                                this.addNonce = false;
                                this.addNonceTimestamp = false;
                                Tr.warning(tc, "security.wssecurity.WSEC0113W", new Object[]{this.authMethod});
                            } else {
                                this.addNonceTimestamp = true;
                            }
                        }
                    }
                } else {
                    this.addNonce = false;
                    this.addNonceTimestamp = false;
                }
                if ((string8 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestamp")) != null && (string8 = string8.trim()).length() != 0) {
                    this.addNonceTimestamp = Boolean.valueOf(string8);
                    if (this.addNonceTimestamp && !this.addNonce) {
                        this.addNonceTimestamp = false;
                        Tr.warning(tc, "security.wssecurity.WSEC0114W");
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce enabled: " + this.addNonce + ", Nonce timestamp: " + this.addNonceTimestamp);
            }
        }
        EncryptionInfo encryptionInfo = null;
        EList eList = null;
        reference = null;
        referencePart = null;
        if (securityRequestSenderBindingConfig != null) {
            encryptionInfo = securityRequestSenderBindingConfig.getEncryptionInfo();
            eList = securityRequestSenderBindingConfig.getKeyLocators();
            reference = securityRequestSenderBindingConfig.getLoginBinding();
            referencePart = securityRequestSenderBindingConfig.getSigningInfo();
            if (tc.isDebugEnabled()) {
                if (map2 != null) {
                    Tr.debug(tc, "Request Sender Service Config (EncryptionInfo, KeyLocators, LoginBinding, SigningInfo, Properties):", new Object[]{encryptionInfo, eList, reference, referencePart, map2});
                } else {
                    Tr.debug(tc, "Request Sender Service Config (EncryptionInfo, KeyLocators, LoginBinding, SigningInfo):", new Object[]{encryptionInfo, eList, reference, referencePart});
                }
            }
            if (map2 != null || map2.size() != 0) {
                string3 = (String)map2.get("com.ibm.ws.wssecurity.config.WSSE.Namespace");
                if (string3 != null && string3.length() != 0) {
                    if (!NamespaceUtil.isWsse(string3)) {
                        throw SoapSecurityException.format("security.wssecurity.WSEC0152E", string3);
                    }
                    this.wsseNS = string3;
                    this.wsuNS = NamespaceUtil.getCorrespondingWSUNS(this.wsseNS);
                }
                object4 = (String)map2.get(Constants.WSSECURITY_INCLUSIVE_NAMESPACES);
                this.inclusiveNamespaces = ConfigUtil.isTrue((String)object4);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Namespace configured to be used to send the request, wsse=" + this.wsseNS + ", wsu=" + this.wsuNS);
            }
        }
        if (!((ConfigValidation)object5).senderSigningInfoValid((SigningInfo)referencePart, null, null, integrity)) {
            throw new SoapSecurityException("Invalid sender SigningInfo");
        }
        if (!((ConfigValidation)object5).encryptionInfoValid(encryptionInfo, eList, confidentiality)) {
            throw new SoapSecurityException("Invalid EncryptionInfo");
        }
        if (!((ConfigValidation)object5).loginBindingValid((LoginBinding)reference, loginConfig)) {
            throw new SoapSecurityException("Invalid LoginBinding");
        }
        if (encryptionInfo != null) {
            string3 = encryptionInfo.getName();
            object4 = encryptionInfo.getEncryptionKey();
            object3 = null;
            string2 = null;
            if (object4 != null) {
                object3 = object4.getName();
                string2 = object4.getLocatorRef();
            }
            basicAuth = encryptionInfo.getEncryptionMethod();
            object2 = null;
            if (basicAuth != null) {
                object2 = basicAuth.getAlgorithm();
            }
            keyEncryptionMethod = encryptionInfo.getKeyEncryptionMethod();
            String string9 = null;
            if (keyEncryptionMethod != null) {
                string9 = keyEncryptionMethod.getAlgorithm();
            }
            object = ConfigConstants.findKeyLocator(eList, string2, variableMap, wSSecurityDefaultConfiguration, classLoader);
            if (object2 == null || object3 == null || object == null) {
                String string10 = "security.wssecurity.IncompleteEncryptionInfo";
                if (object2 == null) {
                    Tr.warning(tc, string10, "Data Encryption Algorithm");
                }
                if (object3 == null) {
                    Tr.warning(tc, string10, "Encryption Key Name");
                }
                if (object == null) {
                    Tr.warning(tc, string10, "Key Locator");
                }
            }
            this.encryptionSettings = new EncryptionSettings((String)object2, string9, (String)object3, (KeyLocator)object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Encryption Info Name = " + string3 + "Encryption Key Name = " + (String)object3 + "Encryption KeyLocatorRef = " + string2 + "Encryption Data Algorithm = " + (String)object2 + "Encryption Key Algorithm = " + string9);
            }
        }
        if (reference != null) {
            string3 = null;
            object4 = null;
            object3 = null;
            string2 = null;
            basicAuth = reference.getBasicAuth();
            if (basicAuth != null) {
                object4 = basicAuth.getUserid();
                object3 = basicAuth.getPassword().toCharArray();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Basic-Auth(" + (String)object4 + ", XXXXXXXX)");
                }
            }
            if ((object2 = reference.getTokenValueType()) != null) {
                this.tokenValueType = new QName(object2.getUri(), object2.getLocalName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TokenValue(" + object2.getUri() + ", " + object2.getLocalName() + ")");
                }
            }
            string3 = reference.getCallbackHandler();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CallbackHandler Class Name = " + string3);
            }
            int n4 = reference.getProperties().size();
            for (int i = 0; i < n4; ++i) {
                object = (Property)reference.getProperties().get(i);
                if (variableMap == null) {
                    string2.put(object.getName(), object.getValue());
                } else {
                    string2.put(object.getName(), variableMap.expand(object.getValue()));
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "CallbackHandler Properties = " + string2);
            }
            if (string3 != null) {
                try {
                    Class<?> clazz = Class.forName(string3);
                    object = clazz.getConstructor(String.class, [C.class, Map.class);
                    this.callbackHandler = (CallbackHandler)((Constructor)object).newInstance(object4, object3, string2);
                }
                catch (Exception exception) {
                    throw SoapSecurityException.format(com.ibm.xml.soapsec.Constants.getQName(this.getWSSENS(), "InvalidSecurity"), "security.wssecurity.RequestSenderConfig.token28", exception.toString());
                }
            }
        }
        if (referencePart != null) {
            string3 = referencePart.getCanonicalizationMethod();
            object4 = null;
            if (string3 == null) {
                Tr.warning(tc, "security.wssecurity.nocanonicalization.algo");
            } else {
                object4 = string3.getAlgorithm();
            }
            this.c14nMethod = object4;
            object3 = referencePart.getSignatureMethod();
            string2 = null;
            if (object3 == null) {
                Tr.warning(tc, "security.wssecurity.nosignature.algo");
            } else {
                string2 = object3.getAlgorithm();
            }
            this.signatureMethod = string2;
            basicAuth = referencePart.getDigestMethod();
            object2 = null;
            if (basicAuth == null) {
                Tr.warning(tc, "security.wssecurity.nodigest.algo");
            } else {
                object2 = basicAuth.getAlgorithm();
            }
            this.digestMethod = object2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Signature Canonicalization Algorithm = " + this.c14nMethod + "Signature Algorithm = " + this.signatureMethod + "Signature Digest Algorithm = " + this.digestMethod);
            }
            if ((keyEncryptionMethod = referencePart.getSigningKey()) != null) {
                String string11 = keyEncryptionMethod.getLocatorRef();
                this.keyName = keyEncryptionMethod.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Signature Keyname = " + this.keyName + "Signature KeyLocatorRef = " + string11);
                }
                this.keyLocator = ConfigConstants.findKeyLocator(eList, string11, variableMap, wSSecurityDefaultConfiguration, classLoader);
            }
        }
        this.processPrivateConfig(DOMUtil.getPrivateConfig(true));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogProperties((Map)object6, map3, map, map2, "request", "sender"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    final String getOrigin() {
        return this.origin;
    }

    final String getWSSENS() {
        return this.wsseNS;
    }

    final String getWSUNS() {
        return this.wsuNS;
    }
}

