/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.SecurityResponseSenderBindingConfig;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonext.AddCreatedTimeStamp;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wsext.SecurityResponseSenderServiceConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.confimpl.PrivateSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Duration;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class WSEMFResponseSenderConfig
extends PrivateSenderConfig {
    private String origin = "non-ws-security";
    private static final TraceComponent tc = Tr.register(WSEMFResponseSenderConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSEMFResponseSenderConfig.class.getName();

    public WSEMFResponseSenderConfig(SecurityResponseSenderBindingConfig securityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig securityResponseSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService) throws SoapSecurityException {
        this(securityResponseSenderBindingConfig, securityResponseSenderServiceConfig, string, variableMap, wSSecurityService, null, null);
    }

    public WSEMFResponseSenderConfig(SecurityResponseSenderBindingConfig securityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig securityResponseSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService, ClassLoader classLoader) throws SoapSecurityException {
        this(securityResponseSenderBindingConfig, securityResponseSenderServiceConfig, string, variableMap, wSSecurityService, null, null);
    }

    public WSEMFResponseSenderConfig(SecurityResponseSenderBindingConfig securityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig securityResponseSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService, ClassLoader classLoader, PCBinding pCBinding) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFResponseSenderConfig(SecurityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader, portCmpBnd):", new Object[]{securityResponseSenderBindingConfig, securityResponseSenderServiceConfig, string, variableMap, wSSecurityService, classLoader});
        }
        this.init(securityResponseSenderBindingConfig, securityResponseSenderServiceConfig, string, variableMap, wSSecurityService, classLoader, pCBinding);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFResponseSenderConfig()");
        }
    }

    WSEMFResponseSenderConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFResponseSenderConfig()");
            Tr.exit(tc, "WSEMFResponseSenderConfig()");
        }
    }

    final void init(SecurityResponseSenderBindingConfig securityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig securityResponseSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService, ClassLoader classLoader, PCBinding pCBinding) throws SoapSecurityException {
        Object object;
        String string2;
        Object object2;
        String string3;
        Object object3;
        String string4;
        String string5;
        String string6;
        Reference reference;
        int n;
        String string7;
        boolean bl;
        WSSGeneratorConfig wSSGeneratorConfig;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(SecurityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader, portCmpBnd):", new Object[]{securityResponseSenderBindingConfig, securityResponseSenderServiceConfig, string, variableMap, wSSecurityService, classLoader});
        }
        AddCreatedTimeStamp addCreatedTimeStamp = null;
        Confidentiality confidentiality = null;
        Integrity integrity = null;
        String string8 = null;
        WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = null;
        if (wSSecurityService != null && (object4 = wSSecurityService.getConfig()) instanceof WSSecurityDefaultConfiguration) {
            wSSecurityDefaultConfiguration = (WSSecurityDefaultConfiguration)object4;
        }
        object4 = null;
        Map map = null;
        Map map2 = null;
        Map map3 = null;
        this._properties = new HashMap();
        if (wSSecurityDefaultConfiguration != null) {
            wSSGeneratorConfig = wSSecurityDefaultConfiguration.getDefaultGeneratorBinding();
            if (wSSGeneratorConfig != null) {
                object4 = wSSGeneratorConfig.getProperties();
                if (object4 != null) {
                    this._properties.putAll(object4);
                }
            } else {
                object4 = wSSecurityDefaultConfiguration.getProperties();
                if (object4 != null) {
                    this._properties.putAll(object4);
                }
            }
        }
        if (securityResponseSenderServiceConfig != null && (wSSGeneratorConfig = securityResponseSenderServiceConfig.getProperties()) != null && (map = ConfigConstants.getProperties((EList)wSSGeneratorConfig, variableMap)) != null) {
            this._properties.putAll(map);
        }
        if (pCBinding != null && (wSSGeneratorConfig = pCBinding.getParameters()) != null && (map3 = ConfigConstants.getProperties((EList)wSSGeneratorConfig, variableMap)) != null) {
            this._properties.putAll(map3);
        }
        if (securityResponseSenderBindingConfig != null && (wSSGeneratorConfig = securityResponseSenderBindingConfig.getProperties()) != null && (map2 = ConfigConstants.getProperties((EList)wSSGeneratorConfig, variableMap)) != null) {
            this._properties.putAll(map2);
        }
        if (securityResponseSenderServiceConfig != null) {
            addCreatedTimeStamp = securityResponseSenderServiceConfig.getAddCreatedTimestamp();
            confidentiality = securityResponseSenderServiceConfig.getConfidentiality();
            integrity = securityResponseSenderServiceConfig.getIntegrity();
            string8 = securityResponseSenderServiceConfig.getActor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Response Sender Service Config (AddCreatedTimestamp, Confidentiality, Integrity, targetActor):", new Object[]{addCreatedTimeStamp, confidentiality, integrity, string8});
            }
        }
        this.serviceGetMustUnderstand = !(bl = ConfigUtil.getIsTrueProperty(this._properties, Constants.WSSECURITY_GET_MUSTUNDERSTAND));
        ConfigValidation configValidation = new ConfigValidation(variableMap, wSSecurityDefaultConfiguration);
        if (!configValidation.confidentialityValid(confidentiality)) {
            throw new SoapSecurityException("Invalid Confidentiality");
        }
        if (!configValidation.integrityValid(integrity)) {
            throw new SoapSecurityException("Invalid Integrity");
        }
        if (string != null) {
            string7 = string.trim();
            if (string7.length() != 0) {
                this.myactor = string7;
            }
        } else {
            this.myactor = null;
        }
        if (string8 != null) {
            string7 = string8.trim();
            if (string7.length() != 0) {
                this.targetactor = string7;
            }
        } else {
            this.targetactor = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "actorURI = " + this.myactor + ", actor = " + this.targetactor);
        }
        this.enableCreatedTimestamp = false;
        this.duration = null;
        if (addCreatedTimeStamp != null) {
            this.enableCreatedTimestamp = addCreatedTimeStamp.isFlag();
            string7 = addCreatedTimeStamp.getExpires();
            if (string7 != null && string7.length() > 0) {
                try {
                    this.duration = Duration.parse(string7);
                }
                catch (ParseException parseException) {
                    String string9 = "security.wssecurity.CommonSenderConfig.sconf07";
                    FFDCFilter.processException((Throwable)parseException, clsName + ".WSEMFResponseSenderConfig", "178", this);
                    Tr.error(tc, string9, string7);
                    throw SoapSecurityException.format(string9, string7, (Throwable)parseException);
                }
            }
        }
        if (integrity != null) {
            int n2 = integrity.getReferences().size();
            for (n = 0; n < n2; ++n) {
                reference = (Reference)integrity.getReferences().get(n);
                string6 = reference.getPart();
                string5 = string6.getName();
                this.integralParts.add(string5);
                if (!string5.equals("securitytoken")) continue;
                this.isSecTokenSigned = true;
            }
        }
        if (confidentiality != null) {
            int n3 = confidentiality.getConfidentialParts().size();
            for (n = 0; n < n3; ++n) {
                reference = (ConfidentialPart)confidentiality.getConfidentialParts().get(n);
                string6 = reference.getPart();
                string5 = string6.getName();
                this.confidentialParts.add(string5);
                if (!string5.equals("usernametoken")) continue;
                this.isUsernameTokenEncrypted = true;
            }
        }
        EncryptionInfo encryptionInfo = null;
        EList eList = null;
        reference = null;
        if (securityResponseSenderBindingConfig != null) {
            encryptionInfo = securityResponseSenderBindingConfig.getEncryptionInfo();
            eList = securityResponseSenderBindingConfig.getKeyLocators();
            reference = securityResponseSenderBindingConfig.getSigningInfo();
            string6 = securityResponseSenderBindingConfig.getProperties();
            if (string6 != null) {
                map2 = ConfigConstants.getProperties((EList)string6, variableMap);
            }
            if (tc.isDebugEnabled()) {
                if (map2 != null) {
                    Tr.debug(tc, "Response Sender Binding Config (EncryptionInfo, KeyLocators, SigningInfo, Property):", new Object[]{encryptionInfo, eList, reference, map2});
                } else {
                    Tr.debug(tc, "Response Sender Binding Config (EncryptionInfo, KeyLocators, SigningInfo):", new Object[]{encryptionInfo, eList, reference});
                }
            }
        }
        if (map2 != null || map2.size() != 0) {
            string6 = (String)map2.get(Constants.WSSECURITY_INCLUSIVE_NAMESPACES);
            this.inclusiveNamespaces = ConfigUtil.isTrue(string6);
        }
        if (!configValidation.senderSigningInfoValid((SigningInfo)reference, null, null, integrity)) {
            throw new SoapSecurityException("Invalid sender SigningInfo");
        }
        if (!configValidation.encryptionInfoValid(encryptionInfo, eList, confidentiality)) {
            throw new SoapSecurityException("Invalid EncryptionInfo");
        }
        if (encryptionInfo != null) {
            string6 = encryptionInfo.getEncryptionKey();
            string5 = null;
            string4 = null;
            if (string6 != null) {
                string5 = string6.getName();
                string4 = string6.getLocatorRef();
            }
            object3 = encryptionInfo.getEncryptionMethod();
            string3 = null;
            if (object3 != null) {
                string3 = object3.getAlgorithm();
            }
            object2 = encryptionInfo.getKeyEncryptionMethod();
            string2 = null;
            if (object2 != null) {
                string2 = object2.getAlgorithm();
            }
            object = ConfigConstants.findKeyLocator(eList, string4, variableMap, wSSecurityDefaultConfiguration, classLoader);
            if (string3 == null || string5 == null || object == null) {
                String string10 = "security.wssecurity.IncompleteEncryptionInfo";
                if (string3 == null) {
                    Tr.warning(tc, string10, "Data Encryption Algorithm");
                }
                if (string5 == null) {
                    Tr.warning(tc, string10, "Encryption Key Name");
                }
                if (object == null) {
                    Tr.warning(tc, string10, "Key Locator");
                }
            }
            this.encryptionSettings = new EncryptionSettings(string3, string2, string5, (KeyLocator)object);
        }
        if (reference != null) {
            string6 = reference.getCanonicalizationMethod();
            string5 = null;
            if (string6 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No CanonicalizationMethod defined");
                }
            } else {
                string5 = string6.getAlgorithm();
            }
            this.c14nMethod = string5;
            string4 = reference.getSignatureMethod();
            object3 = null;
            if (string4 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No SignatureMethod defined");
                }
            } else {
                object3 = string4.getAlgorithm();
            }
            this.signatureMethod = object3;
            string3 = reference.getDigestMethod();
            object2 = null;
            if (string3 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No DigestMethod defined");
                }
            } else {
                object2 = string3.getAlgorithm();
            }
            this.digestMethod = object2;
            string2 = reference.getSigningKey();
            if (string2 != null) {
                object = string2.getLocatorRef();
                this.keyName = string2.getName();
                this.keyLocator = ConfigConstants.findKeyLocator(eList, (String)object, variableMap, wSSecurityDefaultConfiguration, classLoader);
            }
        }
        this.processPrivateConfig(DOMUtil.getPrivateConfig(true));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogProperties((Map)object4, map3, map, map2, "response", "sender"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFResponseSenderConfig()");
        }
    }

    final String getOrigin() {
        return this.origin;
    }
}

