/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSConsumer;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.WSSoapSecurityUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Node;

public class WSSecurityConsumerBase
extends WSSConsumer {
    private static final TraceComponent tc = Tr.register(WSSecurityConsumerBase.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityConsumerBase.class.getName();
    public static final String OPTION = GlobalSecurityHandler.class.getName() + ".configPath";
    private final WSSecurityPlatformContext _contextManager = WSSecurityPlatformContextFactory.getInstance();
    private boolean _initialized = false;

    public void init() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        if (!this._initialized) {
            HashMap hashMap = new HashMap();
            super.init(hashMap);
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public void invoke(SOAPMessageContext sOAPMessageContext, WSSConsumerConfig wSSConsumerConfig) throws WebServicesFault {
        MessageContext messageContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(SOAPMessageContext mcontext[" + sOAPMessageContext + "]," + "WSSConsumerConfig config[" + wSSConsumerConfig + "])");
        }
        if (WSSoapSecurityUtil.getServiceHandler(messageContext = (MessageContext)sOAPMessageContext) != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("com.ibm.wsspi.wssecurity.core.messageContext", sOAPMessageContext);
            hashMap.put("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey", wSSConsumerConfig);
            try {
                super.invoke(null, hashMap);
                if (tc.isDebugEnabled()) {
                    SOAPMessage sOAPMessage = messageContext.getMessage();
                    SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
                    Tr.debug(tc, "The message processed by " + (this._contextManager.isServer() ? "server side" : "client side") + " " + this.getClass().getName() + " : " + DOMUtil.toString((Node)sOAPPart));
                }
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".invoke", "94", this);
                Tr.error(tc, "security.wssecurity.WSSConsumer.s23", soapSecurityException);
                if (this._contextManager.isServer()) {
                    if (soapSecurityException.getFaultCode() != null) {
                        throw WebServicesFault.makeUserFault(soapSecurityException, soapSecurityException.getFaultCode());
                    }
                    throw WebServicesFault.makeUserFault(soapSecurityException, new QName(Constants.NS_SOAP, "Server.securityException"));
                }
                throw WebServicesFault.makeUserFault(soapSecurityException, new QName(Constants.NS_SOAP, "Client.securityException"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(WSSMessageContext mcontext,WSSConsumerConfig config)");
        }
    }
}

