/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSGenerator;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.WSSoapSecurityUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Node;

public class WSSecurityGeneratorBase
extends WSSGenerator {
    private static final TraceComponent tc = Tr.register(WSSecurityGeneratorBase.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityGeneratorBase.class.getName();
    public static final String OPTION = GlobalSecurityHandler.class.getName() + ".configPath";
    public static final String TARGET_PORT = GlobalSecurityHandler.class.getName() + ".targetPort";
    private final WSSecurityPlatformContext _contextManager = WSSecurityPlatformContextFactory.getInstance();
    private final ThreadLocal _threadStore = new ThreadLocal();
    private static Map _globalObjectCache = new HashMap();
    private boolean _initialized = false;

    public void init() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        if (!this._initialized) {
            HashMap hashMap = new HashMap();
            super.init(hashMap);
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public void invoke(SOAPMessageContext sOAPMessageContext, WSSGeneratorConfig wSSGeneratorConfig) throws WebServicesFault {
        MessageContext messageContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(SOAPMessageContext mcontext[" + sOAPMessageContext + "]," + "WSSGeneratorConfig config[" + wSSGeneratorConfig + "])");
        }
        if (WSSoapSecurityUtil.getServiceHandler(messageContext = (MessageContext)sOAPMessageContext) != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("com.ibm.wsspi.wssecurity.core.messageContext", sOAPMessageContext);
            hashMap.put("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey", wSSGeneratorConfig);
            try {
                super.invoke(null, null, hashMap);
                if (tc.isDebugEnabled()) {
                    SOAPMessage sOAPMessage = messageContext.getMessage();
                    SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
                    Tr.debug(tc, "The message processed by " + (this._contextManager.isServer() ? "server side" : "client side") + " " + this.getClass().getName() + " : " + DOMUtil.toString((Node)sOAPPart));
                }
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".invoke", "111", this);
                Tr.error(tc, "security.wssecurity.WSSConsumer.s23", soapSecurityException);
                WebServicesFault webServicesFault = null;
                if (this._contextManager.isServer()) {
                    webServicesFault = soapSecurityException.getFaultCode() != null ? WebServicesFault.makeUserFault(soapSecurityException, soapSecurityException.getFaultCode()) : WebServicesFault.makeUserFault(soapSecurityException, new QName(Constants.NS_SOAP, "Server.securityException"));
                    messageContext.setCurrentMessage(new Message(webServicesFault));
                } else {
                    webServicesFault = WebServicesFault.makeUserFault(soapSecurityException, new QName(Constants.NS_SOAP, "Client.securityException"));
                }
                throw webServicesFault;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(SOAPMessageContext mcontext,WSSGeneratorConfig config)");
        }
    }

    public void retrieveCachedInformation(SOAPMessageContext sOAPMessageContext) throws SoapSecurityException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveCachedInformation(SOAPMessageContext context)");
        }
        if ((object2 = this.getObject((String)this.getMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress"))) != null && object2 instanceof UsernameToken) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved username token found [" + object2 + "].");
            }
            sOAPMessageContext.setProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken", object2);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved username token not found.");
            }
            sOAPMessageContext.removeProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken");
        }
        String string = this.getInitialSenderId();
        if (string != null && string.length() > 0) {
            object = new UsernameToken(null, string, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved identifier of initial sender found [" + object + "].");
            }
            sOAPMessageContext.setProperty("com.ibm.wsspi.wssecurity.username.initialSenderId", object);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved identifier of initial sender not found.");
            }
            sOAPMessageContext.removeProperty("com.ibm.wsspi.wssecurity.username.initialSenderId");
        }
        object = this.getInitialSenderCert();
        if (object != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved cert of initial sender found [" + object + "].");
            }
            sOAPMessageContext.setProperty("com.ibm.wsspi.wssecurity.username.initialSenderCert", object);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved cert of initial sender not found.");
            }
            sOAPMessageContext.removeProperty("com.ibm.wsspi.wssecurity.username.initialSenderCert");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveCachedInformation(SOAPMessageContext context)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObject(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject(Object key[" + object + "])");
        }
        Object var2_2 = null;
        if (object != null && (var2_2 = this.getThreadStore().get(object)) == null) {
            Map map = _globalObjectCache;
            synchronized (map) {
                var2_2 = _globalObjectCache.get(object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject(Object key) " + (var2_2 == null ? "not found" : "found"));
        }
        return var2_2;
    }

    protected void saveTempObject(String string, Object object) {
        SOAPMessageContext sOAPMessageContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveTempObject(String key[" + string + "], " + "Object value[XXXXXXXX])");
        }
        if (!this._contextManager.isServer() && string != null && (sOAPMessageContext = (SOAPMessageContext)this.getMessageOption("A")) != null) {
            sOAPMessageContext.setProperty(string, object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Data for " + string + " is saved to temporary store");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveTempObject(String key,Object value)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveObject(String string, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveObject(String key[" + string + "], " + "Object value[XXXXXXXX])");
        }
        Object var3_3 = null;
        Map map = _globalObjectCache;
        synchronized (map) {
            var3_3 = _globalObjectCache.get(string);
            if (var3_3 == null) {
                _globalObjectCache.put(string, object);
            }
        }
        this.getThreadStore().put(string, object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Data for " + string + " is saved to global store");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveObject(String key,Object value)");
        }
    }

    private Map getThreadStore() {
        HashMap hashMap = (HashMap)this._threadStore.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            this._threadStore.set(hashMap);
        }
        return hashMap;
    }

    private String getInitialSenderId() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInitialSenderId()");
        }
        String string = null;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager == null) {
            Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
            throw SoapSecurityException.format("security.wssecurity.ctxmgr.isnull");
        }
        Subject subject = (Subject)contextManager.get("com.ibm.wsspi.wssecurity.username.initialSenderId");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initial Sender is found.");
        }
        if (subject != null) {
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            if (wSCredential != null) {
                try {
                    string = wSCredential.getSecurityName();
                }
                catch (Exception exception) {
                    Tr.error(tc, "security.wssecurity.noprincipal.found");
                    throw SoapSecurityException.format("security.wssecurity.noprincipal.found");
                }
            } else {
                Tr.error(tc, "security.wssecurity.nocred.found");
                throw SoapSecurityException.format("security.wssecurity.nocred.found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitialSenderId() returns String[" + string + "]");
        }
        return string;
    }

    private X509Certificate getInitialSenderCert() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInitialSenderCert()");
        }
        X509Certificate x509Certificate = null;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager == null) {
            Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
            throw SoapSecurityException.format("security.wssecurity.ctxmgr.isnull");
        }
        x509Certificate = (X509Certificate)contextManager.get("com.ibm.wsspi.wssecurity.username.initialSenderCert");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initial Sender Cert", x509Certificate);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitialSenderCert() returns X509Certificate[" + x509Certificate + "]");
        }
        return x509Certificate;
    }
}

