/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.handler.WSSoapSecuritySenderBase;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.token.SenderLogin;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;

public class WSSenderLogin
extends SenderLogin {
    private static final TraceComponent tc = Tr.register(WSSenderLogin.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSenderLogin.class.getName();
    private String targetPort = null;
    private WSSoapSecuritySenderBase soapSecuritySender = null;
    private MessageContextProxy context = null;
    boolean isServer = true;

    public WSSenderLogin(WSSoapSecuritySenderBase wSSoapSecuritySenderBase, MessageContextProxy messageContextProxy, boolean bl) {
        this.soapSecuritySender = wSSoapSecuritySenderBase;
        this.context = messageContextProxy;
        this.isServer = bl;
    }

    protected void cacheUsernameTokenByTargetPort(TokenRequest.Username username) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheUsernameTokenByTargetPort", new Object[]{(String)this.soapSecuritySender.getMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress"), username});
        }
        if (!this.isServer) {
            this.soapSecuritySender.saveTempObject("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.basicAuthToken", username);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheUsernameTokenByTargetPort");
        }
    }

    protected TokenRequest.Username retrieveUsernameTokenByTargetPort() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveUsernameTokenByTargetPort", new Object[]{(String)this.soapSecuritySender.getMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress"), new Boolean(this.isServer)});
        }
        TokenRequest.Username username = null;
        if (!this.isServer) {
            username = (TokenRequest.Username)this.soapSecuritySender.getObject((String)this.soapSecuritySender.getMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveUsernameTokenByTargetPort", new Object[]{username});
        }
        return username;
    }

    protected String getInitialSenderId() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInitialSenderId");
        }
        String string = null;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager == null) {
            Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
            throw SoapSecurityException.format("security.wssecurity.ctxmgr.isnull");
        }
        final Subject subject = (Subject)contextManager.get("wssecurity.initial.sender.id");
        if (tc.isDebugEnabled()) {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    Tr.debug(tc, "Initial Sender", subject);
                    return null;
                }
            });
        }
        if (subject != null) {
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            if (wSCredential != null) {
                try {
                    string = wSCredential.getSecurityName();
                }
                catch (Exception exception) {
                    Tr.error(tc, "security.wssecurity.noprincipal.found");
                    throw SoapSecurityException.format("security.wssecurity.noprincipal.found");
                }
            } else {
                Tr.error(tc, "security.wssecurity.nocred.found");
                throw SoapSecurityException.format("security.wssecurity.nocred.found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitialSenderId", string);
        }
        return string;
    }

    protected X509Certificate getInitialSenderCert() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInitialSenderCert");
        }
        X509Certificate x509Certificate = null;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager == null) {
            Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
            throw SoapSecurityException.format("security.wssecurity.ctxmgr.isnull");
        }
        x509Certificate = (X509Certificate)contextManager.get("com.ibm.ws.wssecurity.OriginalCert");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initial Sender Cert", x509Certificate);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitialSenderCert", x509Certificate);
        }
        return x509Certificate;
    }
}

