/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestSenderConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseSenderConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSSenderLogin;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.WSSoapSecurityUtil;
import com.ibm.wsspi.webservices.rpc.handler.GenericHandler;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.SoapSecuritySender;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.token.SenderLoginComponent;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import java.util.Map;

public class WSSoapSecuritySenderBase
extends SoapSecuritySender {
    public static final String OPTION = GlobalSecurityHandler.class.getName() + ".configPath";
    protected static final String MESSAGE_CONTEXT = GlobalSecurityHandler.class.getName() + ".messageContext";
    private boolean isServer = true;
    private final WSSecurityPlatformContext contextManager = WSSecurityPlatformContextFactory.getInstance();
    private final ThreadLocal threadStore = new ThreadLocal();
    private static final Map globalStore = new HashMap();
    private static final TraceComponent tc = Tr.register(WSSoapSecuritySenderBase.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSoapSecuritySenderBase.class.getName();

    public void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    protected void initConfig(MessageContextProxy messageContextProxy) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initConfig(" + messageContextProxy + ")");
        }
        if ((string = (String)this.getHandlerOption(GenericHandler.HANDLER_PARAM_ROLE)) != null && string.length() != 0) {
            this.isServer = string.equals(GenericHandler.HANDLER_PARAM_ROLE_SERVER);
        } else {
            boolean bl = this.isServer = !messageContextProxy.getPastPivot();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isServer=" + this.isServer);
        }
        try {
            if (this.isServer) {
                SenderConfig senderConfig = (SenderConfig)messageContextProxy.getConfig("ResponseSenderConfig");
                if (senderConfig == null) {
                    throw new IllegalArgumentException(ConfigConstants.getMessage("security.wssecurity.response.sender.config.isnull"));
                }
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("SenderConfig class name=");
                    stringBuffer.append(senderConfig.getClass().getName());
                    stringBuffer.append(", source=");
                    if (senderConfig instanceof WSEMFResponseSenderConfig) {
                        stringBuffer.append(((WSEMFResponseSenderConfig)senderConfig).getOrigin());
                    } else {
                        stringBuffer.append("unknown");
                    }
                    stringBuffer.append(", SenderConfig=").append(senderConfig);
                    Tr.debug(tc, stringBuffer.toString());
                }
                this.setMessageOption(CONFIG_KEY, senderConfig);
            } else {
                Object object;
                SenderConfig senderConfig = (SenderConfig)messageContextProxy.getConfig("RequestSenderConfig");
                if (senderConfig == null) {
                    throw new IllegalArgumentException(ConfigConstants.getMessage("security.wssecurity.request.sender.config.isnull"));
                }
                if (tc.isDebugEnabled()) {
                    object = new StringBuffer("SenderConfig class name=");
                    ((StringBuffer)object).append(senderConfig.getClass().getName());
                    ((StringBuffer)object).append(", source=");
                    if (senderConfig instanceof WSEMFRequestSenderConfig) {
                        ((StringBuffer)object).append(((WSEMFRequestSenderConfig)senderConfig).getOrigin());
                    } else {
                        ((StringBuffer)object).append("unknown");
                    }
                    ((StringBuffer)object).append(", SenderConfig=").append(senderConfig);
                    Tr.debug(tc, ((StringBuffer)object).toString());
                }
                if (senderConfig instanceof WSEMFRequestSenderConfig) {
                    object = (WSEMFRequestSenderConfig)senderConfig;
                    String string2 = ((WSEMFRequestSenderConfig)object).getWSSENS();
                    if (string2 != null && string2.length() != 0) {
                        messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", string2);
                    }
                    if ((string2 = ((WSEMFRequestSenderConfig)object).getWSUNS()) != null && string2.length() != 0) {
                        messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", string2);
                    }
                }
                this.setMessageOption(CONFIG_KEY, senderConfig);
            }
            super.initConfig(messageContextProxy);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Throwable throwable) {
            Tr.processException(throwable, clsName + ".init", "96", this);
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", throwable);
            throw new IllegalArgumentException(throwable.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initConfig(MessageContextProxy context)");
        }
    }

    protected SenderLoginComponent createLoginComponent(MessageContextProxy messageContextProxy) {
        return new WSSenderLogin(this, messageContextProxy, this.contextManager.isServer());
    }

    public void invoke(MessageContextProxy messageContextProxy) throws FaultProxy {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + messageContextProxy + ")");
        }
        if (WSSoapSecurityUtil.getServiceHandler((MessageContext)messageContextProxy.get()) != null) {
            super.invoke(messageContextProxy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(MessageContextProxy context)");
        }
    }

    public String toString() {
        return "WSSoapSecuritySenderBase(config=" + this.getMessageOption(CONFIG_KEY) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject(" + object + ")");
        }
        Object var2_2 = null;
        if (object != null && (var2_2 = this.getThreadStore().get(object)) == null) {
            Map map = globalStore;
            synchronized (map) {
                var2_2 = this.getGlobalStore().get(object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject() " + (var2_2 == null ? "not found" : "found"));
        }
        return var2_2;
    }

    void saveTempObject(String string, Object object) {
        MessageContextProxy messageContextProxy;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveTempObject(" + string + ", " + "XXX)");
        }
        if (!this.contextManager.isServer() && string != null && (messageContextProxy = (MessageContextProxy)this.getMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.messageContext")) != null) {
            messageContextProxy.setConfig(string, object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Data for " + string + " is saved to temporary store");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveTempObject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveObject(String string, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveObject(" + string + ", " + "XXX)");
        }
        if (!this.contextManager.isServer() && string != null) {
            Object var3_3 = null;
            Map map = globalStore;
            synchronized (map) {
                var3_3 = globalStore.get(string);
                if (var3_3 == null) {
                    this.getGlobalStore().put(string, object);
                }
            }
            this.getThreadStore().put(string, object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Data for " + string + " is saved to global store");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveObject");
        }
    }

    private Map getThreadStore() {
        HashMap hashMap = (HashMap)this.threadStore.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            this.threadStore.set(hashMap);
        }
        return hashMap;
    }

    private Map getGlobalStore() {
        return globalStore;
    }
}

