/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.ws.webservices.wssecurity.handler.token.CacheEntry;
import com.ibm.ws.webservices.wssecurity.util.DistributedMapFactory;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

class NonceCache
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(NonceCache.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = NonceCache.class.getName();
    private static final String comp = "security.wssecurity";
    private static final String DEFAULT_VALUE = "exist";
    private Hashtable _table;
    private Hashtable _secondaryTable;
    private Hashtable _tertiaryTable;
    private int _minSize = 0;
    private boolean _wipeCache;
    private Alarm _defaultAlarm;
    private String _cacheName;
    private DistributedMap _dm;
    private boolean _dmInitialized;
    private int _timeout;

    public NonceCache(String string, int n, int n2, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NonceCache(String cacheName[" + string + "]," + "int size[" + n + "]," + "int timeout[" + n2 + "]," + "boolean wipeCache[" + bl + "]," + "boolean cacheDistributed[" + bl2 + "]");
        }
        this._defaultAlarm = new Alarm(n2);
        this._table = new Hashtable(n);
        this._secondaryTable = new Hashtable(n);
        this._tertiaryTable = new Hashtable(n);
        this._minSize = n;
        this._wipeCache = bl;
        this.addAlarmListener(this, n2);
        this._dm = null;
        this._timeout = n2;
        if (bl2 && WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing DistributedMap for nonce.");
            }
            if (string == null || string.length() == 0) {
                string = "NonceDistributionCacheMap";
            }
            Properties properties = new Properties();
            properties.put("com.ibm.ws.cache.CacheConfig.cacheSize", Integer.toString(n));
            properties.put("com.ibm.ws.cache.CacheConfig.enableDiskOffload", "false");
            properties.put("com.ibm.ws.cache.CacheConfig.diskOffloadLocation", "");
            this._dm = DistributedMapFactory.getMap(string, properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NonceCache(String cacheName, int size, int timeout, boolean wipeCache, boolean cacheDistributed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contains");
            StringBuffer stringBuffer = new StringBuffer("Key = ");
            stringBuffer.append(object.toString());
            stringBuffer.append(", key class is ");
            stringBuffer.append(object.getClass().getName());
            Tr.debug(tc, stringBuffer.toString());
        }
        boolean bl = true;
        Hashtable hashtable = null;
        CacheEntry cacheEntry = null;
        if (this._dm != null && (object2 = this._dm.get(object)) instanceof CacheEntry) {
            cacheEntry = (CacheEntry)object2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found distributed nonce corresponding the key [" + object + "].");
            }
            if (cacheEntry != null) {
                this._table.put(object, cacheEntry);
            }
        }
        if (cacheEntry == null) {
            cacheEntry = (CacheEntry)this._table.get(object);
            if (cacheEntry == null) {
                cacheEntry = (CacheEntry)this._secondaryTable.get(object);
                if (cacheEntry == null) {
                    cacheEntry = (CacheEntry)this._tertiaryTable.get(object);
                    if (cacheEntry != null) {
                        hashtable = this._tertiaryTable;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found cached nonce corresponding the key [" + object + "] in the tertiary table.");
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found cached nonce corresponding the key [" + object + "] in the secondary table.");
                    }
                    hashtable = this._secondaryTable;
                }
                if (cacheEntry == null) {
                    object2 = this._table;
                    synchronized (object2) {
                        if (tc.isEntryEnabled() && (this._table.size() + this._secondaryTable.size() + this._tertiaryTable.size()) % 100 == 0) {
                            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
                            stringBuffer.append(" number of entries: ");
                            stringBuffer.append(this._table.size() + this._secondaryTable.size() + this._tertiaryTable.size());
                            Tr.debug(tc, stringBuffer.toString());
                        }
                        if ((cacheEntry = (CacheEntry)this._table.get(object)) == null) {
                            cacheEntry = new CacheEntry(object, new Date());
                            this._table.put(object, cacheEntry);
                            bl = false;
                            if (this._dm != null) {
                                this._dm.put(object, cacheEntry, 1, this._timeout, 2, null);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Created a new cache corresponding the key [" + object + "].");
                            }
                        }
                    }
                } else {
                    this._table.put(object, cacheEntry);
                    hashtable.remove(object);
                    if (this._dm != null) {
                        this._dm.put(object, cacheEntry, 1, this._timeout, 2, null);
                    }
                }
            } else {
                if (this._dm != null) {
                    this._dm.put(object, cacheEntry, 1, this._timeout, 2, null);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found cached nonce corresponding the key [" + object + "] in the firs table.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contains returns " + bl);
        }
        return bl;
    }

    protected void mark() {
        if (this._wipeCache) {
            this._tertiaryTable.clear();
        } else {
            this._tertiaryTable.putAll(this._secondaryTable);
        }
        this._secondaryTable = this._table;
        this._table = new Hashtable(this._minSize > this._secondaryTable.size() ? this._minSize : this._secondaryTable.size() + 100);
    }

    public void alarm(Object object) {
        long l = System.currentTimeMillis();
        this.mark();
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
            stringBuffer.append(" Time elapsed cleaning cache: ");
            stringBuffer.append(System.currentTimeMillis() - l);
            stringBuffer.append(" milliseconds, Primary cache size: ");
            stringBuffer.append(this._table.size());
            stringBuffer.append(", Secondary cache size: ");
            stringBuffer.append(this._secondaryTable.size());
            stringBuffer.append(", Tertiary cache size: ");
            stringBuffer.append(this._tertiaryTable.size());
            Tr.debug(tc, stringBuffer.toString());
        }
    }

    private void addAlarmListener(AlarmListener alarmListener, long l) {
        if (l == this._defaultAlarm.getTimeout()) {
            this._defaultAlarm.addAlarmListener(alarmListener);
        } else {
            Alarm alarm = new Alarm(l);
            alarm.addAlarmListener(alarmListener);
        }
    }

    private class Alarm
    implements AlarmListener {
        private Vector alarms = new Vector();
        private long timeout;

        public void addAlarmListener(AlarmListener alarmListener) {
            this.alarms.addElement(alarmListener);
        }

        public Alarm(long l) {
            this.timeout = l / 2L;
            this.alarm(null);
        }

        public void alarm(Object object) {
            for (int i = 0; i < this.alarms.size(); ++i) {
                ((AlarmListener)this.alarms.elementAt(i)).alarm(object);
            }
            AlarmManager.create(this.timeout * 1000L, this);
        }

        public long getTimeout() {
            return this.timeout * 2L;
        }
    }
}

